/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: netload.c,v 1.3 87/05/15 10:25:04 davidb Exp $ */

static char sccsId[] = " @(#)netload.c	1.27 8/23/85";

#include "netload.h"

/* MWP 3/4/85: no need to fix V7 ctype macro, as we now supply our own 
		in xctype.h */

#define	ID86V7		0411

#ifdef	vms
#define	MAX_TELNET_CONN	32
#endif

#define	DATAADDR	0x01000000L

long	xrhost();
u_short	cxswap();

int	hilo = 1;	/* data order for 68K-based cc86 */
char	xcvmsg0[] = "WARNING: EXOS 101 boards prior to Rev G \n";
char	xcvmsg1[] = "\tshould use an Ethernet Version 1.0 transceiver\n";
char	fwwarn[] = "WARNING: Firmware is out of date, may malfunction\n";
char	lbwarn[] = "WARNING: Transceiver loopback test failed\n";
char	tswarn1[] = "WARNING: Netload option will cause strange results on\n";
char	tswarn2[] = "\ttelnet sessions. It is not recommended to set echo\n ";
char	tswarn3[] = "\ton the -nr or -nc options to netload.\n ";
char	tsusage1[] = "The telnet server options to netload are as follows:\n";
char	tsusage2[] = "\t-no option  (option = binary,noecho,sga)\n";
char	tsusage3[] = "\t-np option  (option = nobinary,noecho,nosga)\n";
char	tsusage4[] = "\t-nr option  (option = binary,echo,sga)\n";
char	tsusage5[] = "\t-nc option  (option = nobinary,echo,nosga)\n";
char	buf[8192] = { 0 };
char	*nmfile = NMFILE;
long	startaddr = 0;
long	textaddr = 0, textsize = 0;
long	dataaddr = 0, datasize = 0;
int	inithow = 0;
char	localhost[] = "localhost";
char	*nameoraddr = localhost;
long	inetaddr = 0;
int	debug = 0;
int	gotopts = 0;
int	boardno = 0;
struct	exosopt exosopt = {
/*00*/	1,		/* use ARP protocol */
/*01*/	1,		/* do checksums */
/*02*/	0,		/* use board's given Ethernet address */
/*03*/	8,		/* support 8 telnet connections */
/*04*/	{0,0,0,0},	/* look up Internet address */
/*08*/	{0,0,0,0,0,0},
/*14*/	XOECHO,			/* offer to echo */
/*15*/	XOBIN|XOECHO|XOSGA,	/* agree to binary, echo, and SGA */
/*16*/	0,			/* disable host link mode access */
/*17*/	0,			/* let EXOS decide how many pending rqsts */
/*18*/	0,			/* reserved (formerly extended mbufs) */
/*19*/	XP_WARM,		/* print operational error/warning messages */
/*20*/	1,			/* use NX 5.0 buffer chaining, if possible */
/*21*/	0,			/* reserved (formerly subnet mask) */
/*22*/	0,			/* let EXOS decide number of extended mbufs */
/*24*/	0,			/* reserved (formerly subnet mask) */
/*25*/	0,			/* For UDP broadcast address */
/*26*/	0,			/* loopback address is 127.0.0.0 (grantr) */
/*27*/	0,			/* let EXOS decide number of re-xmits */
/*28*/	{0,0,0,0},		/* subnet mask */
/*32*/	0,
/*33*/	XOBIN|XOSGA,
};

struct	exec86v7 {
	unsigned short	x7_magic;
	unsigned short	x7_textsiz;
	unsigned short	x7_datasiz;
	unsigned short	x7_bsssiz;
	unsigned short	x7_symsiz;
	unsigned short	x7_entry;
	unsigned short	x7_pad1;
	unsigned short	x7_reloc;
} exec = { 0 };

struct	init_msg confmsg = { 0 };

char 	*snm = 0;
u_long	snetmask = 0;

/*
 * Note:
 *	host parameter may be either the host's alphanumeric name,
 *		or an Internet "dot" address, in hex, octal, or decimal.
 *		If no name or address is given, it looks up the address
 *		of "localhost" in /etc/hosts.
 *	ENET_addr parameter must be a 6-part Ethernet address,
 *		all in hex digits
 *	-d prints a bunch of status messages
 *	-t enables the on-board telnet/server and specifies how many
 *		connections to support
 *	-m disables ARP
 *	-l enables host access to link level mode
 *	if no net_file is named, it uses /net/net.
 *	-x specifies the number of extended memory buffers to allocate
 *	-r specifies the maximum number of host requests to support
 *	-c specifies an address at which to download net module text
 *	-o turns off buffer chaining
 *	-i allows infinite timeout during initialization
 *	-p specifies printf priority level:
 *		XP_COOL		1	chit-chat
 *		XP_WARM		2	benign operational problems
 *		XP_HOT		3	unexpected, non-fatal problems
 *		XP_PANIC	4	unexpected, fatal problems
 *	-b specifies board number
 *		default is 0
 *	-s specifies the subnet mask
 *	-u specifies UDP broadcast to be all 1's
 *	-a specifies loopback address to be 127.0.0.1 (grantr)
 *	-no specifies telNet server options binary,noecho,sga must specify a
 *	   -no for each option needed
 *	-np specifies the telnet options that the server agrees to offer if
 *	    requested (o for Offer)
 *	-nr specifies the telnet options that the server requests on connection
 *	    establishment (r for Request)
 *	-nc specifies the telnet options that the server accepts that changes 
 *	    by the client. (c for Client)
 */

char	usage[] = "usage: %s [-d] [-h host] [-e EADDR] [-t n] [-m] [-l] [-x n] [-r n] [-c n] [-o] [-i] [-p n] [-b n] [-u] [-s subnet] [-no option] [-np option] [-nr option] [-nc option] [net_file]\n";

xmain(argc, argv)
	int argc;
	char *argv[];
{
	register char *ap;
	register int an, nread, nwritten;
	int i, nmfd, exos;
	char *addrpt;
	int rval;

	xsysident();
	for (an = 1; an < argc && *(ap = argv[an]) == '-'; ++an)
		switch (*++ap) {
		case 'd':
		case 'D':
			/* Turn on debug messages */
			debug = 1;
			break;
		case 'i':
		case 'I':
			/* Allow infinite timeout (for debuggers) */
			inithow |= 0x80;
			break;
		case 'h':
		case 'H':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			nameoraddr = argv[an];
			break;
		case 's':
		case 'S':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			snm = argv[an];
			break;
		
		case 'u':
		case 'U':
			if (exosopt.xo_udpba == 1) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_udpba = 1;
			break;
		
		case 'e':
		case 'E':
			if (++an >= argc || exosopt.xo_useaddr) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_useaddr = 1;
			if (enet_addr(argv[an], exosopt.xo_eaddr) == -1) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			break;
    		case 'b':
    		case 'B':	/* define board number */
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			};
			boardno = xatoi(argv[an]);
			break;	    
		case 't':
		case 'T':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_ntsconn = xatoi(argv[an]);
#ifdef	vms
			if ((exosopt.xo_ntsconn & 0xFF) > MAX_TELNET_CONN) {
				xoprintf(xstderr, "%s -t n > %d\n", argv[0],
					MAX_TELNET_CONN);
				goto error;
			};
#endif
			break;
		case 'R':
		case 'r':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_npending = xatoi(argv[an]);
			break;
		case 'X':
		case 'x':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_nxmbufs = xatoi(argv[an]);
			break;
		case 'M':
		case 'm':
			if (exosopt.xo_doarp == 0) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_doarp = 0;
			break;
		case 'L':
		case 'l':
			if (exosopt.xo_dolink == 1) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_dolink = 1;
			break;
		case 'c':
		case 'C':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			textaddr = xatoi(argv[an]);
			textaddr <<= 16;
			break;
		case 'o':
		case 'O':
			exosopt.xo_bufchain = 0;
			break;
		case 'p':
		case 'P':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}
			exosopt.xo_xptemp = xatoi(argv[an]);
			if ( (exosopt.xo_xptemp < XP_COOL)
			  || (exosopt.xo_xptemp > XP_PANIC) ) {
				xoprintf(xstderr, "%s -p n (illegal value)\n",
				  argv[0]);
				goto error;
			}
			break;
		case 'a':
		case 'A':
			exosopt.xo_lb = 1;
			break;
		case 'q':
		case 'Q':
			if (++an >= argc) {
				xoprintf(xstderr, usage, argv[0]);
				goto error;
			}	
			exosopt.xo_ntcprxmt = xatoi(argv[an]);
			if (exosopt.xo_ntcprxmt > TCP_MAXRXTSHIFT) {
				xoprintf(xstderr, "%s -p n (llegal value)\n",
				argv[0]);
				goto error;
			}
			break;
		case 'n':
		case 'N':
			switch (*++ap) {
			case 'o':
			case 'O':
				if (++an >= argc) {
					xoprintf(xstderr,tsusage1);
					xoprintf(xstderr,tsusage2);
					xoprintf(xstderr,tsusage3);
					xoprintf(xstderr,tsusage4);
					xoprintf(xstderr,tsusage5);
					goto error;
				}
				if(!(xstricmp(argv[an],"binary"))) {
					exosopt.xo_tsoffer ^= XOBIN;
				} else if(!(xstricmp(argv[an],"noecho"))) {
					exosopt.xo_tsoffer ^= XOECHO;
				} else if(!(xstricmp(argv[an],"sga"))) {
					exosopt.xo_tsoffer ^= XOSGA;
				} else {
					xoprintf(xstderr,
					"%s -no %s (illegal value)\n",
					argv[0],argv[an]);
					goto error;
				}
				break;
			case 'p':
			case 'P':
				if (++an >= argc) {
					xoprintf(xstderr,tsusage1);
					xoprintf(xstderr,tsusage2);
					xoprintf(xstderr,tsusage3);
					xoprintf(xstderr,tsusage4);
					xoprintf(xstderr,tsusage5);
					goto error;
				}
				if(!(xstricmp(argv[an],"nobinary"))) {
					exosopt.xo_tspermit ^= XOBIN;
				} else if(!(xstricmp(argv[an],"noecho"))) {
					exosopt.xo_tspermit ^= XOECHO;
				} else if(!(xstricmp(argv[an],"nosga"))) {
					exosopt.xo_tspermit ^= XOSGA;
				} else {
					xoprintf(xstderr,
					"%s -np %s (illegal value)\n",
					argv[0],argv[an]);
					goto error;
				}
				break;
			case 'r':
			case 'R':
				if (++an >= argc) {
					xoprintf(xstderr,tsusage1);
					xoprintf(xstderr,tsusage2);
					xoprintf(xstderr,tsusage3);
					xoprintf(xstderr,tsusage4);
					xoprintf(xstderr,tsusage5);
					goto error;
				}
				if(!(xstricmp(argv[an],"binary"))) {
					exosopt.xo_tsdo ^= XOBIN;
				} else if(!(xstricmp(argv[an],"echo"))) {
					xoprintf(xstderr,tswarn1);
					xoprintf(xstderr,tswarn2);
					xoprintf(xstderr,tswarn3);
					exosopt.xo_tsdo ^= XOECHO;
				} else if(!(xstricmp(argv[an],"sga"))) {
					exosopt.xo_tsdo ^= XOSGA;
				} else {
					xoprintf(xstderr,
					"%s -nr %s (illegal value)\n",
					argv[0],argv[an]);
					goto error;
				}
				break;
			case 'c':
			case 'C':
				if (++an >= argc) {
					xoprintf(xstderr,tsusage1);
					xoprintf(xstderr,tsusage2);
					xoprintf(xstderr,tsusage3);
					xoprintf(xstderr,tsusage4);
					xoprintf(xstderr,tsusage5);
					goto error;
				}
				if(!(xstricmp(argv[an],"nobinary"))) {
					exosopt.xo_tsagree ^= XOBIN;
				} else if(!(xstricmp(argv[an],"echo"))) {
					xoprintf(xstderr,tswarn1);
					xoprintf(xstderr,tswarn2);
					xoprintf(xstderr,tswarn3);
					exosopt.xo_tsagree ^= XOECHO;
				} else if(!(xstricmp(argv[an],"nosga"))) {
					exosopt.xo_tsagree ^= XOSGA;
				} else {
					xoprintf(xstderr,
					"%s -nc %s (illegal value)\n",
					argv[0],argv[an]);
					goto error;
				}
				break;
				default:
					xoprintf(xstderr,tsusage1);
					xoprintf(xstderr,tsusage2);
					xoprintf(xstderr,tsusage3);
					xoprintf(xstderr,tsusage4);
					xoprintf(xstderr,tsusage5);
					goto error;
			}
			break;
		default:
			xoprintf(xstderr, usage, argv[0]);
			goto error;
		}

	if (an == argc-1) {
		nmfile = ap;
	} else {
		if (an != argc) {
			xoprintf(xstderr, usage, argv[0]);
			goto error;
		}
	}

	if ((exosopt.xo_doarp == 0) && (nameoraddr == localhost))
		nameoraddr = "89.0.0.0";
	inetaddr = (long)xrhost(&nameoraddr);
	if (inetaddr == -1) {
		xperror( XEHOSTUNKNOWN, nameoraddr);
		goto error;
	}
	xbcopy( (char *)&inetaddr, exosopt.xo_iaddr,
		sizeof( exosopt.xo_iaddr ));

	if (snm) {
		snetmask = xrhost(&snm);
		if (snetmask == -1) {
			xperror(XSYSERR, "rhost");
			goto error;
		}
	}
	xbcopy((char *)&snetmask, exosopt.xo_snetmask, 
		sizeof(exosopt.xo_snetmask));

		
	if (debug) {
		xoprintf(xstdout, "inet addr =     %x.%x.%x.%x\n",
			exosopt.xo_iaddr[0]&0xFF, exosopt.xo_iaddr[1]&0xFF,
			exosopt.xo_iaddr[2]&0xFF, exosopt.xo_iaddr[3]&0xFF);
		xoprintf(xstdout, "enet addr =     %x-%x-%x-%x-%x-%x\n",
			exosopt.xo_eaddr[0]&0xFF, exosopt.xo_eaddr[1]&0xFF,
			exosopt.xo_eaddr[2]&0xFF, exosopt.xo_eaddr[3]&0xFF,
			exosopt.xo_eaddr[4]&0xFF, exosopt.xo_eaddr[5]&0xFF);
		xoprintf(xstdout, "telnet nconn  = %d\n", exosopt.xo_ntsconn);
		xoprintf(xstdout, "ARP is %s\n", exosopt.xo_doarp ?
			"enabled" : "disabled");
		xoprintf(xstdout, "net module =    %s\n", nmfile);
	}

	if (debug) {
		xoprintf(xstdout,  "opening download device\n" );
	}
	if ((exos = xbrdopen( boardno, 3)) < 0) {
		xperror(exos, DLDEV);
		goto error;
	}
	if (debug) {
		xoprintf(xstdout,  "configuring EXOS board\n");
	}
	if ((rval = xioctl(exos, BRDINIT, &inithow )) < 0 ) {
		xoprintf(xstderr, "%s: configuration failed\n", argv[0]);
		xperror( rval, "BRDINIT" );
		goto error;
	}
	if ((rval = xioctl(exos, BRDGCONF, &confmsg )) < 0 ) {
		xoprintf(xstderr, "%s: BRDGCONF failed\n", argv[0]);
		xperror( rval, "BRDGCONF" );
		goto error;
	}
	if (debug) {
		long *lp = (long *) confmsg.im_byteptn;

		xoprintf(xstdout, "\tNX release %c.%c\n",
			confmsg.im_version[0], confmsg.im_version[1]);
		xoprintf(xstdout, "\tEXOS release %c.%c\n",
			confmsg.im_version[2], confmsg.im_version[3]);
		xoprintf(xstdout, "\tcompletion code = %x\n",
			confmsg.im_result & 0xFF);
		xoprintf(xstdout, "\tcontext = %d\n",
			confmsg.im_junk[1]);
		xoprintf(xstdout, "\tPORT B = %x\n",
			confmsg.im_dummy2 & 0xFF);
		xoprintf(xstdout, "\tmemory map size = %d\n",
			confmsg.im_mmsize);
		if ((i = confmsg.im_mmsize) > 4)
			i = 4;
		while (i--) {
			xoprintf(xstdout, "\tmemory map segment: %X %X\n",
				*lp, *(lp+1));
			lp += 2;
		}
	}
	{
		u_short fw = confmsg.im_version[0]<<8
			| confmsg.im_version[1]&0xFF;
		u_short hw = confmsg.im_version[2]<<8
			| confmsg.im_version[3]&0xFF;

		if ( (fw < 0x3430) && (hw < 0x3430) )
			xoprintf(xstdout, "%s%s", xcvmsg0, xcvmsg1);
		if ( (fw < 0x3231) || (fw == 0x3430) || (fw == 0x3431) )
			xoprintf(xstdout, "%s", fwwarn);
		/*
		 * For 200-series, NX >= 5.0 returns an xcvr loopback result.
		 * Note that while NX puts this result on I/O port B, the
		 * xmem driver stashes it in the configuration reply msg.
		 * For 200-series prior to NX 5.0, the test bit is always
		 * zero;  test the exos context field because the EXOS 101
		 * does not define this bit.
		 */
		if ( (confmsg.im_junk[1]) && (confmsg.im_dummy2 & 0x40) )
			xoprintf(xstdout, "%s", lbwarn);
	}
	if (debug) {
		xoprintf(xstdout, "opening net module\n" );
	}
	if ((nmfd = xdopen(nmfile, XFREAD, FILE_NAME)) < 0) {
		xperror(nmfd, nmfile);
		goto error;
	}


    /* read a.out exec header */

	nread = xread(nmfd, &exec, sizeof(exec));
	if (nread != sizeof(exec)) {
		if (nread >= 0)
			xoprintf(xstderr, "%s: incomplete read (%d/%d)\n",
				ap, nread, sizeof(exec));
		else
			xperror(nread, ap);
		goto error;
	}
	if (cxswap(exec.x7_magic) != ID86V7)
		hilo = 0;	/* try VAX/8086/PDP11 byte order */
	if (cxswap(exec.x7_magic) != ID86V7) {
		xoprintf(xstderr, "%s: bad magic in %s.\n", argv[0], nmfile);
		goto error;
	}
	if (debug) {
		xoprintf(xstdout,"magic =   0x%4x\n", cxswap(exec.x7_magic));
		xoprintf(xstdout,"textsiz = 0x%4x\n", cxswap(exec.x7_textsiz));
		xoprintf(xstdout,"datasiz = 0x%4x\n", cxswap(exec.x7_datasiz));
		xoprintf(xstdout,"bsssiz =  0x%4x\n", cxswap(exec.x7_bsssiz));
		xoprintf(xstdout,"symsiz =  0x%4x\n", cxswap(exec.x7_symsiz));
		xoprintf(xstdout,"entry =   0x%4x\n", cxswap(exec.x7_entry));
		xoprintf(xstdout,"reloc =   0x%4x\n", cxswap(exec.x7_reloc));
	}

	textsize = cxswap(exec.x7_textsiz);
	if (textaddr == 0) {
		/*
		 * Figure out highest address at which we can load the text.
		 * Note that it is calculated such that the offset value is 0.
		 */
		/* end of 1st user RAM extent */
		textaddr = *(long *)confmsg.im_wordptn;
		textaddr = (textaddr>>12 & 0x000FFFF0L)
		  + (textaddr & 0x0000FFFFL) + 1;
		textaddr -= textsize;
		textaddr = (textaddr & 0x000FFFF0L) << 12;
	}

	startaddr = textaddr;
	dataaddr = DATAADDR;
	datasize = cxswap(exec.x7_datasiz);

    /* send text down load address (board address) */
	if (debug) {
		xoprintf(xstdout,
			"seeking to text download address 0x%X\n", textaddr);
	}
	if ( (rval = xioctl(exos, BRDADDR, &textaddr )) < 0 ) {
		xoprintf(xstderr,"%s: lseek to text address failed\n", argv[0]);
		xperror( rval, "BRDADDR" );
		goto error;
	}
    /* transfer text to board */
	if (debug) {
		xoprintf(xstdout, "hit CR to download text: ");
		xfflush( xstdout );
		xgetchar();
		xoprintf(xstdout, "transferring board text\n");
	}
	while (textsize) {
		int ntoread = MIN(sizeof(buf), textsize);

		if (debug)
			xoprintf(xstdout,
				"reading %d bytes of text.\n", ntoread);
		nread = xread(nmfd, buf, ntoread);
		if (nread < ntoread) {
			xoprintf(xstderr,
				"%s: missing text in %s.\n", argv[0], nmfile);
			goto error;
		}
		if (nread < 0 ) {
			xperror( nread, ap);
			goto error;
		}
		textsize -= nread;
		nwritten = xwrite(exos, buf, nread);
		if (nwritten != nread) {
			if (nwritten >= 0)
				xoprintf(xstderr,
					"%s: incomplete write (%d/%d)\n",
					DLDEV, nwritten, nread);
			else
				xperror(nwritten, DLDEV);
			goto error;
		}
	}

    /* send data down load address (board address) */
	if (debug) {
		xoprintf(xstdout,
			"seeking to data download address 0x%X\n", dataaddr);
	}
	if ( (rval = xioctl( exos, BRDADDR, &dataaddr)) < 0 ) {
		xoprintf(xstderr,
			"%s: lseek to data address failed\n", argv[0]);
		xperror( rval, "BRDADDR" );
		goto error;
	}

    /* transfer data to board */
	if (debug) {
		xoprintf(xstdout,"transferring board data\n");
	}
	while (datasize) {
		int ntoread = MIN(sizeof(buf), datasize);

		if (debug)
			xoprintf(xstdout,
				"reading %d bytes of data.\n", ntoread);
		nread = xread(nmfd, buf, ntoread);
		if (nread < ntoread) {
			xoprintf(xstderr,
				"%s: missing data in %s.\n", argv[0], nmfile);
			goto error;
		}
		if (nread < 0) {
			xperror(nread, ap);
			goto error;
		}
		datasize -= nread;
		if (gotopts == 0 && debug) {
			xoprintf(xstdout,"Default %s options:\n", nmfile);
			showopts(buf);
			gotopts = 1;
		}
		nwritten = xwrite(exos, buf, nread);
		if (nwritten != nread) {
			if (nwritten >= 0)
				xoprintf(xstderr,
					"%s: incomplete write (%d/%d)\n",
					DLDEV, nwritten, nread);
			else
				xperror(nwritten, DLDEV);
			goto error;
		}
	}

    /* send option vector address (board address) */
	if (debug) {
		xoprintf(xstdout,
			"seeking to option vector address 0x%X\n", dataaddr);
	}
	if ((rval = xioctl( exos, BRDADDR, &dataaddr )) < 0 ) {
		xoprintf(xstderr, "%s: lseek to options address failed\n",
			argv[0]);
xperror( rval, "BRDADDR" );
		goto error;
	}
	if (debug) {
		xoprintf(xstdout, "Writing option vector:\n");
			showopts(&exosopt);
	}
	nwritten = xwrite(exos, &exosopt, sizeof(struct exosopt));
	if (nwritten != sizeof(struct exosopt)) {
		if (nwritten >= 0)
			xoprintf(xstderr,
				"%s: incomplete write (%d/%d)\n",
				DLDEV, nwritten, nread);
		else
			xperror(nwritten, DLDEV);
		goto error;
	}

    /* send start address and start things up */
	if (debug) {
		xoprintf(xstdout, "hit CR to start code: ");
		xfflush( xstdout );
		xgetchar();
		xoprintf(xstdout, "starting at address 0x%X\n", startaddr);
	}
	if ((rval = xioctl(exos, BRDSTART, &startaddr)) < 0) {
		xoprintf(xstderr, "%s: start failed\n", argv[0]);
		xperror( rval, "BRDSTART" );
		goto error;
	}
	if (debug) {
		xoprintf(xstdout, "closing devices\n" );
	}
	xclose(exos);
	xclose(nmfd);
	if (debug) {
		xoprintf(xstdout, "ALL IS WELL\n" );
	}
	xexit(0);

error:
	xoprintf(xstderr, "Network download failed\n");
	xexit(-1);
}

u_short
cxswap(s)
u_short s;
{
	char *cp = (char *)&s;
	u_short result;

	if (hilo)
		result = ( (*cp<<8) | (*(cp+1)&0xFF) );
	else
		result = ( (*(cp+1)<<8) | (*cp&0xFF) );
	return (result & 0xFFFF);
}

showopts(xo)
struct exosopt *xo;
{
	xoprintf(xstdout,
		"\tARP %s\n", xo->xo_doarp ? "enabled" : "disabled");
	xoprintf(xstdout,"\tchecksums %s\n",
		xo->xo_docksum ? "enabled" : "disabled");
	xoprintf(xstdout,
		"\t%s\n", xo->xo_useaddr ? "use ENET addr below" :
		"use given ENET addr");
	xoprintf(xstdout,"\ttelnet connections = %d\n", xo->xo_ntsconn);
	xoprintf(xstdout,"\tinternet address = %x.%x.%x.%x\n",
		xo->xo_iaddr[0]&0xFF,
		xo->xo_iaddr[1]&0xFF,
		xo->xo_iaddr[2]&0xFF,
		xo->xo_iaddr[3]&0xFF);
	xoprintf(xstdout,"\tethernet address = %x-%x-%x-%x-%x-%x\n",
		xo->xo_eaddr[0]&0xFF, xo->xo_eaddr[1]&0xFF,
		xo->xo_eaddr[2]&0xFF, xo->xo_eaddr[3]&0xFF,
		xo->xo_eaddr[4]&0xFF, xo->xo_eaddr[5]&0xFF);
	xoprintf(xstdout,"\ttelnet options offered = %x\n",
		xo->xo_tsoffer & 0xFF);
	xoprintf(xstdout,"\ttelnet options permitted = %x\n",
		xo->xo_tspermit & 0xFF);
	xoprintf(xstdout,"\thost link mode access %s\n",
		xo->xo_dolink ? "enabled" : "disabled");
	xoprintf(xstdout,"\tmaximum pending host requests = %d\n",
		xo->xo_npending);
	xoprintf(xstdout,"\tnumber of extended memory buffers = %d\n",
		xo->xo_nxmbufs);
	xoprintf(xstdout,"\tNX 5.0 buffer chaining %s\n",
		xo->xo_bufchain ? "requested" : "disabled");
}

enet_addr(cp, ep)
char	*cp;
char	*ep;
{
	int val;
	char c;
	int np;

	for (np = 0; np < 6; np++) {
		/*
		 * Collect number up to "-".
		 * Values are hexadecimal only!
		 */
		val = 0;
		while (c = *cp) {
			if (isdigit(c)) {
				val = (val * 16) + (c - '0');
				cp++;
				continue;
			}
			if (isxdigit(c)) {
				val = (val << 4) + (c + 10 - (islower(c) ?
					 'a' : 'A'));
				cp++;
				continue;
			}
			break;
		}
		if (np < 5 && *cp != '-')
			return -1;
    		if (val > 0xFF)
    			return -1;
		*ep++ = val, cp++;
	}
	return 0;
}

clientinit()
{
	int xmodname();

	/*
	 * The comparison below must look legit, or the System 8000
	 * compiler will optimize the xmodname() invocation right
	 * out of existence.
	 */
	if(xmodname == 0)	/* fake-out linker */
		xmodname();
}
