/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_ioctl.h,v 1.3 87/04/24 14:38:13 davidb Exp $ */
/* @(#)ex_ioctl.h	1.12 5/7/85 */

/*
 * GAP 1/11/85:  W A R N I N G  - This file is included by both host
 * and board code.  Make changes with extreme caution, and test
 * effects on both the host and board sides.
 */


#ifdef	BSD4dot2

#ifndef _IO
/*
 * Ioctl's have the command encoded in the lower word,
 * and the size of any in or out parameters in the upper
 * word.  The high 2 bits of the upper word are used
 * to encode the in/out status of the parameter; for now
 * we restrict parameters to at most 128 bytes.
 */
#define	IOCPARM_MASK	0x7f		/* parameters must be < 128 bytes */
#define	IOC_VOID	0x20000000	/* no parameters */
#define	IOC_OUT		0x40000000	/* copy out parameters */
#define	IOC_IN		0x80000000	/* copy in parameters */
#define	IOC_INOUT	(IOC_IN|IOC_OUT)
/* the 0x20000000 is so we can distinguish new ioctl's from old */
#define	_IO(x,y)	(IOC_VOID|('x'<<8)|y)
#define	_IOR(x,y,t)	(IOC_OUT|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
#define	_IOW(x,y,t)	(IOC_IN|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
/* this should be _IORW, but stdio got there first */
#define	_IOWR(x,y,t)	(IOC_INOUT|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
#endif

#define _IOS(y) (IOC_VOID|((sizeof(long))<<16)|y)

#ifndef _IOXSIO
#define _IOXSIO(y) (IOC_VOID|((sizeof(long))<<16)|('s'<<8)|y)
#define _IOXFIO(y) (IOC_VOID|((sizeof(long))<<16)|('f'<<8)|y)
#endif

#define map_ioctl_cmd(x) (x&0xffff)

#else	/* BSD4dot2 */
#define	_IO(x,y)	(('x'<<8)|y)
#define _IOR(x,y,t)	_IO(x,y)
#define _IOW(x,y,t)	_IO(x,y)
#define _IOWR(x,y,t)	_IO(x,y)
#define _IOS(y)     	(y)	

#ifndef _IOXSIO
#define _IOXSIO(y) (('s'<<8)|y)		/* define SIO ioctls */
#define _IOXFIO(y) (('f'<<8)|y)		/* define FIO ioctls */
#endif

#define map_ioctl_cmd(x) (x)

#endif	/* BSD4dot2 */
/* ioctl commands for exos admin and download devices */
#define	EXIOCRESET	_IOS(0)		/* download some data */
#define	EXIOCSTART	_IOS(1)		/* start exos running */
#define	EXIOCFIND	_IOS(2)		/* find a free socket */
#define	EXIOCSTAT	_IOS(3)		/* get network stats */
#define EXBDSTAT	_IOS(5)		/* get board statistics */
#define EXBDSTATRESET	_IOS(6)		/* get/reset board statistics */
#define	EXIOCGCONF	_IOS(7)		/* get configuration msg */

#ifdef LINKMODE
/* link-mode msgs -- same as "real" link-mode */
#define	EX_NET_MODE	8
#define	EX_NET_ADDRS	9
#define	EX_NET_RECV	10
#define	EX_NET_STATS	11
#define	EX_XMIT		12
#define	EX_RECV		13
#endif
#define EXIOCSARP	_IOS(20)		/* set an arp entry */
#define EXIOCGARP	_IOS(21)		/* get an arp entry */
#define EXIOCDARP	_IOS(22)		/* delete an arp entry */
#define EXIOCADDRT	_IOS(23)		/* add route entry */
#define EXIOCDELRT	_IOS(24)		/* delete route entry */
#define EXIOCSHOWRT	_IOS(25)		/* show route entry */
#define EXIOCDISPRT	_IOS(26)		/* display route entry */
#define EXNETBIOSINIT	_IOS(27)		/* init netbios params */
/* commands for xioctl */
#define BRDADDR		10		/* set address for next io on board */
#define BRDINIT		EXIOCRESET
#define BRDSTART	EXIOCSTART
#define BRDGSTAT	EXBDSTAT
#define BRDRSSTAT	EXBDSTATRESET
#define	BRDGCONF	EXIOCGCONF
#define BRDSARP		EXIOCSARP
#define BRDGARP		EXIOCGARP
#define BRDDARP		EXIOCDARP
#define BRDGCONF	EXIOCGCONF
#define BRDADDRT	EXIOCADDRT	
#define BRDDELRT	EXIOCDELRT	
#define BRDSHOWRT       EXIOCSHOWRT	
#define BRDDISPRT	EXIOCDISPRT	
#define NETBIOSINIT	EXNETBIOSINIT

/*
 * Socket ioctl call interface structure:
 *	- all of the "system calls" are implemented as ioctl's
 *	- this structure is used for all the ioctl's
 *	- only the data appropriate for the particular call is filled
 *	  in, the remainder is unused
 * GAP 5/7/85: Declare pointers as longs, for systems like S8000
 * and Xenix/286 3.0, where pointer size depends on programming model.
 */
struct	SOioctl {
	short	hassa;			/* non-zero if sa specified */
	struct	sockaddr sa;		/* socket address (optional) */
	short	hassp;			/* non-zero if sp specified */
	struct	sockproto sp;		/* socket protocol (optional) */
	int	type;			/* socket type */
	int	options;		/* options */

    /* these are for select() */
	int	nfd;
	long	wp;			/* POINTER to long wp */
	long	rp;			/* POINTER to long rp */
	long	timo;

    /* these are for send(), receive(), and ioctl() */

	long	cbuf;			/* POINTER to data buffer */
	unsigned count;			/* size of buffer */
};

/* Data structure used to send board statistics to host */

struct EXbdstats {
	long	xmt;		/* frames transmitted successfully */
	long	excess_coll;	/* xmits aborted due to excess coll */
	long	late_coll;	/* xmits aborted due to late coll */
	long 	tdr;		/* time domain reflectometer */
	long	rcv;		/* error free frames received */ 
	long	align_err;	/* frames rcvd with alignment err */
	long	crc_err;	/* frames rcvd with crc errors */
	long	lost_err;	/* frames lost due to no buffers */

	/* other bits of info about the board */

	short 	fw_release;	/* firmware release */
	short	sw_release;	/* software release */
	short 	hw_release;	/* hardware release */
};	

/*
* Ioctl structure for manipulations of the ARP cache
*/

struct EXarp_ioctl {
	struct sockaddr		arp_pa;		/* protocol address */
	struct sockaddr		arp_ha;		/* hardware address */
	long			arp_flags;	/* flags */
};

#define ATF_COM			2		/* completed entry */
#define ATF_PERM		4		/* perminant entry */
#define ATF_PUBL		8		/* respond for another host */

/*
 * Socket ioctl calls:
 *	- a trick in the implementation here is that the socket messages
 *	  to the exos board use the ioctl type as the message type,
 *	  thus the numbers used have to be outside the range of the
 *	  normal exos message numbers
 *	- dont change these numbers!
 *	- due to changes in how the generic ioctl works it will be nessasary
 *        to handle numbers from the board differently. (for 4.2)
 *	- host-to-board requests must be less than 64; flags take up the
 *	  top two bits.  (see, eg, NM_MORE in exos.h)
 */

#define	TSCOMMAND	_IOS(40)
#define	SOSOCKET	_IOS(50)
#define	SOACCEPT	_IOS(51)
#define	SOCONNECT	_IOS(52)
#define	SOSEND		_IOS(53)
#define	SORECEIVE	_IOS(54)
#define	SOSOCKETADDR	_IOS(55)
#define	SOCLOSE		_IOS(56)
#define	SOVERIFY	_IOS(57)
#define	SOIOCTL		_IOS(58)
#define	SOSELECT	_IOS(59)
#define	SOASYNCIO	_IOS(60)

/*  unsollicited messages from board */
#define SOSELWAKEUP	_IOS(80)
#define	SOHASOOB	_IOS(81)
