/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: mchc.c,v 1.4 87/04/24 14:15:39 davidb Exp $ */
/*
 * @(#)pcxenix.c	1.2 8/21/85
*/

#define ibmxenix2

#ifdef scoxenix5		/* scoxenix5 and SYSTEM5 are mutex */

/* The following symbols were removed from super Makefile and put here to
 * avoid compilation problem.  They are used by system include files.
 */
#ifndef ibmxenix2
#define M_KERNEL
#endif
#define M_OLDSIGN

#include "sys/types.h"
#include "sys/param.h"
#ifndef ibmxenix2
#include "sys/sysmacros.h"
#endif
#include "sys/systm.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#ifndef EPERM
#include "sys/errno.h"
#endif
#include "sys/file.h"
#include "sys/tty.h"
#include "sys/conf.h"
#include "sys/buf.h"
#define SBUFSIZE BSIZE
#else /* scoxenix5 */
#ifdef SYSTEM5
#include "sys/param.h"
#include "sys/config.h"
#include "sys/types.h"
#include "sys/systm.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/tty.h"
#include "sys/termio.h"
#include "sys/conf.h"
#include "sys/buf.h"
#endif /* SYSTEM5 */
#endif /* scoxenix5 */

#ifdef SYSTEM3		/*dan rector*/
#include "sys/param.h"	/*dan rector*/
#include "sys/dir.h"	/*dan rector*/
#include "sys/user.h"	/*dan rector*/
#include "sys/systm.h"	/*dan rector*/
#include "sys/buf.h"	/*dan rector*/
#endif			/*dan rector*/

#ifdef VERSION7
#include <sys/param.h>
#include <sys/buf.h>
#endif

#include <sys/extypes.h>
#include <sys/socket.h>
#include "exreg.h"
#include <sys/init.h>
#include <sys/proc_dep.h>
#include "exos.h"

#ifdef PULLIN
#undef PULLIN
#endif /* PULLIN */
#include "config.h"

#include "context.h"
#include <sys/stdxln.h>
#include <sys/client.h>

IMPORT short	xso_client_id;
IMPORT VOID	xsointr();
IMPORT VOID	xsonotify();
IMPORT VOID ex_killprocs();
extern	struct exctrl ex_db;
extern	struct rmsg_area *rmsgarea;
extern	struct wmsg_area *wmsgarea;
static struct buf *imsgb = 0;

struct rmsg_area rmsgq;
struct wmsg_area wmsgq;
extern struct commarea *xm_pca;
long xpeekd();
long fixadr();
struct buf *ex_getbuf();

/***************************************************************************/
/* Set PORTADDR for YOUR system !!!                                        */
/***************************************************************************/

/* base i/o address of excelan on multibus */
#define	PORTADDR	0x310

#define	DEBUG

static
long
wswap( x )
union host_long x;
{
	union host_long tmp;

	tmp.hl_struct.hls_high = x.hl_struct.hls_high;
	tmp.hl_struct.hls_low = x.hl_struct.hls_low;
	return( tmp.hl_long );
}

exinit()
{
	extern int xm_cp2;
	register long adr;
	int imsg_offset;
	struct init_msg *inpt;
	int hipara;

	if ( !ex_db.ex_port )
		ex_db.ex_port = (u_short) PORTADDR;
	/*
	 * copy initialization message for download program
	 */
	swtchbank( offtobank(CONFMSGADR) );
	if( !imsgb )
		imsgb = getblk( EXSEG_BUF );
	ex_db.ex_imsg = bptof(imsgb->b_paddr);
	adr = fixadr( xpeekd((int)(CONFMSGADR & (long)(XM_WSIZE-1))) );
	swtchbank( offtobank( adr ) );
	imsg_offset = (adr & (long)(XM_WSIZE-1) );
	xcopyi(ex_db.ex_imsg, imsg_offset, sizeof( struct init_msg ));
	swtchbank( XM_UPPER);

	/*
	 * fix up init message to reflect current reality
	 * ie add space for message queues
	 */
	inpt = (struct init_msg *)0;
	hipara = xpeekw( HIBOUND & (long)(XM_WSIZE-1));
	biput(imsgb, &inpt->im_wordptn[0], 0);
	biput(imsgb, &inpt->im_wordptn[1], hipara);
	adr = fixadr( xpeekd(&xm_pca->ca_rcvhd));
	rmsgarea = (struct rmsg_area *)&rmsgq;
	rmsgarea->ma_lastr = (struct msg *)(adr & (long)(XM_WSIZE-1));

	adr = fixadr( xpeekd(&xm_pca->ca_sendhd));
	wmsgarea = (struct wmsg_area *)&wmsgq;
	wmsgarea->ma_lastw = (struct msg *)(adr & (long)(XM_WSIZE-1));

	/*
	 * CAUTION: both queues are assumed to be in one and the same
	 * window.
	 */
	ex_db.ex_qbank = offtobank(adr);

	/*
	 * register socket client in the client interface.
	 */
#ifdef ibmxenix2  /* kludge because ibmxenix depends on scoxenix5 */
	client_register((EXaddr_t)&context[ 0 ], 
			(EXaddr_t)&context[ NET_CONTEXTS-1 ], 
			xsointr, xsonotify, ex_killprocs, &xso_client_id );
#else
#ifdef scoxenix5
	client_register( (((EXaddr_t)&context[ 0 ]) & 0x0000ffffL ), 
			(((EXaddr_t)&context[ NET_CONTEXTS-1 ]) & 0x0000ffffL ),
			xsointr, xsonotify, ex_killprocs, &xso_client_id );
#else
	client_register((EXaddr_t)&context[ 0 ], 
			(EXaddr_t)&context[ NET_CONTEXTS-1 ], 
			xsointr, xsonotify, ex_killprocs, &xso_client_id );
#endif /* scoxenix5 */
#endif /* ibmxenix2 */
	ex_db.ex_init = 1;
	return 1;
} /* exinit */


exrequest()
{
	register unsigned tcnt, chunk;
	register caddr_t ex_adr;
	register faddr_t pc_adr;
	register short mode;
	extern int xm_cp2;
	long adr;
	int spurious = 1;

	swtchbank( XM_UPPER );

	if( (xpeekw(&xm_pca->ca_hsb.hsb_status) & HSB_OWN ) == 0 ) {
		switch( mode = xpeekw(&xm_pca->ca_hsb.hsb_reqcode) ) {
			/*
			 * CAUTION: requests are assumed not to cross
			 * host page boundries.
			 */
		case EX_TO_PC:
		case PC_TO_EX:
			/*
			 * read transfer count
			 */
			spurious = 0;
			tcnt = xpeekw( &xm_pca->ca_hsb.hsb_tcount );

/*			if( tcnt >EXBSIZE ) {
 *				printf( "unreasonable count: %d\n", tcnt );
 *				break;
 *			}
 */

			adr = xpeekd(&xm_pca->ca_hsb.hsb_pcadr);
			/*
			 * NX stores a physical address need to convert to
			 * a kernel virtual address for xcopy? to work
			 * No, we passed NX a virtual address.
			 */
			pc_adr = (faddr_t)adr;
			/*
			 * get exos address and manipulate it into a
			 * window plus offset
			 */
			adr = fixadr(xpeekd(&xm_pca->ca_hsb.hsb_exadr));
			while( tcnt ) {
				ex_adr = (caddr_t)(adr & (long)(XM_WSIZE-1));
				if( (int)(ex_adr + tcnt) > XM_WSIZE )
					chunk = XM_WSIZE - (int)ex_adr;
				else
					chunk = tcnt;
				swtchbank(offtobank(adr));
				if( mode == EX_TO_PC ) {
					xcopyi(pc_adr, ex_adr, chunk );
				} else {
					xcopyo(ex_adr, pc_adr, chunk );
				}
				tcnt -= chunk;
				adr += (long)chunk;
				pc_adr += chunk;
			}
			break;
		case RESET586:
			/*
			 * reset and re-enable 82586.
			 */
			spurious = 0;
			xm_cp2 &= ~CP2_ENA586;
			out(CP2_ADR, xm_cp2 );
			xm_cp2 |= CP2_ENA586;
			out(CP2_ADR, xm_cp2 );
			break;
		case NO_REQ:
			return ( spurious );
		default:
			printf( "unknown 205 request\n" );
			break;
		}
		swtchbank(XM_UPPER);
		xpokew(&xm_pca->ca_hsb.hsb_status, HSB_OWN|HSB_DONE);
		out(CP1_ADR, 0);
	}
	return( spurious );
}


long
fixadr( padr)
union segaddr padr;
{
	register long adr;

	adr = (long)padr.sa_s.sa_segment;
	adr <<= 4;
	adr += (long)padr.sa_s.sa_offset;
	return( adr );
}

/*
 * ex_getbuf:
 *	- get a buffer from the buffer cache which does not cross
 *	  a segment boundary - this is presumed to be in the multibus
 *	  address space
 *	- if we get a buffer which crosses a segment boundary, recurse
 *	  until we get a good one
 */
struct buf *
ex_getbuf()
{
	register struct buf *nextbp, *bp;
	register caddr_t p;
	struct buf *getablk();	/*dan rector*/

	bp = getablk(EXSEG_BUF);	/*dan rector*/
	if (bp->b_paddr)	/*dan rector*/
		xclear((bp->b_paddr), BSIZE);	/*dan rector*/
	return bp;
}


#define	EXOS_MEOI	0x63
#define	EXOS_SEOI	0x62

/* reset system interrupt hardware */
ex_zap()
{
}

unsigned
SEGNO(x)
long x;
{
	struct host_long xx;

	xx.hl_long = x;
	return (unsigned)(xx.hl_struct.hls_high << 12);
}
