/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_socket.c,v 1.2 87/04/24 14:13:39 davidb Exp $ */

/*
 * Socket driver for excelan ethernet driver
 *
 * This driver is used to:
 *	- manipulate the sockets which reside on the exos
 *
 * Written by: Kipp Hickman
 */

/*
   revision history:
   rev	by	description
   ---  ------- -----------
   1.7	pbf	Make xsoopen check ex_inited & return ENXIO if not set.
		Make xsoopen look at so_id when checking if socket is reserved.
		Remove unnecessary checks of ex_inited from other routines.
		Make xsoclose call ex_klfree. Change calls to ex_send to add
		dev argument. Add dev argument to socontrol.
   1.8	pbf	Add kl_baddr field to context struct to hold pointer to data
		buffer for send and receive operations so buffer can be
		reclaimed when a send or receive is interrupted.
   4/18	wrn     no un-killable messages to board.
   8/17/84 wrn	small amounts of data sent/received in messages, not in buffers
   8/23/84 wrn	send/receive possibly generate more than 1 send/receive on bd.
   9/9/84 wrn	New vax-compatable exos.h rearranges "struct msg".
		Set length of message before passing it to board.
  12/12/86 dab	Changed most references to kl_reply to kl_error. 
		Ex_subr.c: ex_send() puts the error code into kl_error. 
		Only cases where NM_MAGIC_DATA is looked at use kl_reply, 
		for the most part.

		Added error mapping code (as in ex_send()) to ex_pendio().
		As a result, fixed a potential problem in ex_pendio().
		If the pending I/O had already occurred (i.e., KL_DONE
		bit set), the routine just returned without resetting
		u_qsav (or spl). Spl isn't a real problem (since it gets
		reset when the process exits the kernel), but not resetting
		qsav could be. If the process got hit by another signal,
		it would likely cause the kernel to go south, as it would
		long jump to the middle of ex_pendio().
 
 */

#define EXOSASYNCIO

#define PULLIN
#include "config.h"

extern	struct msg *ex_findmsg();
struct	context *ex_send(), *xsoreceive(), *ex_pendio();
struct	exctrl ex_db;			/* software device structure */
short	xso_client_id = -1;		/* socket client id */
static char sccsId[] = "@(#)ex_socket.c	2.4 5/31/85";

/*
 * xsoopen:
 *	- called to initiate usage of a socket device
 *	- device must be free for this to work correctly, so check
 *	  the so_state and make sure it is
 *	- xsoclose() will clear the state
 *	- xsoioctl() --> SOSOCKET will set up the state
 */
/*ARGSUSED*/
xsoopen(dev, flag)
	dev_t dev;
	int flag;
{
	register int mdev = minor(dev);

	if (!ex_inited) {
		u.u_error = ENXIO;
		return(u.u_error);
	}
	if (so_state[mdev] != SOS_RESERVED || so_id[mdev] != u.u_procp->p_pid)
		u.u_error = EBUSY;
	return(u.u_error);
}

/*
 * xsoclose:
 *	- called to terminate usage of a socket
 *	- send SOCLOSE message
 *	- shutdown socket usage by clearing its state and socket id
 */
/*ARGSUSED*/
xsoclose(dev, flag)
	dev_t dev;
	int flag;
{
	register struct messages *mp;
	register struct context *kp;
	register int mdev = minor(dev);
	register short s;
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

	if (so_state[mdev] & SOS_BUSY) {
		mp = (struct messages *)ex_findmsg( mdev );
		xputw (mp->nm_soid, so_id[mdev]);
		kp = ex_send(map_ioctl_cmd(SOCLOSE), mdev, mp, 0);
		u.u_error = kp->kl_error;
		kp->kl_state = KL_FREE;
	} else  {
		so_state[mdev] = SOS_FREE;
		so_id[mdev] = 0;
		socket_deallocate( xso_client_id, mdev );
#ifdef SOASYNCIO
		EXSPL6(s);
		so_async[mdev] = 0;
		so_signum[mdev] = -1;
		spl0();
#endif	/* SOASYNCIO */
	}
	return(u.u_error);
}

/*
 * xsoread:
 *	- attempt read on a socket
 */
#ifdef BSD4dot2
xsoread(dev, uio )
	dev_t dev;
	struct uio *uio;
#else
xsoread(dev)
	dev_t dev;
#endif
{
	register int mdev = minor(dev);
	register struct context *kp;
#ifdef BSD4dot2
	/*
	compensate for obsolesence of u.u_count
	*/
	register int uiocnt;
	struct iovec *iov;

	for ( u.u_count = 0, iov = uio->uio_iov, uiocnt = 0 ; 
		uiocnt < uio->uio_iovcnt ; ++uiocnt, ++iov )
		{
		u.u_count += iov->iov_len;
		}
#endif
	if (so_state[mdev] & SOS_BUSY) {
#ifdef BSD4dot2
		kp = xsoreceive(mdev, (struct sockaddr *)NULL, iov, uio);
#else
		kp = xsoreceive(mdev, (struct sockaddr *)NULL);
#endif
		kp->kl_state = KL_FREE;
		if (ex_db.ex_state & ST_WAITING)
			wakeup((caddr_t)&ex_db);
	} else
		u.u_error = EIO;
	return(u.u_error);
}

#ifdef BSD4dot2
xsowrite(dev, uio)
	dev_t dev;
	struct uio *uio;
#else
xsowrite(dev)
	dev_t dev;
#endif
{
	register int mdev = minor(dev);
#ifdef BSD4dot2
	/*
	compensate for obsolesence of u.u_count
	*/
	register int uiocnt;
	struct iovec *iov;

	for ( u.u_count = 0, iov = uio->uio_iov, uiocnt = 0 ; 
		uiocnt < uio->uio_iovcnt ; ++uiocnt, ++iov )
		{
		u.u_count += iov->iov_len;
		}
#endif
	if (so_state[mdev] & SOS_BUSY)
#ifdef BSD4dot2
		xsosend(mdev, (struct sockaddr *)NULL, iov, uio );
#else
		xsosend(mdev, (struct sockaddr *)NULL);
#endif
	else
		u.u_error = EIO;
	return( u.u_error );
}

/*
 * xsoioctl:
 *	- all the major socket system calls are emulated via the xsoioctl()
 *	  processor
 */
/*ARGSUSED*/
xsoioctl(dev, cmd, addr, flag)
	dev_t dev;
	register int cmd;
	int flag;
	EXioctltype addr;
{
	register struct Sock_cmd *Sock_cmd;
	register int mdev = minor(dev);
	register struct context *kp;
	struct SOioctl param;
#ifdef BSD4dot2
	struct iovec iov;
	struct uio uio;

	/* IOVOID sets addr to point to the original argument */
	addr = (caddr_t)(*((long *)addr));
	/* map command to number used by board */
	cmd = map_ioctl_cmd(cmd);
#endif
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

#ifdef	DEBUG
printf("unix: xsoioctl: mdev=%x cmd=%d\n", minor(mdev), cmd);
#endif
	if (copyin(addr, (caddr_t)&param, sizeof(param))) {
		u.u_error = EFAULT;
		return(u.u_error);
	}

	if (cmd != map_ioctl_cmd(SOSOCKET))
		if ((so_state[mdev] & SOS_BUSY) == 0) {
			u.u_error = EIO;
			return(u.u_error);
		}
	switch (cmd) {
	  case map_ioctl_cmd(SOSOCKET):
	  case map_ioctl_cmd(SOACCEPT):
	  case map_ioctl_cmd(SOCONNECT):
	  case map_ioctl_cmd(SOSOCKETADDR):
 		Sock_cmd = (struct Sock_cmd *)ex_findmsg( mdev );
		xputw( Sock_cmd->nm_isaddr, param.hassa );
		if (param.hassa)
			xcpo((EXbatype)&param.sa, &Sock_cmd->nm_saddr,
				sizeof (struct sockaddr));
		xputw( Sock_cmd->nm_isproto, param.hassp );
		if ( param.hassp)
			xcpo((EXbatype)&param.sp, &Sock_cmd->nm_sproto,
				sizeof (struct sockproto));
		if (cmd == map_ioctl_cmd(SOSOCKET)) {
			if (u.u_ruid == 0 || u.u_uid == 0) /* suser() */
				xputw( Sock_cmd->nm_iamroot, 1);
			else
				xputw( Sock_cmd->nm_iamroot, 0);
			u.u_error = 0;
		} else
			xputw( Sock_cmd->nm_soid, so_id[mdev]);
		xputw( Sock_cmd->nm_type, param.type);
		xputw( Sock_cmd->nm_options, param.options);
		xputw( Sock_cmd->mh_length, 
			sizeof( struct Sock_cmd ) - sizeof( struct headers ));
		kp = ex_send(cmd, mdev, Sock_cmd, 0);
		if (u.u_error = kp->kl_error) {
			kp->kl_state = KL_FREE;
			if (ex_db.ex_state & ST_WAITING)
				wakeup((caddr_t)&ex_db);
			return(u.u_error);
		}
		break;
	  case map_ioctl_cmd(SOSEND):
	  case map_ioctl_cmd(SORECEIVE):

#ifdef BSD4dot2
		basemv(0, param.cbuf, param.count, &iov, &uio);
#else
		basemv(0, EXupaddr(param.cbuf), param.count);
#endif
		if (cmd == map_ioctl_cmd(SOSEND)) {
#ifdef BSD4dot2
			xsosend(mdev, param.hassa ? &param.sa :
			                (struct sockaddr *)NULL,
					&iov, &uio);
#else
			xsosend(mdev, param.hassa ? &param.sa :
				                  (struct sockaddr *)NULL);
#endif
			param.count -= u.u_count;
			return(u.u_error);
		}
#ifdef BSD4dot2
		kp = xsoreceive(mdev, param.hassa ? &param.sa :
					(struct sockaddr *)NULL,
					&iov, &uio);
#else
		kp = xsoreceive(mdev, param.hassa ? &param.sa :
						  (struct sockaddr *)NULL);
#endif
		param.count -= u.u_count;
		break;

	  default:
		socontrol(mdev, cmd, addr, so_id[mdev]);
		return(u.u_error);
	}

    /* handle response to command */

	switch (cmd) {
	  case map_ioctl_cmd(SOSOCKET):
		so_id[mdev] = kp->kl_soid;
		so_state[mdev] = SOS_BUSY;
		socket_set( xso_client_id, mdev, kp->kl_soid );
		break;
	  case map_ioctl_cmd(SOACCEPT):
	  case map_ioctl_cmd(SOCONNECT):
	  case map_ioctl_cmd(SOSOCKETADDR):
		if(param.hassa) {
			param.sa = kp->kl_sa;
		}
		/*
		Fall Through
		*/
	  case map_ioctl_cmd(SORECEIVE):
		if (param.hassa) {
			if (copyout((caddr_t)&param, addr, sizeof(param)))
				break;
		}
	}
	kp->kl_state = KL_FREE;		/* free up context buf */
	if (ex_db.ex_state & ST_WAITING)
		wakeup((caddr_t)&ex_db);
	return(u.u_error);
}

/*
 * xsosend
 *	- write/send data to a socket
 */
#ifdef BSD4dot2
xsosend(mdev, sa, iov, uio)
	int mdev;
	register struct sockaddr *sa;
	struct iovec *iov;
	struct uio *uio;
#else
xsosend(mdev, sa)
	int mdev;
	register struct sockaddr *sa;
#endif
{
	register struct Sock_pkt *Sock_pkt;
	register int amount;
	register EXbatype baddr;
	register struct context *kp;
	register struct msg *mp;
	register long sopaddr;
	register short d;
	register int more;
	register int current_cnt;
	int	pk_flags;
	EXbtype *bp;
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

	if (u.u_count == 1) {
#ifdef 		BSD4dot2
		sendmagic(mdev, sa, uio);
#else	/* BSD4dot2 */
		sendmagic(mdev, sa);
#endif	/* BSD4dot2 */
		return;
	}
	d = so_id[mdev];
	if (so_state[mdev] & SOS_PENDWRT) {
		kp = ex_pendio(mdev, KL_WRITE);
		if (kp) {
			bp = kp->kl_baddr;
			baddr = (EXbatype) kp->kl_daddr;
			sopaddr =((long) EXvtop(baddr,bp,0));
			current_cnt = kp->kl_prevcnt;
			if (kp->kl_count > u.u_count) {
			/*
			 *	Socket is unreliable from this point on.
			 *	Would have tried to copy pass the end of
			 *	the user's data buffer.
			 */
				u.u_error = EIO;
				kp->kl_baddr = (struct buf *)0;
				EXbrelse(bp, BSIZE);
				kp->kl_state = KL_FREE;
				so_state[mdev] &= ~SOS_PENDWRT;
				return (u.u_error);
			}
			/*	Adjust the start of where to start copying 
			 *	from in the user's data buffer.  This is to
			 *	handle write requests which are larger than
			 *	a system buffer.
			 */
			if(kp->kl_count) {
#ifdef BSD4dot2
				basemv(kp->kl_count, iov->iov_base, 
					iov->iov_len, iov, uio);
#else
				basemv(kp->kl_count, (long)u.u_base,
					(unsigned)u.u_count);
#endif
			}
			pk_flags = 0;
			goto restart;
		
		} else {
			so_state[mdev] &= ~SOS_PENDWRT;
			pk_flags = PK_FIRST;
		} 
	} else {
			pk_flags = PK_FIRST;
	}


	EXgetblk( baddr, bp, BSIZE );
	sopaddr = ((long)EXvtop(baddr,bp,0));
	current_cnt = 0;
	while (u.u_count) {
		more = 0;
		amount = MIN(EXBSIZE, u.u_count);
#ifdef BSD4dot2
		uiomove(EXioaddr(baddr,bp), amount, UIO_WRITE, uio );
		u.u_count -= amount;
#else
		iomove(EXioaddr(baddr,bp), amount, B_WRITE);
#endif
		EXmapout( bp );
		if (u.u_error)
			break;
		mp = ex_findmsg( mdev );
		kp = (struct context *)xgetp( mp->msg_context);
		kp->kl_count = current_cnt;
		current_cnt += amount;
		kp->kl_prevcnt = current_cnt;
#ifdef plexus
		kp->kl_baddr = (unsigned far *)baddr;
#else
		kp->kl_baddr = bp;
		kp->kl_daddr = (long)baddr;
#endif
		Sock_pkt = (struct Sock_pkt *)mp;
		xputw( Sock_pkt->nm_count, amount);
		xputw( Sock_pkt->nm_soid, d);
		xputw( Sock_pkt->mh_length,
			sizeof( struct Sock_pkt ) - sizeof( struct headers ) );
		if (sa) {
			pk_flags |= PK_ADDR;
			/*Sock_pkt->nm_saddr = *sa;	/* NON PORTABLE */
			xcpo((EXbatype)sa,
				&Sock_pkt->nm_saddr, sizeof(struct sockaddr));
		}
		if (u.u_count) {
			more = NM_MAGIC_DATA;
		} else {
			pk_flags |= PK_LAST;
		}
		xputw( Sock_pkt->nm_isaddr, pk_flags);
		xputd( Sock_pkt->nm_bufaddr, sopaddr);
		kp->kl_state |= KL_WRITE;
		kp = ex_send(map_ioctl_cmd(SOSEND)|more, mdev, mp, 0);
restart:
		kp->kl_state = KL_FREE;
		if (ex_db.ex_state & ST_WAITING)
			wakeup((caddr_t)&ex_db);
		pk_flags &= ~PK_FIRST;
		if (kp->kl_error == EMSGSIZE) {
			u.u_error = kp->kl_error;
			break;
		}
		/*	partial write with error		*/
		if (kp->kl_reply && kp->kl_count) {
			amount = current_cnt - kp->kl_count;
			u.u_count += amount;
#ifdef BSD4dot2
			uio->uio_resid += amount;
#endif
			break;
		}
		if (u.u_error = kp->kl_error) {
			if (u.u_error == EPIPE)
				psignal(u.u_procp, SIGPIPE);
			break;
		}
		/*	partial write no error			*/
		if (kp->kl_count != current_cnt) {
			amount = current_cnt - kp->kl_count;
			u.u_count += amount;
#ifdef BSD4dot2
			uio->uio_resid += amount;
#endif
			break;
		}
	}
	EXbrelse(bp, BSIZE);
}

/*
 * sendmagic:
 *	- write/send 1 byte of data to a socket
 */
#ifdef BSD4dot2
sendmagic(mdev, sa, uio)
	struct uio *uio;
#else	/* BSD4dot2 */
sendmagic(mdev, sa)
#endif	/* BSD4dot2 */
	int mdev;
	register struct sockaddr *sa;
{
	register struct Sock_pkt *Sock_pkt;
	register struct context *kp;
	register short d;
	int rval;
	char c;
	/*
	 * swtchbank already done !!!
	*/

	d = so_id[mdev];
#ifdef BSD4dot2
	uiomove((EXbatype)&c, 1, UIO_WRITE, uio);
	u.u_count -= 1;
#else	/* BSD4dot2 */
#ifdef xenix286
	rval = cpass();
	if ( rval == -1 )
		goto exout;
	c = rval;
#else	/* xenix286 */
	iomove((EXbatype)&c, 1, B_WRITE);
#endif	/* xenix286 */
#endif	/* BSD4dot2 */
	if (u.u_error)
		goto exout;
	Sock_pkt = (struct Sock_pkt *)ex_findmsg( mdev );
	xputw( Sock_pkt->nm_soid, d);
	xputw( Sock_pkt->nm_count, 1);
	xputb( Sock_pkt->nm_data, c);
	if (sa) {
		xputw( Sock_pkt->nm_isaddr, 1);
		xcpo((EXbatype)sa, &Sock_pkt->nm_saddr, sizeof(struct sockaddr));
	} else
		xputw( Sock_pkt->nm_isaddr, 0);
	xputw( Sock_pkt->mh_length,
		sizeof( struct Sock_pkt ) - sizeof( struct headers ) );
	kp = ex_send(map_ioctl_cmd(SOSEND)|NM_MAGIC_DATA, mdev, Sock_pkt, 0);
	if (u.u_error = kp->kl_error) {
		if (u.u_error == EPIPE)
			psignal(u.u_procp, SIGPIPE);
	}
	kp->kl_state = KL_FREE;
	if (ex_db.ex_state & ST_WAITING)
		wakeup((caddr_t)&ex_db);
exout:
	return;
}

/*
 * xsoreceive:
 *	- read/receive data from a socket
 *	- only do a single read, returning the number of bytes read
 */
struct context *
#ifdef BSD4dot2
xsoreceive(mdev, sa, iov, uio)
	int mdev;
	register struct sockaddr *sa;
	struct iovec *iov;
	struct uio *uio;
#else
xsoreceive(mdev, sa)
	int mdev;
	register struct sockaddr *sa;
#endif
{
	register struct Sock_pkt *Sock_pkt;
	register int amount;
	register EXbatype baddr;
	register struct msg *mp;
	register struct context *kp;
	register long sopaddr;
	register int cmd;
	register int current_cnt;
	int pk_flags;
	EXbtype *bp;
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

	if (so_state[mdev] & SOS_PENDRD) {
		kp = ex_pendio(mdev, KL_READ);
		if (kp) {
			bp = kp->kl_baddr;
			baddr = (EXbatype) kp->kl_daddr;
			sopaddr =((long) EXvtop(baddr,bp,0));
			current_cnt = kp->kl_prevcnt;
			if (kp->kl_count > u.u_count) {
			/*
			 *	Socket is unreliable from this point on.
			 *	Would have tried to copy pass the end of
			 *	the user's data buffer. 
			 */
				u.u_error = EIO;
				so_state[mdev] &= ~SOS_PENDRD;
				goto out1;
			}
			/*
			 *	Adjust the start of where to start copying
		 	 *	into the user's data buffer.  This is to
			 *	handle read requests which are larger than	
			 *	a system buffer.
			 */
			if(kp->kl_prevcnt) {
#ifdef BSD4dot2
				basemv(kp->kl_prevcnt, iov->iov_base,
					 iov->iov_len, iov, uio);
#else
				basemv(kp->kl_prevcnt, (long)u.u_base,
					(unsigned)u.u_count);
#endif
			}
			pk_flags = 0;
			goto retrive;
		
		} else {
			pk_flags = PK_FIRST;
			so_state[mdev] &= ~SOS_PENDRD;
		}
	} else {
		pk_flags = PK_FIRST;
	}

	EXgetblk( baddr, bp, BSIZE );
	sopaddr = ((long)EXvtop(baddr,bp,0));
	current_cnt = 0;

again:
	amount = MIN(EXBSIZE, u.u_count);

	mp = ex_findmsg(  mdev );
	kp = (struct context *)xgetp( mp->msg_context );
	kp->kl_count = current_cnt;
#ifdef plexus
	kl_baddr = baddr;
#else
	kp->kl_baddr = bp;
	kp->kl_daddr = (long)baddr;
#endif
	Sock_pkt = (struct Sock_pkt *)mp;
	xputw( Sock_pkt->nm_soid, so_id[mdev] );
	xputw( Sock_pkt->nm_count, amount);
	if (sa) {
		pk_flags |= PK_ADDR;
		xcpo((EXbatype)sa, &Sock_pkt->nm_saddr, sizeof(struct sockaddr));
	}
	if (amount == u.u_count)
		pk_flags |= PK_LAST;
	xputw(Sock_pkt->nm_isaddr, pk_flags);
	xputd(Sock_pkt->nm_bufaddr, sopaddr);
	xputw( Sock_pkt->mh_length,
		sizeof( struct Sock_pkt ) - sizeof( struct headers ) );
	cmd = map_ioctl_cmd(SORECEIVE)|NM_MAGIC_DATA;
	kp->kl_state |= KL_READ;
	kp = ex_send(cmd, mdev, mp, 0);
retrive:
	/*	truncated datagram
 	 *	The datagram on the board is larger than the user's  
	 *	buffer.  The board sets EMSGSIZE and the byte count
	 *	of the amount of data copied in.  This error can not
	 *	be reported back to the user.
	 */
	if ( kp->kl_error == EMSGSIZE) {
		kp->kl_error = 0;
	}
	if (u.u_error = ( kp->kl_error )) {
		amount = 0;
		if( kp->kl_prevcnt ) {
			/*	partial read with error			*/
			u.u_error = 0;
		}
		goto out1;
	}
	pk_flags &= ~PK_FIRST;
	if ( sa ) {
		bcopy( &(kp->kl_sa), sa, sizeof( struct sockaddr ));
		sa = NULL;
	}
	amount = kp->kl_count - kp->kl_prevcnt;
	if(amount < 0 || amount > EXBSIZE) {
		printf("xsoreceive: bad read count = %x\n",amount);
	}
	current_cnt += amount;
	/* 1 byte of data passed in context buffer if magic turned on */
	if ((kp->kl_reply & NM_MAGIC_DATA) && (amount == 1))
#ifdef pcxenix
		*((char far *)baddr) = kp->kl_achar;
#else
		*baddr = kp->kl_achar;
#endif
	if (amount) {
#ifdef BSD4dot2
		uiomove(EXioaddr(baddr,bp), amount, UIO_READ, uio);
		u.u_count -= amount;
#else
		iomove(EXioaddr(baddr,bp), amount, B_READ);
		EXmapout( bp );
#endif
	}
	/*
	 * continue to read if there is more pending and the user wants it.
	 * note that if we just received 1 byte, the flag
	 * means magic data as opposed to more data.
	 */
	if (u.u_count && (kp->kl_reply & NM_MAGIC_DATA) && (amount > 1)) {
		kp->kl_baddr = (struct buf *)0;
		kp->kl_state = KL_FREE;
		goto again;
	}

out1:
	kp->kl_baddr = (EXbtype *)0;
	EXbrelse(bp, BSIZE);
	return kp;
}

/*
 * socontrol:
 *	- process socket ioctl's (real socket ioctl's)
 */
socontrol(mdev, cmd, addr, soid)
	int cmd;
	EXioctltype addr;
	int soid;
	int mdev;
{
	register struct context *kp;
	register struct Sock_ioctl *sp;
	register int howmuch = 0;	/* 1==char, 2==int, 3 == route */
	int	anint;
	char	achar;
	struct	rtentry route;
	/*
	 * swtchbank already in xsoioctl
	 */

    /* figure out which ioctl we are doing ... */

	switch (cmd) {
	  case map_ioctl_cmd(FIONREAD):
	  case map_ioctl_cmd(SIOCGKEEP):
	  case map_ioctl_cmd(SIOCGLINGER):
	  case map_ioctl_cmd(SIOCRCVOOB):
	  case map_ioctl_cmd(SIOCATMARK):
	  case map_ioctl_cmd(SIOCGPGRP):
		break;
	  case map_ioctl_cmd(SIOCSENDOOB):
#ifdef altos
		/*
		Aviod bug with xenix copyin.
		*/
		if (copyin(addr, (caddr_t)&anint, sizeof(anint))) {
			u.u_error = EFAULT;
			return(u.u_error);
		}
		achar = ((char *)&anint)[0];
#else
		if (copyin(addr, (caddr_t)&achar, sizeof(achar))) {
			u.u_error = EFAULT;
			return(u.u_error);
		}
#endif
		howmuch = 1;
		break;
	  case map_ioctl_cmd(FIONBIO):
	  case map_ioctl_cmd(FIOASYNC):
	  case map_ioctl_cmd(SIOCSKEEP):
	  case map_ioctl_cmd(SIOCSLINGER):
	  case map_ioctl_cmd(SIOCSPGRP):
	  case map_ioctl_cmd(SIOCDONE):
		if (copyin(addr, (caddr_t)&anint, sizeof(anint))) {
			u.u_error = EFAULT;
			return(u.u_error);
		}
		howmuch = 2;
		break;
	  default:
		u.u_error = EOPNOTSUPP;
		return(u.u_error);
	}

    /* send command to board */

	sp = (struct Sock_ioctl *)ex_findmsg( mdev );
	xputw( sp->nm_soid, soid);
	xputw( sp->nm_ioccmd, cmd);
	switch (howmuch) {
	  case 1:
		xputb(sp->nm_iocdata[0], achar);
		break;
	  case 2:
		{
#if (pcxenix || rtpc)
			xputw(sp->nm_iocdata[0], anint );
#else	/* pcxenix */
			/* the board expects a short here */
			short *p = (short *)&sp->nm_iocdata[0];

			*p = anint;
#endif	/* pcxenix */
			break;
		}
	}
	xputw( sp->mh_length,
		sizeof( struct Sock_ioctl) - sizeof( struct headers ) );
	kp = ex_send(map_ioctl_cmd(SOIOCTL), mdev, sp, 0);
	if (u.u_error = kp->kl_error) {
		kp->kl_state = KL_FREE;
		if (ex_db.ex_state & ST_WAITING)
			wakeup((caddr_t)&ex_db);
		return(u.u_error);
	}

    /* examine reply (if needed) */

	switch (cmd) {
	  case map_ioctl_cmd(FIONREAD):
		if (copyout((caddr_t)&kp->kl_along, addr, sizeof(kp->kl_along)))
			u.u_error = EFAULT;
		break;
	  case map_ioctl_cmd(SIOCGKEEP):
	  case map_ioctl_cmd(SIOCGLINGER):
	  case map_ioctl_cmd(SIOCATMARK):
	  case map_ioctl_cmd(SIOCGPGRP):
		if (copyout((caddr_t)&kp->kl_ashort, addr,
	  	  sizeof(kp->kl_ashort)))
			u.u_error = EFAULT;
		break;
	  case map_ioctl_cmd(SIOCRCVOOB):
		if (copyout((caddr_t)&kp->kl_achar, addr, sizeof(kp->kl_achar)))
			u.u_error = EFAULT;
		break;
	}
	kp->kl_state = KL_FREE;
	if (ex_db.ex_state & ST_WAITING)
		wakeup((caddr_t)&ex_db);
	return(u.u_error);
}

#ifndef NOSELECT
xsoselect(dev, rw)
	dev_t dev;
	short rw;
{
	register struct Sock_select *Sock_select;
	register struct context *kp;
	register short d;
	register short s;
	register int mdev;
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

#ifdef BSD4dot2 /* called from selscan */
	mdev = minor(dev);
#else  /* called by xselscan */
	mdev = dev;
#endif
	if ((so_state[mdev] & SOS_BUSY) == 0) {
		u.u_error = ENXIO;
		return 0;
	}
	d = so_id[mdev];
	Sock_select = (struct Sock_select *)ex_findmsg( mdev );
	xputw( Sock_select->nm_soid, d);
	xputw( Sock_select->nm_rw, rw);
#ifdef	EXOSASYNCIO
	if (so_async[mdev] & SOA_ON) {
		/*
		 * Set the SOA_SIGNAL bit.
		 * If SELWAKEUP comes up before we return from
		 * ex_send, we are guaranteed to get a signal.
		 */
		EXSPL6(s);
		so_async[mdev] |= SOA_SIGNAL;
		spl0();
	}
#endif	/* EXOSASYNCIO */
	xputw( Sock_select->nm_proc, u.u_procp - &proc[0]);
	xputw( Sock_select->mh_length,
		sizeof( struct Sock_select ) - sizeof( struct headers ) );
	kp = ex_send(map_ioctl_cmd(SOSELECT), mdev, Sock_select, 0);
	d = kp->kl_reply;	/* select can't return an error, so use reply */
#ifdef	EXOSASYNCIO
#ifdef	DEBUGASYNC
	EXSPL6(s);
	printf("Select(%d): Socket %d is %s\n", u.u_procp->p_pid,
		so_id[mdev], d ? "selectable" : "non-selectable");
	spl0();
#endif	/* DEBUGASYNC */
	if (d && so_async[mdev] & SOA_ON) {
		/*
		 * The socket is selectable and we don't want
		 * a signal later, so we clear the SOA_SIGNAL bit.
		 */
		EXSPL6(s);
		so_async[mdev] &= ~SOA_SIGNAL;
		spl0();
	}
#endif	/* EXOSASYNCIO */
	kp->kl_state = KL_FREE;
	if (ex_db.ex_state & ST_WAITING)
		wakeup((caddr_t)&ex_db);
	return d;
}
#endif /* NOSELECT */

/*
 * Return dev such that so_id[dev] == id.
 * Return -1 if not such socket has this id.
 */
xsofinddev(id)
	register u_short id;
{
	register u_short	dev;

	for (dev = 0; dev < MAXDEVS; dev++)
		if (so_id[dev] == id)
			return dev;
	return -1;
}
/*
 * ex_pendio:
 *	- Find the interrupted read or write request.  If the
 *	  reply has not returned from the board resleep awaiting
 *	  the reply.
 */
struct context *
ex_pendio(mdev, io_type)
        int mdev;
	int io_type;
{
        register struct context *kp;
        register int s1, s2;
        label_t lqsav;

	if (io_type == KL_READ) {
		for(kp = context;;kp++) {
			if(kp == &context[NET_CONTEXTS])
				return ((struct context *)0);
			if((kp->kl_dev == mdev) && (kp->kl_state & KL_READ) &&
		  	((kp->kl_state & KL_BUSY) == 0)) {
				break;
			}
		}
	} else {
		for(kp = context;;kp++) {
			if(kp == &context[NET_CONTEXTS])
				return ((struct context *)0);
			if((kp->kl_dev == mdev) && (kp->kl_state & KL_WRITE) &&
		  	((kp->kl_state & KL_BUSY) == 0)) {
				break;
			}
		}

	}
	if(kp->kl_state & KL_DONE)
		goto maperr;

        if (!ex_inited) {
                u.u_error = ENXIO;
                return;
        }

        EXSPL5( s1 );
#ifdef STRUCTLABELT
        bcopy((caddr_t)&u.u_qsav, (caddr_t)&lqsav, sizeof (label_t));
#else
        bcopy((caddr_t)u.u_qsav, (caddr_t)lqsav, sizeof (label_t));
#endif
	/*
	 * If this proc gets hit by a signal (possibly from arrival of
	 * out-of-band data), free exos resources, THEN do the non-local goto
	 * to exit current system call.  This leaves a message pending
	 * on the board, but since we here clear only KL_BUSY, no one
	 * else will try to use this context buffer until the pending
	 * message comes back from the board and the int. routine clears
	 * KL_WAITING.
	 */
#ifdef BSD4dot2
	if (setjmp(&u.u_qsav)) {
#else
#ifdef rtpc
	if (setjmp(u.u_qsav)) {
#else
	if (save(u.u_qsav)) {
#endif
#endif
		if (ex_db.ex_state & ST_WAITING)
			wakeup((caddr_t)&ex_db);
		kp->kl_state &= ~KL_BUSY;
		if(kp->kl_state & KL_READ) {
			so_state[kp->kl_dev] |= SOS_PENDRD;
		}
		if(kp->kl_state & KL_WRITE) {
			so_state[kp->kl_dev] |= SOS_PENDWRT;
		}
		splx(s1);
		/* Watchout: on some systems p_addr might be, eg, p_uaddr... */
#ifdef DEBUG
/*
* printf("my proc structure (addr = %X, length = %d):\n",
* u.u_procp, sizeof(struct proc));
* exdump(u.u_procp, sizeof(struct proc));
*/
printf("resuming(%x, %X) \007 \n",
u.u_procp->p_addr, lqsav);
#endif
#ifdef BSD4dot2
		longjmp(&lqsav);
#else
#ifdef rtpc
		longjmp( lqsav, &u.u_procp->p_addr );
#else
#ifdef cadmus
		resume(u.u_procp->p_addr, u.u_procp->p_trnbuf, lqsav);
#else
		resume(u.u_procp->p_addr, lqsav);
#endif
#endif
#endif
#ifdef DEBUG
		printf("got past resuming (unreachable)! \007 \n");
#endif
	}
        else {
        	EXSPL5( s2 );
#ifdef  DEBUG_QUEUES
		printf("{ex_pendio: kp=%X} ", kp);
#endif	/* DEBUG_QUEUES */

		kp->kl_state |= KL_WAITING|KL_BUSY;
		kp->kl_proc = u.u_procp;
 		if(!(kp->kl_state & KL_DONE)) /* Don't sleep if I/O 
 						 already done. dab 861212. */
			while (kp->kl_state & KL_WAITING) {
			    	sleep((caddr_t)kp, PZERO+1);
			    	/* interruptable */
			}
		splx( s2 );
	}
#ifdef STRUCTLABELT
        bcopy((caddr_t)&lqsav, (caddr_t)&u.u_qsav, sizeof (label_t));
#else
        bcopy((caddr_t)lqsav, (caddr_t)u.u_qsav, sizeof (label_t));
#endif
        splx(s1);

#ifdef  DEBUG_QUEUES
        printf("{ex_pendio: reply=%x} ", kp->kl_reply);
#endif	/* DEBUG_QUEUES */
#ifdef  DEBUG_NOISE
        if (kp->kl_reply)
                printf("ex0: reply = %x\n", kp->kl_reply);
#endif	/* DEBUG_NOISE */

maperr:

	/* Map the error number. dab 861212 */

	/* Strip off the high order (NM_MAGIC_DATA) bit. */
	kp->kl_error = kp->kl_reply & ~NM_MAGIC_DATA;
	if (kp->kl_error >= (MINEXERR - ERR_MAP_OFFSET) &&
				 kp->kl_error <= (MAXEXERR - ERR_MAP_OFFSET))
		/* Make sure code is within the range that should be
		   mapped. We don't want to map errors such as EPIPE.
		   MINEXERR & MAXEXERR are defined in include/EXOS/ex_errno.h */
		kp->kl_error += ERR_MAP_OFFSET;
        return kp;
}
/*
 * basemv:
 *	- Adjust the base address and user count for the user buffer
 *	  for interrupted reads and writes.
 */
#ifdef BSD4dot2
basemv(offset, cbuf, ucount, iov, uio)
unsigned offset;
long cbuf;
unsigned ucount;
struct iovec *iov;
struct uio *uio;
#else
basemv(offset, cbuf, ucount)
unsigned offset;
long cbuf;
unsigned ucount;
#endif
{
	long tmp;
	unsigned nbytes;
	EXbtype *bp;
	EXbatype baddr;
#ifdef BSD4dot2
	iov->iov_base = (caddr_t)(cbuf + offset);
	iov->iov_len = ucount - offset;
	uio->uio_iov = iov;
	uio->uio_iovcnt = 1;
	uio->uio_offset = 0;		/* ?? right */
	uio->uio_segflg = 0;
	uio->uio_resid = ucount - offset;	/* ?? right */
#endif
	if (offset == 0) {
	  u.u_count = ucount;
#ifdef zilog
	  u.u_base.l = cbuf + offset;
	  if (!u.u_segmented)	/* if not segmented */
	    u.u_base.half.left = nsseg(u.u_base.half.right);
#else
	  u.u_base = cbuf;
#endif
	} else {
	  /*
	   *  This new offset must be checked for wrapping over a
	   *  segment boundary for segmented machines.
	   */
	  EXgetblk (baddr, bp, BSIZE);
	  u.u_base = EXupaddr (cbuf);
	  u.u_count = ucount;
	  while (offset > 0) {
	    nbytes = offset > BSIZE ? BSIZE : offset;
	    iomove (EXioaddr (baddr, bp), nbytes, B_WRITE);
	    u.u_base -= nbytes;
	    u.u_count += nbytes;
	    iomove (EXioaddr (baddr, bp), nbytes, B_READ);
	    offset -= nbytes;
	  }
	EXbrelse(bp, BSIZE);
	}
	u.u_segflg = 0;
}


xsonotify( socket_idx )
	short	socket_idx;
{
	/*
	 * This routine wakes all processes that wait on &ex_db for an
	 * available bucket instead of just waking up the process which 
	 * owns the socket,even though "socket_idx" is supplied. The normal 
	 * xenix process scheduling in favor here to the round-robin scheduling 
	 * of sockets waiting for buckets.
	 */
	wakeup( (caddr_t)&ex_db );
} /* xsonotify */
