/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: exos205.h,v 1.3 87/05/14 17:43:03 davidb Exp $ */

/*
 * @(#)exos205.h	1.2 8/21/85
 * Constants for drivers.
 */
#define XM_WSIZE	(16*1024)	/* window size to be used */
#define XM_PAGES	(XM_WSIZE/MMPGSZ)	/* number of mmu pages needed */
#define XM_WSEG		3		/* forth segment */
#define XM_PADR		0xA0000L	/* physical addr of window */
#define XM_CHNKSZ	1024		/* managable piece for copy routines */
#define XM_COMAREA	0x3f00		/* offset to comm area in upper bank */
#define XM_UPPER	15		/* upper bank */

/*
 * control port 1
 */
#define CP1_ADR		ex_db.ex_port	/* address of cp1 in io */
#define CP1_PARITY	0x0080		/* parity error interupt */
#define CP1_INTR	0x8000		/* normal interupt */

/*
 * control port 2
 */
#define CP2_ADR		(CP1_ADR + 2)	/* address of cp2 in io */
#define CP2_ENA186	0x0001		/* enable 80186 */
#define CP2_ENA586	0x0002		/* enable 80586 */
#define CP2_ENAPAR	0x0004		/* enable parity error flag */
#define CP2_NETNRML	0x0008		/* enable normal mode of 8023 */
#define CP2_FRCPAR	0x0010		/* force parity error on write */
#define CP2_586CA	0x0020		/* channel attention to 82586 */
#define CP2_205BANK	0x01C0		/* bits 14-16 of window in exos mem */
#define CP2_WINADR	0x7E00		/* bits 14-19 of window address in
						host memory */
#define CP2_WINON	0x8000		/* enable exos memory */
#define CP2_ENA17	CP2_FRCPAR	/* enable bit17 to access upper 128k */
#define CP2_DISAB17	0xFFEF		/* disable access upper 128k */

/*
 * control port 3
 */
#define CP3_ADR		(CP1_ADR + 4)	/* address of cp3 in io */

/*
 * ioctl commands
 */
#define EXIODEBUG	('x'<<8|0)	/* turn debugging on/off */
#define EXIOCP1READ	('x'<<8|1)	/* read control port 1 */
#define EXIOCP2READ	('x'<<8|2)	/* read control port 2 */
#define EXIOCP1WRITE	('x'<<8|3)	/* write control port 1 */
#define EXIOCP2WRITE	('x'<<8|4)	/* write control port 2 */
#define EXIOSWITCHON	('x'<<8|5)	/* mark initialization completed */
#define EXDIRECTACCESS	('x'<<8|6)	/* access board memory directly */
#define EXMESSAGEACCESS	('x'<<8|7)	/* access board memory via messages */
#define EXRESET205	('x'<<8|8)	/* cause soft reset of board */

/*
 * xm_flags
 */
#define XM_INIT		01	/* mapping was initialized */
#define XM_BUSY		02	/* driver is being used */
#define XM_RDONLY	04	/* read only open */
#define XM_PARERR	010	/* parity error during read or write */
#define XM_MODRUNNING	020	/* protocol module running */
#define XM_SEGMOD	040	/* lseeks using segmented addresses */

/*
 * layout of segmented addresses for NX 205
 */
#ifdef rtpc
struct nx205_seg {
	unsigned short sa_segment;
	unsigned short sa_offset;
};
#else
struct nx205_seg {
	unsigned short sa_offset;
	unsigned short sa_segment;
};
#endif
union segaddr {
	long sa_l;
	struct nx205_seg sa_s;
};

/*
 * Host service block definition.
 */
struct hsb {
	short hsb_status;
	short hsb_reqcode;
#ifdef rtpc
	struct nx205_seg hsb_pcadr;
	struct nx205_seg hsb_exadr;
#else
	long hsb_pcadr;
	long hsb_exadr;
#endif
	short hsb_tcount;
};

/*
 * status bits for host service block
 */
#define HSB_OWN		01	/* exos owns the block */
#define HSB_DONE	02	/* operation completed */

/*
 * possible request codes
 */
#define NO_REQ		00	/* no request */
#define EX_TO_PC	01	/* transfer from exos memory */
#define PC_TO_EX	02	/* transfer to exos memory */
#define RESET586	03	/* reset 82586 chip */

/*
 * address of initialization message.
 */
#define CONFMSGADR	0x3ff80L	/* 0x3ff80- 0x3ff83 */
/*
 * address of high memory bound
 */
#define HIBOUND		0x3ffe4L	/* 0x3ffe4- 0x3ffe6 */
#define COMSTARTADR	0x3fff0L	/* location of starting address */

/*
 * on-board communication area
 */
struct commarea {
	char ca_state;
	char ca_err;
	struct hsb ca_hsb;
	char ca_rsv[208];
	short ca_cp2;
	short ca_lmap;
	short ca_hmap;
#ifdef rtpc
	struct nx205_seg ca_sendhd;
	struct nx205_seg ca_rcvhd;
#else
	long ca_sendhd;
	long ca_rcvhd;
#endif
	short ca_msgbsz;
	long ca_sav;
	short ca_rsv2;
	char ca586vec[10];
};

#define offtobank(a) ((short)(a >> 14))
#define swtchbank(a) { \
	xm_cp2 &= ~CP2_205BANK; \
	(a >= 8) ? (xm_cp2 |= CP2_ENA17) : (xm_cp2 &= CP2_DISAB17); \
	xm_cp2 |= ((a << 6) & CP2_205BANK); \
	out(CP2_ADR, xm_cp2 ); \
}
