h26524
s 00039/00033/00068
d D 1.4 83/03/09 20:05:05 mjb 4 3
c 
e
s 00021/00008/00080
d D 1.3 83/03/08 20:22:09 tes 3 2
c modified axis pipeline for integer calculations
e
s 00005/00006/00083
d D 1.2 83/01/28 14:06:25 tes 2 1
c initial_internal_update
e
s 00089/00000/00000
d D 1.1 83/01/28 13:05:45 tes 1 0
c date and time created 83/01/28 13:05:45 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine neatic (dmin, dmax, maxtic, rmin, rmax, numtic)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: determine neat tic intervals                           #
#                                                                      #
#     Input Parameters:                                                #
#            dmin   - minimum data                                     #
#            dmax   - maximum data                                     #
#            maxtic - maximum number of tics to be output              #
#                                                                      #
#     Output Parameters:                                               #
#            rmin   - optimum minimum data range for neat ticking      #
#            rmax   - optimum maximum data range for neat ticking      #
#            numtic - optimum number of tics to be used for neat tics  #
#                                                                      #
#     Routines Called:                                                 #
#            none                                                      #
#                                                                      #
########################################################################
integer maxtic, numtic
real dmin, dmax, rmin, rmax

integer scale, ntic
D 2
real ticval, tval, factor, xmin, xmax
PLOTxREALS PLOTxGETREAL
E 2
I 2
real ticval, tval, factor, xmin, xmax, gtreal 
I 3
real one, ldmin, ldmax
E 3
E 2
 
include(`pltcom')
 
I 3
data one /1.0/

E 3
DxB write (DEBUGxUNIT, 100) dmin, dmax, maxtic, rmin, rmax, numtic
DxB 100 format (' neatic:', 2f10.5, i5, 2f10.5, i5)
 
I 3
   ldmax = gtreal (dmax, 0)
   ldmin = gtreal (dmin, 0)
E 3
   ntic = max0 (maxtic, 2)  # Must have at least 2 tics
 
   # Detemine minimum tic interval based on maximum number of tics
D 2
   ticval = abs(PLOTxGETREAL(dmax) - PLOTxGETREAL(dmin))/float(ntic-1)
E 2
I 2
D 3
   ticval = abs(gtreal (dmax, 0) - gtreal (dmin, 0))/float(ntic-1)
E 3
I 3
   ticval = abs(ldmax - ldmin)/float(ntic-1)
E 3
E 2
 
I 3
   # the following if clause takes care of a special case when the extremes
   # are equal (ie. we have only one point to plot). In this case we guarantee
   # that at least 3 is returned as the number of tics and that the minimum
   # and maximum values are different.
D 4
   if (ldmax == ldmin) ticval = 2.
E 4
I 4
   if (ldmax == ldmin) {
      ticval = 1.
      xmax = ldmax + 1.
      xmin = ldmin - 1.
      }
   else {
E 4

E 3
D 4
   # Now scale the tic inverval into a (1,10) range
   scale = 0
E 4
I 4
      # Now scale the tic inverval into a (1,10) range
      scale = 0
    
      if (ticval >= 10.) { # Scale down
         for (scale=1; ticval>=10.; scale=scale+1)  ticval = ticval/10.
         scale = scale - 1  # Fixup the scale factor
         }
      else if (ticval < 1.)  { # Scale up
         for (scale=-1; ticval<1.; scale=scale-1)   ticval = ticval*10.
         scale = scale + 1
         }
       
      # If the tic value is larger than 5.*scale then move it to 1.
      if (ticval > 5.)  {
         scale = scale + 1
         tval = 1.
         }
      else if (ticval > 2.)  tval = 5.  # The best tic is 5.* scale
      else if (ticval == 1.) tval = 1.  # A special case
      else                   tval = 2.  # Best tic is 2.*scale
E 4
 
D 4
   if (ticval >= 10.) { # Scale down
      for (scale=1; ticval>=10.; scale=scale+1)  ticval = ticval/10.
      scale = scale - 1  # Fixup the scale factor
      }
   else if (ticval < 1.)  { # Scale up
      for (scale=-1; ticval<1.; scale=scale-1)   ticval = ticval*10.
      scale = scale + 1
      }
E 4
I 4
      # Combine tic interval and scale to get the real tic interval
      ticval = tval*10.**scale
E 4
 
D 4
   # If the tic value is larger than 5.*scale then move it to 1.
   if (ticval > 5.)  {
      scale = scale + 1
      tval = 1.
      }
   else if (ticval > 2.)  tval = 5.  # The best tic is 5.* scale
   else if (ticval == 1.) tval = 1.  # A special case
   else                   tval = 2.  # Best tic is 2.*scale
E 4
I 4
      factor = ldmax/ticval  # Number of tics required for data max
       # If max is not on tic boundary, number of tics is increased by one
       # to include the data maximum, sign function is used if max is negative
      if (amod(factor,one) != 0.0) factor = factor + (.5 + sign(.5,ldmax))
      xmax = aint(factor)  # Tic interval for data maximum
E 4
 
D 4
   # Combine tic interval and scale to get the real tic interval
   ticval = tval*10.**scale
 
D 3
   factor = dmax/ticval  # Number of tics required for data max
E 3
I 3
   factor = ldmax/ticval  # Number of tics required for data max
E 3
    # If max is not on tic boundary, number of tics is increased by one
    # to include the data maximum, sign function is used if max is negative
D 3
   if (amod(factor,1.) != 0.0) factor = factor + (.5 + sign(.5,dmax))
E 3
I 3
   if (amod(factor,one) != 0.0) factor = factor + (.5 + sign(.5,ldmax))
E 3
   xmax = aint(factor)  # Tic interval for data maximum
 
    # Do the same for the minimum
D 3
   factor = dmin/ticval
   if (amod(factor,1.) != 0.0) factor = factor - (.5 - sign(.5,dmin))
E 3
I 3
   factor = ldmin/ticval
   if (amod(factor,one) != 0.0) factor = factor - (.5 - sign(.5,ldmin))
E 3
   xmin = aint(factor)
 
E 4
I 4
       # Do the same for the minimum
      factor = ldmin/ticval
      if (amod(factor,one) != 0.0) factor = factor - (.5 - sign(.5,ldmin))
      xmin = aint(factor)
      }

E 4
   # By knowing the tic interval and scale factor for the "best" tics,
   # the best minimum and maximum data values are determined
D 2
   PLOTxPUTREAL(xmax*ticval, rmax)
   PLOTxPUTREAL(xmin*ticval, rmin)
E 2
I 2
D 3
   call ptreal (xmax*ticval, 0, rmax)
   call ptreal (xmin*ticval, 0, rmin)
E 3
I 3
   ldmax = xmax*ticval
   ldmin = xmin*ticval
   call ptreal (ldmax, 0, rmax)
   call ptreal (ldmin, 0, rmin)
E 3
E 2
 
   # The number of tics is determined by the data range / tic value
D 2
   numtic = abs(rmax-rmin)/(ticval)+1
E 2
I 2
D 3
   numtic = abs(rmax-rmin)/(ticval)+1.5
E 3
I 3
   numtic = abs(ldmax-ldmin)/(ticval)+1.5
E 3
E 2
 
   return
end
E 1
