h17044
s 00000/00000/00094
d D 1.2 83/03/31 12:46:54 mmm 2 1
c 
e
s 00094/00000/00000
d D 1.1 83/03/15 21:46:18 tes 1 0
c date and time created 83/03/15 21:46:18 by tes
e
u
4
U
t
T
I 1
subroutine gztxtn (yuser)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: select best fit character size and inform d/d          #
#                                                                      #
#     Input Parameters:                                                #
#            yuser - user specified world y value (character height)   #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - d/i interface to device driver                   #
#            gzwndc - transform point from world to NDC units          #
#            gzndcd - transform point from NDC to device units         #
#            gzdcwd - transform point from device to world units       #
#                                                                      #
########################################################################
real yuser
 
integer contrl(5), opcd, vertin, idummy(1), ptsin(2), ptsout(4), 
        ptsin1, ndchgt, devwid, dclhgt, devhgt, i
real xorig, yorig, xtemp, ytemp, xdcorg, ydcorg, xdcpnt, ydcpnt,
     wrldxy, viewxy

include(`gkscom')
 
# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements. The arrays and the
#    variables equivalenced are listed below:
#
#       contrl(OPCODE) :: opcd
#       contrl(VERTICESxIN) :: vertin
#       ptsin(1)       :: ptsin1
#       ptsin(2)       :: ndchgt
#       ptsout(2)      :: devhgt
#       ptsout(3)      :: devwid
#       ptsout(4)      :: dclhgt
 
equivalence (contrl(OPCODE), opcd), (contrl(VERTICESxIN), vertin),
	    (ptsin(1), ptsin1), (ptsin(2), ndchgt),
	    (ptsout(2), devhgt), (ptsout(3),devwid), 
	    (ptsout(4),dclhgt)
 
   # transform user specified character height to ndc space
   call gzwndc (0.0, 0.0, xtemp, ytemp)
   call gzndcd (xtemp, ytemp, xdcorg, ydcorg)
 
   call gzwndc (0.0, yuser, xtemp, ytemp)
   call gzndcd (xtemp, ytemp, xdcpnt, ydcpnt)
 
   #   ptsin(1) = 0
   ptsin1 = 0
   #   ptsin(2) =  abs(ydcpnt-ydcorg)
   ndchgt = abs(ydcpnt-ydcorg)
 
   # pass character height to device
 
   #   contrl(OPCODE) = SETxCHARACTERxHEIGHT
   opcd = SETxCHARACTERxHEIGHT
   #   contrl(VERTICESxIN) = 1
   vertin = 1
   call gzddop (contrl, idummy, ptsin, idummy, ptsout)
 
   # ptsout(1) `char. width' is not used by KERNEL             

   # transform device specified character size to 2D world space
   call gzdcwd (0, 0, xorig, yorig)
 
   #   call gzdcwd (intout(3), intout(4), xdcpnt, ydcpnt)
   call gzdcwd (devwid, dclhgt, xdcpnt, ydcpnt)
   curwdt = abs(xdcpnt-xorig) # Store the actual cell width and height
   celhgt = abs(ydcpnt-yorig)

   #   call gzdcwd (0, intout(2), xdcpnt, ydcpnt)
   call gzdcwd (0, devhgt, xdcpnt, ydcpnt)
   curhgt = abs(ydcpnt-yorig) # Store the actual character height

   # xywasp = x-y aspect ratio of world window  / x-y aspect ratio
   # of the world viewport
   i = nrmcur + 1 # calculate index into world window lists
   wrldxy = (wxmaxl(i)-wxminl(i))/(wymaxl(i)-wyminl(i))
   viewxy = (vxmaxl(i)-vxminl(i))/(vymaxl(i)-vyminl(i))
   xywasp = wrldxy / viewxy

   return
end
E 1
