h32434
s 00001/00009/00068
d D 1.2 83/03/31 12:45:34 mmm 2 1
c 
e
s 00077/00000/00000
d D 1.1 83/03/15 21:45:02 tes 1 0
c date and time created 83/03/15 21:45:02 by tes
e
u
4
U
t
T
I 1
subroutine gzcell (pxy,nmax,mmax,invval,n,m,colia)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Internal routine to inquire on cell arrays             #
#                                                                      #
#     Input Parameters:                                                #
#            pxy(1)  - lower left x point in world coordinates         #
#            pxy(2)  - lower left y point in world coordinates         #
#            pxy(3)  - upper right x point in world coordinates        #
#            pxy(4)  - upper right y point in world coordinates        #
#            nmax    - number of elements in each row                  #
#            mmax    - number of rows in color index array             #
#                                                                      #
#     Output Parameters:                                               #
#            invval  - presence of invalid values in color index array #
#            n       - number of elements in each row used             #
#            m       - number of rows used in color index array        #
#            colia   - color index array                               #
#                                                                      #
#     Errors:                                                          #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#               gwddc2 - convert/clip line from world to device        #
#               gzddop - d/i driver interface                          #
#                                                                      #
########################################################################
integer nmax, mmax, invval, n, m, colia(1)     
real pxy(4)

integer contrl(10), ptsin(4), idummy(1)
D 2
real linein(4)
REALS GETREAL
E 2

logical q1move, q2move, qgone

include(`gkscom')

   invval = 1 # Initialize to 1 in case of complete clip
   contrl(10) = 1 # Initialize output in case device has not inquiry

   contrl(OPCODE) = INQUIRExCELLxARRAY
   contrl(VERTICESxIN) = 2
   contrl(INTEGERxINxLENGTH) = nmax * mmax
   contrl(6) = nmax  # number of elements per row
   contrl(7) = mmax  # number of rows

D 2
   # Convert from user format reals to fortran real format
   linein(1) = GETREAL(pxy(1))
   linein(2) = GETREAL(pxy(2))
   linein(3) = GETREAL(pxy(3))
   linein(4) = GETREAL(pxy(4))

E 2
   # Now convert to device coordinates and clip
D 2
   call gwddc2 (linein, ptsin, q1move, q2move, qgone)
E 2
I 2
   call gwddc2 (pxy, ptsin, q1move, q2move, qgone)
E 2

   if (!qgone) {
      call gzddop (contrl, idummy, ptsin, colia, idummy)

      #  number of elements per row used
      n = contrl(8)  
      #  number of rows used
      m = contrl(9)
      #  invalid value flag
      invval = contrl(10)
      }

   return
end
E 1
