h32382
s 00003/00003/00079
d D 1.2 83/03/31 12:32:24 mmm 2 1
c 
e
s 00082/00000/00000
d D 1.1 83/03/15 21:38:35 tes 1 0
c date and time created 83/03/15 21:38:35 by tes
e
u
4
U
t
T
I 1
subroutine gipmf (wktype,errind,npmi,rpmi)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire polyline facilities                            #
#                                                                      #
#     Input Parameters:                                                #
#            wktype - workstation type                                 #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            npmi(1)- number of available marker types                 #
#            npmi(2)- number of available marker heights               #
#            rpmi(1)- nominal marker height                            #
#            rpmi(2)- minimum marker height                            #
#            rpmi(3)- maximum marker height                            #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           22  Specified workstation type is invalid                  #
#           23  Specified workstation does not exist                   #
#           37  Specified workstation is neither an output             #
#               station nor an output/input workstation                #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer  wktype, errind, npmi(2)
real rpmi(3)

real trpm1, trpm2, trpm3, rtemp

ifdef(`ERROR_ON',`
   integer errchk, ierdum, ierary(1), erary1
   ')

include(`gkscom')

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GIPMF
      #   ierary(1) = wktype
      erary1 = wktype
      errind = errchk(ierdum, ierary)
      if (errind !=  0) return
      ')
   
   npmi(1) = nmktyp  # Get values from common
   npmi(2) = nmksiz

   # Convert from 32k to device rasters
   rtemp = (float(mxdsdc(2))+1.0) / 32768.0
   trpm1 = float(mnmksz) * rtemp
   trpm2 = trpm1
   trpm3 = float(mxmksz) * rtemp 
   if (trpm1 <= 0.0) trpm1 = 1.0  # Check for continous devices

   if (devcor == METERS) {
      trpm1 = trpm1 * sptszy
      trpm2 = trpm2 * sptszy
      trpm3 = trpm3 * sptszy
      }

D 2
   PUTREAL(trpm1, rpmi(1))   # Put back into user format reals
   PUTREAL(trpm2, rpmi(2))
   PUTREAL(trpm3, rpmi(3))
E 2
I 2
   call ptreal (trpm1, 0, rpmi)   # Put back into user format reals
   call ptreal (trpm2, 1, rpmi)
   call ptreal (trpm3, 2, rpmi)
E 2

 return
end
E 1
