h21487
s 00003/00003/00099
d D 1.2 83/03/31 12:30:52 mmm 2 1
c 
e
s 00102/00000/00000
d D 1.1 83/03/15 21:37:16 tes 1 0
c date and time created 83/03/15 21:37:16 by tes
e
u
4
U
t
T
I 1
subroutine gicr (wkid,coli,type,errind,red,green,blue)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire color representation                           #
#                                                                      #
#     Input Parameters:                                                #
#            wkid   - workstation identifier                           #
#            coli   - color index                                      #
#            type   - type of returned values (0=set,1=realized)       #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            red    - color intensities                                #
#            green  -                                                  #
#            blue   -                                                  #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           20  Specified workstation identifier is invalid            #
#           25  specified workstation is not open                      #
#           86  Colour index is invalid                                #
#           88  A representation for the specified color index         #
#               has not been defined                                   #
#                                                                      #
#     Routines Called: None                                            #
#            gzddop - d/i driver interface                             # 
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer  wkid, coli, type, errind
real     red, green, blue
 
integer intin1, intin2, intin(2), intout(4), opcd, vertin,
	contrl(5), inout2, inout3, inout4, gimnmx, ptsdum(1)

ifdef(`ERROR_ON',`
   integer errchk, ierary(1), erary1
   ')
 
include(`gkscom')

# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements.  The arrays and the 
#    variables equivalenced are listed below:
#
#       contrl(OPCODE) :: opcd
#       contrl(VERTICESxIN) :: vertin
#
#       intin(1)  :: intin1
#       intin(2)  :: intin2
#       intout(2)  :: inout2
#       intout(3)  :: inout3
#       intout(4)  :: inout4

equivalence (contrl(OPCODE), opcd), (contrl(VERTICESxIN), vertin),
	    (intin(1), intin1), (intin(2), intin2), 
	    (intout(2), inout2), (intout(3), inout3),
	    (intout(4), inout4)

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')
 
   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0

   ifdef(`ERROR_ON',`
      rounum = GICR
      #   ierary(1) = coli
      erary1 = coli
      errind = errchk(wkid, ierary)
      if (errind !=  0) return
      ')
   
   # Contrl(OPCODE) = INQUIRExCOLORxREPRESENTATION
   opcd = INQUIRExCOLORxREPRESENTATION
   # Contrl(VERTICESxIN) = 0
   vertin = 0

   # intin(1)
   intin1 = coli
   # intin(2)
   intin2 = gimnmx (type, 0, 1)

   call gzddop (opcd, intin, ptsdum, intout, ptsdum)

   # intout(1) `color index' is not used for this inquiry
   
D 2
   PUTREAL((float(inout2)/1000.0), red) # Put back into user format reals
   PUTREAL((float(inout3)/1000.0), green)
   PUTREAL((float(inout4)/1000.0), blue)
E 2
I 2
   call ptreal ((float(inout2)/1000.0), 0, red) # Put back into user reals
   call ptreal ((float(inout3)/1000.0), 0, green)
   call ptreal ((float(inout4)/1000.0), 0, blue)
E 2

   return
end
E 1
