h34065
s 00000/00000/00087
d D 1.8 83/03/18 19:17:13 mjb 8 7
c 
e
s 00004/00006/00083
d D 1.7 83/03/16 12:05:45 mjb 7 6
c 
e
s 00001/00000/00088
d D 1.6 83/03/06 21:04:37 mjb 6 5
c 
e
s 00001/00004/00087
d D 1.5 83/03/03 22:31:07 mjb 5 4
c 
e
s 00006/00002/00085
d D 1.4 83/03/03 18:46:05 mjb 4 3
c put in check for single graph recalls in multi graph mode
e
s 00011/00014/00076
d D 1.3 83/02/11 12:42:39 mjb 3 2
c 
e
s 00001/00001/00089
d D 1.2 83/02/01 19:29:09 mjb 2 1
c fixed problem with checking for 0 file descriptors
e
s 00090/00000/00000
d D 1.1 83/01/31 16:24:03 mjb 1 0
c date and time created 83/01/31 16:24:03 by mjb
e
u
mjb
tes
U
t
T
I 1
D 4
integer function fileck (mode, fname, length)
E 4
I 4
integer function fileck (mode, type, fname, length)
E 4
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Check if file is valid or not                          #
#                                                                      #
#     Input Parameters:                                                #
#            mode - mode to open file in                               #
I 4
#            type - file type to check (1=either, 2=multi)             #
E 4
#            fname - file name to check                                #
#                                                                      #
#     Output Parameters:                                               #
#            length - file length in bytes                             #
#            fileck - 1=ok, anything else is error                     #
#                                                                      #
#     Routines Called:                                                 #
#            rdwrit - read or write to a file                          #
#                                                                      #
########################################################################
SHORTINT fname(14)
D 4
integer mode, length
E 4
I 4
integer mode, type, length
E 4

integer i, kmode, ilen, fildes, sector, offset
SHORTINT locbf1(3), locbf2(3), badfil
ifdef(`UNIX',`character*14 ufname')

integer gdopen, gdclos, gdseek, gdread

include(`gphcom')

equivalence (locbf1(2), ilen)

fileck = YES
I 6
D 7
length = 0
E 7
I 7
do i = 1, 3 {                # Initialize local buffers 
   locbf1(i) = NUL           # to some known state 
   locbf2(i) = NUL  
   }
E 7
E 6

kmode = mode
if (mode > 2) kmode = mode - 3

if (fname(1) == NUL) return

ifdef(`UNIX',`
  do i = 1,14 {
     ufname(i:i) = char (fname(i))
     }
    ')
ifdef(`UNIX',
  `fildes = gdopen (ufname, mode)',
  `fildes = gdopen (fname, mode)')

D 2
if (fildes <= 0) {                 # Cannot open file
E 2
I 2
if (fildes < 0) {                 # Cannot open file
E 2
   fileck = CANNOTxOPENxFILExERROR 
      }

else if (kmode == ASCIIxREAD) {
D 7

    do i = 1, 3 {                # Initialize local buffers 
       locbf1(i) = NUL           # to some known state 
       locbf2(i) = NUL  
       }
E 7

    i = gdread (fildes, locbf1, HEADERxLENGTH)      # Read header
         
D 3
    if (multfg > 1)                                 # Want a multi chart
       ilen = MULTxSIZE
E 3
I 3
    sector = (ilen+HEADERxLENGTH) / 128
    offset = (ilen+HEADERxLENGTH) - (sector * 128)# Skip over file
    i = gdseek (fildes, sector, offset)
E 3

D 3
       sector = (ilen+HEADERxLENGTH) / 128
       offset = (ilen+HEADERxLENGTH) - (sector * 128)# Skip over file
       i = gdseek (fildes, sector, offset)
E 3
I 3
    i = gdread (fildes, locbf2, HEADERxLENGTH)      # Read trailer
E 3

D 3
       i = gdread (fildes, locbf2, HEADERxLENGTH)      # Read trailer

       badfil = NO
       do i = 1, 3 {                       # Check for corrupted file
          if (locbf1(i) != locbf2(i)) badfil = YES
	  }
      if (badfil == YES) {
         fileck = CORRUPTxFILExERROR
	 }
E 3
I 3
    badfil = NO
    do i = 1, 3 {                       # Check for corrupted file
       if (locbf1(i) != locbf2(i)) badfil = YES
       }
D 5
   if (badfil == YES) {
E 5
I 5
   if (badfil == YES | (type == MULTI & ilen != MULTxSIZE)) {
E 5
      fileck = CORRUPTxFILExERROR
I 4
D 5
      }
   else if (type == MULTI & ilen != MULTxSIZE) {
      fileck = NOTxMULTIxGRAPH
E 5
E 4
E 3
      }
I 3
   }
E 3

   length = ilen
   i = gdclos (fildes)

return
end
E 1
