h08726
s 00180/00000/00000
d D 1.1 83/03/23 16:20:20 bog 1 0
c date and time created 83/03/23 16:20:20 by bog
e
u
4
U
t
T
I 1
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#############################################################################
#									    #
#	Function:  							    #
#		Subroutine EmRest ()					    #
#		    Reset Emulator as if just powered up		    #
#									    #
#	Called By:							    #
#		Subroutine EmInit ()					    #
#		    Environment initializer				    #
#									    #
#		Subroutine EmPoll ()					    #
#		    4012/4014 Emulator Main Polling Loop		    #
#									    #
#	Routines Called:						    #
#		Subroutine EmHome ()					    #
#		    Force ALPHA mode, home gezotz			    #
#									    #
#############################################################################
 
Subroutine EmRest
 
CHARACTER C
INTEGER I
INTEGER DriCtl(5),DriIn(10),DriPtI(2),DriOut(50),DriPtO(12)
INTEGER XDCell(4),YDCell(4)
INTEGER Color
INTEGER DH,DW
 
INTEGER MulDiv			# MulDiv(A,B,C) is A*B/C
External MulDiv
 
BEGINCOMMON
COMMON(BEAMSTATE)
COMMON(STRAPS)
COMMON(DRIVER)
COMMON(INITIALIZATION)
ENDCOMMON
 
# Default GKS Open parameters
#  Line Type			1 (solid)
#  Polyline color index		7 (white)
#  Marker type			1 (dot)
#  Polymarker color index	7 (white)
#  Text font			1 (normal)
#  Text color index		7 (white)
#  Fill interior style		0 (hollow)
#  Fill style index		1 (meaningless for hollow)
#  Fill color index		7 (white)
Data DriIn	/0,1,7,1,7,1,7,0,1,7/
 
# Desired character cell height & width in 32k space
Data XDCell	/442,403,268,245/
Data YDCell	/913,850,550,498/
 
If (CurDev != OpnDev) {			# Must open or reopen
  If (OpnDev != -1) {			# Some device open so close it
    STOPGRAPHICS
    }
  DriCtl(1) = 1				# GKS Open opcode
  DriCtl(2) = 0				# No x,y pairs in DriPtI
  DriCtl(4) = 10			# 10 items in DriIn
  DriIn(1) = CurDev			# New workstation id
  Call GZDdOp(DriCtl,DriIn,DirPtI,DriOut,DriPtO)# GKS Open Workstation
  For (C = 1; C <= 45; C = C+1) {	# Move capabilities to Common
    DevCap(C) = DriOut(C)
    }
  For (C = 1; C <= 12; C = C+1) {	# Move x,y pairs to Common
    DevCap(C+45) = DriPtO(C)
    }
 
  OpnDev = CurDev			# Remember what we opened
  }
 
# With XMul = 8192, XDiv = 1038 and YMul = 8192, YDiv = 790,
#  (4095+SpWidth+1,3071+LfHeight+1) maps to (32768,32768), which
#  is just what is wanted for ~PAspct & ~Native.
 
 
# Assume that 4014 space maps to full screen, i.e. 0..32k in both axes
XMul = 8192			# (0..4152,0..3160) maps to
YMul = 8192			#  (0..32768,0..32768)
XDiv = 1038
YDiv = 790
 
If (PAspct) {			# Preserve 4010 aspect ratio
 
  DW = DWidth+1			# Number of pixels
  DH = DHight+1			# Number of pixels
 
  # Let the pixel width be a unit of measure.  There are DW pixel widths
  #  across the screen.  Compute the height of the screen in pixel widths in
  #  DH.  DH is the number of pixels in Y, DPixH is the height of a
  #  pixel and DPixW is the width of a pixel.
 
  DH = MulDiv(DH,DPixH,DPixW)	# DH now screen height in DPixWs
 
  # DH/DW is device aspect ratio; 3160/4151 is 4014 aspect ratio.
  # If the device aspect ratio is less than a 4014's, then it is wider and
  # XMul must be scaled down by R[Dev]/R[4014].  Similarly, if it is
  # taller, then YMul must be scaled down by R[4014]/R[Dev].
 
  If (MulDiv(4152,DH,DW) > 3160) {	# Narrower than 4014
    # 6234.7591 is MulDiv(8192,3160,4152)
    YMul = MulDiv(6234,DW,DH)
    }
   Else {			# Wider than 4014
    # 10763.665 is MulDiv(8192,4152,3160)
    XMul = MulDiv(10763,DH,DW)
    }
  }
 
# MulDiv(X,XMul,XDiv) now maps X in [0..4151] to devices NDC and
# MulDiv(Y,YMul,YDiv) now maps Y in [0..3160] to devices NDC, preserving
# aspect ratio if necessary.
 
# Figure character sizes, figure if Native.
 
# Ask for largest character to compute char:cell ratio
DriCtl(1) = 12			# Set Char Height opcode
DriCtl(2) = 1			# 1 x,y pair in DriPtI
DriPtI(1) = 0			# Char width meaningless on input
DriPtI(2) = DChMax		# Ask for max size
Call GZDdOp(DriCtl,DriIn,DriPtI,DriOut,DriPtO)# Set char size
For (C = 1; C <= 4; C = C+1) {	# Compute char heights to ask for
  YChH(C) = MulDiv(MulDiv(YDCell(C),YMul,8192),DriPtO(2),DriPto(4))
  }
For (C = 1; C <= 4; C = C+1) {	# Get actual character cell sizes
  DriPtI(2) = YChH(C)		# Char height to ask for
  Call GZDdOp(DriCtl,DriIn,DriPtI,DriOut,DriPtO)# Set the char size
  XCell(C) = DriPtO(3)		# Cell width
  YCell(C) = DriPtO(4)		# Cell height
  YChH(C) = DriPtO(2)		#  & height for which to ask
  }
For (C = 1; C <= 4; C = C+1) {	# Set character deltas
  If (Native) {			# Use actual cell size for native
    XChC(C) = XCell(C)
    YChC(C) = YCell(C)
    }
  Else {			# Use 4010 size for 4010 mode
    XChC(C) = MulDiv(XDCell(C),XMul,8192)#  scaled if aspect ratio preserved
    YChC(C) = MulDiv(YDCell(C),YMul,8192)
    }
  }
# If character spacing is native, (4096,3072) should map to
#  (32768-XChSize,32768-YChSize)... preserving aspect ratio
If (Native) {			# Native character spacing
  XDiv = MulDiv(1024,XMul,XMul-XCell(1)/4)
  YDiv = MulDiv(768,YMul,YMul-YCell(1)/4)
  }
 
YHome = MulDiv(3071,YMul,YDiv)				
XMarg2 = MulDiv(2048,XMul,XDiv)
XRight = XMarg2+XMarg2-1		# Last valid position
 
LINESTYLE(DEFAULTLINESTYLE)
 
TEXTSIZE(YChH(1))
XCh = XChC(1)
YCh = YChC(1)
 
Color = Min0(DPCols-1,7)
 
LINECOLOR(Color)
TEXTCOLOR(Color)
MARKERCOLOR(Color)
 
Call EmHome
 
Return
End
E 1
