h61516
s 00066/00000/00000
d D 1.1 83/03/23 16:19:00 bog 1 0
c date and time created 83/03/23 16:19:00 by bog
e
u
4
U
t
T
I 1
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#############################################################################
#									    #
#	Function:  							    #
#		Subroutine EmOCom (Ch)					    #
#			Output	Ch:	Character in [NUL..DEL,BREAK])	    #
#		    Send Ch out the communications port			    #
#									    #
#	Called By:							    #
#		Subroutine EmPoll ()					    #
#		    4012/4014 Emulator Main Polling Loop		    #
#									    #
#		Subroutine EmGTrm (Ch,X,Y)				    #
#			Input	Ch:	Character in [NUL..DEL,EMPTY])	    #
#				X,Y:	Integer coordinates in XYSPACE	    #
#		    Terminate Graphic Input, maybe with Ch		    #
#									    #
#	Routines Called:						    #
#		Subroutine PUTCOMMPORT (Ch,Error)			    #
#			Input	Ch:	Character in [NUL..DEL,BREAK]	    #
#			Output	Error:	Busy flag:			    #
#					 -1:  Busy; Ch not sent		    #
#					  0:  Ch sent successfully	    #
#		    Send Ch or BREAK out the communications port	    #
#		    Note that COMMPORTBREAK is sent if different than BREAK #
#									    #
#############################################################################
 
Subroutine EmOCom(Ch)
CHARACTER Ch
 
INTEGER ICh,Error
 
BEGINCOMMON
COMMON(COMMSTATE)
ENDCOMMON
 
ICh = Ch
 
If (Ch == BREAK) {
  ICh = COMMPORTBREAK
  }
 Else {
  If (POnOff == ONPARITY) {	# Turn on parity bit
    ICh = IOR(ICh,128)
    }
   Else {
    If (POnOff == OFFPARITY) {	# Turn off parity bit
      ICh = IAND(ICh,127)
      }
    }
  }
Repeat {
  PUTCOMMPORT(ICh,Error)
  } Until (Error != -1)		# Until not busy
Return
End
E 1
