/*===============================================================*
 *   Version 1.3        YDK.C                                    *
 *                      O.S. interface for the PC/AT hard disk   *
 *                      driver.                                  *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.01     4-2-85  pjp     ygetssn passed address of head/   *
 *                             sec/cyl.                          *
 *    1.02     4-23-85 pjp     was not adding bias to hsc addrs. *
 *    1.03     5-01-85 pjp     check doasr returns for errors    *
 *    1.04     7-21-85 pjp     bad ssns' e_badpb->e_seek         *
 *    1.05     860404  reb     endssn plus one for seek limit    *
 *                             in dkiosetup                      *
 *    1.1      8/13/86 mei     Metaware port. OR'd disk errors   *
 *			       with ED_DISK.			 *		
 *    1.2      9/11/86 DR-K    initialize io_error to zero	 *
 *    1.3      9/16/86 DR-K    add special DKF_PUD call for get	 *
 *			       PUD information			 *
 *    1.4      861022  reb     added phydrvno-- to allow uninit  *
 *			       and re-init of individual units   *
 *===============================================================*
 *  INCLUDES:                                                    */

#include    "portab.h"
#include    "system.h"
#include    "yio.h"
#include    "ymd.h"
#include    "ydk.h"

/*********************************************************************
*  local constants
*/

/********************************************************************
*  code macros
*/


/***********************************************************************
*  conditional compile switches
*/


/************************************************************************
*  external declarations
*/

EXTERN  PROC    phd_init() ;        /* low level init   */
EXTERN  PROC    phd_uninit() ;      /* low level uninit */
EXTERN  ASR phd_recal() ;       /* low level restrore   */
EXTERN  ERROR   phd_select() ;       /* low level select */
EXTERN  ASR phd_format() ;      /* low level format */
EXTERN  ASR phd_io() ;      /* low level rd/write   */

EXTERN  ERROR   phd_determinemedia() ;  /*  setup eack logical unit */
EXTERN  SSN yGetSsn() ;     /*  calcs ssn from hsc address  */
EXTERN  PROC    movie() ;       /*  byte wide string move   */
EXTERN	VOID	phd_terminate();
EXTERN	ERROR	dkyfindpud();	/*  get index of hard file's PUD	*/


/***********************************************************************
*  declarations for routines in this module
*/

ERROR   dkyinit() ; /*  initialize driver               */
ERROR   dkysubdrv() ;   /*  link with sub-driver            */
ERROR   dkyuninit() ;   /*  uninitialize a driver           */
ERROR   dkyselect() ;   /*  enable i/o on a unit            */
LONG    dkyflush() ;    /*  disable i/o on a unit           */
EMASK   dkyread() ; /*  start a read operation on a unit        */
EMASK   dkywrite() ;    /*  start a write operation on a unit       */
LONG    dkyget() ;  /*  get unit parameters             */
LONG    dkyset() ;  /*  set new unit parameters         */
ERROR   dkyformat() ;   /*  format                  */
LONG    dkyspecial() ;  /*  perform special functions           */

EMASK   dkyiosetup() ;  /*  common code for read/write          */
ERROR   dkyrecal() ;    /*  recalibrate drive... make sure on tk 0  */

BOOLEAN xdkiallocate();

/************************************************************************
 *              Global Data             *
 ************************************************************************/

/***************************************************
 *  Driver Header -
 *  This is the driver header.  It MUST BE THE FIRST ITEM IN THE DATA
 *  SEGMENT and is used by the supervisor install routines to 'install'
 *  the driver into the i/o system
 */

#define DKFLAGVAL   2
			/*  driver sync flags.              */
		        /*  0 = no sync required            */
			/*  1 = sync at driver level            */
			/*  2 = sync at unit level          */

#define FILLVAL     0L  /*  fill value for control words    */

GLOBAL DKH dkydh =
{
	0,DKMAXUNITS,DKFLAGVAL,
	dkyinit,            /*  address of init routine */
	dkysubdrv,          /*  address of subdrv routine   */
	dkyuninit,          /*  address of uninit routine   */
	dkyselect,          /*  address of select routine   */
	dkyflush,           /*  address of flush routine    */
	dkyread,            /*  address of read routine */
	dkywrite,           /*  address of write routine    */
	dkyget,             /*  address of get routine  */
	dkyset,             /*  address of set routine  */
	dkyspecial,         /*  address of special routine  */
	FILLVAL,                    /* must be 0 !  */
	FILLVAL,                    /* must be 0 !  */
	FILLVAL,                    /* must be 0 !  */
	(PD **)0L,           /*  ptr to rlr          */
	FILLVAL             /*  ptr to sys table        */
} ;


/***********************************************************************
*  xDKUT -
*   Floppy Disk Unit Table.  An array of entries which contain
*   information about the logical unit.  Indexed by the logical
*   unit number (number passed in parm block from supervisor).
*/

LUTE    xDKUT[ ] =
{
	/*
	 *  logical unit 0
	 */
				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	0,          /*  logical unit number         */
	0,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0,          /*  request flags           */


	/*
	 *  logical unit 1
	 */

				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	1,          /*  logical unit number         */
	0,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0,          /*  request flags           */

	/*
	 *  logical unit 2 (possible hard disk partition)
	 */

				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	2,          /*  logical unit number         */
	0,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0,          /*  request flags           */


	/*
	 *  logical unit 3 (possible hard disk partition)
	 */

				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	3,          /*  logical unit number         */
	0,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0,          /*  request flags           */

	/*
	 *  logical unit 4 (possible hard disk partition)
	 */

				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	4,          /*  logical unit number         */
	1,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0,          /*  request flags           */


	/*
	 *  logical unit 5 (possible hard disk partition)
	 */

				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	5,          /*  logical unit number         */
	1,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0,          /*  request flags           */

	/*
	 *  logical unit 6 (possible hard disk partition)
	 */

				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	6,          /*  logical unit number         */
	1,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0,          /*  request flags           */


	/*
	 *  logical unit 7 (possible hard disk partition)
	 */

				/*  IORB .............................. */
		0,      /*    io_op             */
		0,      /*    io_type               */
		0,      /*    io_totnsecs           */
		0L,     /*    io_stssn              */
		0L,     /*    io_buffer             */
		0,      /*    io_rtc                */
			0,      /*        io_dkaddr.hsc_head        */
			0,      /*        io_dkaddr.hsc_sector      */
			0,      /*        io_dkaddr.hsc_cyl     */
		0,      /*    io_nsecs              */
		0L,     /*    io_dmaddr             */
		0L,     /*    io_dmcount            */
		0L,     /*    io_error              */
		0,      /*    io_savnsecs           */
		0L,     /*    io_savssn             */
				/*  ................................... */
	(PD *) 0L,      /*  current PB Proc Descr Address   */
	(PD *) 0L,      /*  current Proc Descr Address      */
	0L,         /*  current swi             */
	(PUD *)0L,      /*  address of phys unit descr      */
	(LDD *)0L,      /*  ptr to current Log Disk Descr   */
	0L,         /*  i/o flag number - init'd @ init */
	7,          /*  logical unit number         */
	1,          /*  physical Drive Number       */
	0,          /*  install flags           */
	0           /*  request flags           */

} ;

EXTERN	BYTE phydrvno ;

#define MAXDKUT     sizeof(xDKUT) / sizeof(LUTE)


/***************************************************
*  dkyinit -
*/

ERROR   dkyinit(unitnbr)
LONG    unitnbr ;
{
	static  BYTE    initialized = FALSE ;
	BYTE    unitno = (BYTE) unitnbr ;

	LUTE    *u ;
	ERROR   r ;


	if( unitno > DKMAXUNITS )
		return( ED_DISK | E_UNITNO ) ;

	u = &xDKUT[ unitno ] ;

	if( u->lu_ioflagno )        /* already initialized ? */
		return( ED_DISK | E_UNITNO ) ;

	u->lu_iflag = (WORD) (( unitnbr & 0xffff0000L ) >> 16 ) ;
	u->lu_flags = 0 ;

	u->lu_pdaddr = (*dkydh.dkh_pdaddr) ;

	u->lu_swi = 0L ;

	if( ! xdkiallocate( u ) ) {         /*  allocate resources  */
		r = (ED_DISK | E_POOL) ;                    /*  not a driver E_CODE */
	}
	else  {
		if( !initialized )  {
			phd_init( u ) ;             /* phys level init  */
			initialized = TRUE ;        /* called only once */
		}
		if( (r = phd_determinemedia( u )) != NULLPTR ) {  
						   /* per logical unit    */
			SFREE( u->lu_lddp ) ;
			FLAGCLR( u->lu_ioflagno ) ;
			FLAGREL( u->lu_ioflagno ) ;
			u->lu_ioflagno = 0 ;
		}
	}
	return( (r) ? r : (LONG)DVR_DISK );
}


/**********************************************************
*  xdkiallocate -
*   allocate resources for driver being installed.
*   returns:    TRUE    allocate complete
*           FALSE   POOL error on resources
*/

BOOLEAN xdkiallocate( u )
LUTE    *u ;
{
	if( (u->lu_ioflagno = FLAGGET() ) != NULLPTR)
		if( (u->lu_lddp = (LDD *) SALLOC( (LONG) sizeof(LDD) ) ) != NULLPTR )
			return( TRUE ) ;
	return( FALSE ) ;
}

/*****************************************************************
*  dkysubdrv - link to sub-driver (if any)
*
*/

ERROR dkysubdrv(pb)
DKSDPB  *pb ;
{
	return( ED_DISK | E_IMPLEMENT ) ;
}


/***************************************************
*  dkyuninit -
*   Uninitialize a driver unit
*/

ERROR   dkyuninit(unitnbr)
LONG    unitnbr ;
{
	BYTE    unitno = (BYTE) unitnbr ;
	BYTE    unit ;      /* local varible unitno */
	LUTE    *u ;
	LONG    flag ;

	if( unitno > DKMAXUNITS )
		return( ED_DISK | E_UNITNO ) ;

	u = &xDKUT[ unitno ] ;
	if( (flag = u->lu_ioflagno ) == NULLPTR)  
				/* ioflagno -> has been installed */
		return( ED_DISK | E_UNITNO ) ;

	SFREE( u->lu_lddp ) ;
	FLAGCLR( flag ) ;
	FLAGREL( flag ) ;
	u->lu_ioflagno = 0 ;
	phydrvno-- ;		/* change 861021 */

	/* if all units are uninstalled call low level uninit   */

	for( unit = DKMAXUNITS ; unit-- ; )  {
		if(( &xDKUT[ unit ])->lu_ioflagno)
			return( E_SUCCESS ) ;
	}

	phd_uninit( u ) ;       /* low level uninit */
	return( E_SUCCESS ) ;
}


/***************************************************
*  dkyselect -
*   determines the type of drive we are on (if
*   that is a variable) and the type of media
*   in the drive.
*/

ERROR   dkyselect(pb)
DKSELPB *pb ;       /*  ptr to select parm block            */
{

	ERROR   r ;     /*  return code             */
	LUTE    *u ;        /*  ptr to logical unit table entry */

	u = &xDKUT[ pb->dks_unitno ] ;      /*  u => LUTE for this unit */

	u->lu_pdaddr = (*dkydh.dkh_pdaddr) ;    /*  use current pd addr     */
	u->lu_b_pdaddr = (PD *) 0L ;
	u->lu_swi = 0L ;            /*  null swi address    [1] */
	u->lu_flags = 0 ;           /*  null request flags      */

	if( (r = phd_select( u )) == NULLPTR)  { 
  					/*  copy mdb to callers buffer  */
		movie( pb->dks_mdbp , &u->lu_lddp->ld_mdb , sizeof(MDB) ) ;
	}
	return( r ) ;
}
/*
*  [1]  the select parm block does not contain a swi or pdaddr entry.  this is
*   because the call comes from the file system.  Assume that the current
*   process is requesting disk i/o which the file system deems needs a
*   select before granting.
*/


/***************************************************
 *  dkyflush -
 *  dealloc:  ppd for this unit.
 */

LONG    dkyflush(pb)
DKPBLK  *pb ;
{
	return(E_SUCCESS) ;
}


/***************************************************
 *  dkyread -
 *  start read or verify operation from disk.
 */

EMASK   dkyread(pb)
DKPBLK  *pb ;
{
	if( pb->dk_flags & DKF_VERIFY )  {
		return( dkyiosetup( DKVERIFY , pb ) ) ;
	}
	else  {
		return( dkyiosetup( DKREAD , pb )  ) ;
	}
}

/***************************************************
*  dkywrite -
*   start write operation to disk.
*/

EMASK   dkywrite(pb)
DKPBLK  *pb ;
{
	return( dkyiosetup( DKWRITE , pb )  ) ;
}


/**************************************************
*  dkyget -
*   This driver handles non-removable media only,
*   therefor mdb values can be used .
*
*/

LONG    dkyget(pb)
DKGETPB     *pb ;
{
	LUTE    *u = &xDKUT[ pb->fgt_unitno ] ;
	LDD *l = u->lu_lddp ;

	pb->fgt_dtype = 0 ;         /* non-removable disk   */
	pb->fgt_maxrs = l->ld_mdb.md_secsiz ;   /* max record size  */
	pb->fgt_addr  = 0L ;            /* open door address    */
	pb->fgt_maxfatrecs = l->ld_mdb.md_nfrecs ; /* max fat records   */
	pb->fgt_mxfsize = l->ld_mdb.md_secsiz * (UWORD)l->ld_mdb.md_nfrecs ;
	pb->fgt_mxdsize = l->ld_mdb.md_dirsize ; /* max root dir entries */
	return( E_SUCCESS ) ;
}

/***************************************************
 * dkyset -
 */

LONG    dkyset(pb)
DKPBLK  *pb ;
{
	return( ED_DISK | E_IMPLEMENT ) ;     /*  per spec    */
}


/***************************************************
*  dkyspecial -
*/

LONG    dkyspecial(spb)
DKSPPB  *spb ;
{
	LUTE    *u = &xDKUT[ spb->dsp_unitno ] ;
	DKPBLK  *pb ;
	BYTE    opt ;
	ERROR   r ;

	switch( opt = spb->dsp_funcno )  {

		case    DKO_RDSYS:  /*  READ  SYSTEM AREA       */
		case    DKO_WRSYS:  /*  WRITE SYSTEM AREA       */
		case    DKO_FMSYS:  /*  FORMAT SYSTEM AREA      */
			r = (ED_DISK | E_INVCMD) ;
			break ;
		case    DKO_FMTRK:
			if( spb->dsp_flags & DKF_UADDR )  {
				if( (r = MRANGE(spb->dsp_prbuf,spb->dsp_prsiz) ) != NULLPTR )
					break ;
			}
			r = dkyformat(spb) ;
			break ;
		case    DKO_INFMT:  /*  INIT FORMAT         */
			if( spb->dsp_flags & DKF_UADDR )  {
				if( (r = MRANGE( spb->dsp_buffer , spb->dsp_bufsiz ) ) != NULLPTR )
					break ;
			}
			movie( &(u->lu_lddp->ld_mdb) , spb->dsp_buffer , sizeof(MDB) ) ;
			r = dkyrecal( u ) ;
			break ;

		case	DKO_PUD:	/* return PUD for format/fdisk info. */
			if ( spb->dsp_flags & DKF_UADDR )	/* user address */
			   if((r=MRANGE(spb->dsp_buffer, (LONG)sizeof(PUD))) != NULLPTR )
				break;		 /* if not accessable break */
					/* create a default PUD */
			r = dkyfindpud(u->lu_driveno,u);
					/* put info into dsp_buffer */
			movie(spb->dsp_buffer, u->lu_pudp, sizeof(PUD));
			break;
		default:
			r = (ED_DISK | E_BADPB) ;
			break ;
	}

	return( r ) ;
}

/*
*
*  [1]  Use the same parameter block for i/o call
*
*  [2]  System Start Address is hard coded. It is probably necessary
*   to have the System Start Address hard coded in the drivers, although
*   it may vary between hard and floppy disks.  This shouldn't be critical,
*   and it will be left up to the OEM to change the system area addressing.
*
*  [c]  current definition of Format System Area says that only whole tracks
*   are formatted.  Any partial tracks left over are left untouched.
*   Media currently supported only contain one system sector, sector 1.
*   (There are no whole tracks, therefore no format takes place).
*/


/***************************************************
*  dkyiosetup -
*   Prep for the i/o operation.
*   setup the LUTE's i/o request variables and
*   invoke the io state machine.
*
*/

EMASK   dkyiosetup( op , pb )
BYTE    op ;
DKPBLK  *pb ;
{
	IORB    *i ;
	LUTE    *u ;
	EMASK   IoEmask ;
	LONG    r ;

	u = &xDKUT[ pb->dk_unitno ] ;
	i = &u->lu_iorb ;

	i->io_op = op ;
	/*  io_type bits 9,10 00-na,01-fat,10-dir,11-data   */
	i->io_type = (pb->dk_flags & 0x0600 ) ;
	i->io_totnsecs = i->io_savnsecs = pb->dk_nsecs ;
      	i->io_error = 0L ;

	if( pb->dk_flags & DKF_HSCADDR )
	{                           /* [1] */
		i->io_stssn = i->io_savssn =
			u->lu_lddp->ld_stssn + yGetSsn( &pb->dk_record , u ) ;
	}
	else
	{
		i->io_stssn = i->io_savssn =
			pb->dk_record + u->lu_lddp->ld_stssn ;
	}

	if(  i->io_stssn   <   u->lu_lddp->ld_stssn )
		return( ED_DISK | E_SEEK ) ;
	if(  i->io_stssn + i->io_totnsecs   >   u->lu_lddp->ld_endssn + 1  ) /* 860404 reb last sector recovered */
		return( ED_DISK | E_SEEK ) ;

	i->io_buffer = (SYSADDR) pb->dk_buffer ;
	if( pb->dk_flags & DKF_UADDR )  {
		i->io_buffer = (SYSADDR) SADDR( i->io_buffer ) ;
	}
	u->lu_pdaddr = (*dkydh.dkh_pdaddr) ;
	u->lu_b_pdaddr = (PD*) pb->dk_pdaddr ;

	u->lu_swi = pb->dk_swi ;
	u->lu_flags = pb->dk_flags ;

	IoEmask = FLAGEVENT( u->lu_ioflagno , pb->dk_swi ) ;

	if(( r = DKASR( phd_io , u , 0L )) < 0L)  {
		phd_terminate(u,r) ;
/*		FLAGSET( u->lu_ioflagno , u->lu_pdaddr , r );
		return( r ) ;
*/
	}
	return( IoEmask ) ;
}

/*
*  [1]  addr in HSC format... relative to start of phys disk in non-partition
*   mode, relative to start of partition in partition mode
*/


/*********************************************************************
*  dkyrecal -
*   Recalibrates the drive to track 0.
*   This code WAITS!  It must be called from synchronous code...
*   eg: from code with a process context.
*/

ERROR   dkyrecal( u )
LUTE    *u ;        /*  pointer to logical unit table       */
{
	IORB    *i ;
	EMASK   e ;
	LONG    r ;

	i = &u->lu_iorb ;
	u->lu_swi = 0L ;            /*  dummy swi       */
	u->lu_pdaddr = (*dkydh.dkh_pdaddr) ;    /*  current process */
	u->lu_b_pdaddr = (PD *) 0L ;
	u->lu_flags = 0 ;           /*  null flags      */

	e = FLAGEVENT( u->lu_ioflagno , 0L ) ;
	if(( r = DKASR( phd_recal , u , 0L )) < 0L)  {
		FLAGSET( u->lu_ioflagno , u->lu_pdaddr , r ) ;
		return( r ) ;
	}
	SUPIF( F_WAIT , e ) ;
	return(  SUPIF( F_RETURN , e )  ) ;

}


/************************************************************************
*   dkyformat - format media
*/

ERROR   dkyformat( pb )
DKSPPB  *pb ;
{
	LUTE    *u ;
	EMASK   IoMask ;
	IORB    *i ;
	LDD *l ;
	FPBUF   *fp ;
	BYTE    op ;
	LONG    r ;

	u = &xDKUT[ pb->dsp_unitno ] ;
	u->lu_b_pdaddr = (PD *) pb->dsp_pdaddr ;
	u->lu_pdaddr = (*dkydh.dkh_pdaddr) ;
	u->lu_swi = 0L ;
	u->lu_flags = pb->dsp_flags ;   /* request flags    */

	i = &u->lu_iorb ;       /* io request block */
	l = u->lu_lddp ;        /* ptr to LDD       */
	fp = pb->dsp_prbuf ;        /* ptr to fmt parm buff */

	switch( pb->dsp_flags & 0xa )  {

		case 0x0: op = DKFMT ;      /* plain format     */
			 break ;
		case 0x2: op = DKFMTBB ;    /* format w/bad blocks  */
			 break ;
		case 0x8: op = DKFMTLST ;   /* format w/list of sec #s  */
			 break ;
		case 0xa: op = DKFMTBBLST ; /* format w/list of sec #s and
			 break ;            bad blocks  */
	}
	i->io_op = op ;

	i->io_stssn = (LONG) fp->fp_bytsec ;    /* bytes per sector */
	i->io_dkaddr.hsc_head = fp->fp_head ;   /* head         */
	i->io_dkaddr.hsc_sector = fp->fp_stsec ;/* starting sector  */
	i->io_dkaddr.hsc_cyl = fp->fp_cyl ; /* cylinder     */
	i->io_nsecs = fp->fp_sectrk ;       /* nbr secs, this trk   */
	i->io_totnsecs = (LONG) &fp->fp_list ;  /* ptr to sector list   */

	IoMask = FLAGEVENT( u->lu_ioflagno , 0L ) ;

	if(( r = DKASR( phd_format , u , 0L ))  < 0L)  {
		FLAGSET( u->lu_ioflagno , u->lu_pdaddr , r ) ;
		return( r ) ;
	}
	SUPIF( F_WAIT , IoMask ) ;
	return( SUPIF( F_RETURN , IoMask )) ;
}

