/*===============================================================*
 *   Version 1.2        YIO.H                                    *
 *                      General definitions for the PC/AT hard   *
 *                      disk driver.                             *     
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.1       5-3-85  pjp     doasr now returns error          *
 *    1.2	8/13/86 mei	deleted disk error codes; they're*
 *				in system.h			 *
 *                                                               *
 *===============================================================*
 */

/*
 *  structure name defines
 */


#define PD 		struct _ProcDescr
			/*  Process Descriptonr structure.		*/


/************************************************************************
 *  general type definitions
 ************************************************************************/

#define	PROC		WORD
			/*  this is subroutine type.  it is similar to	*/
			/*  VOID, in that it declares that a routine	*/
			/*  returns no value in particular; i.e., it is	*/
			/*  a procedure, as opposed to a function.  It	*/
			/*  differs from VOID in that you can actually	*/
			/*  globally declare a procedure with PROC, 	*/
			/*  whereas you can't with VOID ('cause someone	*/
			/*  saw fit to define it as a comment, thus 	*/
			/*  causing a syntax error in the following:	*/
			/*	VOID   funcname() ;			*/
			/*  however, it will be legal to declare:	*/
			/*	PROC	funcname() ;			*/

#define	ASR		WORD
			/*  another subroutine type.  declares the rtn	*/
			/*  as an ASR, returning no value, and running	*/
			/*  asynchronously.				*/

#define	ISR		BOOLEAN
			/*  for interrupt service routines		*/


#define	ERROR		LONG		
			/*  Error codes.				*/

#define EMASK		LONG
			/*  Event Masks.				*/

#define ENUM		LONG
			/*  Event numbers.				*/

#define	MXID		LONG
			/*  mutual exclusion id's			*/
			/*  used with mxinit, mxevent, etc		*/

#define	FLAGNO		LONG
			/*  flag numbers used with flagget, flagset, etc*/

#define	NULLL		0L
			/*  Long Nulls					*/

#define	SYSADDR		LONG
			/*  System Address				*/

#define	PHYSADDR	LONG
			/*  Physical Address				*/

#define	USRADDR		LONG
			/*  User Address				*/



/***********************************************************************
*  usefull constants
*/

#define	MAXPOSLONG	0x7fffffffL



/***********************************************************************
*  usefull code macros
*
*/

#define	MAX(x,y)	( (x) > (y) ? (x) : (y) ) 
#define	MIN(x,y)	( (x) < (y) ? (x) : (y) ) 




/***********************************************************************
*  system call map
*	maps all calls to the correct system routines
*/

#define	MXINIT		mxinit
#define	MXEVENT		mxevent
#define	MXUNINIT	mxunint
#define	MXREL		mxrel
#define	FLAGCLR		flagclr
#define	FLAGSET		flagset
#define	FLAGEVENT	flagevent
#define	FLAGGET		flagget
#define	FLAGREL		flagrel

#define	WAIT		mwait
#define	MWAIT		mwait

#define	ARET		aret

#define SALLOC		salloc
#define	MAPU		mapu
#define	MAPPHYS		mapphys
#define	SADDR		saddr
#define	UADDR		uaddr
#define	PADDR		log2phy

#define	NODISP		nodisp
#define OKDISP		okdisp
#define	NOABORT		noabort
#define	OKABORT		okabort
#define	NOASR		noasr
#define	OKASR		okasr
#define SFREE		sfree
#define	MLOCK		mlock
#define	MUNLOCK		munlock
#define	UNMAPU		unmapu
#define MRANGE		mrange
#define	PCREATE		pcreate
#define	OUTP		outp
#define INP		inp
#define SUPIF		supif
#define DOASR		doasr
#define NEXTASR		nextasr
/**********************************************************************
*
*  system externals
*/
					/*  mutual exclusion functions	*/
EXTERN	MXID	MXINIT() ;			
EXTERN	MXID	MXEVENT() ;
EXTERN	MXID	MXUNINIT() ;
EXTERN	MXID	MXREL() ;

EXTERN	VOID	NODISP() ;
EXTERN	VOID	OKDISP() ;
EXTERN	VOID	NOABORT() ;
EXTERN	VOID	OKABORT() ;
EXTERN	VOID	NOASR() ;
EXTERN	VOID	OKASR() ;
					/*  flag system functions	*/
EXTERN	ERROR	FLAGCLR() ;
EXTERN	ERROR	FLAGSET() ;
EXTERN	EMASK	FLAGEVENT() ;
EXTERN	FLAGNO	FLAGGET() ;
EXTERN	ERROR	FLAGREL() ;

EXTERN	EMASK	WAIT() ;
EXTERN	ERROR	ARET() ;
					/*  memory allocate functions	*/
EXTERN	SYSADDR	SALLOC() ;
EXTERN	ERROR	SFREE() ;
					/*  memory mapping functions	*/
EXTERN	VOID	MAPU() ;
EXTERN	VOID	UNMAPU() ;
EXTERN	SYSADDR	MAPPHYS() ;

EXTERN	SYSADDR	SADDR() ;
EXTERN	USRADDR	UADDR() ;
EXTERN	PHYSADDR PADDR() ;
					/*  misc memory mgmt functions	*/
EXTERN	VOID	MLOCK() ;
EXTERN	VOID	MUNLOCK() ;
EXTERN	ERROR	MRANGE() ;
					/*  misc functions		*/
EXTERN	EMASK	PCREATE() ;
EXTERN	VOID	SETVEC() ;
EXTERN	LONG	SUPIF() ;
EXTERN  ERROR	DOASR();
EXTERN	ERROR	NEXTASR();


/*
 *  Process Descriptor structure.  Details are not necessary
 */

PD 
{
	LONG	p_stuff;
} ;


