/******************************************************************************
* CONFIG.C - OEM Configuration Module				Version 1.3.01
*******************************************************************************
* Copyright (c) 1985, Digital Research, Inc. All Rights Reserved. The Software
* Code contained in this listing is proprietary to Digital Research, Inc.,
* Monterey, California and is covered by U.S. and other copyright protection.
* Unauthorized copying, adaptation, distribution, use or display is prohibited
* and may be subject to civil and criminal penalties.  Disclosure to others is
* prohibited.  For the terms and conditions of software code use refer to the
* appropriate Digital Research License Agreement.
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
* v1.3.01 10/10/86 ldt  renamed file to config.c.
* v1.3.00 09/16/86 ldt  Changed 'Concurrent' references to 'FlexOS' 
* v1.2.03 06/12/86 RFW  GMAN is no longer a resource manager but a graphics
*			interface module called GIF.
*  1.2.02 06/09/86 mei	High C port.
* v1.2.01 06/02/86 tdm  Added network #ifs
* v1.2.00 04/16/86 FRH	If NEWTICK, places clock stuff in clock.c
*      20 01/07/86 bvh	added GMAN support
*      19 12/13/85 ldt	forced reldate/signon to even bufsize.
*      18 12/12/85 gat	Initial memory descriptors must come from mgetblk.
*      17 12/03/85 gat	Code cleanup. Complete PIC initialize.
*      16 11/18/85 gat	Added int_enable routine.  Enable 287 error interrupt
*			if 287 present.  Added dummy sethwclk routine.  Added
*                       int_enable routine. Removed tik_close.
******************************************************************************/
#include	"portab.h"
#include	"sysbuild.h"
#include	"system.h"
#include	"sup.h"
#include	"dh.h"
#include	"flags.h"
#include	"imc286.h"
#include	"struct.h"
#include	"baspag.h"
#include	"panic.h"
#include	"config.h"


#define	RELDATE	"November 25, 1986\r\nRelease V1.3A\r\n"
#define SIGNON	"\033EFlexOS 286. Version 1.0\r\nPC/AT I/O System\r\n"

#if (NETWORK == TRUE)
#define	NETON	"\n\rWith FlexNet V1.3A\n\r11/25/86\n\r"
#endif

#if METAWARE 
#define CONFIG
#include "protos.h"
#endif

#if NEWTICK
EXTERN	UWORD	rtcrd();
#endif

/************************
 * OS function calls	*
 ************************/
EXTERN	LONG	s_install();
EXTERN	LONG	s_open();
EXTERN	LONG	s_close();
EXTERN	LONG	s_define();
EXTERN	LONG	s_write();
EXTERN  LONG	s_read();
EXTERN  LONG	s_command();
EXTERN	LONG	install();
EXTERN	LONG	s_exit();

/******************
 * other OS calls *
 ******************/
EXTERN	BYTE	*mgetblk();
EXTERN	VOID	nodisp(), okdisp(), _bzero(), outp();
EXTERN	WORD	_ssize(), hasnpx();
EXTERN	LONG	panic();
EXTERN	BYTE	inp();

/******************
 * Driver Headers *
 ******************/
EXTERN	DH	c_dh;
EXTERN	DH	p_dh;
EXTERN	DH	null_dh;
EXTERN	DH	fd_dh;

#if HARD
	EXTERN	DH	dkydh;
#endif

/************************
 * forward declarations *
 ************************/
VOID 	bootinit(), pause(), message(), sysinit(), minit(), pic_init(), 
	int_enable(), gate_a20(), c8042(); 
WORD	cmosword();

/************************
 *  Bootinit load info  *
 ************************/
#define	PINFO	struct	_pinfo
PINFO
{
	BYTE	pi_pname[10];	/* Process name				*/
	BYTE	pi_prior;	/* Process priority			*/
	BYTE	pi_fill;	/* Filler				*/
	LONG	pi_maxmem;	/* Max. mem. to give to the process	*/
	LONG	pi_reserve;	/* Reserved				*/
};

#define	BOOT_PRIOR    180	/* Default process priority		*/
#define	DFLT_MEM      0x20000L	/* Default process memory size		*/

/********************
 * Bootinit process *
 ********************/
BYTE	boottail[] = "-c boot:config.bat";
BYTE	bootcmd[] = "boot:command.286";

#define	TAILLEN	(LONG)sizeof(boottail)

/*****************************
 * Linked in network drivers.*
 *****************************/
#if (NETWORK == TRUE)
EXTERN LONG	netman();		/* Network resource manager 	*/
EXTERN DH	nm_dh;
#endif

#if (NETXPORT == TRUE)
EXTERN	DH	xp_dh;			/* Transport driver.		*/
#endif
#if (NETNAMES == TRUE)
EXTERN	DH	ns_dh;			/* Name Server driver.		*/
#endif
#if (NETDEV == TRUE)
EXTERN	DH	nd_dh;			/* Net: Device driver.		*/
#endif
#if (NETSERV == TRUE)
EXTERN	DH	cs_dh;			/* Net Server driver.		*/
#endif

/****************************
 * Linked in printer driver *
 ****************************/
#if PRINTER
EXTERN	DH	prn_dh;
#endif

/***********************
 * Driver access flags *
 ***********************/
#define	ACC	A_DEVLOCK+A_SHARE+A_READ+A_WRITE+A_SET
#define	ACC1	ACC+A_REMOVE
#define	ACC2	ACC1+A_PART


/***************************************
****************************************
** GLOBAL DEFINITIONS, INITIALIZATION **
****************************************
***************************************/

/****************
* kernel/memory *
****************/

GLOBAL LONG	defstk = DEFSTK;	/* size of process stack */
GLOBAL UWORD	maxldt = MAXLDT;	/* number LDT slots per process */
GLOBAL WORD	nmods;			/* number of resource modules */

/*****************************
 * primary memory descriptor *
 *****************************/
GLOBAL MPB pmd = { (MD*) 0, (MD*) 0, (MD*) 0, 0x0100, (MD*) 0 } ;
/* free list has  md, allocated list, rover, */
/* max waste 256 bytes, thread root          */

/**********************
 * file system tuning *
 **********************/

GLOBAL LONG	dirfatsz = DIRFATSZ;
GLOBAL LONG	datasz = DATASZ;
GLOBAL UWORD	pathquota = PATHQUOTA;
GLOBAL UWORD	totalquota = TOTALQUOTA;
GLOBAL LONG	fsmemsize = FSMEMSIZE;

/*********************
 * file number table *
 *********************/
GLOBAL WORD	max_fnums = NUM_FNUMT;	/* Max file number table size */
EXTERN FNUMT	*fnumtab;		/* File number table entry    */


/*************
 * ASR Table *
 *************/
GLOBAL	ASR	asrtab[NUM_ASR];
GLOBAL	ASR	*asrfree;


/************************************
 * release date and signon messages *
 ************************************/
BYTE	reldate[60] = RELDATE;
BYTE	signon[70] = SIGNON;
#if (NETWORK == TRUE)
BYTE	neton[40] = NETON;
#endif


/***************************************************
 * Resource Manager Entry Points and Modules Table *
 ***************************************************/
EXTERN	LONG	diskman();
EXTERN	LONG	kernman();
EXTERN	LONG	pipeman();
EXTERN	LONG	misman();
EXTERN	LONG	superman();
EXTERN	LONG	conman();
EXTERN	LONG	cmdentry();

/***********************
 * optional front ends *
 ***********************/
#ifdef DOSFE
EXTERN	LONG	dosman();
#endif

#ifdef GIF
EXTERN	LONG	gif();
#endif

/********************************************
 * Default resource manager for empty slots *
 ********************************************/
LONG noman(f,p)
    WORD f;
    LONG p;
{
	if (f <= I_PABORT)
	    return(E_SUCCESS);
	return(EM_SUP | E_IMPLEMENT);
}

/******************************
 * The resource manager table *
 ******************************/
typedef LONG (*PFL)();		/* Pointer to Function returning Long */
GLOBAL PFL modules[] = {
	kernman,		/* 0  - Kernal Module		*/
	pipeman,		/* 1  - Pipe Manager Module	*/
	diskman,		/* 2  - Disk Manager Module	*/
	conman,			/* 3  - Console Manager Module	*/
	cmdentry,		/* 4  - Command Module		*/
	noman,			/* 5  - Extra RM Slot		*/
	noman,			/* 6  - Network Manager Module	*/
	misman,			/* 7  - Misc. Manager Module	*/
	superman,		/* 8  - Supervisor Module	*/
#ifdef DOSFE
	dosman,			/* 9  - DOS Front End		*/
#else
	noman,
#endif
	noman,			/* 10 - CPM Front End		*/
#ifdef GIF
	gif			/* 11 - Graphics Interface 	*/
#else
	noman
#endif
};


/***************************************************************************
 * CONFIG - first process run by system at initialization, never completes *
 ***************************************************************************/
VOID CONFIG()
{
    REG	WORD i;
    REG	LONG ofn;


	/* initialize resource managers */

	for (i=0; i<nmods; i++)
	{
	    nodisp();
	    if ((*modules[i])(I_INIT,0L))
		panic(XX_INIT);			/* initialization failed */
	    okdisp();
	}


	/* install drivers */

		/* Null device driver    	*/

	install("null:",ACC,&null_dh);


		/* Floppy drivers         	*/

	install("fd0:",ACC,&fd_dh) ; 

		/* Console drivers		*/

	install("pt0:",ACC,&p_dh) ;
	if( install( "con0:",ACC1,&c_dh ) == (EM_SUP | E_SUBDEV) )
	    s_install(3,0,"pt0:","con0:");

		/* Hard disk driver		*/

#if	HARD
	install( "hd0:",ACC2,&dkydh ) ;
#if	TWOHARD
	s_install( 2,ACC2,"hd1:","hd0:" ) ;
#if	THREEHARD
	s_install( 2,ACC2,"hd2:","hd0:" ) ;
#endif
#endif
#endif
		/* Printer driver		*/

#if	PRINTER
	install("prn:",ACC1,&prn_dh);
#endif

		/* Network Drivers.		*/

#if (NETWORK == TRUE)
	install("network:",ACC,&nm_dh);
#endif
#if (NETXPORT == TRUE)
	install("xport:",ACC,&xp_dh);
#endif
#if (NETNAMES == TRUE)
	install("names:",ACC,&ns_dh);
#endif
#if (NETDEV == TRUE)
	install("net:",ACC,&nd_dh);
#endif
#if (NETSERV == TRUE)
	install("csrv:",ACC,&cs_dh);
#endif

		/* Set up REQUIRED defines	*/

	s_define( 0,"stdin","con",0L );
	s_define( 0,"stdout","con",0L );
	s_define( 0,"stderr","con",0L );
	s_define( 0,"stdcmd","con",0L );
	s_define( 0,"con","con:console",0L );
	s_define( 0,"con:","con0:",0L );

		/* Set up according to which	*/
		/* partion wmex.286/command.286	*/
		/* are on			*/
#if	HARD
#if	(DOSPART == 1)
	s_define( A_SYSTEM,"boot:","hd0:",0L );
	s_define( 0,"default:","hd0:",0L );
#endif
#if	(DOSPART == 2)
	s_define( A_SYSTEM,"boot:","hd1:",0L );
	s_define( 0,"default:","hd1:",0L );
#endif
#if	(DOSPART == 3)
	s_define( A_SYSTEM,"boot:","hd2:",0L );
	s_define( 0,"default:","hd2:",0L );
#endif
#else
	s_define( A_SYSTEM,"boot:","fd0:",0L );
	s_define( 0,"default:","fd0:",0L );
#endif
		/* Print startup banner		*/

	ofn = s_open( 0x0055,"stdout");
	s_write( 0,ofn,signon,(LONG)sizeof(signon),0L );
	s_write( 0,ofn,reldate,(LONG)sizeof(reldate),0L );
#if (NETWORK == TRUE)
	s_write( 0,ofn,neton,(LONG)sizeof(neton),0L );
#endif
	s_close(0,ofn);

		/* Start the bootinit process	*/

	bootinit();

		/* Terminate the config process	*/

	s_exit( 0L );
}

/* Load bootinit */
VOID bootinit()
{
	REG WORD	i;
	REG BYTE	*p;
	REG BYTE	*q;
	    PINFO	pi;

	pi.pi_prior = BOOT_PRIOR;
	pi.pi_maxmem = DFLT_MEM;
	pi.pi_reserve = 0L;
	p = "bootinit";
	for(q = pi.pi_pname,i = 0; (i < 10) && ((*q = *p) != NULLPTR); p++,q++);
	while (s_command(0, bootcmd, boottail, TAILLEN, &pi) < 0L)
		pause(
"Cannot find COMMAND.286.  Do you have the proper FlexOS disk inserted?"
		);
}

/* pause - print a message, wait for user to strike key */

VOID pause(s)
BYTE *s;
{
	WORD c;			/* one word buffer for read */
	LONG ofn, ifn;

	ofn = s_open(0x0055, "stdout");
	ifn = s_open(0x0019, "stdin");
	message(ofn, "\r\n");
	message(ofn, s);
	message(ofn, "\r\nPress any key to continue...");
	s_read(0, ifn, &c,(LONG)sizeof(c), 0L);
	s_close(0, ofn);
	s_close(0, ifn);
}

/* message - print a message */

VOID message(f, s)
LONG	f;
BYTE	*s;
{
	s_write(0, f, s, (LONG)_ssize(s), 0L);
}

/* sysinit - initialize "cold" system.  Hardware dependent initialization
 * not handled by drivers should take place here */

VOID sysinit()
{
	WORD	i;
	LONG	ln;

		/* Initialize ASR List */

	asrfree = asrtab;
	for (i = 1; i < NUM_ASR; i++)
	    asrfree = asrfree->asr_link = asrfree + 1;
	asrfree->asr_link = 0;
	asrfree = asrtab;

		/* Zero the FNUM Table */

	ln = sizeof(FNUMT) * NUM_FNUMT;
	_bzero(fnumtab,ln);

	nmods = sizeof(modules)/sizeof(PFL);	/* # resource managers */

	pic_init();		/* clear any pending interrupts */
	gate_a20();		/* enable 24-bit linear addressing */
	minit();		/* initialize memory descriptors */
}

EXTERN LONG	codebase;
EXTERN LONG	codelen;
EXTERN LONG	database;
EXTERN LONG	datalen;

/* minit -  Size memory, fill in memory descriptors */

VOID minit()
{
	LONG	b, l, u;
	MD	*m;		/* diagnostic */

	/* there is ALWAYS at least one memory descriptor */
	m = (MD*)mgetblk(sizeof(MD));
	m->m_flags = M_FREE;

	/* initialize primary memory descriptor to point to it */
	pmd.mp_mfl = m;				/* memory free list */
	pmd.mp_rover = m;			/* rover starts here */
	pmd.mp_thrdrt = m;			/* memory thread root */

	/* get size of lower memory from CMOS */
	l = cmosword(0x15) * 1024L;

	if (codebase) {			/* booted? */
#ifdef DEBUG
		printf("BOOTED\r\n");
#endif
		/* find end of image */
		if (codebase > database)
			b = codebase + codelen;
		else
			b = database + datalen;
		m->m_start = b;
		m->m_length = l - b;
	}
	else {
#ifdef DEBUG
		printf("NOT BOOTED\r\n");
#endif
		/* else use memory from 1000x to load image */
		m->m_start = 0x1000;
		m->m_length = LOADADDR - 0x1000;
	}

	/* get size of upper memory */
	if (( u = cmosword(0x30) * 1024L) != NULLPTR) {
		m = m->m_link = (MD*)mgetblk(sizeof(MD)); /* link in another */
		m->m_flags = M_FREE;
		m->m_start = 0x100000;	/* 1 Meg */
		m->m_length = u;
	}

	/* diagnostic stuff - remove for release */
#ifdef DEBUG
	printf("Lower=%ldk, Upper=%ldk\r\n", l/1024, u/1024);
	for (m = pmd.mp_mfl; m; m=m->m_link)
		printf("%08lx for %08lx\r\n", m->m_start, m->m_length);
#endif
}


/* cmosword - return a word (2 consecutive bytes) from CMOS */

WORD cmosword(n)
{
	return( rtcrd(n+1)*256 + rtcrd(n) );
}

/*****************************
******************************
** INTERRUPT INITIALIZATION **
******************************
*****************************/

#define		PIC_M0	0x20		/* MASTER PIC */
#define		PIC_M1	0x21
#define		ICW1_M	0x11		/* ICW1 for master */
#define		ICW2_M	0x68		/* start of master interrupt numbers */
#define		ICW3_M	0x04
#define		ICW4_M	0x01

#define		PIC_S0	0xa0		/* SLAVE PIC */
#define		PIC_S1	0xa1
#define		ICW1_S	0x11
#define		ICW2_S	0x70		/* slave interrupt numbers start here */
#define		ICW3_S	0x02
#define		ICW4_S	0x01

#define		NSEOI	0x20		/* Non-specific End-of-Interrupt */

/******************************************************************************
**************
** pic_init **		Initialize the PICs
**************
*************/

VOID pic_init() {

	/* Master */		/* Slave */
	outp(PIC_M0, ICW1_M);	outp(PIC_S0, ICW1_S);
	outp(PIC_M1, ICW2_M);	outp(PIC_S1, ICW2_S);
	outp(PIC_M1, ICW3_M);	outp(PIC_S1, ICW3_S);
	outp(PIC_M1, ICW4_M);	outp(PIC_S1, ICW4_S);
	outp(PIC_M1, 0xff);	outp(PIC_S1, 0xff);	/* mask ALL interrupts */

	if (hasnpx()) int_enable(13);		/* unmask NPX errors (irq13) */
}


/******************************************************************************
****************
** int_enable **	Enable particular interrupt on interrupt controller.
****************
***************/

VOID int_enable(irq_no)	/* Interrupt ReQuest Number on AT */
{
	if (irq_no < 8)					/* on the master */
		 outp(0x21, inp(0x21) & ~(1 << irq_no));
	else if (irq_no < 16) {				/* on the slave */
		int_enable(2);				/* enable master */
		outp(0xa1, inp(0xa1) & ~(1 << irq_no-8));	/* then slave */
	}
}

/******************************************************************************
**************
** gate_a20 **		Enable a20 address line.  Should be done before going
**************		to protected mode, but fortunately we start in lower
**************		memory. */

VOID gate_a20()		/* see page 5-155 in AT Tech Ref for insight */
{
	c8042();
	outp(0x64,0xd1);
	c8042();
	outp(0x60,0xdf);
	c8042();
}

VOID c8042()
{
	while (inp(0x64) & 2);
}

#if NEWTICK == 0	/* The following goes into CLOCK.C if NEWTICK */

/* Hardware-dependent tick routines */
 
/* Following is for the IBM AT real time clock */

EXTERN LONG tikcnt;
EXTERN WORD tickit(),sio_out();
EXTERN WORD tikflg;

EXTERN LONG curtime;
EXTERN LONG curdate;


tikcod()
{
	LONG n;
	tikcnt++;
	if (tikcnt % 4) n = 31L;
	else n = 32L;
	if (tikflg) doasr(&tickit,n,0L,150);	
	rtcrd(0x0c); /* clear int - read reg C */
	outp(PIC_M0, NSEOI); /* non-specific EOI */
	outp(PIC_S0, NSEOI);
	return(tikflg);
}

tik_open()
{
	UWORD	hour, minute, second, month, day, year, dayofweek;

	/* a trick to reference a long as structure elements */
	struct ts {WORD y; BYTE m,d;} *t = (struct ts*) &curdate;

/* set up tick vector (on timer 1) */
	setvec(&tikcod,0x70);
/* inhibit operation for a bit */
	rtcwrt(0x0b,0x80); /* inhibit operation */
/* read current time and date from RTC chip */
	hour = rtcrd_bcd(4);
	minute = rtcrd_bcd(2);
	second = rtcrd_bcd(0);
	month = rtcrd_bcd(8);
	day = rtcrd_bcd(7);
	year = rtcrd_bcd(9);
	dayofweek = rtcrd(6);
/* setup tick on MC146818 RTC cmos chip */
	rtcwrt(0x0a,0x2b); /* 32 Hz (0x2a is 64 Hz) */
	rtcwrt(0x0b,0x43); /* periodic int enable, 24-hour clock, dst feature */
/* enable tick on pic */
	int_enable(8);
/* set system date and time */
	curtime = (hour*3600L + minute*60L + second) * 1000L;
	t->y = year+1900;
	t->m = month;
	t->d = day;
}

rtcwrt(add,dat)
WORD add,dat;
{
	outp(0x70,add);
	outp(0x71,dat);
}

rtcrd(add)
WORD add;
{
	outp(0x70,add);
	return(inp(0x71));
}

rtcrd_bcd(add)		/* as above, with bcd to binary conversion */
WORD add;
{
	UWORD item;
	outp(0x70, add);
	item = inp(0x71);
	return ((item&0xf)+(item>>4)*10);
}


/******************************************************************************
**************
** sethwclk **		Set the hardware time of day clock
**************
*************/

sethwclk()
{
}
#endif		/* End of NEWTICK == 0 */
