
                  Concurrent DOS 86 XM, v. 5.0
               Application Note 1065/1066/1067-01                 

     Notes on customizing File Manager, RUNMENU, EDITMENU and 
         COPYMENU for use with third party CRT terminals.

           Copyright 1986 by Digital Research, Inc.
    Concurrent PCDOS is a trademark of Digital Research, Inc. 
                    Compiled September, 1986

Products and Serial Numbers Affected:  Concurrent DOS 86 XM v. 5.0
Developer Kit release, product code 1065, Concurrent DOS 86 XM v.
5.0 OEM release, product code 1066, Concurrent PCDOS XM v. 5.0 
End-User release, product code 1067.

The FM (File Manager),  RUNMENU,  EDITMENU and COPYMENU utilities 
which  are  provided  with the Developer Kit, OEM, and end-user
version of Concurrent DOS 86 XM v. 5.0 include a generalized
terminal driver  which allows emulation of both the ASCII and 
the graphic character sets of the IBM-PC and the console control
codes of Concurrent's XIOS.  OEMs and ISVs can customize these 
four utilities to CRT terminals of their choosing by editing the
file Z29.A86 and following the procedures outlined below.  The
purpose of this application note is to document this procedure
in detail.

This driver expects to find a file named TERMn.DAT or TERM.DAT on 
the  floppy  or  hard disk designated as the  system  drive.  The 
driver  will first search for TERMn.DAT,  where n is  the  window 
number  (1-16) on which the utility is running.  If TERMn.DAT  is 
not  present,  TERM.DAT  is sought.  If still  unsuccessful,  the 
"Cannot  run  on this terminal" message is displayed  before  the 
program aborts. Because of this search order, each console may be 
of  a  different  terminal  type with  a  unique  TERMn.DAT  file 
assigned to it, or they may all be the same terminal type and use 
the same TERM.DAT file. 

As an example, if you were going to configure a three user system 
with  Concurrent DOS 86 XM 5.0 on an IBM-PC/XT using a Zenith Z29 
terminal  and a TeleVideo 950 terminal,  then you would  have  to 
create two terminal data files.  To create the terminal data file 
for  the  Televideo,  edit  a  copy of  Z29.A86  to  reflect  the 
TeleVideo's control characters (and graphics characters,  if they 
exist),  then  rename  the file to something like TVI950.A86  and 
save it.  Next,  assemble it,  link it and convert it to a binary 
file according the the prescribed procedure (see below). Then, if 
the  TeleVideo  is connected to the COM1 serial  port,  name  the 
TVI950 data file TERM5.DAT.  For the Zenith Z29, use the original 
TERM.DAT file,  which was already generated from Z29.A86 by  DRI. 
Simply  rename this file to TERM6.DAT and connect the  Zenith  to 
the COM2 serial port.


Most  CRT  terminals use escape code sequences to handle  special  
console control functions.  For example,  on the Zenith Z29,  the 
home  cursor  function  is  done by sending an  'ESC  H'  to  the 
terminal.  In  this  case,  the 'ESC' character is the  'lead-in' 

Concurrent DOS 86 XM 5.0              Ap. Note 1065/1066/1067-01


character and 'H' is the unique character.  Most console  control 
codes  have  a  lead-in character (usually ESC) and  all  have  a 
unique character.  Some terminals, however, have multiple lead-in 
characters  and  some even have one or more  trailing  characters 
following  the  unique  character.  To  support  these  types  of 
terminals,  the  terminal driver must support lead-in strings and 
trailing strings.  Fortunately, those terminals that use multiple 
lead-in characters usually use a few of them over and over again. 

At this point,  you should print out a copy of Z29.A86. The first 
page  and  a half gives a brief description of the terminal  data 
file's structure and some instructions on how to create one.  The 
Z29.A86 file has seven parts to it.

The first part is the PREAMBLE, which identifies the file and the 
terminal for which it was created. When customizing this file, be 
sure  to alter the terminal name in the PREAMBLE so that you  can 
come  back later and TYPE out the file to identify what  terminal 
it supports.

The  second part of Z29.A86,  CHARTRAN,  defines the 256 possible 
unique  character  codes.  Many of these are the  standard  ASCII 
characters.  The  remainder of the characters correspond  to  the 
extended  graphics  character  set of the  IBM-PC.  The  comments 
associated  with  the character definitions identify  the  IBM-PC 
character that is being translated. Note that the Zenith Z29 does 
have some graphic characters which are equivalent to the IBM-PC's 
characters.  File  Manager and the other three utilities use  the 
horizontal  line,  the  vertical line and the  four  corners  for 
drawing  boxes.  EDITMENU  can  be used to select  other  graphic 
characters  for  borders and the like.  If the terminal  you  are 
using does not have an equivalent character code, enter a space.

The third part,  CHAR_ON, is composed of 256 pointers which point 
to  the "lead-in string" which must precede the unique  character 
of  a  console  control code sequence.  The  256  characters  are 
arranged  in the same order as they were with CHARTRAN.  If  your 
terminal  has no lead-in character for the  corresponding  unique 
character,  then  define the pointer as zero.  The actual  string 
definitions come at the end of the terminal data file. The Zenith 
Z-29  terminal uses just two lead-in sequences:  gr_on  (graphics 
on) and alt_on (alternate character mode on).  Most terminals use 
just a few lead-in character sequences.

The fourth part of the Z29.A86 file, CHAR_OFF, is composed of 256 
pointers  which point to the "trailing string" which  may  follow 
the unique character of a console control code sequence.  The 256 
characters  are  arranged  in the same order as  they  were  with 
CHARTRAN,  including  comments.  If your terminal has no trailing 
character for the corresponding unique character, then define the 
pointer as zero. 

Concurrent DOS 86 XM 5.0               Ap. Note 1065/1066/1067-01


The fifth area of Z29.A86 is ATTRIB,  a table of 256 pointers  to 
strings  which invoke terminal modes corresponding to the various 
(monochrome) character attributes of the IBM-PC.  The IBM-PC uses 
an attribute byte after each character in its display RAM to tell 
the video controller how the character is to be highlighted. This 
feature  allows the IBM-PC to display text in normal  or  inverse 
video,  normal or high intensity,  blinking or non-blinking video 
or in combinations thereof.  The ATTRIB area of the terminal data 
file allows you to map the attribute codes used by the monochrome 
IBM-PC to those which are used by your terminal.  This is done by 
adding the appropriate attribute strings, consisting of escape or 
control codes,  to the end of the terminal data file. Then modify 
the  ATTRIB table such that they reference the  proper  attribute 
string.  To  illustrate ATTRIB further,  refer to the listing  of 
Z29.A86.  This  listing  shows 10 attribute modes set up  on  the 
Zenith Z29. They are:

1.) Normal Video (normal_on)
2.) Underlined Video (under_on)
3.) High Intensity Video (hi_on)
4.) Inverse Video (inv_on)
5.) Blinking Video (blink_on)
6.) High Intensity Underlined Video (hi_under_on)
7.) Blinking Underlined Video (bl_under_on)
8.) High Blinking Video (hi_blink_on)
9.) Blinking Inverse Video (bl_inv_on)
10.) Blinking High Intensity Underlined Video (bl_hi_under_on)

The  names of the attribute strings used in the Z29.A86 file  are 
shown above in parenthesis. If you look at the end of the Z29.A86 
file,  you  will find the actual attribute strings.  Depending on 
the capabilities of the terminal,  it is possible to create  even 
more  attribute modes by combining simpler ones. 

The sixth area of Z29.A86 is CURSOR, a pointer table for thirteen 
common screen functions. The screen functions are:

1.) X-Y Cursor Position (cur_posn)
2.) Clear Screen (clr_scrn)
3.) Clear to the End of Line (clr_eol)
4.) Clear to the End of Screen (clr_eos)
5.) Line Wrap On (wrap_on)
6.) Line Wrap Off (wrap_off)
7.) Turn Cursor On (curs_on)
8.) Turn Cursor Off (curs_off)
9.) Move Cursor Up (curs_up)
10.) Move Cursor Down (curs_down)
11.) Move Cursor Right (curs_right)
12.) Move Cursor Left (curs_left)
13.) Set Attributes (set_attr)        (optional)


Concurrent DOS 86 XM 5.0                Ap. Note 1065/1066/1067-01


For each of the screen functions listed above,  the corresponding 
screen  control  string  is named  in  parenthesis.  Each  screen 
control  string contains those escape (or control) code sequences 
needed  to initiate the appropriate function on the  terminal  in 
question. Of the thirteen functions listed, all but two are self- 
explanatory.  The  two  screen  functions which  require  further 
elaboration are X-Y Cursor Positioning and Set Attributes.  These 
two special case topics will be discussed below.

The  seventh  and  final part of the Z29.A86 terminal  data  file 
consists  of all the control code character  string  definitions. 
This area is normally broken up into three sub-sections:

1.) Screen Function Control Strings
2.) Lead-In and Trailing Character Strings
3.) Special Attribute Strings

Each  string starts off with a string length byte which specifies 
the number of characters in the escape code sequence that will be 
transmitted to the terminal.  String lengths can be up to 128 (0-
7fh)  characters.   With  the  character  strings  and  attribute 
strings,  the  string  length  byte is also  used  to  contain  a 
"special  case" flag (the most significant bit) which is used for 
two purposes. The first purpose is with X-Y Cursor Positioning to 
indicate   whether   the  row  coordinate  preceeds  the   column 
coordinate  or  vice-versa.  The second purpose  is  to  indicate 
whether  the  Set  Attribute  function  (bit  controlled   screen 
attributes) is to be used. 

The X-Y Cursor Positioning function typically consists of a 'ESC' 
for a lead-in character,  some unique character,  followed by the 
row  and  column  coordinates.  Sometimes,  the  row  and  column 
coordinates are reversed and sometimes they include an offset  of 
32 (20h) to make sure that the coordinates are not control codes. 
Both  of these variables have to be communicated to the  terminal 
driver via the terminal data file.

The  row/column  order is specified by setting or  resetting  the 
"special  case"  flag  of  the  cursor  position  control  string 
("cur_posn").  When this flag is reset, it indicates that the row 
coordinate preceeds the column coordinate. When this flag is set, 
it   indicates  that  the  column  coordinate  proceeds  the  row 
coordinate.  So,  if  your  string  length is 4  and  the  column 
coordinate preceeds the row coordinate,  use 132 (84H) instead of 
4 (which means that row precedes column).

The row and column offset is defined by the last two bytes of the 
cursor position control string.  If no offset is used,  then  the 
last  two bytes of the string should be nulls (00h).  If there is 
an offset of 32 (20h),  then the last two bytes should be be  32, 
20h or two spaces enclosed in single quotes.  The string for  the 

Concurrent DOS 86 XM 5.0               Ap. Note 1065/1066/1067-01


Z29  is:  "  cur_posn  db   4,ESC,'Y  ' ".  Since the first  byte 
(string length byte) is 4,  not 132, the row coordinate is first, 
followed by the column coordinate. Also, since the last two bytes 
of  the string are both spaces,  an offset of 32 (20h)  is  used. 
Therefore,  the  cursor positioning code sequence for the  Zenith 
Z29 terminal is "ESC Y (row+32) (col+32)".

The  second use for the "special case" flag (the most significant 
bit  of  the string length byte) is to indicate to  the  terminal 
driver whether special bit manipulations are required to set  bit 
controlled  screen  attributes.  This  function was  designed  to 
support the bit mapped screen attribute (Set Attribute)  features 
of  the  Zenith Z29 terminal.  This feature allows you to  switch 
several  attributes  with  a single  escape  code  sequence.  The 
important  thing to remember is that this is an optional  feature 
that most CRT terminals do not support. If your terminal does not 
support  this feature,  just make sure the "special case" flag is 
set to zero and null out set_attr.

If  you  have a CRT terminal that supports a  bit  mapped  screen 
attributes  function similiar to the one provided with the Zenith 
Z29  (and you decide to implement this feature),  then  you  will 
need  some  background information on how this function works  on 
the Z29 terminal.  The Z29 User/Technical Manual defines the  ESC 
code  sequence for Set Attribute as "ESC s <attribute>" where ESC 
is  the  lead-in  character,  "s" is  the  unique  character  and 
"<attribute>"  is  a byte value that indicates which  bit  mapped 
attributes are to be enabled.  The documentation further descibes 
which bit positions are used to enable which attributes.

     1.) b0 = reverse video
     2.) b1 = blinking video
     3.) b2 = half intensity video
     4.) b3 = underlined video
     5.) b4 = alternate character set
     6.) b5-b7 (not used)

To  enable  one  or  more of these  attributes,  simply  set  the 
corresponding bit. An ASCII bias of (30H) has to be added to this 
byte value before transmitting it to the terminal. 

To  set the terminal data file up such that it will  support  Set 
Attribute,  first set the "special case" flag by setting the most 
significant  bit of the string length.  The string length  should 
also  be  set  to zero.  This means that the first  byte  of  the 
attribute (or character) string should be 80h.  The string should 
also  contain two binary numbers which specify  which  attributes 
are  to  be  enabled  and  which are  to  be  disabled.  This  is 
accomplished by the terminal driver which ANDs the first byte and 
ORs  the  second byte.  The first byte is used to switch  off  an 
attribute  (if the bit is zero) or to maintain an  attribute  (if 

Concurrent DOS 86 XM 5.0               Ap. Note 1065/1066/1067-01


the  bit  is  one).  The  second byte is used  to  switch  on  an 
attribute  (if the bit is set to one) or to maintain an attribute 
(if the bit is set to 0). 

As an example,  look at the strings for set_attr and bl_inv_on in 
the   Z29.A86  listing.   The  set_attr  string  is  defined   as 
"3,ESC,'s0'", where "3" indicates the string length, "ESC" is the 
lead-in  character,  "s" is the unique character and "0" (30h) is 
the  bit  mapped attribute value.  The string  for  bl_inv_on  is 
defined as "80h, 00010000b, 00000011b", where 80h represents both 
the  "special  case" flag (which is set) and a string  length  of 
zero.  The  first  binary  value,  which will be ANDed  with  the 
previous   bit  mapped  attribute  value,  will  switch  off  all 
attributes  except  bit  position  4,   which  is  the  alternate 
character set attribute. The second byte, which will be ORed with 
the  previous  bit mapped attribute value,  will  switch  on  the 
attributes  for bit positions B0 and B1.  These two bit positions 
correspond  to inverse video and  blinking  video,  respectively. 
Also,  notice  that the alternate character set attribute (b4) is 
maintained by setting b4 of the first byte to one while b4 of the 
second byte is set to zero. 

As  was hinted above,  the terminal driver maintains  a  variable 
that  holds  the  last  screen attribute that  was  sent  to  the 
terminal.  When  new  attribute values are calculated,  they  are 
based  on  the  previous attribute  value.  The  terminal  driver 
precedes these calculations by a subtracting the ASCII bias (30h) 
from the previous attribute value. Next, the first byte following 
the 80h of the attribute string is ANDed to this value.  Then the 
last  byte  of the attribute string is ORed to  this  value.  The 
ASCII  bias is then added back on,  the resulting value  is  then 
saved and (finally) is transmitted to the terminal.

When  modifying  pointer  and  string definitions  for  your  own 
terminal,  be  sure  to have a terminal  reference  manual  which 
explains  what  codes are used to implement  what  functions.  It 
normally  takes  several attempts at creating the  terminal  data 
file  before you have one which is both bug free and operates  to 
your  liking.  The following is the description on how to  create 
the  binary file version of your terminal data file.  Follow  the 
instuctions closely.

Once you have made all the changes appropriate for your terminal, 
save  this  file  away  using a filename which  you  will  easily 
associate with the terminal. Next, use the native-mode version of
RASM86 (the tools are included in the Developer and OEM releases) 
to assemble this file.  Once it has assembled, use the native-mode 
version  of LINK86 to link it to an absolute offset address.  Use 
the command LINK86 TERM.DAT=TERM[DATA[ORIGIN[0]],  where TERM.DAT 
is  the name of your terminal data file.  After linking  it,  use 
SID86  (or  DDT86) to load the file into RAM and save it back  to 
disk without the CMD file header.  The command sequence is listed 

Concurrent DOS 86 XM 5.0                Ap. Note 1065/1066/1067-01


at  the beginning of Z29.A86.  The 80 hex address listed in the W 
command  serves  to  eliminate  the  128-byte  header  from   the 
beginning  of  the file.  For further information,  refer to  the 
Programmer's Utilities Guide.


DRI  specifically  disclaims any express or implied warranty  and 
shall  not be liable for any loss of profits,  loss of  business, 
loss of use or loss of data,  interruption of business,  nor  for 
indirect,  special,  incidental,  or consequential damages of any 
kind  caused  by the use or adaptation of this application  note. 
Liscensed   users  are  granted  the  right  to   include   these 
modifications in their Digital Research software.

e. 
Liscensed   users  are  granted  the  right  to   include   thes