h20012
s 00005/00005/00059
d D 1.2 83/03/06 23:32:48 mrk 2 1
c changed MINUS to NEGATIVE to avoid collisions
e
s 00064/00000/00000
d D 1.1 83/02/17 12:58:02 mrk 1 0
c date and time created 83/02/17 12:58:02 by mrk
e
u
mrk
mjb
tes
U
t
T
I 1
subroutine sincos (angle, sinout, cosout)
real angle, sinout, cosout

define(`PLUS',1)
D 2
define(`MINUS',-1)
E 2
I 2
define(`NEGATIVE',-1)
E 2
define(`FORWARD',1)
define(`REVERSE',0)

integer i, inext, index, kquad
real diff, start, stop, slope, curang
real sine(19)
integer sinsgn(4), cossgn(4), sindir(4), cosdir(4)

D 2
data sinsgn /PLUS, PLUS, MINUS, MINUS/
data cossgn /PLUS, MINUS, MINUS, PLUS/
E 2
I 2
data sinsgn /PLUS, PLUS, NEGATIVE, NEGATIVE/
data cossgn /PLUS, NEGATIVE, NEGATIVE, PLUS/
E 2
data sindir /FORWARD, REVERSE, FORWARD, REVERSE/
data cosdir /REVERSE, FORWARD, REVERSE, FORWARD/
data sine    /.000000, .087156, .173648, .258819, .342020, .422619,
         .500000, .573577, .642788, .707107, .766045, .819152, .866026,
         .906308, .939693, .965926, .984808, .996195, 1.000000/

   curang = angle
   if (curang >= 360.) curang = 0.  # Get back in 0-360 range
   kquad = curang / 90.                      # determine quadrand for sign, dir
   curang = curang - kquad*90.
   kquad = kquad + 1
   
   index = curang /5.

   if (sindir(kquad) == FORWARD) {
      i = index + 1
      inext = index + 2
      }
   else  {
     i = 19 - index
     inext = i - 1
     }

   diff =  curang - 5*index

   # Determine the sine using a little linear algebra
   start = sine(i)
   stop = sine(inext)
   slope = (stop-start)/5.
   sinout = slope*diff + start
D 2
   if (sinsgn(kquad) == MINUS)  sinout = -sinout
E 2
I 2
   if (sinsgn(kquad) == NEGATIVE)  sinout = -sinout
E 2
   
   if (cosdir(kquad) == FORWARD) {
      i = index + 1
      inext = index + 2
      }
   else  {
     i = 19 - index
     inext = i - 1
     }

   # Determine the cosine using a little linear algebra
   start = sine(i)
   stop = sine(inext)
   slope = (stop-start)/5.
   cosout = slope*diff + start
D 2
   if (cossgn(kquad) == MINUS)  cosout = -cosout
E 2
I 2
   if (cossgn(kquad) == NEGATIVE)  cosout = -cosout
E 2
   return
end
E 1
