h14615
s 00018/00013/00108
d D 1.6 83/03/29 16:53:26 mjb 6 5
c fixed viewport transformation of log axis
e
s 00011/00007/00110
d D 1.5 83/03/08 20:20:09 tes 5 4
c modified axis pipeline for integer calculations
e
s 00001/00001/00116
d D 1.4 83/02/07 14:57:51 mrk 4 3
c fixed compiler bug
e
s 00002/00002/00115
d D 1.3 83/02/07 14:24:13 mrk 3 2
c fixed bug for value less than 0
e
s 00012/00007/00105
d D 1.2 83/01/28 13:50:52 tes 2 1
c initial_internal_update
e
s 00112/00000/00000
d D 1.1 83/01/28 13:01:57 tes 1 0
c date and time created 83/01/28 13:01:57 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpglga (index, lstart, lend, lbltyp)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: output a log axis                                      #
#                                                                      #
#     Input Parameters:                                                #
#            index  - axis to be generated (1=x, 2=y)                  #
#            lstart - label starting value                             #
#            lend   - label ending value                               #
#            lbltyp - index for menued label types                     #
#                        1 - label major cycle only                    #
#                        2 - label major and draw 8 minor tics         #
#                        3 - label major and .5 cycle with minor tics  #
#                        4 - label major .2,.5,.8 cycle with minor tics#
#                        5 - label major and minor tics                #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gssatt - Set an attribute on the current device           #
#            gpdbln - draw the axis base line                          #
#            gpgntc - generate a tic mark                              #
#            gptclb - output a tic label                               #
#                                                                      #
########################################################################
integer index, lbltyp
real lstart, lend
 
integer i, kount, tics(9), itype, iout
D 2
real x1, xinc, xcycle, xlog, xp
E 2
I 2
D 5
real x1, xinc, xcycle, xlog, xp, val1, val2
E 5
I 5
integer dc(2), xp
D 6
real x1, xinc, xlog, val1, val2, p(2)
E 6
I 6
real x1, xinc, xlog, val1, val2, p(2), offset
E 6
E 5
E 2
 
real log1,        # variable used to store logrithm of minimum value
     log2,        # variable used to store logrithm of maximum value
     lratio       # variable used to save the ratio for log to linear
 
include(`pltcom')
 

DxB write (DEBUGxUNIT, 100) index, lstart, lend, lbltyp
DxB 100 format (' gpglga:', i5, 2f10.5, i5)
 
   call gpdbln (index)   # Draw axis base line
   itype = natype(index)
I 2

   val1 = lstart
   val2 = lend
D 3
   if (val1 == 0)  val1 = 1./10.**10  # Protect again less than zero values
   if (val2 == 0)  val2 = 1./10.**10
E 3
I 3
D 6
   if (val1 <= 0)  val1 = 1.  # Protect again less than zero values
D 4
   if (val2 <= 0   val2 = 1.
E 4
I 4
   if (val2 <= 0)  val2 = 1.
E 6
I 6
   if (val1 <= 0.)  val1 = 1.  # Protect again less than zero values
   if (val2 <= 0.)  val2 = 1.
E 6
E 4
E 3
E 2
   if (itype == LOGxBASEx10) {
D 2
      log1 = alog10 (lstart)
      log2 = alog10 (lend)
E 2
I 2
      log1 = alog10 (val1)
      log2 = alog10 (val2)
E 2
      }
   else {
D 2
      log1 = alog (lstart)
      log2 = alog (lend)
E 2
I 2
      log1 = alog (val1)
      log2 = alog (val2)
E 2
      }

D 5
   lratio = ztdist(index)/(log2-log1)
E 5
I 5
   lratio = ztdist/(log2-log1)
E 5
 
   if (lbltyp ==1) {
      do i=1, 9
         tics(i) = 0
      }
   else {
      do i=1, 9
         tics(i) = 1
      if (lbltyp > 2) tics(4) = -1
      if (lbltyp > 3) {
         tics(1) = -1
         tics(7) = -1
         }
      if (lbltyp > 4) {
         do i=1, 9
            tics(i) = -1
         }
      }
   tics(9) = -1
D 2
   x1 = lstart
E 2
I 2
   x1 = val1
E 2
   xinc = x1
D 5
   xcycle = 10.*x1
E 5
   kount = 1

   call gpsatt (SETxPOLYLINExLINETYPE, ngdstl(index), iout)

   call gpsatt (SETxPOLYLINExCOLORxINDEX, ngdclr(index), iout)

D 5
   call gpgntc (index, ztstrt(index), 2)   # Output a major tic
   call gptclb (index, ztstrt(index), x1)
E 5
I 5
   call gpgntc (index, ntstrt, 2)   # Output a major tic
   call gptclb (index, ntstrt, x1)

I 6
   if (index == 1) offset = xvwmin  # Transform to viewport
   else            offset = yvwmin

E 6
   p(1) = 0.0
   p(2) = 0.0
E 5
D 2
   for (x1=x1+xinc; x1<=lend; x1=x1+xinc) {
E 2
I 2
   for (x1=x1+xinc; x1<=val2; x1=x1+xinc) {
E 2
D 6
      if (itype == LOGxBASEx10) xlog = alog10 (x1)
      else                      xlog = alog (x1)
D 5
      xp = ztstrt(index) + (xlog-log1)*lratio
E 5
I 5
      p(index) = (xlog-log1)*lratio
      call gpn2dc (p(1), p(2), dc)
      xp = ntstrt + dc(index)
E 5
      if (tics(kount) > 0) call gpgntc (index, xp, 1)   # minor tic
      if (tics(kount) < 0) {
         call gptclb (index, xp, x1)
         call gpgntc (index, xp, 2)     # major tic
         }
E 6
I 6
      if (tics(kount) != 0) {
         if (itype == LOGxBASEx10) xlog = alog10 (x1)
         else                      xlog = alog (x1)
         p(index) = (xlog-log1)*lratio
         call gpn2dc (p(1), p(2), dc)
         xp = ntstrt + dc(index) - offset
         if (tics(kount) > 0) call gpgntc (index, xp, 1)   # minor tic
         else {
            call gptclb (index, xp, x1)
            call gpgntc (index, xp, 2)     # major tic
            }
	 }
E 6
      kount = kount + 1
      if (kount > 9) {
D 5
         xcycle = 10.*xcycle
E 5
         xinc = 10.*xinc
         kount = 1
         }
      }
   naxsts(index) = 1
 
   return
end
E 1
