h55027
s 00000/00000/00068
d D 1.2 83/03/31 12:46:47 mmm 2 1
c 
e
s 00068/00000/00000
d D 1.1 83/03/15 21:46:10 tes 1 0
c date and time created 83/03/15 21:46:10 by tes
e
u
4
U
t
T
I 1
subroutine gztxcp (linein, delta, start, stop)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#          COPYRIGHT (C) 1981 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: clip a text extent line and set the string index       #
#                                                                      #
#     Input Parameters:                                                #
#            linein - world coordinates of input line                  #
#            delta  - distance of one character cell along line        #
#                                                                      #
#     Output Parameters:                                               #
#            start  - starting index of text string                    #
#            stop   - ending index of text string                      #
#                                                                      #
#     Routines Called:                                                 #
#            gwddc2 - transform and clip a line from world to device   #
#            gzdcwd - transform a point from device coord. to world    #
#                                                                      #
########################################################################
real linein(1), delta
integer start, stop

real delta2, dx, dy, x, y
integer linout(4)
logical qp1, qp2, qgone

   # Initialize the starting index to 0, no output
   start = 0
  
   # Transform and clip the line ('linein') to determine if there is
   #   to be any text clipped
   call gwddc2 (linein, linout, qp1, qp2, qgone)

   # Determine if any of the string is visible (qgone == .true.)
   if (!qgone) {
      start = 1
     
      # If the first point has moved recalculate the starting index
      if (qp1) {
	 call gzdcwd (linout(1), linout(2), x, y)
	 dx = x - linein(1)
	 dy = y - linein(2)
	 delta2 = sqrt (dx*dx + dy*dy)
	 start = (delta2/delta) + 2
	 }
     
      # If the second point has moved recalculate the ending index
      if (qp2) {
	 call gzdcwd (linout(3), linout(4), x, y)
         dx = x - linein(1)
	 dy = y - linein(2)
	 delta2 = sqrt (dx*dx + dy*dy)
	 stop = delta2/delta
	 }
      }
   return
end

E 1
