h00965
s 00000/00000/00069
d D 1.2 83/03/31 12:37:02 mmm 2 1
c 
e
s 00069/00000/00000
d D 1.1 83/03/15 21:41:19 tes 1 0
c date and time created 83/03/15 21:41:19 by tes
e
u
4
U
t
T
I 1
subroutine grqst (wkid, stdnr, l, echo, stat, strl, str)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Request string                                         #
#                                                                      #
#     Input Parameters:                                                #
#            wkid   - workstation identifier                           #
#            stdnr  - string device number                             #
#            l      - maximal character item count                     #
#            echo   - echo / no echo flag (NO = 0, YES = 1)            #
#     Output Parameters:                                               #
#            stat - status (OK= 1, NONE = 0)                           #
#            strl - length of string (in characters)                   #
#            str  - character string                                   #
#                                                                      #
#     Errors:                                                          #
#            7 GKS not in proper state: GKS must be in one of the      #
#              states WSOP, WSAC or SGOP                               #
#           20 Specified workstation identifier is invalid             #
#           25 Specified workstation is not open                       #
#           36 Specified workstation is neither an input workstation   #
#              nor an output/input workstation                         #
#                                                                      #
#     Routines Called:                                                 #
#            arysgn - copy integer arrays                              #
#            gzddop - call current device driver                       #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer wkid, stdnr, l, echo, stat, strl, str(l)
 
integer contrl(5), intin(3), ptsdum(1)
	
ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

include(`gkscom')

ifdef(`ERROR_ON',`
      rounum = GRQST
      errind = errchk(wkid, ierdum)
      ')
 
   contrl(OPCODE) = INPUTxSTRING
   contrl(VERTICESxIN) = 0

   intin(1) = stdnr
   intin(2) = l
   intin(3) = echo
   contrl(5) = NONE # Initialize output for non-string devices(trumpets etc.)
   stat = NONE

   call gzddop (contrl, intin, ptsdum, str, ptsdum)

   # Return the status, string length and the string
   if (contrl(5) >= 1) stat = OK
   strl = contrl(5)

   return
end
E 1
