h20910
s 00224/00000/00000
d D 1.1 83/03/17 17:51:18 bog 1 0
c date and time created 83/03/17 17:51:18 by bog
e
u
4
U
t
T
I 1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;									 ;
;    	This material is confidential and is furnished under a written   ;
;	license agreement. It may not be used, copied or disclosed to    ;
;	others except in accordance with the terms of that agreement.	 ;
;									 ;
;	Copyright (c) 1982 GRAPHIC SOFTWARE SYSTEMS INC.                 ;
;	All rights reserved.						 ;
;									 ;
;   FPARSE--                                                             ;
;	Function:							 ;
;		parse and pack a CPM filename into FCB format            ;
;	Input:								 ;
;		CPM filename (a null terminated string)                  ;
;	Output:								 ;
;		FCB file name                                    	 ;
;	Description:							 ;
;		Append gsxldr to program, fill in length parameters	 ;
;		 	for leech, so leech can perform memory check	 ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; BNF for filename parse
;  1	<filename>	::= <drive>        '.'          {blank name & extension}
;  2			  | <drive>        '.' <name>   {blank name}
;  3			  | <drive> <name>	        {default extension}
;  4			  | <drive> <name> '.'          {blank extension}
;  5			  | <drive> <name> '.' <name>
;
;  7    <drive>		::=		      	        {default drive}
;  8			  | <drivechar> ':'
;
;  9    <drivechar>	::= 'A' | 'a' | 'B' | 'b'       {lower becomes upper}
; 13			  | 'C' | 'c' | 'D' | 'd'
; 17			  | 'E' | 'e' | 'F' | 'f'
; 21			  | 'G' | 'g' | 'H' | 'h'
; 25			  | 'I' | 'i' | 'J' | 'j'
; 29			  | 'K' | 'k' | 'L' | 'l'
; 33			  | 'M' | 'm' | 'N' | 'n'
; 37			  | 'O' | 'o' | 'P' | 'p'
;
; 41	<name>		::= <name> <namechar>
;
; 53			  | '/' | '0'..'9' | '@'
; 65			  | 'A'..'Z' | '\' | '^'
; 93			  | '_' | '`' | 'a'..'z'	{lower becomes upper}
;121			  | '{' | '|' | '}' | '~'

; Parse a d:filename.ext into the Fcb pointed to by DE
; Default extension should be preset in Fcb; no validity check is made of it
; A is assumed to hold whitespace before filespec or 1st char of filespec
; Carry set on return if not valid filename
; A will hold the parse stopper (-1 if EOF) on return
; other registers preserved
; GetCh is used to get characters to parse
Public  FParse
Chrptr  dw      0               ; pointer to next char in file name
FParse	Shld    Chrptr          ; save character pointer
        Mov     A,M             ; Get first character
	Push    H               ;
	Push    D               ;
	Xchg			; HL now points to Fcb
	Mvi	M,0		; Assume default drive
	Call	SkipBl		; Skip whitespace
	Call	UpCase		; Upcase potential <drivechar>
	Cpi	'A'		; Possible <drivechar>?
	Jc	FTryFn		; No.. go try filename
	Cpi	'P'+1		; <drivechar>?
	Jnc	FTryFn		; No.. go try filename
	Push	Psw		; Save char to peek at next
	Call	PeekCh		; Temporarily get next character
	Cpi	':'		; Is it a :?
	Jnz	FNDriv		; Jump if drive not specified
	Pop	Psw		; Get <drivechar> back
	Sui	'@'		; Make it drive number
	Mov	M,A		; Stuff in Fcb
	Call	GetUC		; Real get of ':'
	Call	GetUC		; Get first filename char
	Push	Psw		; Compensate for following Pop

FNDriv	Pop	Psw		; Get first filename char back

FTryFn	Mvi	D,8		; Name is 8 characters long
	Call	StName		; Fetch name, if present
	Cpi	'.'		; Extension follows?
	Jnz	FAftEx		; Nope.. bypass extension stuff
	Call    GetUC           ; Get first char in extension
	Mvi	D,3		; Extension is 3 characters long
	Call	StName		; Fetch extension

; If the first StName found no filename, D would be 8.  If a '.' were
;  present, D would have been changed to 3 or less.  Thus, if D is 8,
;  no filename.ext was found.
FAftEx	Mov	E,A		; Save parse stopper
	Mov	A,D		; Get D into A
	Cpi	8		; Filename found?
	Stc			; Assum not found
	Jz	FQuit		; Jump if filename not parsed
	Cmc			; Turn off carry if filename parsed

FQuit	Sbb     A               ; return 0 if error
        Cma
	Pop	D		; Restore caller's DE
	Pop	H		;  & HL
	Ret			;  & return
	Page
; Clear field to spaces then stuff valid <namechar>s; skip following
;   <namechar>s
; D contains count of chars to stuff
; HL points to char before place to stuff
; A will contain stopper on return
; HL will contain pointer to last place to stuff on return
; D crashed on return
StName	Push	H		; Save ptr to before place to stuff
	Push	D		; Save char count

StNamC	Inx	H		; Point to char to stuff
	Mvi	M,' '		; Clear to space
	Dcr	D		; Decrement stuff count
	Jnz	StNamC		; Loop until cleared to spaces

	Pop	D		; Get char count back
	XTHL			; Point to before place to stuff; save last

StNamS	Call	NameCh		; Valid <namechar>?
	Jnc	StNamQ		; Quit if not valid <namechar>
	Inx	H		; Bump to place to stuff
	Mov	M,A		; Stuff name or extension character in Fcb
	Call	GetUC		; Get next possible name or ext char
	Dcr	D		; Decrement stuff count
	Jnz	StNamS		; Loop until all chars of name or ext stuffed

StNamB	Call	NameCh		; Valid <namechar>?
	Jnc	StNamQ		; Quit if not valid <namechar>
	Call	GetUC		; Get next possible name or ext char
	Jmp	StNamB		; Loop until all <namechar>s bypassed

StNamQ	Pop	H		; Return pointer to last place to stuff
	Ret			;  & return

NameChs	Db	'!',')'+1	; Ranges of valid characters
	Db	'+','+'+1	; <firstvalid>,<lastvalid>+1
	Db	'-','-'+1
	Db	'/','9'+1
	Db	'@','Z'+1
	Db	05ch,05ch+1
	Db	'^','~'+1
	Db	0ffh		; Stopper

; Return carry reset if invalid <namechar>
NameCh	Cpi	080h		; If char >= 080h
	Rnc			;  return invalid
	Push	H		; Save caller's HL
	Lxi	H,NameChs	; Point to transition table

NamChL	Cmp	M		; Test against bottom of valid range
	Jc	NamChC		; < bottom; not valid; return carry 0
	Inx	H		; Point to top+1 of valid range
	Cmp	M		; Test against top+1 of valid range
	Jc	NamChR		; < top+1; valid; return carry 1
	Inx	H		; Point to next pair
	Jmp	NamChL		;  & loop

NamChC	Cmc			; Reset carry

NamChR	Pop	H		; Restore caller's HL
	Ret			;  & return

GetUC   Call    GetCH           ; Get next char and fall through
                                ; UpCase
; Upcase character in A; i.e. 'a'..'z' -> 'A'..'Z'
UpCase	Cpi	'a'	; Less than 'a'?
	Rc		; Return if so
	Cpi	'z'+1	; Lower case alphabetic?
	Rnc		; Return if not
	Sui	'a'-'A'	; Make upper case
	Ret		;  & return

PeekCh  Push     H      ;
	Lhld     Chrptr ;
	Inx      H      ;
	Mov      A,M    ;
	Pop      H      ;
	Ret

SkipBL  Cpi      ' '    ; Compare to "blanks"
	Jz       SkipBLG; Jump if equal
	Cpi      8
	Rnz
SkipBLG Call     GetCh  ; Get next character
	Jmp      SkipBL ; Loop

GetCh   Push     H
	Lhld     Chrptr ;
	Inx      H      ;
	Mov      A,M    ;
	Shld     Chrptr ;
	Pop      H      ;
	Ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;									 ;
;    	This material is confidential and is furnished under a written   ;
;	license agreement. It may not be used, copied or disclosed to    ;
;	others except in accordance with the terms of that agreement.	 ;
;									 ;
;	Copyright (c) 1982 GRAPHIC SOFTWARE SYSTEMS, INC.                ;
;	All rights reserved.						 ;
;									 ;
;   GZBDOS--                                                             ;
;	Function:							 ;
;		call bdos with disk I/O opcode and FCB address           ;
;	Input:								 ;
;		integer*1 opcode                                         ;
;               FCB address in DE                                        ;
;	Output:								 ;
;		FCB file with appropriate bytes set                      ;
;               error in A                                               ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BDOS	Equ	5	;
Public	Gzbdos		;
Gzbdos: Mov	C,M	;
	Call 	BDOS	;
	Mvi     H,0     ;
	Mov     L,A     ;
	Ret             ;
	End             ;
E 1
