h19403
s 00002/00001/00049
d D 1.7 83/02/23 14:47:29 tes 7 6
c fixed error - set graphic character size after setting graphics mode
e
s 00002/00001/00048
d D 1.6 83/02/18 12:09:07 mjb 6 5
c 
e
s 00003/00001/00046
d D 1.5 83/02/03 19:56:24 mjb 5 4
c removed common block mnucom 
e
s 00003/00001/00044
d D 1.4 83/02/02 19:30:18 tes 4 3
c added hardware text size setting when changing to graphics
e
s 00011/00008/00034
d D 1.3 83/01/28 23:27:04 tes 3 2
c modified apmenu interface to include a clear screen flag
e
s 00002/00002/00040
d D 1.2 83/01/21 16:53:47 tes 2 1
c Removed reference to ASCIIxMODE
e
s 00042/00000/00000
d D 1.1 83/01/20 11:09:27 tes 1 0
c date and time created 83/01/20 11:09:27 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine chgmod (mode) 
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: change current device mode, graphics or ascii          #
#                                                                      #
#     Input Parameters:                                                #
D 2
#            mode = 0 -> ascii, 1 -> graphics                          #
E 2
I 2
#            mode = Corresponds to device opcode: ENTER/EXIT GRAPHICS  #
E 2
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzesc - d/i interface to device driver escape functions   #
#                                                                      #
########################################################################
integer mode

D 4
integer ilen, iarray(1)
E 4
I 4
integer ilen, iarray(1), isize, temp
E 4

D 5
include(`mnucom')
E 5
I 5
integer mnumod
I 6
SHORTINT xcursr, ycursr
E 6

D 6
common /mnumcm/ mnumod
E 6
I 6
common /mnumcm/ mnumod, xcursr, ycursr
E 6
E 5

D 3
   ilen = 0
E 3
I 3
data ilen /0/
I 4
data isize /2/
E 4
E 3

D 2
   if (mode == ASCIIxMODE) {   # exit graphics and enter ascii
E 2
I 2
D 3
   if (mode == EXITxGRAPHICSxMODE) {   # exit graphics and enter ascii
E 2
      mnumod = EXITxGRAPHICSxMODE
      }
   else {             # exit ascii mode and enter graphics
      mnumod = ENTERxGRAPHICSxMODE
      }
E 3
I 3
   if (mode != mnumod) {   # don't do anything if it is already set
E 3

D 3
   call gzesc (mnumod, ilen, iarray)
E 3
I 3
      if (mode == EXITxGRAPHICSxMODE) {   # exit graphics and enter ascii
         mnumod = EXITxGRAPHICSxMODE
I 7
         call gzesc (mnumod, ilen, iarray)
E 7
         }
      else {             # exit ascii mode and enter graphics
         mnumod = ENTERxGRAPHICSxMODE
I 7
         call gzesc (mnumod, ilen, iarray)
E 7
I 4
	 call qsthsz (isize, temp, temp)
E 4
         }

D 7
      call gzesc (mnumod, ilen, iarray)
E 7
      }
E 3

   return
end
E 1
