	.title 'Network Login Program'
	.sbttl 'LOGIN'
version	==	1
revision==	1
;----------
; LOGIN - log a user into the network
;
; 1) Ask user for name and password
; 2) Wait for poll of pseudo-user 253
; 3) Give name and password to master
; 4) Get user number assignment from master
; 5) Start answering polls
;
; Update history:
;
; 1.00 (10/01/80) Initial release
; 1.01  (11/03)   Added name, password
;----------
LOGusr	==	253	; login pseudo-userno
ticks	==	40h	; location of time info
NETusr	==	47h	; location of user number
loginNET==	13h
poll	==	'P'
logack	==	'L'
lognack	==	'N'
cr	==	0Dh
lf	==	0Ah
cntlC	==	03h
stack	==	1000h
WBOOT	==	0
BDOS	==	5
instr	==	10	; input a string
outstr	==	9	; output a string
	.pabs
	.phex
	.page
	.loc	100h	; start at base of TPA
;	
; Greet the user
	lxi	SP,stack
	mvi	C,outstr
	lxi	D,LOGmsg
	call	BDOS
;
; Ask for name
..askname:
	mvi	C,outstr
	lxi	D,NAMEmsg
	call	BDOS	; ask for name
	mvi	C,instr
	lxi	D,NAME
	call	BDOS	; get name
	lxi	H,NAME
	call	BLKfill	; blank fill end of name
	lxi	H,NAME+2
	lxi	D,LOGnam
	lxi	B,8
	ldir		; move to network command
;
; Ask for password
	mvi	C,outstr
	lxi	D,PSWmsg
	call	BDOS	; ask for password
	mvi	C,instr
	lxi	D,PASSWD
	call	BDOS	; get password
	lxi	H,PASSWD
	call	BLKfill	; blank fill end of password
	lxi	H,PASSWD+2
	lxi	D,LOGpsw
	lxi	B,6
	ldir		; move to network command
;
; Wait for poll of pseudo-user 253
..poll:
	lxi	H,LOGcom
	lxi	B,1
	mvi	A,LOGusr
	call	RECNET
	bit	7,A	; check for time-out
	jrz	..timeout
	lda	LOGcom
	cpi	poll
	jrnz	..poll	; jump if poll not received
;
; Send login request to master
	lxi	H,LOGcom
	mvi	M,loginNET
	lxi	B,lenlog
	sub	A
	call	SENDNET
;
; Receive user number assignment from master
	lxi	H,LOGcom
	lxi	B,9
	mvi	A,LOGusr
	call	RECNET
	lda	LOGcom
	cpi	logack
	jrz	..login
	cpi	lognack	; retry if conflict
	jrz	..poll
	mvi	C,outstr; denied due to bad name or psw
	lxi	D,DENYmsg
	call	BDOS
	jmp	..askname
;
; Login failed due t                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                