
;    **************************************************
;    **************************************************
;    **************************************************



                              .LCTL

;                          ***********
	.TITLE            "SNAPTRY.COM"
;                          ***********


;                        Version:    1.00

;                  First Written:    11/25/89

;                  Last Modified:    11/29/89



                             .XLIST



;                          **********
;                          LABEL DATA:
;                          **********



                      VERSION	=       '1'
                      MODIF	=	'00'
                      CHANGE	=	' '

                      MONTH	=	'11'
                      DAY	=	'29'
                      YEAR	=	'89'



;                            ******
;                            SAMPLE
;                            DIALOG:
;                            ******



;	A>PROGNAME
;
;
;		PROGNAME UTILITY     Version:  1.00a
;			.
;			.
;			.
;
;		EXIT TO CP/M
;
;
;	A>



;                           *******
;                           HISTORY:
;                           *******



;   	11/25/89:	Tryout of snapshot dump
;			debugging macro, to be
;			provided as "includable"
;			file during utility debugging.

;			Identifies the breakpoint by
;			name, and provides a snapshot
;			of the CPU registers, and any
;			memory area requested.



;    **************************************************
;    **************************************************



;                          ********
;                          ASSEMBLY
;                          CONTROLS:
;                          ********



                         DEBUG  ==  OFF
                      SUBROUTINES  ==  OFF
                         MACROS  ==  ON


			.PABS
			.PHEX

			.RADIX	16
			.LADDR

;			.XSYM

			.SALL



;                         **********
;                          SYMBOLIC
;                         REFERENCES:
;                         **********



;                        CP/M  SYSTEM:
;                        ----  ------


		PAGE.0		==	0000
		BIOS.JUMP	==	PAGE.0 + 0001
		IO.BYTE		==	PAGE.0 + 0003
		USER.DRIVE	==	PAGE.0 + 0004
		BDOS.JUMP	==	PAGE.0 + 0005
		SYSTEM		==	BDOS.JUMP
		DEF.FCB		==	PAGE.0 + 005C
		DEF.DISK.BUFF	==	PAGE.0 + 0080
		TPA		==	PAGE.0 + 0100


;                        CHARACTER  I/O:
;                        ---------  ---


		WARM.BOOT	==	0
		CONS.INPUT	==	1
		CONS.OUTPUT	==	2
		LIST.CHAR	==	5
		CONS.DIRECT	==	6
		STRING.PRINT	==	9
		  END.MESSAGE	==	0
		READ.LINE	==	0A
		CONS.STATUS	==	0B

		BREAK		==	''


;                            ASCII:
;                            -----


		NULL		==	00
		BEL		==	07
		BACKSPACE	==	08
		LF		==	0A
		CR		==	0D
		SPACE		==	20
		FORMFEED	==	0C
		RUBOUT		==	7F
		DEL		==	RUBOUT
		QUESTION.MARK	==	'?'
		HUH		==	QUESTION.MARK
		CNTRL.CHAR	==	'^'


;                           UTILITY:
;                           -------


		ZERO		==	0000
		OFF		=	ZERO
		ON		=	#ZERO
		CLEAR		=	OFF
		SET		=	ON
		OK		=	ZERO
		NOT.OK		=	#ZERO


                           MAPPING:
;                           -------


		LOAD.POINT	==	TPA

		STACK.SIZE	==	20 ; words



;                       MACRO DEFINITION:


                      .INSERT	SNAPSHOT.MAC


;                            DEBUG:


                              .LIST
                              .PAGE
                  .SBTTL  "MAIN PROGRAM SEGMENT"

;    **************************************************
;    **************************************************



;                          *********
;                          PROCEDURE:
;                          *********



		       .LOC   LOAD.POINT


			     FIRST:

                          JMP	START


;                            LABEL:
;                            -----


                             .XLIST


..NAME:
		.ASCII	' SNAPTRY.COM'
		.BYTE	END.MESSAGE

VERS.NUMBER:
		.ASCII	'Version:  '
		.BYTE	VERSION
		.BYTE	'.'
		.BYTE	MODIF / 100
		.BYTE	MODIF @ 100
		.BYTE	CHANGE
		.BYTE	END.MESSAGE

..DATE:
		.ASCII	'Date:  '
		.BYTE	MONTH / 100
		.BYTE	MONTH @ 100
		.BYTE	'/'
		.BYTE	DAY / 100
		.BYTE	DAY @ 100
		.BYTE	'/'
		.BYTE	YEAR / 100
		.BYTE	YEAR @ 100
		.BYTE	END.MESSAGE



                              .LIST



START:
	LXI	SP, TOP.STACK

MAIN:
	LXI	D, HELLO
	CALL	FLASH
	CALL	SPC5
	LXI	D, VERS.NUMBER
	CALL	FLASH
	CALL	CRLF
	CALL	LFEED

..LOOP:

	NOP

	SNAPSHOT[#11  0100 THRU 01F0,ON,0100,01F0]

	SUB	A

	SNAPSHOT[#12  ZERO FLAG]

	MVI	A, 0FF
	ADI	2

	SNAPSHOT[#13  CARRY FLAG]

	MVI	A, 80
	ORA	A

	SNAPSHOT[#14  SIGN FLAG]

	MVI	A, 80
	SUI	2

	SNAPSHOT[#15  OVERFLOW FLAG (-128 - 2)]

	MVI	A, 7F
	ADI	2

	SNAPSHOT[#16  OVERFLOW (127 + 2)]

	MVI	A, 0FF
	ADI	2

	SNAPSHOT[#17  OVERFLOW (-1 + 2)]

	MVI	A, 00
	SUI	2

	SNAPSHOT[#18  OVERFLOW (0 - 2)]

	PUSH	PSW
	LXI	H, 0000
	DAD	SP
	MVI	M, ^B11000101
	INX	H
	MVI	M, 00
	POP	PSW

	SNAPSHOT[#19  SET ALL FLAGS]

	MVI	A, 01
	CPI	00
	MVI	A, 00

	LXI	B, 0000
	LXI	D, 0000
	LXI	H, 0000
	LXI	X, 0000
	LXI	Y, 0000

	SNAPSHOT[#20  CLEAR STATE]


	NOP

	CALL	LFEED
	CALL	LFEED
	LXI	D, CONTINUE
	CALL	FLASH
	CALL	GETCHAR
	CALL	CRLF
	CPI	BREAK
	JNZ	..LOOP

NORM.EXIT:

	CALL	LFEED
	LXI	D, GOODBYE
	CALL	FLASH

	MVI	C, WARM.BOOT
	CALL	SYSTEM



;    **************************************************
;    **************************************************



;                           ********
;                           MESSAGES:
;                           ********



HELLO:
	.BYTE	LF, LF
	.ASCII	'     SNAPSHOT DEBUGGING MACRO'
	.BYTE	END.MESSAGE

CONTINUE:
	.ASCII	/     KEEP ON TRUCKIN'?  /
	.BYTE	END.MESSAGE

GOODBYE:
	.ASCII	'     EXIT TO CP/M'
	.BYTE	CR, LF, LF
	.BYTE	END.MESSAGE



;    **************************************************
;    **************************************************



;                         ***********
;                         SUBROUTINES:
;                         ***********



                       .IFE  DEBUG - OFF,  .XLIST


                      .INSERT	SNAPSHOT.LIB


;                            .XLIST


;                     CONSOLE CHARACTER  I/O:
;                     ------- ---------  ---


IF.KEY.GET:

;		GET CHARACTER, IF AVAILABLE.
;		IF NOT, RETURN ZERO IN "A":

	CALL	REG.SAVE

	MVI	C, CONS.DIRECT
	MVI	E, SET
	CALL	SYSTEM
	CPI	ZERO

	CALL	REG.RESTORE

	RET

GETCHAR:

;		CP/M "UNCONDITIONED" CHARACTER FETCH:

	CALL	REG.SAVE

GETC1:
	MVI	C, CONS.DIRECT
	MVI	E, SET
	CALL	SYSTEM
	CPI	ZERO
	JRZ	GETC1

	CALL	REG.RESTORE

	RET

FETCH:

;		CP/M "FILTERED" CHARACTER FETCH
;		CHECKS FOR ^S AND ^P (^C?):

	CALL	REG.SAVE

	MVI	C, CONS.INPUT
	CALL	SYSTEM

	CALL	REG.RESTORE

	RET

PUTCHAR:
ECHO:
	PUSH	PSW
	CALL	REG.SAVE

	MOV	E, A
	MVI	C, CONS.OUTPUT
	CALL	SYSTEM

	CALL	REG.RESTORE
	POP	PSW

	RET

FLASH:

;		SEND STRING TO SCREEN:

	PUSH	PSW
	CALL 	REG.SAVE

..FL1:
	LDAX	D
	CPI	END.MESSAGE
	JRZ	..FL2

	CALL	PUTCHAR
	INX	D
	JMPR	..FL1

..FL2:
	CALL	REG.RESTORE
	POP	PSW

	RET

REG.SAVE:
	XTHL
	PUSH	D
	PUSH	B
	PUSH	H

	RET

REG.RESTORE:
	POP	H
	POP	B
	POP	D
	XTHL

	RET


;                  CONSOLE UTILITY:
;                  ------- -------


CRLF:
	PUSH	PSW

	MVI	A, CR
	CALL	PUTCHAR
	MVI	A, LF
	CALL	PUTCHAR

	POP	PSW

	RET

LFEED:
	PUSH	PSW

	MVI	A, LF
	CALL	PUTCHAR

	POP	PSW

	RET

SPC1:
	PUSH	PSW

	MVI	A, SPACE
	CALL	PUTCHAR

	POP	PSW

	RET

SPC3:
	PUSH	PSW
	CALL	REG.SAVE
	
	MVI	B, 3
	CALL	SSPC

	CALL	REG.RESTORE
	POP	PSW

	RET

SPC5:
	PUSH	PSW
	CALL	REG.SAVE
	
	MVI	B, 5
	CALL	SSPC

	CALL	REG.RESTORE
	POP	PSW

	RET

SSPC:

..SS1:
	MVI	A, SPACE
	CALL	PUTCHAR
	DCR	B
	JRNZ	..SS1

	RET

BKSPC:
	PUSH	PSW

	MVI	A, BACKSPACE
	CALL	PUTCHAR
	MVI	A, SPACE
	CALL	PUTCHAR
	MVI	A, BACKSPACE
	CALL	PUTCHAR

	POP	PSW

	RET

WORD.OUT:

;		SEND HEX FORM OF WORD POINTED BY "HL"
;		          TO THE SCREEN

	INX	H
	CALL	BYTE.OUT
	DCX	H
	CALL	BYTE.OUT

	RET

BYTE.OUT:

;		SEND HEX FORM OF BYTE POINTED BY "HL"
;		           TO THE SCREEN

	PUSH	PSW

	MOV	A, M
	PUSH	PSW
	CALL	SHFTR4
	CALL	ASCII.OUT
	POP	PSW
	CALL	ASCII.OUT

	POP	PSW

	RET

ASCII.OUT:

;		RIGHT-HAND NYBBLE IN "A" REGISTER
;		       GOES TO THE SCREEN

	ANI	0FH
	ADI	30H
	CPI	( '9' + 1 )
	JM	..SKIP

	ADI	'A' - ( '9' +  1 )

..SKIP:
	CALL PUTCHAR

	RET

SHFTR4:

;		ZEROS SHIFTED IN AT BIT #7:

	SRLR	A
	SRLR	A
	SRLR	A
	SRLR	A

	RET


INDIRECT:

;		RETURN VALUE POINTED BY "HL"
;		IN "HL" ITSELF, READY
;		FOR SUBSEQUENT INDIRECT ACCESS:

	PUSH	D
	MOV	E, M
	INX	H
	MOV	D, M
	XCHG
	POP	D

	RET



;   ***************************************************
;   ***************************************************



;                            *****
;                            STACK:
;                            *****



		    .LOC  ( . + 0F ) & 0FFF0


		   .BLKW	STACK.SIZE


			   TOP.STACK:



                              .LIST



;    **************************************************
;    **************************************************



;                         ***********
;                           ASSEMBLY
;                         TERMINATION:
;                         ***********



			     LAST:


	      SIZE.PROGRAM   ==   LAST - FIRST



;    **************************************************
;    **************************************************
;    **************************************************



			.END	FIRST

