

;		CP/M FILESPEC PARSER EXPERIMENT

;    **************************************************
;    **************************************************



;                          ********
;                          ASSEMBLY
;                          CONTROLS:
;                          ********



			.PABS
			.PHEX
			.XSYM

			.RADIX	16
			.LADDR



;                         **********
;                          SYMBOLIC
;                         REFERENCES:
;                         **********



;                        CP/M  SYSTEM:
;                        ----  ------


		PAGE.0		==	0000
		BIOS.JUMP	==	PAGE.0 + 0001
		IO.BYTE		==	PAGE.0 + 0003
		USER.DRIVE	==	PAGE.0 + 0004
		BDOS.JUMP	==	PAGE.0 + 0005
		SYSTEM		==	BDOS.JUMP
		DEF.FCB		==	PAGE.0 + 005C
		DEF.DISK.BUFF	==	PAGE.0 + 0080
		TPA		==	PAGE.0 + 0100


;                        CHARACTER  I/O:
;                        ---------  ---


		WARM.BOOT	==	0
		CONS.INPUT	==	1
		CONS.OUTPUT	==	2
		LIST.CHAR	==	5
		CONS.DIRECT	==	6
		STRING.PRINT	==	9
		  END.MESSAGE	==	0
		READ.BUFFER	==	0A
		CONS.STATUS	==	0B

		BREAK		==	''


;                            ASCII:
;                            -----


		NULL		==	00
		BEL		==	07
		BACKSPACE	==	08
		LF		==	0A
		CR		==	0D
		SPACE		==	20
		FORMFEED	==	0C
		RUBOUT		==	7F
		DEL		==	RUBOUT
		QUESTION.MARK	==	'?'
		HUH		==	QUESTION.MARK
		CNTRL.CHAR	==	'^'


;                           UTILITY:
;                           -------


		ZERO		==	0000
		OFF		=	ZERO
		ON		=	#ZERO
		CLEAR		=	OFF
		SET		=	ON
		OK		=	ZERO
		NOT.OK		=	#ZERO


;                           PROGRAM:
;                           -------


		LOAD.POINT	==	TPA

		STACK.SIZE	==	40 ; words

		MAX.FILE.SIZE	==	01B8

		DRV.A.RESET	==	0001



;    **************************************************
;    **************************************************



;                          *********
;                          PROCEDURE:
;                          *********



		       .LOC   LOAD.POINT


			     FIRST:


START:
	LXI	SP, TOP.STACK

	LDA	COM.TAIL.LENGTH
	LXI	H, COMMAND.TAIL
	CALL	MARK.END
	CALL	PARSE.LINE

	LDA	ARGC
	CPI	ZERO
	JRZ	..PROMPT.LINE

	CPI	1
	JRZ	..VALIDATE

..TROUBLE:

;		BAIL OUT OF THIS, IF
;		COMMAND-TAIL IS A DUD:

	LXI	D, COMPLAIN
	CALL	FLASH

..PROMPT.LINE:

	LXI	D, NAME.PROMPT
	CALL	FLASH

	MVI	A, 10
	STA	MAX.LINE
	CALL	GET.LINE

;		CHECK FOR INPUT OVERFLOW:

	LDA	CHAR.COUNT
	LXI	H, MAX.LINE
	CMP	M
	JRZ	..TROUBLE

;		PARSE THE INPUT STRING

	LXI	H, LINE.IN
	CALL	MARK.END
	CALL	PARSE.LINE

	LDA	ARGC
	CPI	1
	JRNZ	..TROUBLE

..VALIDATE:

	CALL	VALIDATE.FILESPEC
	CPI	OK
	JRNZ	..TROUBLE

	CALL	PREPARE.FCB

..END.PARSE:

	LXI	D, CRLF
	CALL	FLASH

	LXI	D, FILENAME
	CALL	FLASH

	JMP	..PROMPT.LINE


	
;		ASSOCIATED SUBROUTINES
;		---------- -----------

MARK.END:

	PUSH	H
	PUSH	D

	MOV	E, A
	MVI	D, ZERO
	DAD	D
	MVI	M, NULL

	POP	D
	POP	H

	RET
	
PARSE.LINE:

	PUSH	H

	MVI	A, ZERO
	STA	ARGC

..P1:
	CALL	..NON.SPACE
	CPI	NULL
	JRZ	..P2
	CALL	..STASH.POINTER

	CALL	..NEXT.SPACE
	CPI	NULL
	JRZ	..P2
	MVI	M, NULL
	INX	H
	JMPR	..P1

..P2:
	POP H

	RET

..NON.SPACE:

	MOV	A, M
	CPI	NULL
	RZ
	CPI	SPACE
	RNZ
	INX	H
	JMPR	..NON.SPACE

..NEXT.SPACE:

	MOV	A, M
	CPI	NULL
	RZ
	CPI	SPACE
	RZ
	INX	H
	JMPR	..NEXT.SPACE

..STASH.POINTER:

	LDA	ARGC
	CPI	8
	RP

	PUSH	D
	PUSH	H

	LXI	H, ARGV
	MVI	B, 2
	CALL	SUBSCRIPT
	POP	D
	MOV	M, E
	INX	H
	MOV	M, D
	XCHG

	LDA	ARGC
	INR	A
	STA	ARGC

	POP	D

	RET

ARGC:
		.BYTE	0

ARGV:
		.WORD	0, 0, 0, 0, 0, 0, 0, 0

VALIDATE.FILESPEC:

;		SCREEN FOR 0 OR 1 "PERIOD",
;		SCREEN FOR "." FILENAME,
;		BISECT THE ARGUMENT, IF REQ'D,
;		CHECK LENGTHS OF THE "NAME"
;		AND "TYPE" FIELDS:

	LXI	H, ARGV
	CALL	INDIRECT
	SHLD	..NAME
	CALL	STRLEN
	DAD	B
	SHLD	..TYPE

	LHLD	..NAME
	CALL	..PERIOD.COUNT

	CPI	2
	JP	..TROUBLE

	CPI	ZERO
	JRZ	..OK

	CALL	STRLEN
	CPI	1
	JRZ	..TROUBLE

	CALL	..BISECT

..OK:

	LHLD	..NAME
	CALL	STRLEN
	CPI	9
	JP	..TROUBLE

	LHLD	..TYPE
	CALL	STRLEN
	CPI	4
	JP	..TROUBLE

	LXI	H, ..NAME
	LXI	D, ..TYPE
	MVI	A, OK

	RET

..TROUBLE:

	MVI	A, NOT.OK

	RET

..PERIOD.COUNT:

	PUSH	H

	MVI	B, ZERO

..PER1:
	MOV	A, M
	CPI	NULL
	JRZ	..PER3

	CPI	'.'
	JRNZ	..PER2

	INR	B

..PER2:
	INX	H
	JMPR	..PER1

..PER3:
	MOV	A, B

	POP	H

	RET

..BISECT:

	LHLD	..NAME
	MVI	A, '.'

	CCIR

	SHLD	..TYPE
	DCX	H
	MVI	M, NULL

	RET

..NAME:
	.WORD	0

..TYPE:
	.WORD	0

PREPARE.FCB:

	PUSH	D
	PUSH	H

	LXI	H, FILENAME
	MVI	A, SPACE
	LXI	B, 0BH
	CALL	FILL

	POP	H
	CALL	INDIRECT
	CALL	STRLEN
	LXI	D, FILENAME
	CALL	MOVE

	POP	H
	CALL	INDIRECT
	CALL	STRLEN
	LXI	D, FILETYPE
	CALL	MOVE

	CALL	ZERO.FCB
	LXI	H, FILENAME
	CALL	UP.CASE.STRING

	RET

ZERO.FCB:
	LXI	H, FILE.EXTENT.NO
	MVI	C, DISK.BUFFER - FILE.EXTENT.NO
	MVI	A, ZERO

	CALL	FILL

	RET

STRLEN:
	PUSH	H

	LXI	B, ZERO
	MVI	A, NULL

..STR1:
	CMP	M
	JRZ	..STR2

	INX	H
	INX	B
	JMPR	..STR1

..STR2:
	MOV	A, C

	POP	H

	RET

TO.UPPER:
	CPI	'a'
	RM
	CPI	'z' + 1
	RP
	SUI	20H

        RET

UP.CASE.STRING:

	MOV	A, M
	CPI	NULL

	RZ

	CALL	TO.UPPER
	MOV	M, A
	INX	H
	JMPR	UP.CASE.STRING

TO.LOWER:
	CPI	'A'
	RM
	CPI	'Z' + 1
	RP
	ANI	20H

        RET

SUBSCRIPT:
	CPI	ZERO
	RZ

	PUSH	D
	MVI	D, ZERO
	MOV	E, B

..SUB1:
	DAD	D
	DCR	A
	JRNZ	..SUB1

	POP	D

	RET

INDIRECT:
	PUSH	D
	MOV	E, M
	INX	H
	MOV	D, M
	XCHG
	POP	D

	RET

MOVE:
	MOV	A, B
	ORA	C
	RZ

	PUSH	H
	STC
	CMC
	DSBC	D
	POP	H
	JM	..UP

..DOWN:
	LDIR

	RET
..UP:
	DAD	B
	DCX	H
	XCHG
	DAD	B
	DCX	H
	XCHG

	LDDR

	RET

FILL:
	PUSH	PSW

	MOV	A, B
	ORA	C
	JRNZ	..FIL1

	POP	PSW

	RZ

..FIL1:
	POP	PSW

	MOV	M, A
	INX	H
	DCX	B
	PUSH	PSW

	MOV	A, B
	ORA	C
	JRNZ	..FIL1

	POP	PSW

	RET

FLASH:
	CALL 	REG.SAVE

..FL1:
	LDAX	D
	CPI	END.MESSAGE
	JRZ	..FL2

	CALL	PUTCH
	INX	D
	JMPR	..FL1

..FL2:
	CALL	REG.RESTORE

	RET

GET.LINE:
	MVI	C, 0A
	LXI	D, CONSOLE.BUFFER
	CALL	SYSTEM

	RET

PUTCH:
ECHO:
	CALL	REG.SAVE

	MOV	E, A
	MVI	C, CONS.OUTPUT
	CALL	SYSTEM

	CALL	REG.RESTORE

	RET

REG.SAVE:
	XTHL
	PUSH	D
	PUSH	B
	PUSH	H

	RET

REG.RESTORE:
	POP	H
	POP	B
	POP	D
	XTHL

	RET



;    **************************************************
;    **************************************************



;                        ***************
;			 DUMMY ADDRESSES:
;                        ***************


;		      FOR EXTERIOR ASSEMBLY


NAME.PROMPT:
	.BYTE	CR, LF
	.ASCII	'ENTER A FILENAME TO BE PARSED:   '
	.BYTE	END.MESSAGE

COMPLAIN:
	.BYTE	BEL
	.BYTE	CR, LF
	.ASCII	'INVALID FILESPEC!'
	.BYTE	END.MESSAGE

CRLF:
	.BYTE	CR, LF
	.BYTE	END.MESSAGE



;    **************************************************
;    **************************************************



;                             ***
;                             RAM:
;                             ***



			RAM.VARIABLES:


		  .LOC	 DEF.FCB


FCB:

DRIVE.SELECT:
		.BLKB	1

FILENAME:
		.BLKB	8

FILETYPE:
		.BLKB	3

FILE.EXTENT.NO:
		.BLKB	1


		.BLKB	2

EXTENT.LENGTH:
		.BLKB	1

MAP.AREA:
		.BLKB	1

NEW.NAME:
		.BLKB	0FH

SEQ.POINTER:
		.BLKB	1


RAN.POINTER:
FILE.LENGTH:
		.BLKB	3


DISK.BUFFER:
CONSOLE.BUFFER:
COM.TAIL.LENGTH:
MAX.LINE:
		.BLKB	1

COMMAND.TAIL:
CHAR.COUNT:
		.BLKB	1

LINE.IN:
		.BLKB	7EH



;   ***************************************************
;   ***************************************************



;                            *****
;                            STACK:
;                            *****



			    .RELOC

		    .LOC  ( . + 0F ) & 0FFF0


		   .BLKW	STACK.SIZE


			   TOP.STACK:



;    **************************************************
;    **************************************************



			.END

