

;	   ***   CP/M PATCHES FOR DAD'S SYSTEM   ***



;	Begin with standard CP/M 2.249.
;
;	Create 1-page files for each of the 4
;	relevant Track 01 Sectors: 28, 45, 46, and 50
;	using SAVE.
;
;	Use DUU to:
;		(a)	read each relevant sector,
;		(b)	save it,
;		(c)	read in corresponding sector
;			file,
;		(d)	restore saved sector, and
;		(e)	write sector into its sector file.
;
;	Use DEBUG to:
;		(a)	load each sector's file,
;		(b)	load DAD.HEX just above it,
;		(c)	move appropriate patch down
;			into the sector's area, and
;		(d)	save the modified sector.
;
;	Then use DUU again, to:
;		(a)	read in each modified sector
;			from its file,
;		(b)	save it,
;		(c)	read in corresponding system
;			sector,
;		(d)	restore modified sector, and
;		(e)	write it to system tracks.



;                          ********
;                          ASSEMBLY
;                          CONTROLS:
;                          ********



			.PABS
			.PHEX
			.XSYM

			.RADIX	16
			.LADDR




;                          *********
;                          PROCEDURE:
;                          *********




  USER.INITL  ==   0FD18  ; Cold Boot User Selection
  CONTINUE    ==   0FD1C
  STAT.PORT2  ==   0F486  ; Used For User #1 Patch
  IN.PORT2    ==   0F493
  OUT.PORT2   ==   0F498  ; Output, After XOFF Screening
  BUSY.FLAG   ==   0F4FA
  XOFF        ==   13




;			DEFAULT USER #1:
;
;	 Installed at Trk 1 : Sect 28 : Byte 6  =  F486
;               ( Replaces Port #2 Status Check )
;
;    Also install "JMP   F486"  at Trk 1 : Sect 45 : Byte 18
;	               ( Address  FD18 )



		       .LOC   200

	MVI	A, 10
	STA	0004
	XRA	A
	JMP	CONTINUE
	NOP
	NOP



;	     FIX PRINTER TO RECOGNIZE XON / XOFF
;                     ON SERIAL PORT #2:
;
;       Installed at Trk 1 : Sect 28 : Byte 5D  =  F4DD
;			( 1Eh  Bytes )


			.LOC	( . + 0F ) & 0FFF0


			     FIRST:

BEGIN:
	IN	22
	ANI	01
	JRZ	READY

	IN	20
	CPI	XOFF
	JRNZ	ON

	MVI	A, 0FF
	JMPR	SET.FLAG

ON:
	XRA	A

SET.FLAG:
	STA	BUSY.FLAG

READY:
	LDA	BUSY.FLAG
	ORA	A
	JRNZ	BEGIN

	JMP	OUT.PORT2



;                            ***
;                            RAM:
;                            ***



			RAM.VARIABLES:


BUSY:			 .BYTE	 00


			     LAST:


	      SIZE.PATCH   ==   LAST - FIRST


;                     FILL OUT THE PATCH
;             TO START OF "CUSTOM" SERVICE ROUTINE:


	NOP
	NOP
	NOP




;	                   COLD BOOT
;	              JUMP TO USER #1 PATCH
;
;	  Installed at Trk 1 : Sect 45 : Byte 18  =  FD18


			.LOC	( . + 0F ) & 0FFF0

	JMP	STAT.PORT2
	NOP



;			NEW SIGN-ON MESSAGE:
;
;	     Installed at Trk 1 : Sect 46 : Byte 5E


			.LOC	(. + 0F ) & 0FFF0

	.ASCII	'CP/M for POP'



;	       1200 BAUD DEFAULT RATE ON PORT 2 / 3:
;
;	  Installed at Trk 1 : Sect 50 : Byte 67  =  FFE7


			.LOC	( . + 0F ) & 0FFF0

	.BYTE	94		;	NEW IOBYTE
	.BYTE	45, 02		;	unchanged
	.BYTE	45, 68		;	1200 BAUD DEFAULT





			.END


