;    ******************************************************
;    ******************************************************
;    ******************************************************



;                           *********
;                           ASCII.COM
;                           *********



;                        Version:    1.00a

;                  First Written:    05/19/88

;                  Last Modified:    12/15/89



;	LABEL:
                      VERS	EQU	'1'
                      MODIF	EQU	'00'
                      CHANG	EQU	'b'

                      MONTH	EQU	'12'
                      DAY	EQU	'15'
                      YEAR	EQU	'89'



;            ACCEPTS 2-DIGIT ASCII-ENCODED HEX INPUT
;            FROM THE CONSOLE AND OUTPUTS THE ASCII
;            EQUIVALENT CHARACTER TO THE CRT SCREEN.

;            A "CR" AFTER ANY PROMPT TERMINATES THE
;              INPUT AND RETURNS CONTROL TO CP/M.



;                           ******
;                           SAMPLE
;                           DIALOG:
;                           ******



;	A>ASCII
;
;	HEX-TO-ASCII TRANSLATOR:
;             => 3F = ?
;             => 5A = Z
;             => 
;
;            *** EXIT ***
;
;	A>


;                            *****
;                            NOTES:
;                            *****



;    ******************************************************
;    ******************************************************



;                          *********
;                          CONSTANTS:
;                          *********



;                        CP/M  SYSTEM:
;                        ----  ------


TPA	EQU	0100H
ALOAD	EQU	TPA
ABDOS	EQU	0E306H
ABIOS	EQU	0F200H
WBOOT	EQU	0F203H
BDOS	EQU	0005H
BREAK	EQU	''


;                        CHARACTER  I/O:
;                        ---------  ---


BOOT	EQU	0
INP	EQU	1
OUTP	EQU	2
LIST	EQU	5
DINP	EQU	6
PRSTR	EQU	9
XMSG	EQU	'$'
RDBUF	EQU	10
CSTAT	EQU	11


;                           UTILITY:
;                           -------


ZERO	EQU	0
OFF	EQU	ZERO
ON	EQU	0FFFFH
XCASE	EQU	ZERO


;                            ASCII:
;                            -----


NUL	EQU	00H
BEL	EQU	07H
BS	EQU	08H
LF	EQU	0AH
CR	EQU	0DH
SPACE	EQU	20H
FFEED	EQU	0CH
RUB	EQU	7FH
QMARK	EQU	'?'
HUH	EQU	QMARK
CNTRL	EQU	'^'


;                           PROGRAM:
;                           -------


LOAD	EQU	TPA

STACK	EQU	20H



;    ******************************************************
;    ******************************************************



;                           *********
;                           PROCEDURE:
;                           *********



	ORG	LOAD


ENTRY	JMP	START


;                            STAMP:
;                            -----


NAME	DB	'ASCII.COM    '

VERNO	DB	' VERSION:  '
	DB	VERS,'.'
	DB	MODIF AND 0FFH
	DB	(MODIF SHR 8) AND 0FFH
	DB	CHANG

DATE	DB	' DATE:  '
	DB	MONTH AND 0FFH
	DB	(MONTH SHR 8) AND 0FFH,'/'
	DB	DAY AND 0FFH
	DB	(DAY SHR 8) AND 0FFH,'/'
	DB	YEAR AND 0FFH
	DB	(YEAR SHR 8) AND 0FFH
	DB	'   '


START	LXI	SP,SPNTR

	LXI	D,HELLO
	CALL	PRINF

MAIN	LXI	D,MSG1
	CALL	PRINF

MAIN1	CALL	GETCH
	CALL	UPCAS
	STA	HDIG

	CALL	CASE
	DB	BS
	DB	BREAK
	DB	CR
	DB	XCASE

	PUSH	A
	MOV	A,C

	CPI	1
	JNZ	MAIN2
	JMP	MAIN1

MAIN2	CPI	2
	JNZ	MAIN3
	CALL	QUIT

MAIN3	CPI	3
	JNZ	MAIN4
	CALL	QUIT

MAIN4	POP	A
	CPI	SPACE+1
	JM	MAIN5

	CPI	RUB
	JNZ	MAIN6

MAIN5	CALL	QUIZ
	JMP	MAIN7

MAIN6	CALL	ECHO
	CALL	HRCHK
	JNC	MAIN7

	CPI	'7'+1
	JM	MAIN8

MAIN7	CALL	BEEP
	CALL	WAIT1
	CALL	BKSPC
	JMP	MAIN1

MAIN8	CALL	GETCH
	CALL	UPCAS
	STA	LDIG

	CALL	CASE
	DB	BS
	DB	BREAK
	DB	CR
	DB	XCASE

	PUSH	A
	MOV	A,C

	CPI	1
	JNZ	MAIN9
	CALL	BKSPC
	JMP	MAIN1

MAIN9	CPI	2
	JNZ	MN10
	CALL	QUIT

MN10	CPI	3
	JNZ	MN11
	CALL	QUIT

MN11	POP	A
	CPI	SPACE+1
	JM	MN12

	CPI	RUB
	JNZ	MN13

MN12	CALL	QUIZ
	JMP	MN14

MN13	CALL	ECHO
	CALL	HRCHK
	JC	MN15

MN14	CALL	BEEP
	CALL	WAIT1
	CALL	BKSPC
	JMP	MAIN8

MN15	LXI	D,MSG2
	CALL	PRINF

	LDA	HDIG
	CALL	HEX
	RAL
	RAL
	RAL
	RAL
	ANI	0F0H
	STA	HDIG

	LDA	LDIG
	CALL	HEX
	STA	LDIG

	MOV	B,A
	LDA	HDIG
	ORA	B
	STA	ASCII

	CPI	RUB
	JNZ	MN16
	LXI	D,TLAST
	JMP	MN20

MN16	CPI	SPACE+1
	JM	MN17
	CALL	PUTCH
	CALL	CRLF
	JMP	MAIN

MN17	LXI	H,NDTBL
	LXI	D,15

MN18	CPI	0
	JZ	MN19
	DAD	D
	DCR	A
	JMP	MN18

MN19	MOV	D,H
	MOV	E,L

MN20	CALL	PRINF
	CALL	CRLF
	JMP	MAIN



;    ******************************************************
;    ******************************************************



;                      *****************
;                      NON-DISPLAY TABLE:
;                      *****************


NDTBL	DB	'CNTRL-@  (NUL)',XMSG
       	DB	'CNTRL-A  (SOH)',XMSG
       	DB      'CNTRL-B  (STX)',XMSG
	DB	'CNTRL-C  (ETX)',XMSG
       	DB      'CNTRL-D  (EOT)',XMSG
       	DB      'CNTRL-E  (ENQ)',XMSG
       	DB      'CNTRL-F  (NAK)',XMSG
       	DB      'CNTRL-G  (BEL)',XMSG
       	DB      'CNTRL-H  (BS) ',XMSG
       	DB      'CNTRL-I  (HT) ',XMSG
       	DB      'CNTRL-J  (LF) ',XMSG
       	DB      'CNTRL-K  (VT) ',XMSG
       	DB      'CNTRL-L  (FF) ',XMSG
       	DB      'CNTRL-M  (CR) ',XMSG
       	DB      'CNTRL-N  (SO) ',XMSG
       	DB      'CNTRL-O  (SI) ',XMSG
       	DB      'CNTRL-P  (DLE)',XMSG
       	DB      'CNTRL-Q  (DC1)',XMSG
       	DB      'CNTRL-R  (DC2)',XMSG
       	DB      'CNTRL-S  (DC3)',XMSG
       	DB      'CNTRL-T  (DC4)',XMSG
       	DB      'CNTRL-U  (NAK)',XMSG
       	DB      'CNTRL-V  (SYN)',XMSG
       	DB      'CNTRL-W  (ETB)',XMSG
       	DB      'CNTRL-X  (CAN)',XMSG
       	DB      'CNTRL-Y  (EM) ',XMSG
       	DB      'CNTRL-Z  (SUB)',XMSG
       	DB      'CNTRL-[  (ESC)',XMSG
       	DB      'CNTRL-\  (FS) ',XMSG
       	DB      'CNTRL-]  (GS) ',XMSG
       	DB      'CNTRL-^  (RS) ',XMSG
       	DB      'CNTRL-_  (US) ',XMSG
       	DB      'SPACE    (SPC)',XMSG
TLAST  	DB      'RUBOUT   (DEL)',XMSG



;    ******************************************************
;    ******************************************************



;                           ********
;                           MESSAGES:
;                           ********



HELLO	DB	LF,'HEX-TO-ASCII TRANSLATOR',CR,LF,LF,XMSG


MSG1	DB	'      => ',XMSG

MSG2	DB	' = ',XMSG


BYE	DB	'0D = CNTRL-M  (CR)'
	DB	CR,LF,LF,'          *** EXIT ***',CR,LF,XMSG



;    ******************************************************
;    ******************************************************



;                         ***********
;                         SUBROUTINES:
;                         ***********



;                     CP/M  CHARACTER  I/O:
;                     ----  ---------  ---


QUIT	LXI	D,BYE
	CALL	PRINF
	MVI	C,BOOT
	JMP	BDOS

FETCH	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,INP
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET

GETCH	PUSH	B
	PUSH	D
	PUSH	H

GETC1	MVI	C,DINP
	MVI	E,0FFH
	CALL	BDOS
	CPI	0
	JZ	GETC1

	POP	H
	POP	D
	POP	B
	RET

UPCAS   CPI	'a'
	RM
	CPI	'z'+1
	RP
	ANI	0DFH
        RET

LOCAS   CPI	'A'
	RM
	CPI	'Z'+1
	RP
	ORI	20H
        RET

PUTCH	
ECHO    CALL	RSAVE
	MOV	E,A
	MVI	C,OUTP
	CALL	BDOS
	CALL	RREST
	RET

PRINT	CALL	RSAVE
	MOV	E,A
	MVI	C,LIST
	CALL	BDOS
	CALL	RREST
	RET
 
PRINF	CALL	RSAVE
	MVI	C,PRSTR
	CALL	BDOS
	CALL	RREST
	RET

RSAVE	XTHL
	PUSH	A
	PUSH	B
	PUSH	D
	PUSH	H
	RET

RREST	POP	H
	POP	D
	POP	B
	POP	A
	XTHL
	RET


;                  SCREEN / PRINTER  UTILITY:
;                  ------   -------  -------


CRLF	MVI	A,CR
	CALL	PUTCH
	MVI	A,LF
	CALL	PUTCH
	RET

CRET	MVI	A,CR
	CALL	PUTCH
	RET

LFEED	MVI	A,LF
	CALL	PUTCH
	RET

BKSPC	MVI	A,BS
	CALL	PUTCH
	MVI	A,SPACE
	CALL	PUTCH
	MVI	A,BS
	CALL	PUTCH
	RET

QUIZ	MVI	A,HUH
	CALL	PUTCH
	RET

BEEP	MVI	A,BEL
	CALL	PUTCH
	RET

SPC1	MVI	A,SPACE
	CALL	PUTCH
	RET

SPC3	MVI	B,3
	CALL	SSPC
	RET

SPC5	MVI	B,5
	CALL	SSPC
	RET

SPC10	MVI	B,10
	CALL	SSPC
	RET

SSPC	CALL	PUTCH
	DCR	B
	JNZ	SSPC
	RET

WAIT1	PUSH	A			;	1-SECOND DELAY
	PUSH	B
	PUSH	H
	MVI	A,ZERO
	MVI	B,3
	LXI	H,ZERO

WTA	DCX	H
	CMP	H
	JNZ	WTA

WTB	CMP	L
	JNZ	WTA

	DCR	B
	JNZ	WTA
	POP	H
	POP	B
	POP	A
	RET

CASE	XTHL				;	GENERALIZED CASE
	MOV	B,A			;	     SWITCH
	MVI	C,1

CAS1	MOV	A,M			;	SEE "ASCII.ASM"
	CPI	XCASE			;	FOR DETAILS OF
	JZ	CAS4			;	     USAGE
	CMP	B
	JZ	CAS2
	INX	H
	INR	C
	JMP	CAS1

CAS2	MVI	A,0

CAS3	INX	H
	CMP	M
	JNZ	CAS3

CAS4	INX	H
	MOV	A,B
	XTHL
	RET


;                     HEXADECIMAL UTILITY:
;                     ----------- -------


HRCHK	CPI	'0'
	JM	HRCH1
	CPI	'9'+1
	JM	HRCH2
	CPI	'A'
	JM	HRCH1
	CPI	'F'+1
	JM	HRCH2

HRCH1	STC
	CMC
	RET

HRCH2	STC
	RET

HEX	CPI	'9'+1
	JM	HEX1
	SUI	7

HEX1	ANI	0FH
	RET



;    ******************************************************
;    ******************************************************



;                             ***
;                             RAM:
;                             ***



RAM	ORG	(($ AND 0FFF0H)+10H)


HDIG	DS	1

LDIG	DS	1

ASCII	DS	1



;   ******************************************************
;   ******************************************************



;                             *****
;                             STACK:
;                             *****



	ORG	(($ AND 0FFF0H)+10H)


	DS	STACK-1

SPNTR
LAST	DS	1



;    ******************************************************
;    ******************************************************



;                         ***********
;                           ASSEMBLY
;                         TERMINATION:
;                         ***********



PSIZE	EQU	LAST-ENTRY



;    ******************************************************
;    ******************************************************
;    ******************************************************



	END	ENTRY


