/*					*/
/*	Swappable tcb definition	*/
/*					*/
/*	One for each user		*/
/*	Contains the system per user	*/
/*	stack.				*/
/*					*/
/*					*/
/*	Structure of swappable tcb	*/
/*					*/
struct	user	{
	short	u_uid;		/* effectiv user id */
	short	u_gid;		/* Effectiv group id */
	short	u_ruid;		/* real user id		*/
	short	u_rgid;		/* Real group id	*/
	char	u_mxpri;	/* Max priority */
	char	u_mipri;	/* Minimum priority */
	short	u_cmask;	/* Mask for file creation */
	int	*u_ar0;		/* Pointer to saved R0 */
	char	u_sep;		/* Separate I and D flag */
	int	*u_ap;		/* Pointer to argument list */
	laddr_t	u_signal[NSIG];	/* Dispositions of signals */
	time_t	u_utime;	/* This process user time */
	time_t	u_stime;	/* This process system time */
	time_t	u_cutime;	/* Sum of child's utimes */
	time_t	u_cstime;	/* Sum of child's stimes */
	label_t	u_rsav;		/* Register save area on process switch */
	label_t	u_qsav;		/* Register save area */
	label_t	u_ssav;		/* Register save area */
	struct {
		short	*pr_base;	/* Buffer base */
		unsigned pr_size;	/* Buffer size */
		unsigned pr_off;	/* Pc offset */
		unsigned pr_scale;	/* Scale */
	} u_prof;
	dev_t	u_ttyd;		/* Controlling tty device */
	int	u_rval2;		/* Second returned value */
	char	u_error;		/* Error codes from some drivers */
	short	u_arglu;	/* Lu of argument file if used */
};

#define u (*((struct user *) UBASE))
