/*
 * Structure of the system-file
 * This is a read-only structure for some vital volume parameters
 * All numerical values are 32-bit
 * stored MSByte ... LSByte.
 * Last byte is an overall checksum computed as
 * the sum of all bytes modulo 256 and negated.
 */
struct sysfile {
	char	s_fhnd[16];	/* Filehandler spec */
	daddr_t	s_bmadr;	/* Bitmap pointer */
	daddr_t	s_inadr;	/* Inode list pointer */
	daddr_t	s_rtadr;	/* Root file pointer */
	daddr_t	s_swadr;	/* Swap area */
	daddr_t	s_vlsiz;	/* Volume size */
	daddr_t	s_bmsiz;	/* Bitmap size */
	daddr_t	s_swsiz;	/* Swap area size */
	daddr_t	s_bksiz;	/* Block size */
	daddr_t	s_disiz;	/* Size of a directory entry */
	daddr_t	s_insiz;	/* Default size of inode list */
	time_t	s_time;		/* Time initiated */
	char	s_fname[8];	/* Filsys name */
	char	s_fpack[8];	/* Filsys pack name */
	daddr_t	s_[44];		/* Reserved */
	char	s_c[3];		/* Reserved */
	char	s_chksum;	/* Check sum of all bytes */
};
