/*
 *	Copyright 1985 Dataindustrier AB
 *
 *	Shared memory structures
 */

struct shmid_ds {
	struct ipc_perm	shm_perm;	/* permissions */
	int		shm_segsz;	/* segment size */
	ushort		shm_lpid;	/* pid of last shmop */
	ushort		shm_cpid;	/* pid of creator */
	ushort		shm_nattch;	/* current # attached */
	time_t		shm_atime;	/* last shmat time */
	time_t		shm_dtime;	/* last shmdt time */
	time_t		shm_ctime;	/* last change time */
};

#define SHMLBA		0x8000	/* segment low boundary address multiple */

#define SHM_RDONLY	0x01	/* attach read-only (else read-write) */
#define SHM_RND		0x02	/* round attach address to SHMLBA */

#define SHM_LOCK	0x01	/* Lock segment */
#define SHM_UNLOCK	0x02	/* Unlock segment */
