/*
 *	84/10/29 Copyright (c) Dataindustrier DIAB AB, 1984
 */

/*
 *	Structure written on accounting file
 */

typedef	ushort	comp_t;		/* Floating point - 13bit frac., 3bit exp */

#define AFORK	01		/* Has executed fork, but no exec */
#define ASU	02		/* Used super-user privileges */
#define ACCTF	0300		/* Record type: 00 = acct */

struct acct {
	char	ac_flag;	/* Accounting flag */
	char	ac_stat;	/* Exit status */
	ushort	ac_uid;		/* Accounting user id */
	ushort	ac_gid;		/* Accounting group id */
	dev_t	ac_tty;		/* Control typewriter */
	time_t	ac_btime;	/* Beginning time */
	comp_t	ac_utime;	/* User time in clock ticks */
	comp_t	ac_stime;	/* System time in clock ticks */
	comp_t	ac_etime;	/* elapsed time in clock ticks */
	comp_t	ac_mem;		/* Memory usage */
	comp_t	ac_io;		/* Chars transferred */
	comp_t	ac_rw;		/* Blocks read or written */
	char	ac_comm[8];	/* Command name */
};
