/* 
 * X25 and related equ:s
 */

/* Unumbered commands	*/

#define	X25_MUI		0xc3	/* Mode independent unumbered information */
#define	X25_SABM	0x2f	/* Set ansyncronous balanced mode */
#define	X25_DISC	0x43	/* Disconnect command	*/
#define	X25_XID		0xaf	/* Exchange information	*/

/* Unumbered responses	*/

#define	X25_UA		0x63	/* Unumbered acknowledgement	*/
#define	X25_DM		0x0f	/* Disconnected mode	*/
#define	X25_FRMR	0x87	/* Frame reject	*/
/* 	X25_XID		0xaf	   Exchange id (same as command with same na */

/* Flow control	*/

#define	X25_RR		1	/* Receiver ready	*/
#define	X25_RNR		5	/* Receiver not ready	*/
#define	X25_REJ		9	/* Reject	*/

/* Poll and final bit	*/

#define	X25_POLL	0x10	/* Poll bit in command frames	*/
#define	X25_FINAL	0x10	/* Final bit in response frames */

/* Definition of MUI frames	*/

#define	MUC_BOOT	1	/* Boot code follows	*/
#define	MUC_BEXT	2	/* Please boot from other source	*/
#define	MUC_BERR	3	/* Boot error report	*/
#define	MUC_BREQ	4	/* Requesting boot record	*/
#define	MUC_NUM		5	/* Card number info	*/
#define	MUC_ABC		6	/* Start using ABC-net simplified protocol */

/* Frame reject bits	*/
#define	FRMR_W		1	/* Control field illegal or not implemented */
#define	FRMR_X		2	/* Data is illegal with this control field */
#define FRMR_Y		4	/* Data is too long for this station */
#define FRMR_Z		8	/* Illegal N(r) received	*/

/* Level 3 messages	*/
#define	X25_CARQ	0x0b	/* Call request	*/
#define	X25_CACO	0x0f	/* Call confirm	*/
#define	X25_CLRQ	0x13	/* Clear request	*/
#define	X25_CLCO	0x17	/* Clear confirm	*/

#define	X25_INRQ	0x23	/* Interrupt request	*/
#define	X25_INCO	0x27	/* Interrupt confirmation	*/

/* Clearing causes	*/
#define	CLC_RPER	0x11	/* Remote procedure error	*/
#define	CLC_LPER	0x13	/* Local procedure error	*/
#define	CLC_NCOG	0x05	/* Network congestion	*/
#define	CLC_NOBT	0x0d	/* Not obtainable	*/
#define	CLC_OORD	0x09	/* Out of order	*/
