/*
 *	(C) Copyright Dataindustrier DIAB AB, 1985
 */
/*
 * Structure returned by pstat
 */
#define	PS_SPARSZ	80	/* Size of array holding start parameters */


struct	pstasd			/* Info for each asd */
{
	laddr_t		pasd_ad;	/* Memory address */
	unsigned long	pasd_sz;	/* Size */
	short		pasd_ac;	/* Access count */
	short		pasd_lc;	/* Lock count */
	short		pasd_fl;	/* Flags */
};

/* Definition of flag field - equal to asd-node structure flags! */
#define PS_ACONT	1	/* Cont. memory */
#define PS_ASWPED	2	/* Asd is swapped */
#define PS_ASWOUT	4	/* Asd is about to be swapped out */
#define PS_AUPURE	0x10	/* Undefine pure */
#define PS_APLD		0x20	/* Loading pure */
#define PS_AWPROT	0x40	/* Memory is write protected, pure */

/*eject*/
struct	psinfo
{
	short	ps_state;	/* Tcb state */
	short	ps_flags;	/* Tcb flags */
	short	ps_dpri;	/* Dynamic priority */
	short	ps_slct;	/* Timeslice downcount */
	dev_t	ps_ttyd;	/* Controlling tty device */

	short	ps_uid;		/* Effective user id */
	short	ps_pgrp;	/* Process group */
	short	ps_pid;		/* Process id */
	short	ps_ppid;	/* Parent process id */

	short	ps_acltm;	/* Alarm clock time */
	time_t	ps_utime;	/* u - time */
	time_t	ps_stime;	/* s - time */
	time_t	ps_swtim;	/* sw - time */

	struct pstasd	ps_puasd;	/* Memory info for pure segment */
	struct pstasd	ps_imasd;	/* Memory info for impure segment */
	struct pstasd	ps_stasd;	/* Memory info for stack segment */
	struct pstasd	ps_swasd;	/* Memory info for U-page segment */

	char	ps_spar[PS_SPARSZ];	/* Start parameters */

};
/*eject*/
/* Definition of ps_state */
#define PS_SSLEEP	1	/* Waiting */
#define PS_SRUN		3	/* Running or runnable */
#define PS_SSZOMB	5	/* Almost dead */
#define PS_SSTOP	6	/* Stopped */

/* Definition of ps_flags */
#define PS_FLOCK	0x02	/* Locked in core */
#define PS_FSTRC	0x10	/* Process is being traced */
#define PS_FSWTED	0x20	/* A trace flag ??? */
#define PS_FBOOT	0x40	/* Process was booted up */
#define PS_FWSIG	0x80	/* Woke from a signal */
#define PS_FSWOUT	0x100	/* Process is about to be swapped out */
#define PS_FSWPED	0x200	/* Process is swapped */
#define PS_FSWIN	0x400	/* Process wants to be swapped back */
