/*
 *	Structures and definitions for DataBoard routines
 *
 *	(C) Copyright Dataindustrier DIAB AB
 */

struct DBpaddr {
	unsigned char *DBpa_inp;	/* Address for inp */
	unsigned char *DBpa_stat;	/* Address for stat */
	unsigned char *DBpa_opstat;	/* Address for opstat */
	unsigned char *DBpa_out;	/* Address for out */
	unsigned char *DBpa_C1;		/* Address for C1 */
	unsigned char *DBpa_C2;		/* Address for C2 */
	unsigned char *DBpa_C3;		/* Address for C3 */
	unsigned char *DBpa_C4;		/* Address for C4 */
};

/*
 *	Instructions for General DataBoard Interupt Driver
 */
#define	DBI_INP		8
#define	DBI_STAT	9
#define	DBI_OPSTAT	10
#define	DBI_OUT		16
#define	DBI_CS		17
#define	DBI_C1		18
#define	DBI_C2		19
#define	DBI_C3		20
#define	DBI_C4		21
#define	DBI_WI		15

#define	DB_INP(dbp)	((int)(*((dbp)->DBpa_inp)))
#define	DB_STAT(dbp)	((int)(*((dbp)->DBpa_stat)))
#define	DB_OPSTAT(dbp)	((int)(*((dbp)->DBpa_opstat)))
#define	DB_OUT(dbp,value) (*((dbp)->DBpa_out) = (value))
#define	DB_C1(dbp,value)  (*((dbp)->DBpa_C1) = (value))
#define	DB_C2(dbp,value)  (*((dbp)->DBpa_C2) = (value))
#define	DB_C3(dbp,value)  (*((dbp)->DBpa_C3) = (value))
#define	DB_C4(dbp,value)  (*((dbp)->DBpa_C4) = (value))

