#include <stdio.h>
#include <math.h>
#include <setjmp.h>

#ifdef MAINPROG
#define COMMON
#else
#define COMMON	extern
#endif

/* Machine dependent defs */

typedef int		INTEGER;	/* int */
typedef int		*jmpbp;		/* pointer to jmp_buf */
#define LDerr		errenvp=errenv;/* ok if jmp_buf is an array */
#define PI		M_PI
#define FTOI(a)		(((tmpf=(a))<0. ? (INTEGER)(tmpf-0.5):(INTEGER)(tmpf+0.5)))
/* Kill warnings */
#define KILLW		if(1)

/* End of machine dep. */

typedef struct {		/* string structure */
	char	*saddr;		/* pointer to address */
	long	len;		/* current length */
	long	maxlen;		/* maxlength */
	short	tempfl;		/* true if tempstr */
	} *STRING, STRINGS;
typedef struct {		/* static part of array */
	long	alloc;		/* allocated space */
	char	*aaddr;		/* address of array space */
	char	subs;		/* no of subscripts */
	char	type;		/* size of atoms */
	} spart;
typedef struct {		/* dynamic part of array */
	long	lowb;		/* lower bound */
	long	ssize;		/* no of elements in this subscript */
	long	esize;		/* size of elements in this subscript */
	} dpart;

#define defAR(a,b) struct { spart sp; dpart dp[b]; } a={{0,0,b,0}}
#define defARC(a,b) struct { spart sp; dpart dp[b]; } a
#define STRDEF(a,as,at,n) char at[n]; STRINGS as; STRING a=(as.saddr=at,as.len=0,as.maxlen=n,as.tempfl=0,&as)
#define SARG(x,xl) int xl = (ttempfl=x->tempfl,x->tempfl=0,ttempfl)
#define SDEL(x,xl) if (xl) { x->tempfl=xl; freetmp(x); }

#define PDSL		80
#define PUSH_ENV	(gsp<gspmax)?gsp++:moresp(&gbase,&gsp,&gspmax)
#define POP_ENV		(gsp>gbase) ? --gsp : (rterror(139),gsp)
#define INITMAIN	pinfo.pchannel=0; errenvp=NULL; rstruct.readptr=NULL; ERRCODE=0; resflg=0; if (fltsize && fltsize!=sizeof(FLOAT)) rterror(211);line=0;tracech= -1;if (setjmp(mainenv)) return(tmpi);
#define INITPROC	if (setjmp(PUSH_ENV)) goto endproc;lstenvp=errenvp;errenvp=NULL; pinfo.pchannel=0;
#define PDCL		struct{STRING ustr;int upos;int pchannel;} pinfo
#define jmpdcl		jmpbp lstenvp; jmp_buf errenv,resenv
#define LOCVAR		PDCL; jmpdcl; LNDCL;
#define MAIN		main(argc,argv) int argc;char *argv[]; { bmain(argc,argv);}
#define MAINEND		KILLW return(-1); }
#define BEGIN		{
#define FNEXIT		rterror(145); endproc:
#define PROCEXIT	endproc:
#define FNEND		LNEND;errenvp=lstenvp;return retval;}
#define PROCEND		errenvp=lstenvp;return;}
#define DATABEGIN	static char *DATA[] = {
#define DATAEND		NULL };
#define CHAINLIST	struct { char *name; int (*proc)(); } chainl[] = {
#define CHAINEND	NULL,NULL };
#define CHAINS_TO	int
#define FCLR(x)		x=0.
#define ICLR(x)		x=0
#define SCLR(x)		if(x.saddr!=NULL){free(x.saddr);x.saddr=NULL;x.len=0;}
#define ACLR(x)		if(x.sp.aaddr!=NULL){free(x.sp.aaddr);x.sp.aaddr=NULL;}
#define LINE(n)		line=n; DOTRACE

#ifdef LINENO
#define LNDCL		int lastline = line
#define LNEND		line = lastline
#else
#define LNDCL
#define LNEND
#endif

#define DOTRACE		if (tracech != -1) { PRINT; PCHAN(tracech);PINT(line);PSEMI;}
#define TRACE(ch)	tracech = ch
#define NOTRACE		tracech = -1
#define GOTO(l)		KILLW goto l
#define GOSUB(l)	if (!setjmp(PUSH_ENV)) goto l
#define RETURN		longjmp(POP_ENV,1)
#define RETURNX(a)	retval = a; RETURN
#define RETURNSX(a)	retval = SCPY(a); RETURN
#define ON_ERROR(l)	if(!ERRFLG)resflg=0;if(setjmp(errenv)){resflg=1;goto l;}else LDerr
#define ON_ERR1		if(!ERRFLG)resflg=0;if (resflg) rterror(ERRCODE); else errenvp=NULL
#define RESUME(l)	if (resflg){resflg=0;resok=0;goto l;} else rterror(151)
#define RESUME1		if (resok) longjmp(resenv); else rterror(151)
#define RESBEG		setjmp(resenv); resok=1
#define RESEND		resok = 0;
#define ON(e)		switch(e){
#define ON_END		default:rterror(138);}
#define ON_GOTO(v,l)	case v: GOTO(l);break
#define ON_GOSUB(v,l)	case v: GOSUB(l);break
#define ON_RESTORE(v,l)	case v: RESTORE(l);break
#define ON_RESUME(v,l)	case v: RESUME(l);break
#define END		tmpi= -1; longjmp(mainenv,1)
#define STOP		if(line)fprintf(stderr,"Stop in line %d\n",line);else fprintf(stderr,"Stop\n"); bclosall(); bexit(0)
#define BYE		bclosall(); bexit(0)
#define FORI(v,a,t)	{INTEGER lim;for(a,lim=(t);v<=lim;v++){
#define FORF(v,a,t)	{FLOAT lim;for(a,lim=(t);v<=lim;v++){
#define FORIS(v,a,t,s)	{INTEGER lim,step;for(a,lim=(t),step=s;step>0?v<=lim:v>=lim;v+=step){
#define FORFS(v,a,t,s)	{FLOAT lim,step;for(a,lim=(t),step=s;step>0.?v<=lim:v>=lim;v+=step){
#define NEXT		;}}
#define WHILE(e)	while(e){
#define WEND		;}
#define IF		if(
#define THEN		){
#define ELIF		;} else if(
#define ELSE		;} else {
#define IFEND		;}
#define IF_NOT		if(!(
#define THEN_GOTO(l)	)) goto l
#define REPEAT		do {
#define UNTIL(e)	;} while(!(e));
#define CHAIN(s)	tmpi=chainb(s); longjmp(mainenv,1)
#define	PRINT		pinfo.ustr=NULL;pinfo.upos=0;pinfo.pchannel=0
#define	PCHAN(p)	pinfo.pchannel=p
#define	USING(u)	pinfo.ustr=SADD(u,CHR(1,0))
#define PINT(e)		pi(&pinfo,e)
#define PFLT(e)		pf(&pinfo,e)
#define PSTR(e)		ps(&pinfo,e)
#define PCOM		bcomma(pinfo.pchannel,(sizeof(FLOAT)==sizeof(double)))
#define PEND		bnl(pinfo.pchannel); SFREE(pinfo.ustr); bflush(pinfo.pchannel)
#define PSEMI		SFREE(pinfo.ustr); bflush(pinfo.pchannel)
#define ISEMI		ICHK(0)
#define IEND		ICHK(1)
#define TAB(x)		(btab(pinfo.pchannel,x),stmp("",0))
#define CUR(y,x)	(bcur(pinfo.pchannel,y,x),stmp("",0))
#define CLS		(bcls(pinfo.pchannel),stmp("",0))
#define SCNST(s,n)	stmp(s,n)
#define	SPACE(n)	STRINGF(n,32)
#define	ABS(x)		(((tmpf=(x))<0)?-(tmpf):(tmpf))
#define	ATN(x)		atan(x)
#define COS(x)		cos(x)
#define EXP(x)		exp(x)
#define FIX(x)		(((tmpf=(x))<0.)?ceil(tmpf):floor(tmpf))
#define	LOG(x)		log(x)
#define LOG10(x)	log10(x)
#define MOD(a,b)	((a)%(b))
#define SGN(x)		(((tmpf=(x))<0.)?-1:((tmpf)==0)?0:1)
#define SIN(x)		sin(x)
#define SQR(x)		sqrt(x)
#define SWAP(i)		(((tmpi=(i))<<8 & 0xff00) + ((tmpi)>>8 & 0xff))
#define SWAP2(i)	(((tmpi=(i))<<16 & 0xffff0000) + ((tmpi)>>16 & 0xffff))
#define TAN(x)		tan(x)
#define ADD(a,b,p)	asccom(1,a,b,p)
#define SUB(a,b,p)	asccom(2,a,b,p)
#define MUL(a,b,p)	asccom(3,a,b,p)
#define DIV(a,b,p)	asccom(4,a,b,p)
#define POKE(a,d)	(*(char *)(a) = (char)(d))
#define PEEK(a)		(*(char *)(a))
#define	PEEK2(a)	(*(short *)(a))
#define PEEK4(a)	(*(long *)(a))
#define RANDOMIZE	randomize()
#define DIGITS(n)	y_digits = n
#define OPTION_BASE(n)	DLB = n
#define OPTION_EUROPE(n) OP_EUR = n
#define SHORT_INT	INT_FL = 2
#define LONG_INT	INT_FL = 4
#define SLEEP(x)	sleep(x)
#define	VARPTR(x)	((INTEGER)(x))
#define VARPTRS(x)	((INTEGER)((x)->saddr))
#define VAROOT(x)	((INTEGER)(x))
#define TIME		btime()
#define ARGC		argcb()

/* Opt. macros */
#define	AMF(a,i)  ((FLOAT *)(a.sp.aaddr+(i-a.dp[0].lowb)*sizeof(FLOAT)))
#define	AMI(a,i)  ((INTEGER *)(a.sp.aaddr+(i-a.dp[0].lowb)*sizeof(INTEGER)))
#define	AMS(a,i)  ((STRINGS *)(a.sp.aaddr+(i-a.dp[0].lowb)*sizeof(STRINGS)))

#define ITOF(a)		(FLOAT)(a)
#define OR(a,b)		((a)|(b))
#define XOR(a,b)	((a)^(b))
#define AND(a,b)	((a)&(b))
#define EQ(a,b)		(-((a)==(b)))
#define NE(a,b)		(-((a)!=(b)))
#define LT(a,b)		(-((a)<(b)))
#define GE(a,b)		(-((a)>=(b)))
#define GT(a,b)		(-((a)>(b)))
#define LE(a,b)		(-((a)<=(b)))
#define NEG(a)		(-(a))
#define NOT(a)		(~(a))
#define EQV(a,b)	NOT(XOR(a,b))
#define IMP(a,b)	OR(NOT(a),b)

/* Resumable io-statements */
/* If RESUME1 wanted: use RESBEG & RESEND around IOE & IO */
#define	IOE(cmd)	if((ioerr=cmd)!=0) rterror(ioerr)
#define IO(cmd)		cmd
#define OPEN(n,c,m)	IO(openb(c,n,m));
#define PREPARE(n,c,m)	IO(creatb(c,n,m));
#define CLOSE(c)	bclose(c)
#define CLOSEALL	bclosall()
#define GET(c,s,n)	IO(getb(c,s,n))
#define PUT(c,s)	IO(putb(c,s))
#define POSITS(c,n)	IOE(bsposit(c,(long)n))
#define LOCK(c,n)	IOE(bflock(c,n))
#define UNLOCK(c)	IOE(bfulock(c))
#define FIND(c,s,n)	IO(findb(c,s,n))

#define ISAM_KEY	0
#define ISAM_FIRST	1
#define ISAM_LAST	2
#define ISAM_NEXT	3
#define ISAM_PREV	4
#define INKEY		(((ioerr=binkey())<0)?SCNST("",0):CHR(1,ioerr))
#define ESCS		CHR(1,besc())
#define SYNS		CHR(1,bsym())
#define CRT(a)		pinfo.pchannel=0;SFREE(a)
#define CURUP		(bcrt(pinfo.pchannel,0270),SCNST("",0))
#define CURDN		(bcrt(pinfo.pchannel,0271),SCNST("",0))
#define CURRT		(bcrt(pinfo.pchannel,0272),SCNST("",0))
#define HOM		(bcrt(pinfo.pchannel,0273),SCNST("",0))
#define CLE		(bcrt(pinfo.pchannel,0274),SCNST("",0))
#define CLL		(bcrt(pinfo.pchannel,0275),SCNST("",0))
#define IL		(bcrt(pinfo.pchannel,0276),SCNST("",0))
#define DL		(bcrt(pinfo.pchannel,0277),SCNST("",0))
#define REVON		(bcrt(pinfo.pchannel,0300),SCNST("",0))
#define REVOFF		(bcrt(pinfo.pchannel,0301),SCNST("",0))
#define UNDON		(bcrt(pinfo.pchannel,0302),SCNST("",0))
#define UNDOFF		(bcrt(pinfo.pchannel,0303),SCNST("",0))
#define HFON		(bcrt(pinfo.pchannel,0304),SCNST("",0))
#define HFOFF		(bcrt(pinfo.pchannel,0305),SCNST("",0))
#define CLS1		(bcrt(pinfo.pchannel,0306),SCNST("",0))
#define CURLT		(bcrt(pinfo.pchannel,0307),SCNST("",0))
#define CR		(bcrt(pinfo.pchannel,0310),SCNST("",0))
#define BEL		(bcrt(pinfo.pchannel,0311),SCNST("",0))
#define FGFILL		fgfill
#define FGLINE		fgline
#define FGPOINT		fgpoint
#define FGPAINT		fgpaint
#define FGCSEG		fgcseg

#define FREAD(x)	freadb(DATA,&rstruct,x)
#define IREAD(x)	ireadb(DATA,&rstruct,x)
#define SREAD(x)	sreadb(DATA,&rstruct,x)
#define RESTORE(x)	if ((x)<0) rterror(149); else { rstruct.readptr=DATA[rstruct.readrow=x];rstruct.readend=rstruct.readptr+strlen(rstruct.readptr);}
#define RESTORE1	RESTORE(0)

#define MIMF(x)		(tmpf=(x),&tmpf)
#define MIMI(x)		(tmpi=(x),&tmpi)
#define MIMS(x)		(x)
#define MIMGF		IOE(mfirstget())
#define MIMGN		IOE(mgetnext())
#define MIMWR		IOE(mwrite())
#define MIMUP		IOE(mupdate())
#define MIMUP1(c)	MIMWR1(c)
#define MIMDE(c)	IOE(mdelete(c))
#define MIMTR(c)	IOE(mtrans(c))
#define MIMCO(c)	IOE(mcommit(c))
#define MIMAB(c)	IOE(mabort(c))
#define MIMEN		IOE(mend())

STRING	SLD(),SADD(),SCPY(),stmp();
INTEGER	SEQ(),SNE(),SLT(),SGE(),SGT(),SLE();
FLOAT	*AF();
INTEGER	*AI(),ROOTAF(),ROOTAI(),ROOTAS();
STRING	AS();
STRING	CHR(),LEFT(),MID(),NUM(),RIGHT(),STRINGF(),asccom();
INTEGER	ASC(),INSTR(),LEN(),POW2(), COMP();
double	VAL(),RND(),POW1(),POW3(),INT(),POSIT(),CVSF();
INTEGER	INP(),SYS(),CVSI(),argcb();
STRING	ARGV(),CVIS(),CVFS(),timeb();
int	DIMSTR(),DIMF(),DIMI(),DIMS(),SLET();
char	*stralloc(), *strealloc();

#ifdef MAINPROG
#ifdef IGNC
	int	ctrlcfl = 0;
#else
	int	ctrlcfl = 1;
#endif
	INTEGER	DLB = 0;
	int	OP_EUR = 2;
	int	y_digits = 6;
	int	INT_FL = 4;
	int fltsize = sizeof(FLOAT);
	int strsize = sizeof(STRINGS);
	int intsize = sizeof(INTEGER);
#else
	extern INTEGER DLB;
	extern int OP_EUR, y_digits, INT_FL, fltsize, strsize;
	extern int intsize, ctrlcfl;
#endif

COMMON	jmp_buf	*gbase, *gsp;	/* GOSUB stack */
COMMON	jmp_buf *gspmax, *moresp();
COMMON	jmpbp	errenvp;
COMMON	int	resflg,resok;
COMMON	INTEGER ERRCODE;
COMMON	int	line;		/* current line no */

static int tracech;		/* Trace channel */
static int ioerr;
static INTEGER tmpi;
static FLOAT tmpf;
static int ttempfl;
static jmp_buf	mainenv;
static struct {
	char *readptr;	/* points to next READ string */
	char *readend;
	int   readrow;	/* points to current READ row */
} rstruct;
