/* fnkeys.h */

/*
 * Structure for loading / reading of user defined keyboard keys.
 */

struct fnkst {
    union {
        struct {
	    unsigned char fk_code;    /* keycode, usually > 0x80             */
	    unsigned char fk_len;     /* length of string                    */
	} fk_st;
	short fk_space;		      /* space left after loading (returned) */
    } u;
    unsigned char fk_str[60];	      /* the functionkey string              */
};


/*
 * Macros used to load and read the funktion key definitins.
 */

#define		PFNKLD		(('p' << 8) | 4)
#define		PFNKRD		(('p' << 8) | 5)

#define	pfnkld(fd, bp)	dnix(F_IOCR,fd,bp,sizeof(struct fnkst),PFNKLD,0,0,0)
#define	pfnkrd(fd, bp)	dnix(F_IOCR,fd,bp,sizeof(struct fnkst),PFNKRD,0,0,0)
