//---------------------------------------------------------------------------
//
//    DIGITAL hereby grants any authorized developer using the PATHWORKS SDK 
//    ("Developer"), a royalty-free, non-exclusive license to use any of 
//    DIGITAL's source code supplied with the PATHWORKS SDK to create binaries 
//    which the developer may then copy and merge with the developers software 
//    for distribution to its customers.  DIGITAL is not liable for any 
//    damages caused by any errors in the source code provided with the SDK.
//
//---------------------------------------------------------------------------

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#define WIN32_LEAN_AND_MEAN TRUE
    /* kick out conflicts between winsock.h & iocb.h */
    /* Could use #define _WINSOCKAPI_ instead.  */
#include <windows.h>
#include <winerror.h>  // WIN32 defined errors

#define IOCB_INCL_DN         /* include DECnet structures */
#include "iocb_32.h"

/*************************************************************************/

VOID dnp32(VOID) // validate 32-bit DNP IOCB interface
{
    DWORD rc;
    NIOCB iocb;
    char decnet_path[256];
    
    iocb.io_seal = IOCB_SEAL;
    iocb.io_fcode = PRU_LOCALINFO;
    iocb.io_flags = MSG_NIOCB | MSG_USRWAIT;
    iocb.io_callback = NULL;
    iocb.io_status = iocb.io_errno = iocb.io_socket = 0;
    iocb.io_psize = sizeof(LOCALINFO_DN);
    iocb.plcl.lcl_decnet_path = &decnet_path[0];
    
    if (rc = IocbSubmit(DECnet_API,&iocb,0))
    {
        printf("DECnet call failed at WIN32 level, error: %u\n",rc);
        return;
    }   
    if (iocb.io_status)
    {
        printf("DECnet LOCALINFO call failed at DECnet level.");
        if (iocb.io_status == IOCB_ERROR)
            printf("  Errno: %u\n",iocb.io_errno);
        else if (iocb.io_status == IOCB_PENDING)
            printf("  Call is Pending.\n");
    }
    else
    {
        printf("DECnet LOCALINFO:\n");
        printf("   DNP version: %u.%u.%u\n",iocb.plcl.lcl_version[0],
                iocb.plcl.lcl_version[1],iocb.plcl.lcl_version[2]);
        printf("   Node name: %s\n",&iocb.plcl.lcl_nodename[0]);
        printf("   Node address: %u.%u\n",
                iocb.plcl.lcl_nodeaddr / 1024,
                iocb.plcl.lcl_nodeaddr % 1024);
        printf("   Segment size: %u\n",iocb.plcl.lcl_segsize);
        printf("   Available sockets: %u\n",iocb.plcl.lcl_sockets);
        printf("   Database path: %s\n",&decnet_path[0]);
    }
}

/*************************************************************************/

VOID dscb32() // validate 32-bit DSCB interface into DNP
{
    DWORD rc, n, i, b;
    DSCB dscb;
    DSCB *dscbp;
    DSCB_REMOTE_NAME *dscbrp;
    
    dscb.dscb_cmd = DSCB_INSTCHK;
    dscb.dscb_err = dscb.dscb_index = 0;
    if (rc = DscbSubmit(DECnet_DSCB,&dscb))
        printf("DSCB Install Check Failed at WIN32 level, error: %u\n",rc);
    else if (dscb.dscb_err)
        printf("DSCB Install Check Failed at DSCB level, error: %u\n",
                dscb.dscb_err);
    else printf("DECnet DSCB Installed.\n");
    if (rc || dscb.dscb_err)
        return;
    dscb.dscb_cmd = DSCB_READREMSIZ;
    dscb.dscb_err = dscb.dscb_index = 0;
    if (rc = DscbSubmit(DECnet_DSCB,&dscb))
        printf("    Read # of Remote Names Failed at WIN32 level, error: %u\n"
                ,rc);
    else if (dscb.dscb_err)
        printf("    Read # of Remote Names Failed at DSCB level, error: %u\n",
                dscb.dscb_err);
    else if (dscb.dscb_index)
    {
        i = sizeof(DSCB) * dscb.dscb_index;
        dscbp = malloc(i);
        if (!dscbp)
            return;
        dscbp->dscb_cmd = DSCB_READALLREM;
        dscbp->dscb_err = dscbp->dscb_index = 0;
        dscbp->dscb_acc_len = (WORD) i;  
        if (rc = DscbSubmit(DECnet_DSCB,dscbp))
            printf("    Read All Remote Failed at WIN32 level, error: %u\n",rc);
        else if (dscbp->dscb_err)
            printf("    Read All Remote Failed at DSCB level, error: %u\n",
                    dscbp->dscb_err);
        else 
        {
            dscbrp = (DSCB_REMOTE_NAME *) &(dscbp->dscb_name[0]);    
            for (n = 1; n <= dscb.dscb_index; n++)
            {
                i = dscbrp->dscb_num[0];
                i += dscbrp->dscb_num[1] * 0x100;
                for (b = 15; dscbrp->dscb_name[b] == ' ' && b > 1; b--)
                    dscbrp->dscb_name[b] = 0;
                printf("    Remote Name: %s, Node Addr: %u.%u, DECnet Object: %u\n",
                    dscbrp->dscb_name,i / 1024,i % 1024,dscbrp->dscb_objtype);
                dscbrp += 1;
            }
        }
        free(dscbp);
    }
    else printf("   No entries in Remote Adapter Table.\n");
}
