/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  Socket definitions			File: SOCKET.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef SOCKET_H
#define SOCKET_H

#include <skdefs.h>
#include <sockdefs.h>

/*
 *  Utility macros
 */

extern void bzero(void *, int);
extern void bcopy(void *, void *, int);
extern int  bcmp(CONST void *, CONST void *, int);

struct sockaddr {
    unsigned short sa_family;       /* address family */
    char sa_data[14];               /* up to 14 bytes for general address use*/
};

#ifdef	PW3COM	/* Add some constants & structures */


/*
**  Only ioctl flags supported
*/

#define FIONREAD       0x0001
#define FIONBIO        0x0002


#define	MAXHOSTNAMELEN	17
#define	MAX_SOCKETS	64

struct linger {
    int l_onoff;
    int l_linger;
};

struct sockproto {
    unsigned short sp_family;       /* address family */
    unsigned short sp_protocol;     /* protocol */
};


/*
**   defines, types required for select()
*/

#define RM_OFFSET(n)  (n)
#define ADD_OFFSET(n) (n)
#define MASK_BYTES    ((MAX_SOCKETS / 8) + (MAX_SOCKETS % 8 == 0 ? 0 : 1))

#define FD_SET(n,p)  ((p)->mask[(RM_OFFSET(n))/8] |= (1 << (RM_OFFSET(n)) % 8))
#define FD_CLR(n,p)  ((p)->mask[(RM_OFFSET(n))/8] &= ~(1 << (RM_OFFSET(n)) % 8))
#define FD_ISSET(n,p) ((p)->mask[(RM_OFFSET(n))/8] & (1 << (RM_OFFSET(n)) % 8))
#define FD_ZERO(p)   memset( (char *)(p), (char) 0, sizeof( *(p) ) )

typedef struct { char mask[MASK_BYTES]; } fd_set;

#endif		/* PW3COM */


#ifndef	TIMEVAL_DEF
#define	TIMEVAL_DEF
/*
 * Standard system time value data structures.
 */
struct timeval 
{
	long	tv_sec;		/* seconds */
	long	tv_usec;	/* and microseconds */
};
#endif	/* TIMEVAL_DEF */
/*
 * Types
 */

#define SOCK_STREAM	    1		/* stream socket */
#define	SOCK_DGRAM	    2		/* datagram socket */
#define	SOCK_RAW	    3		/* raw-protocol interface */
#define	SOCK_RDM	    4		/* reliably-delivered message */
#define	SOCK_SEQPACKET	5		/* sequenced packet stream */

/*
 * Option flags per-socket.
 */

#define SO_DEBUG	    0x01		/* turn on debugging info recording */
#define	SO_ACCEPTCONN	0x02		/* socket has had listen() */
#define	SO_REUSEADDR	0x04		/* allow local address reuse */
#define	SO_KEEPALIVE	0x08		/* keep connections alive */
#define	SO_DONTROUTE	0x10		/* just use interface addresses */
#define SO_BROADCAST    0x20            /* Allow datagram broadcast */
#define	SO_USELOOPBACK	0x40		/* bypass hardware when possible */
#define SO_LINGER	    0x80		/* linger on close if data present */
#define SO_DONTLINGER	~SO_LINGER	/* don't linger on close if data */

					/* 0x20 was SO_NEWFDONCONN */
#ifdef	PW3COM	/* Add SO_TYPE */
	#define	SO_TYPE	0x20		/* What does this mean? */
#endif		/* PW3COM */


#define SO_RCVUSRBUF    0x0100      /* select ready on partial msg */

/* PROTO_TCP level options */
#define SO_NODELAY      0x01        /* nodelay ACK */

/*
 * Address families.
 */
#define	AF_UNSPEC	 0      /* unspecified  */
#define AF_INET		 2		/* TCP/IP       */
#define AF_OSI		 7		/* OSI          */
#define AF_DECnet	12		/* DECnet       */
#define AF_LAT		14		/* LAT          */
#define AF_MAX		 4

#define AF_OLDDECnet 1		// pre-WINSOCK value for AF_DECnet
#define AF_NSP       AF_OLDDECnet

/*
 *  Transport selectors
 */
#define TSEL_DECNET	0
#define TSEL_TCPIP	1
#define TSEL_OSI	2
#define TSEL_LAT	3

/* 
 * Protocol types.
 */
#define PF_RAW		1		/* DLX data */
#define PF_MOP		2		/* DLX MOP data */

#define PF_MAX		2

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define	SOL_SOCKET	0xffff		/* options for socket level */

/*
 * Maximum queue length specifiable by listen.
 */
#define	SOMAXCONN	5

#ifdef	PW3COM	/* add MSG_PUSH */
	/*
	 * Since our stack *always* does the equivalent of MSG_PUSH, we
	 * don't have a specific value for it.  So, we define the value to
	 * be zero.
	 */
	#define	MSG_PUSH	0x0000
#endif		/* PW3COM */     


#define	MSG_MAXIOVLEN	16

/*  *********************************************************************
    *  Function prototypes						*
    ********************************************************************* */

#if !defined(PW3COM) 	

    int accept(int,void *,int *);
    int bind(int,void *,int);
    int connect(int,void *,int);
    int getpeername(int,void *,int *);
    int getsockname(int,void *,int *);
    int getsockopt(int,int,int,void *,int *);
    int listen(int,int);
    int recv(int,void *,unsigned int,unsigned int);
    int sclose(int);
    int select(int,void *,void *,void *,void *);
    int send(int,void *,unsigned int,unsigned int);
    int setsockopt(int,int,int,void *,int);
    int shutdown(int,int);
    int sioctl(int,int,void *);
    int socket(int,int,int);
    int sread(int,void *,unsigned int);
    int swrite(int,void *,unsigned int);

    #ifdef IOCB_INCL_IN
        int sendto(int,void *,unsigned int,unsigned int,void *,unsigned int);
        int recvfrom(int,void *,unsigned int,unsigned int,void *,unsigned int *);
    #endif

#else		/* 3COM-style function prototypes */

#endif		/* PW3COM */

#endif	/* SOCKET_H */


