/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  Compiler definitions			File: SKDEFS.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef	SKDEFS_H
	#define	SKDEFS_H

/*  *********************************************************************
    *  These macros redefine certain compiler keywords so we can	*
    *  be more compatible with different compilers and models.		*
    ********************************************************************* */

    /* If none of the configuration #defines are set, assume DECnet */
    #if !defined(IOCB_INCL_LAT) && !defined(IOCB_INCL_DN) && !defined(IOCB_INCL_IN)
        #define IOCB_INCL_DN
    #endif

    /* If IOCB_INCL_ALL is defined, rename the plists and define them all */
    #if defined(IOCB_INCL_ALL)
        #define IOCB_INCL_LAT
        #define IOCB_INCL_DN
        #define IOCB_INCL_IN
    #endif

    #ifdef WIN32
        #ifndef WIN32_LEAN_AND_MEAN     // Required to exclude WINSOCK.H
            #define WIN32_LEAN_AND_MEAN
        #endif
        #define IOCB_32BITS
        #define PW_APIENTRY __stdcall
        #ifndef CONST
            #define CONST const
        #endif
        #ifndef PASCAL
            #define PASCAL  __stdcall
        #endif                   
        #ifndef	FAR
            #undef far
            #define far
            #define	FAR far
        #endif
        #define FHANDLE  int
    #else
        #define IOCB_16BITS
        #define IOCB_INCL_IN    
    	#ifndef NOREDEF
	    	#ifndef	CONST
                #ifdef  __HIGHC__
                    #define CONST
                #else
                    #define	CONST	const
                #endif
    		#endif
            #ifndef	FAR
                #ifdef	__HIGHC__
                    #define	FAR
                #else
                    #define FAR far
                #endif
            #endif
            #ifndef	PASCAL
                #ifdef	__HIGHC__
                    #define	PASCAL
                #else
                    #define	PASCAL pascal
                #endif

            #endif
            #define PW_APIENTRY       FAR PASCAL
            #define APIENTRY    short FAR PASCAL
            #define VOID void
        #endif
        #ifdef WINDOWS
            #define FHANDLE  HFILE
        #else
            #define FHANDLE  short
        #endif
	#endif

	#ifndef NULL
		#define NULL ((VOID FAR *) 0)
	#endif
    
    // RTL substitutes
    #define PW_STRLEN   ISktStrlen
    #define PW_STRCPY   ISktStrcpy
    #define PW_MEMCPY   ISktmemcpy
    #define PW_MEMSET   ISktmemset
    #define PW_MEMCMP   ISktmemcmp
    #define PW_STRCAT   ISktStrcat
    #define PW_STRNCPY  ISktStrncpy
    #define PW_STRICMP  ISktStricmp
    #define PW_STRCMP   ISktStrcmp
    #define PW_STRNICMP ISktStrnicmp
    #define PW_STRPBRK  ISktStrpbrk
#endif   // SKDEFS_H

#define	CHECK_NULL(ptr)	(ptr ? ptr : (void FAR *)0)
