/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  function prototypes			File: SKPROTO.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */


#ifndef SKPROTO_H
#define SKPROTO_H
#include <sktypes.h>
#include <skdefs.h>
#include <iocb.h>

/* Core Socket library functions */

APIENTRY SktInstallCheck(short);
APIENTRY SktSubmitIOCB(short,NIOCB FAR *);
APIENTRY SktGetTransport(unsigned short,short FAR *);
APIENTRY SktAccept(unsigned short,void FAR *, short FAR *,short FAR *);
APIENTRY SktBind(unsigned short, CONST void FAR *,unsigned short,short FAR *);
APIENTRY SktConnect(unsigned short,void FAR *,unsigned short,short FAR *);
APIENTRY SktGetPeerName(unsigned short,void FAR *, short FAR *,short FAR *);
APIENTRY SktGetSockName(unsigned short,void FAR *, short FAR *,short FAR *);
APIENTRY SktListen(unsigned short,unsigned short,short FAR *);
APIENTRY SktRecv(unsigned short,unsigned char FAR *,unsigned short,unsigned short,short FAR *);
APIENTRY SktSRead(unsigned short,unsigned char FAR *,unsigned short,short FAR *);
APIENTRY SktSClose(unsigned short,short FAR *);
APIENTRY SktSelect(unsigned short, unsigned char FAR *, unsigned char FAR *,
                    unsigned char FAR *, struct timeval FAR *, short FAR *);
APIENTRY SktSend(unsigned short,unsigned char FAR *,unsigned short,unsigned short,short FAR *);
APIENTRY SktSWrite(unsigned short,unsigned char FAR *,unsigned short,short FAR *);
APIENTRY SktSetSockOpt(unsigned short,unsigned short,unsigned short, CONST void FAR *,unsigned short,short FAR *);
APIENTRY SktGetSockOpt(unsigned short,unsigned short,unsigned short,void FAR *, short FAR *,short FAR *);
APIENTRY SktShutdown(unsigned short,unsigned short,short FAR *);
APIENTRY SktSIOCtl(unsigned short,unsigned short,void FAR *,short FAR *);
APIENTRY SktSocket(unsigned short,unsigned short,unsigned short,short FAR *);
#ifdef	__HIGHC__
	APIENTRY SktSetPollFunc(short, unsigned long);
#else
	APIENTRY SktSetPollFunc(short, short (FAR PASCAL *)(NIOCB FAR *));
#endif

APIENTRY SktSendto(unsigned short,
		unsigned char FAR *,
		unsigned short,
		unsigned short,
		unsigned char FAR *,
		unsigned short,
		short FAR *);
APIENTRY SktRecvfrom(	unsigned short,
				unsigned char FAR *,
				unsigned short,
				unsigned short,
				unsigned char FAR *,
				short FAR*,
				short FAR *);
APIENTRY Sktpwfunc(void FAR *, char FAR *, short FAR *);

/* DECnet library */
APIENTRY SktDnetErrConvert(unsigned short);
APIENTRY SktGetNodeName(char FAR *,short);
APIENTRY SktDnetGetAcc(struct dnet_accent FAR *, struct dnet_accent FAR FAR *);
APIENTRY SktDnetAddr(char FAR *, struct dn_naddr FAR *);
APIENTRY SktDnetGetAlias(char FAR *, char FAR *, short);
APIENTRY SktDnetConn(	char FAR *,
			char FAR *,
			short,
			unsigned char FAR *,
			short,
			unsigned char FAR *,
			short FAR *,
			unsigned short,
#ifdef	__HIGHC__
			unsigned long,
#else
			void (FAR PASCAL *)(void FAR *),
#endif
			short (FAR PASCAL *)(void FAR *, char FAR *, short FAR *),
			short FAR *);
APIENTRY SktDnetEOF(short);
APIENTRY SktDnetHtoA(struct dn_naddr FAR *, char FAR *, short);
APIENTRY SktDnetNtoA(struct dn_naddr FAR *, char FAR *, short);
APIENTRY SktDnetOtoA(struct sockaddr_dn FAR *, char FAR *, short);
APIENTRY SktDnetPath(char FAR *,char FAR *,short);

APIENTRY SktGetNodeByAddr(unsigned long FAR *, unsigned char FAR *, short,
		short, struct nodeent_f FAR *);
APIENTRY SktGetNodeByName(unsigned long FAR *, char FAR *, 
                struct nodeent_f FAR *);
APIENTRY SktGetNodeEnt(unsigned long FAR *, struct nodeent_f FAR *);
APIENTRY SktSetNodeEnt(unsigned long FAR *,short);
APIENTRY SktEndNodeEnt(unsigned long FAR *);
APIENTRY SktGetNodeAdd(struct dn_naddr FAR *);
APIENTRY SktGetNodeName(char FAR *,short);

APIENTRY SktDnetNError(short);
APIENTRY SktNError(short,char FAR *,char FAR *,short);

/* TCP/IP support library */

APIENTRY SktHtons(unsigned short ,unsigned short FAR *,short FAR *);
APIENTRY SktHtonl(unsigned long ,unsigned long FAR *,short FAR *);
APIENTRY SktNtohs(unsigned short ,unsigned short FAR *,short FAR *);
APIENTRY SktNtohl(unsigned long ,unsigned long FAR *,short FAR *);

APIENTRY SktInetMakeAddr(unsigned long FAR *,
			unsigned long FAR *,
			struct in_addr FAR *,
			short FAR *);
APIENTRY SktInetNtoA(struct in_addr FAR *, char FAR *, short FAR *);
APIENTRY SktInetAddr(CONST char FAR *, unsigned long FAR *, short FAR *);
APIENTRY SktInetNetwork(char FAR *,unsigned long FAR *,short FAR *);
APIENTRY SktInetLnaof(struct in_addr FAR *,unsigned long FAR *,short FAR *);
APIENTRY SktInetNetof(struct in_addr FAR *,unsigned long FAR *,short FAR *);

APIENTRY SktSetNetEnt(short ,short FAR *);
APIENTRY SktEndNetEnt(short FAR *);
APIENTRY SktGetNetEnt(struct netent FAR *,short FAR *);

APIENTRY SktSetProtoEnt(short,short FAR *);
APIENTRY SktEndProtoEnt(short FAR *);
APIENTRY SktGetProtoEnt(struct protoent FAR *,short FAR *);

APIENTRY SktSetServEnt(short ,short FAR *);
APIENTRY SktEndServEnt(short FAR *);
APIENTRY SktGetServEnt(struct servent FAR *,short FAR *);

APIENTRY SktSetHostEnt(short ,short FAR *);
APIENTRY SktEndHostEnt(short FAR *);
APIENTRY SktGetHostEnt(struct hostent FAR *,short FAR *);

APIENTRY SktGetHostByName(CONST char FAR *, struct hostent FAR *, short FAR *);
APIENTRY SktGetHostByAddr(CONST char FAR *, short , short , struct hostent FAR *, short FAR *);
APIENTRY SktGetServByName(CONST char FAR *, CONST char FAR *,struct servent FAR *, short FAR *);
APIENTRY SktGetServByPort(short , CONST char FAR *,struct servent FAR *, short FAR *);

APIENTRY SktGetHostName(char FAR *, short, short FAR *);
APIENTRY SktGetNetByName(char FAR *,struct netent FAR *,short FAR *);
APIENTRY SktGetNetByAddr(unsigned long,short,struct netent FAR *,short FAR *);
APIENTRY SktGetProtoByName(CONST char FAR *,struct protoent FAR *,short FAR *);
APIENTRY SktGetProtoByNumber(short,struct protoent FAR *,short FAR *);
APIENTRY SktGetLocalIPAddress(struct in_addr FAR *, short FAR *);
APIENTRY SktGetNetFiles(char FAR *, short, short FAR *);
APIENTRY SktGetUsername(char FAR *, short, short FAR *);

/* Internal routines.  Use at your own risk.
 *
 * *** NOTE TO APPLICATION DEVELOPERS: ***
 *
 * DO NOT EVER CALL ANY ROUTINE WHOSE NAME STARTS WITH "ISkt".
 * It is GUARANTEED that the "ISkt" interface will change over time.
 * It is NOT SUPPORTED.  Also, they are not tested as well as the
 * documented, supported routines.
 */
APIENTRY ISktStrlen(char FAR *);
APIENTRY ISktStrcat(char FAR *, char FAR *);
APIENTRY ISktStrncat(char FAR *, char FAR *, short);
APIENTRY ISktStrcpy(char FAR *, char FAR *);
APIENTRY ISktStrncpy(char FAR *, char FAR *, short);
APIENTRY ISktStrcmp(char FAR *, char FAR *);
APIENTRY ISktStricmp(char FAR *, char FAR *);
int FAR PASCAL ISktStrnicmp(char FAR *, char FAR *, unsigned int);
char FAR * FAR PASCAL ISktStrpbrk(char FAR *, char FAR *);

APIENTRY ISktItoA(unsigned short, char FAR *);
APIENTRY ISktAtoI(char FAR *);

APIENTRY ISktDnetCrypt(unsigned char FAR *, short);

APIENTRY ISktHOpen(char FAR *, short);
APIENTRY ISktHClose(short);
APIENTRY ISktHRead(short, void FAR *, short);
APIENTRY ISktHGets(char FAR *,short, short);
APIENTRY ISktHWrite(short, void FAR *, short);
APIENTRY ISktHSeek(short, long, short);

#if	!defined(PROT386)
short FAR * FAR PASCAL ISktDosGetVect(unsigned char);
#else
char _far * ISktDosGetVect(unsigned char);
#endif
APIENTRY ISktDosGetenv(char FAR *, char FAR *);
char FAR * FAR PASCAL ISktGetenv(char FAR *);
void FAR PASCAL ISktmemset(void FAR *, unsigned char, unsigned int);
void FAR PASCAL ISktmemcpy(void FAR *, const void FAR *, unsigned int);
int FAR PASCAL ISktmemcmp(const void FAR *, const void FAR *, unsigned int);

APIENTRY GetTcpipOpt(char FAR *,char FAR *,char FAR *);

APIENTRY ISktIOCBCall(unsigned short, NIOCB FAR *);

/*
 * Note: These routines are even less supported than the others.
 */
APIENTRY ISkttrans_famtable(short );
APIENTRY ISkttrans_typtable(short );
APIENTRY ISkttrans_protable(short );
APIENTRY ISkttrans_mpxtable(short );
APIENTRY ISktGetTransMap(short );
void FAR PASCAL ISktSetTransMap(short, short );
void FAR PASCAL ISktInitTransMap(void );
APIENTRY ISktFirstSockNum(void );
APIENTRY ISktGetRealModeVector(unsigned char, unsigned short FAR *, unsigned short FAR *);
APIENTRY srmi(unsigned char, unsigned short, unsigned short, unsigned short );
unsigned short FAR PASCAL ISktConvertToSelector(unsigned short, unsigned short);
APIENTRY  ISktGetNewNum(unsigned short , unsigned short, unsigned short, unsigned short, short FAR *);

#endif  
