//***********************************************************************
//*                                                                       
//*                    ****  COPYRIGHT NOTICE ****                        
//*                                                                       
//*  Copyright (c) Digital Equipment Corporation, 1993-1994
//*                                                                       
//*  All Rights Reserved.  Unpublished rights reserved under the          
//*  copyright laws of the United States.                                 
//*                                                                       
//*  The software contained on this media is proprietary to and           
//*  embodies the confidential technology of  Digital Equipment           
//*  Corporation.  Possession, use, duplication or dissemination          
//*  of the software and media is authorized only pursuant to a           
//*  valid written license from Digital Equipment Corporation.            
//*                                                                       
//*  RESTRICTED RIGHTS LEGEND   Use, duplication, or  disclosure          
//*  by the U.S. Government is subject to restrictions as set             
//*  forth in Subparagraph (c)(1)(ii) of DFARS 252.227-7013, or in        
//*  FAR 52.227-19, as applicable.                                        
//*                                                                       
//**********************************************************************

//**********************************************************************
//*                                                                      
//*   FACILITY:         PATHWORKS Network Management API                 
//*                                                                      
//*   ENVIRONMENT:      PATHWORKS for DOS and Windows V5.0               
//*                                                                      
//*   MODULE NAME:      NM_PROTO.H                                       
//*                                                                      
//*   DESCRIPTION:      Function prototypes for NMAPI
//*                                                                      
//*   MODIFICATION HISTORY:                                              
//*                                                                      
//*     22-Nov-1992 CLB     Created file                                 
//*     15-Dec-1992 CLB     Removed mask from GetNextNode and GetFirstNode 
//*     28-Dec-1992 CLB     Added NmGetEvent()                           
//*     13-apr-1993 CLB     int->short                                   
//*     16-aug-1993 CLB     NmResetNodeFile()
//*     07-jun-1994 CLB     removed static reference from NmHtoA and NmLtoA
//      15-jun-1994 CLB     Added context block for NmGetFirstAttr() and
//                          NmGetNextAttr()
//*                                                                      
//************************************************************************/

#ifndef NM_PROTO_H
#define NM_PROTO_H

#include <NM_API.H>

// Get DECnet line info 
short PW_APIENTRY NmGetLineInfo(unsigned short FAR *, unsigned short FAR *, 
    unsigned short FAR *);

// Entity routines 
short PW_APIENTRY NmGetEntity(void FAR *, char FAR *, unsigned short FAR *);
short PW_APIENTRY NmGetAttr(void FAR *, char FAR *);
short PW_APIENTRY NmGetEntString(void FAR *, unsigned char FAR *);
short PW_APIENTRY NmGetAttrString(void FAR *, unsigned char FAR *);
short PW_APIENTRY NmGetAttrValString(void FAR *, unsigned char FAR *);
short PW_APIENTRY NmGetNextAttr(void FAR *, char FAR *, void FAR *);
short PW_APIENTRY NmGetFirstAttr(void FAR *, char FAR *, void FAR *);
short PW_APIENTRY NmSetAttr(void FAR *);
short PW_APIENTRY NmOpenEntityFile(FHANDLE FAR *, short FAR *, unsigned short FAR *);
short PW_APIENTRY NmResetEntityFile(FHANDLE, short FAR *, unsigned short FAR *);
short PW_APIENTRY NmGetFirstEntity(FHANDLE, void FAR *, void FAR *, short FAR *);
short PW_APIENTRY NmGetNextEntity(FHANDLE, void FAR *, void FAR *, short FAR *);
short PW_APIENTRY NmCloseEntityFile(FHANDLE);
short PW_APIENTRY NmZeroCounters(unsigned short);

// Outgoing access routines 
short PW_APIENTRY NmSetAcc(void FAR *);
short PW_APIENTRY NmDelAcc(unsigned char FAR *);
short PW_APIENTRY NmGetAcc(void FAR *);
short PW_APIENTRY NmOpenAccFile(FHANDLE FAR *, short FAR *, short FAR *);
short PW_APIENTRY NmResetAccFile(FHANDLE, short FAR *, short FAR *);
short PW_APIENTRY NmGetFirstAcc(FHANDLE, void FAR *);
short PW_APIENTRY NmGetNextAcc(FHANDLE, void FAR *);
short PW_APIENTRY NmCloseAccFile(FHANDLE);

// Node routines
short PW_APIENTRY NmSetNode(void FAR *, void FAR *, void FAR *, void FAR *, void FAR *);
short PW_APIENTRY NmGetNode(void FAR *, void FAR *, void FAR *, void FAR *, void FAR *);
short PW_APIENTRY NmDelNode(unsigned char FAR *, void FAR *);
short PW_APIENTRY NmOpenNodeFile(FHANDLE FAR *, long FAR *);
short PW_APIENTRY NmResetNodeFile(FHANDLE, long FAR *);
short PW_APIENTRY NmGetFirstNode(FHANDLE, void FAR *, void FAR *, void FAR *, void FAR *, void FAR *);
short PW_APIENTRY NmGetNextNode(FHANDLE, void FAR *, void FAR *, void FAR *, void FAR *, void FAR *);
short PW_APIENTRY NmCloseNodeFile(FHANDLE);
short PW_APIENTRY NmGetRemoteNode(void FAR *, void FAR *, void FAR *, void FAR *);

// DECnet object routines 
short PW_APIENTRY NmSetObj(void FAR *);
short PW_APIENTRY NmDelObj(void FAR *);
short PW_APIENTRY NmGetObj(void FAR *);
short PW_APIENTRY NmOpenObjFile(FHANDLE FAR *, short FAR *);
short PW_APIENTRY NmResetObjFile(FHANDLE, short FAR *);
short PW_APIENTRY NmGetFirstObj(FHANDLE, void FAR *);
short PW_APIENTRY NmGetNextObj(FHANDLE, void FAR *);
short PW_APIENTRY NmCloseObjFile(FHANDLE);

// Remote adapter name routines 
short PW_APIENTRY NmSetRem(void FAR *);
short PW_APIENTRY NmDelRem(unsigned char FAR *);
short PW_APIENTRY NmGetRem(void FAR*);
short PW_APIENTRY NmOpenRemFile(FHANDLE FAR *, short FAR *);
short PW_APIENTRY NmResetRemFile(FHANDLE, short FAR *);
short PW_APIENTRY NmGetFirstRem(FHANDLE, void FAR *);
short PW_APIENTRY NmGetNextRem(FHANDLE, void FAR *);
short PW_APIENTRY NmCloseRemFile(FHANDLE);

// DECnet logical link routines 
short PW_APIENTRY NmGetLinkList(unsigned short FAR *, short FAR *);
short PW_APIENTRY NmGetLink(unsigned short, void FAR *);
short PW_APIENTRY NmDelLink(unsigned short, unsigned char);

// DECnet volatile node routines 
short PW_APIENTRY NmGetVNodeList(unsigned short FAR *, short FAR *);
short PW_APIENTRY NmGetVNode(unsigned short, void FAR *);

// DECnet event logging routines 
short PW_APIENTRY NmGetEvent(void FAR *);
short PW_APIENTRY NmGetEventText(void FAR *, unsigned char FAR *);

// Set and clear dnetpath 
short PW_APIENTRY NmSetPath(char FAR *);
short PW_APIENTRY NmClearPath(void);
char FAR * FAR PASCAL NmApiVersion(void);

// NMAPI error messages 
short PW_APIENTRY NmGetErrorString(unsigned short, unsigned short, unsigned char FAR *);

// Replacement for C Run Time Library 
short PW_APIENTRY NmStrcmp(char FAR *, char FAR *);
short PW_APIENTRY NmStricmp(char FAR *, char FAR *);
short PW_APIENTRY NmStrncmp(char FAR *, char FAR *, short);
short PW_APIENTRY NmItoA(unsigned short, unsigned char FAR *, short);
short PW_APIENTRY NmLtoA(unsigned long, unsigned char FAR *, unsigned short);
short PW_APIENTRY NmHtoA(unsigned char FAR *, unsigned char FAR *, unsigned short);

#endif  // NM_PROTO_H 
