	NAME	RESIDENT
	INCLUDE	PAGESIZE.INC
	TITLE	.RESIDENT -  Resident manager, RESMAN and KFAKE
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU

; Note: OKBSRV is in module KEYBOARD not PUBLICS.
; 3-1-85 EMU2 label moved

	EXTRN	RESFLG:BYTE,	LAST:WORD,	SLVERR:BYTE,	PREFLG:BYTE
	EXTRN	OKBD:DWORD,	OKBSRV:DWORD,	MEMTAB:BYTE,	OSTACK:WORD
	EXTRN	A_INT16:BYTE,	A4SCANC:BYTE
DATA	ENDS

CSTACK	SEGMENT	STACK 'DGROUP'
	EXTRN	INSP:WORD
CSTACK	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	INKEY:NEAR,	BIOSKY:NEAR,	EXIT:NEAR,	E78I:NEAR
	EXTRN	XFILES:NEAR

	PUBLIC	RESMAN
RESMAN	PROC	NEAR
	CMP	RESFLG,0	; Is nothing already resident?
	JZ	RES1		; Not yet, go ahead

	MOV	SLVERR,NF$AR	; Already resident error message

	RET			; Return with nothing done

RES1:	CMP	PREFLG,0	; Is there already one resident emulator?
	JZ	RES2		; No, all is well

	MOV	SLVERR,SE$N2	; Attempt to make number 2 resident.
	RET			;

; Update OKBSRV with address of 'NEW' keyboard service routine so that
;   when KYRLSE is called the new routine will replace the original 
;   routine...

RES2:	MOV	WORD PTR OKBSRV[0],OFFSET KFAKE
	MOV	WORD PTR OKBSRV[2],CS

	MOV	RESFLG,1	; I am here!
	MOV	SLVERR,SE$RR	; Resident at last!
	RET			; Should never get here...

RESMAN	ENDP
	PAGE
;
; The following structure must be immediately before the KFAKE entry
; point to allow direct access to E78 from file transfer & screen I/O
; routines.  Do not modify the basic structure of this data area.
; If additions are to be made they should preceed this block of data.
;
	DW	OFFSET CODE:XFILES	; Offset of file transfer servers
	PUBLIC	IOK,GREVNO		; 
IOK	LABEL	WORD			; Magic numbers used to verify res.
	DW	"IR"			;
	DW	"MA"			;
	DW	"Ok"			;
GREVNO	LABEL	WORD			;
	DW	0142H			; Revision number

; End of file transfer control block
;
	PUBLIC	KFAKE
KFAKE	PROC	FAR
	STI

	PUSH	DS
	PUSH	AX

	MOV	AX,DATA		; Set up data segment
	MOV	DS,AX		;

				; Test for residency
	CMP	RESFLG,2	; Are we already running the emulator?
	JZ	KF1		; Yes, not much to do...

	MOV	AH,2		; Get current shift status
	CALL	BIOSKY		; BIOS keyboard call

	AND	AL,11B		; Are these my shift keys?
	CMP	AL,11B		;
	JNZ	KF1		; No, nothing fancy now...

EMU2:	MOV	RESFLG,2	; Set the emulator active status

	XOR	AX,AX		; Get current stack pointer
	ADD	AX,SP		; Execute E78I with internal not
	MOV	OSTACK[0],AX	; user supplied stack!
	MOV	AX,SS		;
	MOV	OSTACK[2],AX	;

	CLI			; Disable interrupts during stack munch

	MOV	AX,CSTACK	; Set local stack segment
	MOV	SS,AX		;
	MOV	AX,OFFSET INSP	; Initial stack pointer
	MOV	SP,AX		;

	STI			; Interrupts away!

	CALL	E78I		; EMULATE!

	CLI			; Reset stack to outside parameters

	MOV	AX,OSTACK[2]	; Segment
	MOV	SS,AX		;
	MOV	AX,OSTACK[0]	; Offset
	MOV	SP,AX		;

	STI			; Interrupts again, outer stack

	MOV	RESFLG,1	; Emulator is not active now...

KF1:	POP	AX		; Restore call value

	CMP	A_INT16,1	; Is pass through enabled
	JNE	KFMOD
	CMP	AH,0		; get key request?
	JNE	KFMOD
	PUSH	AX
	CALL	BIOSKY

	CMP	AL,A4SCANC	; Hot-shift from INT 16 PASS-THROUGH?
	JE	SHORT EMU2	; Execute Emulator now!!!!!!

	ADD	SP,2		; Get rid of unwanted AX on the stack
	POP	DS		; Restore the data segment
	RET	2

KFMOD:	CMP	AH,0		; Is this a sit and wait call?
	JZ	KF2		; Yes, fake it.

	CMP	AH,4		; Is this supposed to be illegal?
	JZ	IRMAOK		; Yes, send out the message

	CMP	AH,5		; Is this an emulator request?
	JZ	EMU		; Yes, do it!

	CMP	AH,6		; Is this for a memory table pointer?
	JZ	MPTR		; 

	CMP	AH,2		; Is this a shift status test ??
	JNE	KFKA

	CALL	BIOSKY
	POP	DS
	IRET

KFKA:	CALL	BIOSKY		; Unmodified BIOS keyboard routine

	JMP	SHORT KFC	; Return to caller, flags intact.

KF2:	MOV	AH,1		; Get key state (zero if key pending)
	INT	RXIVC		; With escape state test...
	JZ	KF2		; Loop here until key arrives

	MOV	AH,0		; Get the key
	CALL	BIOSKY		;

KFC:	POP	DS		; Restore internal registers
	RET	2		; And return the answer

IRMAOK:	MOV	AX,CS:IOK[0]	; Send a coded message back...
	MOV	BX,CS:IOK[2]	;
	MOV	CX,CS:IOK[4]	; Note: lower case K
	MOV	DI,WORD PTR OKBD[0] ; Pointer to primitive keyboard
	MOV	SI,WORD PTR OKBD[2] ;
	JMP	SHORT KFC	; Exit.

EMU:	MOV	AH,1		; Return w/ keyboard status just for fun..
	PUSH	AX		; 
	JMP	EMU2		; And pretend the shift keys just pressed.

MPTR:	MOV	AX,SEG MEMTAB	; Setup ES
	MOV	ES,AX		;

	MOV	BX,OFFSET MEMTAB; Make the pointer to memory allocation block
	JMP	SHORT KFC	;

KFAKE	ENDP

CODE	ENDS

	END
