	NAME	KEYCODE
	INCLUDE	PAGESIZE.INC
	TITLE	.KEYCODE -  3270 Scan and key position tables SCODE, KCODE
DATA	SEGMENT	PUBLIC BYTE

;	Key 51A (Katakana only) is not supported by this table.
;	Key code 89 represents the KEYBOARD OVERRUN scan code

	PUBLIC	SCODE,FIRKEY,LASKEY
SCODE	LABEL	BYTE

	DB	050H,051H,03DH,021H,022H,023H,024H,025H,026H,027H
	DB	028H,029H,020H,030H,011H,031H,05FH,05EH,052H,053H
	DB	036H,070H,076H,064H,071H,073H,078H,074H,068H,06EH
	DB	06FH,01BH,015H,035H,00CH,00DH,054H,055H,0CCH,060H
	DB	072H,063H,065H,066H,067H,069H,06AH,06BH,07EH,012H
	DB	00FH,008H,00EH,013H,056H,057H,0CDH,009H,079H,077H
	DB	062H,075H,061H,06DH,06CH,033H,032H,014H,0CEH,016H
	DB	01AH,034H,034H,010H,0CFH,018H,040H,041H,042H,043H
	DB	044H,045H,046H,047H,048H,049H,04AH,04BH
	DB	0H

FIRKEY	DB	1	; First valid key number
LASKEY	DB	89	; Last valid key number
	PAGE
	PUBLIC	KCODE,ECCODE
KCODE	LABEL	WORD

KOVER	EQU	89		; Keyboard overrun

SHF	EQU	57
ALT	EQU	75
NUL	EQU	00

KF1	EQU	1		; Keyboard positions
KF2	EQU	2
KF3	EQU	19
KF4	EQU	20
KF5	EQU	37
KF6	EQU	38
KF7	EQU	55
KF8	EQU	56

KESC	EQU	3

K1	EQU	4
K2	EQU	5
K3	EQU	6
K4	EQU	7
K5	EQU	8
K6	EQU	9
K7	EQU	10
K8	EQU	11
K9	EQU	12
K0	EQU	13

KMINUS	EQU	14
KEQUAL	EQU	15
KDEL	EQU	16

KTAB	EQU	21

KQ	EQU	22
KW	EQU	23
KE	EQU	24
KR	EQU	25
KT	EQU	26
KY	EQU	27
KU	EQU	28
KI	EQU	29
KO	EQU	30
KP	EQU	31

KCENT	EQU	32
KBSLASH	EQU	33
KBTAB	EQU	34

KNLOCK	EQU	39

KA	EQU	40
KS	EQU	41
KD	EQU	42
KF	EQU	43
KG	EQU	44
KH	EQU	45
KJ	EQU	46
KK	EQU	47
KL	EQU	48
KSEMI	EQU	49
KSQUOTE	EQU	50
KLBRACE	EQU	51
KCRLF	EQU	52

KSHIFT	EQU	57

KLESS	EQU	58

KZ	EQU	59
KX	EQU	60
KC	EQU	61
KV	EQU	62
KB	EQU	63
KN	EQU	64
KM	EQU	65
KCOMMA	EQU	66
KPERIOD	EQU	67
KSLASH	EQU	68

KUPA	EQU	53
KDNA	EQU	54
KLFA	EQU	70
KRTA	EQU	71

KP1	EQU	17		; PA1/DUP
KP2	EQU	18		; PA2/FIELD MARK
KIC	EQU	35		; Insert character
KDC	EQU	36		; Delete character

KRESET	EQU	72
KALT	EQU	75
KENTER	EQU	76
	
KSPACE	EQU	74

KPF13	EQU	77
KPF14	EQU	78
KPF15	EQU	79
KPF16	EQU	80
KPF17	EQU	81
KPF18	EQU	82
KPF19	EQU	83
KPF20	EQU	84
KPF21	EQU	85
KPF22	EQU	86
KPF23	EQU	87
KPF24	EQU	88
	PAGE
LBLX1	=	$		; Reference to beginning of table
	DB	NUL,NUL		; NUL
	DB	NUL,NUL		; SOH
	DB	NUL,NUL		; STX
	DB	NUL,NUL		; ETX
	DB	NUL,NUL		; EOT
	DB	NUL,NUL		; ENQ
	DB	NUL,NUL		; ACK
	DB	NUL,NUL		; BEL
	DB	NUL,KDEL	; BS	DELETE 
	DB	NUL,KTAB	;	TAB
	DB	NUL,KCRLF	; LF	CRLF
	DB	NUL,NUL		; VT
	DB	NUL,NUL		; FF
	DB	NUL,KENTER	; CR	ENTER
	DB	NUL,NUL		; SO
	DB	NUL,NUL		; SI
	DB	NUL,NUL		; DLE
	DB	NUL,NUL		; DC1
	DB	NUL,NUL		; DC2
	DB	NUL,NUL		; DC3
	DB	NUL,NUL		; DC4
	DB	NUL,NUL		; NAK
	DB	NUL,NUL		; SYN
	DB	NUL,NUL		; ETB
	DB	NUL,NUL		; CAN
	DB	NUL,NUL		; EM
	DB	NUL,NUL		; SUB
	DB	NUL,KP2		; 	ESC	Field mark
	DB	NUL,NUL		; FS
	DB	NUL,NUL		; GS
	DB	NUL,NUL		; RS
	DB	NUL,NUL		; US

	DB	NUL,KSPACE	;	SPACE
	DB	SHF,KCENT	; 	!
	DB	SHF,KSQUOTE	;	'
	DB	SHF,K3		;	#
	DB	SHF,K4		;	$
	DB	SHF,K5		;	%
	DB	SHF,K7		;	&
	DB	NUL,KSQUOTE	;	'
	DB	SHF,K9		;	(
	DB	SHF,K0		;	)
	DB	SHF,K8		;	*
	DB	SHF,KEQUAL	;	+
	DB	NUL,KCOMMA	;	,
	DB	NUL,KMINUS	;	-
	DB	NUL,KPERIOD	;	.
	DB	NUL,KSLASH	;	/
	PAGE
	DB	NUL,K0		;	0
	DB	NUL,K1		;	1
	DB	NUL,K2		;	2
	DB	NUL,K3		;	3
	DB	NUL,K4		;	4
	DB	NUL,K5		;	5
	DB	NUL,K6		;	6
	DB	NUL,K7		;	7
	DB	NUL,K8		;	8
	DB	NUL,K9		;	9
	DB	SHF,KSEMI	;	:
	DB	NUL,KSEMI	;	;
	DB	NUL,KLESS	;	<
	DB	NUL,KEQUAL	;	=
	DB	SHF,KLESS	;	>
	DB	SHF,KSLASH	;	?

	DB	SHF,K2		;	@
	DB	SHF,KA		;	A
	DB	SHF,KB		;	B
	DB	SHF,KC		;	C
	DB	SHF,KD		;	D
	DB	SHF,KE		;	E
	DB	SHF,KF		;	F
	DB	SHF,KG		;	G
	DB	SHF,KH		;	H
	DB	SHF,KI		;	I
	DB	SHF,KJ		;	J
	DB	SHF,KK		;	K
	DB	SHF,KL		;	L
	DB	SHF,KM		;	M
	DB	SHF,KN		;	N
	DB	SHF,KO		;	O
	DB	SHF,KP		;	P
	DB	SHF,KQ		;	Q
	DB	SHF,KR		;	R
	DB	SHF,KS		;	S
	DB	SHF,KT		;	T
	DB	SHF,KU		;	U
	DB	SHF,KV		;	V
	DB	SHF,KW		;	W
	DB	SHF,KX		;	X
	DB	SHF,KY		;	Y
	DB	SHF,KZ		;	Z

	DB	SHF,K1		;	[	Concatanation (solid v bar)
	DB	NUL,KBSLASH	;	\
	DB	NUL,KCENT	;	]	Cent sign
	DB	SHF,K6		;	^ 	Logical not
	DB	SHF,KMINUS	;	_
	PAGE
	DB	NUL,KESC	;	`
	DB	NUL,KA		;	a
	DB	NUL,KB		;	b
	DB	NUL,KC		;	c
	DB	NUL,KD		;	d
	DB	NUL,KE		;	e
	DB	NUL,KF		;	f
	DB	NUL,KG		;	g
	DB	NUL,KH		;	h
	DB	NUL,KI		;	i
	DB	NUL,KJ		;	j
	DB	NUL,KK		;	k
	DB	NUL,KL		;	l
	DB	NUL,KM		;	m
	DB	NUL,KN		;	n
	DB	NUL,KO		;	o
	DB	NUL,KP		; 	p
	DB	NUL,KQ		;	q
	DB	NUL,KR		;	r
	DB	NUL,KS		;	s
	DB	NUL,KT		;	t
	DB	NUL,KU		;	u
	DB	NUL,KV		;	v
	DB	NUL,KW		;	w
	DB	NUL,KX		;	x
	DB	NUL,KY		;	y
	DB	NUL,KZ		;	z

	DB	NUL,KLBRACE	;	{
	DB	SHF,KBSLASH	;	|
	DB	SHF,KLBRACE	;	}
	DB	SHF,KESC	;	~
	DB	ALT,KDEL	;	APL ON/OFF

	DB	NUL,NUL		; Secondary null (control of ALPHA pad)
	DB	NUL,NUL		; A
	DB	NUL,NUL		; B
	DB	NUL,NUL		; C
	DB	ALT,KLFA	; D	Double speed left arrow
	DB	NUL,NUL		; E
	DB	ALT,KRTA	; F	Double speed right arrow
	DB	NUL,KP1		; G	DUP
	DB	NUL,KP2		; H	FM
	DB	NUL,NUL		; I
	DB	ALT,KP1		; J	PA1
	DB	ALT,KP2		; K	PA2
	DB	NUL,NUL		; L
	DB	SHF,KPERIOD	; M	: for APL users
	DB	SHF,KCOMMA	; N	; for APL users
	DB	NUL,NUL		; O
	DB	NUL,NUL		; P
	DB	NUL,NUL		; Q
	DB	NUL,NUL		; R
	DB	NUL,NUL		; S
	DB	NUL,NUL		; T
	DB	NUL,NUL		; U
	DB	NUL,NUL		; V
	DB	NUL,NUL		; W
	DB	NUL,NUL		; X
	DB	NUL,NUL		; Y
	DB	NUL,NUL		; Z
	DB	NUL,KCENT	; [ Extra left arrow for APL
	DB	NUL,NUL		; \
	DB	SHF,KCENT	; ] Extra right arrow for APL

RECNT=	(512-($-LBLX1))/2	; Number of entrys needed to fill out page
	REPT	RECNT		; Fill out table to 256 entry total
	DB	NUL,NUL		;
	ENDM			;
	PAGE
ECCODE	LABEL	WORD		; Extended character codes
LBLX2	=	$		; Reference for fill out to full size
	DB	NUL,NUL		; 0
	DB	NUL,NUL		; 1
	DB	NUL,NUL		; 2
	DB	NUL,NUL		; 3	Null character
	DB	NUL,NUL		; 4
	DB	NUL,NUL		; 5
	DB	NUL,NUL		; 6
	DB	NUL,NUL		; 7
	DB	NUL,NUL		; 8
	DB	NUL,NUL		; 9
	DB	NUL,NUL		; 10
	DB	NUL,NUL		; 11
	DB	NUL,NUL		; 12	Ctrl UP ARROW
	DB	NUL,NUL		; 13	Ctrl DN ARROW
	DB	ALT,KDEL	; 14	APL ON/OFF
	DB	NUL,KBTAB	; 15	Back tab
	DB	ALT,KQ		; 16	Alternate of QWERTYUIOP
	DB	ALT,KW		; 17	
	DB	ALT,KE		; 18	
	DB	ALT,KR		; 19	
	DB	ALT,KT		; 20	
	DB	ALT,KY		; 21	
	DB	ALT,KU		; 22	
	DB	ALT,KI		; 23	
	DB	ALT,KO		; 24	
	DB	ALT,KP		; 25	

	DB	ALT,KCENT	; 26	APL BOXED ACCENT
	DB	ALT,KBSLASH	; 27	APL UNDERSCORED TRIANGLE
	DB	NUL,NUL		; 28
	DB	NUL,NUL		; 29

	DB	ALT,KA		; 30	Alternate of ASDFGHJKL
	DB	ALT,KS		; 31	
	DB	ALT,KD		; 32	
	DB	ALT,KF		; 33	
	DB	ALT,KG		; 34	
	DB	ALT,KH		; 35	
	DB	ALT,KJ		; 36	
	DB	ALT,KK		; 37	
	DB	ALT,KL		; 38	

	DB	ALT,KSEMI	; 39
	DB	ALT,KSQUOTE	; 40
	DB	ALT,KLBRACE	; 41
	DB	NUL,NUL		; 42
	DB	ALT,KBSLASH	; 43

	DB	ALT,KZ		; 44	     Alternate of ZXCVBNM
	DB	ALT,KX		; 45
	DB	ALT,KC		; 46
	DB	ALT,KV		; 47
	DB	ALT,KB		; 48
	DB	ALT,KN		; 49
	DB	ALT,KM		; 50

	DB	ALT,KCOMMA	; 51
	DB	ALT,KPERIOD	; 52
	DB	ALT,KSLASH	; 53
	DB	NUL,NUL		; 54
	DB	NUL,NUL		; 55
	DB	NUL,NUL		; 56
	DB	NUL,NUL		; 57
	DB	NUL,NUL		; 58

	DB	NUL,KF1		; 59	Function keys (Base case)
	DB	ALT,KF2		; 60
	DB	NUL,KF3		; 61
	DB	ALT,KF4		; 62
	DB	NUL,KF5		; 63
	DB	NUL,KF6		; 64
	DB	NUL,KF7		; 65
	DB	NUL,KF8		; 66
	DB	NUL,KCRLF	; 67	New line
	DB	NUL,KRESET	; 68	Reset

	DB	ALT,KTAB	; 69	ALT TAB
	DB	NUL,NUL		; 70

	DB	ALT,KBTAB	; 71	HOME
	DB	NUL,KUPA	; 72	UP ARROW
	DB	NUL,KNLOCK	; 73	PAGE UP Shift lock

	DB	NUL,NUL		; 74

	DB	NUL,KLFA	; 75	LEFT ARROW (Cursor pad)

	DB	NUL,NUL		; 76

	DB	NUL,KRTA	; 77	RIGHT ARROW (Cursor pad)

	DB	NUL,NUL		; 78

	DB	NUL,NUL		; 79	END
	DB	NUL,KDNA	; 80	DOWN ARROW
	DB	NUL,SHF		; 81	PAGE DOWN Release shift lock
	DB	NUL,KIC		; 82	INS (Below cursor pad)
	DB	NUL,KDC		; 83	DEL (Below cursor pad)

	DB	NUL,NUL		; 84	Shifted function keys
	DB	NUL,NUL		; 85
	DB	NUL,NUL		; 86
	DB	NUL,NUL		; 87
	DB	NUL,NUL		; 88
	DB	NUL,NUL		; 89
	DB	NUL,NUL		; 90
	DB	NUL,NUL		; 91
	DB	NUL,NUL		; 92
	DB	NUL,NUL		; 93

	DB	NUL,NUL		; 94	Control function keys
	DB	NUL,NUL		; 96
	DB	NUL,NUL		; 96
	DB	NUL,NUL		; 97
	DB	NUL,NUL		; 98
	DB	NUL,NUL		; 99
	DB	NUL,NUL		; 100
	DB	NUL,NUL		; 101
	DB	NUL,NUL		; 102
	DB	NUL,NUL		; 103

	DB	ALT,KF1		; 104	SYS REQ Alternate function keys
	DB	NUL,KF2		; 105
	DB	ALT,KF3		; 106	
	DB	NUL,KF4		; 107
	DB	ALT,KF5		; 108	ALT CURSOR
	DB	ALT,KF6		; 109
	DB	ALT,KF7		; 110	IDENT
	DB	ALT,KF8		; 111	TEST
	DB	NUL,NUL		; 112
	DB	ALT,KRESET	; 113	DEV CNCL

	DB	NUL,NUL		; 114	CTRL PRTSC

	DB	ALT,KLFA	; 115	CTRL LEFT ARROW (Cursor pad)
	DB	ALT,KRTA	; 116	CTRL RIGHT ARROW (Cursor pad)

	DB	NUL,NUL		; 117	CTRL END 
	DB	NUL,NUL		; 118	CTRL PG DN
	DB	NUL,KOVER	; 119	CTRL HOME Keyboard overrun

	DB	ALT,K1		; 120	PF1 Alternate of number keys
	DB	ALT,K2		; 121
	DB	ALT,K3		; 122
	DB	ALT,K4		; 123
	DB	ALT,K5		; 124
	DB	ALT,K6		; 125
	DB	ALT,K7		; 126
	DB	ALT,K8		; 127
	DB	ALT,K9		; 128
	DB	ALT,K0		; 129
	DB	ALT,KMINUS	; 130
	DB	ALT,KEQUAL	; 131

	DB	NUL,NUL		; 132	CTRL PG UP

	DB	NUL,NUL		; 133
	DB	NUL,NUL		; 134
	DB	NUL,NUL		; 135
	DB	NUL,NUL		; 136
	DB	NUL,NUL		; 137
	DB	NUL,NUL		; 138
	DB	NUL,NUL		; 139

	DB	NUL,KPF13	; 140 	CTRL of numbers row (123...90-=)
	DB	NUL,KPF14	; 141
	DB	NUL,KPF15	; 142
	DB	NUL,KPF16	; 143
	DB	NUL,KPF17	; 144
	DB	NUL,KPF18	; 145
	DB	NUL,KPF19	; 146
	DB	NUL,KPF20	; 147
	DB	NUL,KPF21	; 148
	DB	NUL,KPF22	; 149
	DB	NUL,KPF23	; 150
	DB	NUL,KPF24	; 151
	DB	NUL,NUL		; 152
	DB	NUL,NUL		; 153
	DB	NUL,NUL		; 154
	DB	NUL,NUL		; 155
	DB	NUL,NUL		; 156
	DB	NUL,NUL		; 157
	DB	NUL,NUL		; 158
	DB	NUL,NUL		; 159
	DB	ALT,KDC		; 160
	

RECNT=	(512-($-LBLX2))/2	; Number of entrys to fill out to 256 total
	REPT	RECNT		;
	DB	NUL,NUL		;
	ENDM

DATA	ENDS

	END
