	NAME	KEYBOARD
	INCLUDE	PAGESIZE.INC
	TITLE	.KEYBOARD - BIOS KEYBOARD routine replacement
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	PUBLIC	KEYNORM,KEYSHFT,KEYALT, KEYCTRL,KEYLOCK
	PUBLIC	KYPRECD
	PUBLIC	KYCSHFA,KYCSHFB,KYCCTLA,KYCCTLB
	PUBLIC	KYCALTA,KYCALTB,KYCCAPA,KYCCAPB
	PUBLIC	KYCNUMA,KYCNUMB,KYCSCLA,KYCSCLB
	PUBLIC	KYSSUPR,KYSBRK, KYSHOLD,KYSREST
	PUBLIC	KYASHF
	PUBLIC	OKBSRV
	EXTRN	LSADDR:WORD,	RESFLG:BYTE
	EXTRN	ATFLAG:BYTE,	ALTMOD2:BYTE,	ERICKEY:BYTE

;******************************************************************************
;		      R E V I S I O N    H I S T O R Y			
;******************************************************************************
;
;	1.32	Added a jump which checked to see if an exit for the PC/AT
;		needed to be performed.  The instigation of this was the 
;		fact that the print screen function no longer worked.
;       1.41    3-1-85  Ericsson PC added. kbd
;		3-28-85  Olivetti Deluxe keyb.
;
;******************************************************************************

; System defined equates

KBDATA		EQU	60H		; Keyboard data port
KBCTL		EQU	61H		; Keyboard/speaker control port
KBD_STATUS	EQU	64H
ICTL		EQU	20H		; Interrupt control port

BIOSSEG	EQU	40H			; BIOS local data segment

BIOSRFG  EQU	72H			; BIOS RESET flag bytes (2)
BIOSBRK  EQU	71H			; BIOS BREAK flag byte
BIOSKFLG EQU	17H			; BIOS shift state flags
BIOSSFLG EQU	18H			; BIOS internal key flags

; Local variables

OKBVEC	DD	 0			; Original keyboard vector
OKBSRV	DD	 0			; Keyboard I/O call vector

SUPKEY	DB	 0			; Set to indicate SUPERKEY pressed! 

; KFLG contains bits used to compute current shift status and keyboard state.
;   The lower nybble in this byte is assumed to correspond to the nybbles
;   in the KEYLOCK table (KYL record).  This byte is also assumed to match
;   the format of the BIOS byte KB_FLG.

KFLG	DB	 0 			; Current shift key states

 KFLGNU	EQU	 1H			; Numbers shift key
 KFLGSH	EQU	 2H			; Shift key pressed
 KFLGCT	EQU	 4H			; Control key
 KFLGAL	EQU	 8H			; Alternate key pressed

 KFLGSC	EQU	10H			; Scroll lock key activated
 KFLGNL	EQU	20H			; Numeric lock key activated
 KFLGCL	EQU	40H			; Caps lock key activated
 KFLGIN	EQU	80H			; Insert state

; SSFLG contains bits used to manage Shift States such as CAPS LOCK and INS.
;   This byte is assumed to match BIOS byte KB_FLAG_1.

SSFLG	DB	 0 			; Shift status flags

 SFLGHH	EQU	 8H			; Hold state
 SFLGSC	EQU	KFLGSC			; Scroll lock down
 SFLGNL	EQU	KFLGNL			; Numeric lock down
 SFLGCL	EQU	KFLGCL			; Caps lock down
 SFLGIN	EQU	KFLGIN			; Insert key down

KB_LED_STAT	DB	0		; LED status byte

RESEND_REQ	EQU	0FEH
ACK_KBD		EQU	0FAH
DISABLE_KBD	EQU	0ADH
ENABLE_KBD	EQU	0AEH
KBD_ENABLE_CMD	EQU	0F4H
SET_RESET_CMD	EQU	0EDH
KBD_ERROR_FLAG	EQU	80H
KFLG_LED_BITS	EQU	70H
UPDATE_IN_PROG	EQU	40H
KB_RESEND	EQU	20H
KB_ACK_REC	EQU	10H
LED_BITS	EQU	07H
KBD_BUF_FULL	EQU	02H

UPDATE_IN_PROGRESS	EQU	40H
END_OF_INTERRUPT	EQU	20H
RETRY_COUNT		EQU	03H



	PAGE

; KEYBUF contains keystrokes not yet accepted by application program

KEYBSZ	EQU	16*2			; Size of ring in keystrokes (16)
KEYBUF	DW	0			; Input pointer - Keyboard buffer
	DW	0			; Output pointer
	DW	KEYBSZ			; Ring size info
        DB	KEYBSZ DUP(0)		; Data area

; Shift/Ctrl/Alt key combination precedence table
; 
; The following assignment statements must match the order of keyboard
; tables following the KEYTAB label.  All entrys in the KEYTAB table
; must consist of exactly 128 two byte entrys.  All 16 shift states
; may be accomodated by enlarging KEYTAB table.
;
; This table is indexed by the lower four bits from KFLG which indicate 
; current shift status as noted below:
;
;   ALPHA SHIFT:  1  LSB   (KFLGSH)
;   NUM   SHIFT:  2        (KFLGNU)
;   CTRL  SHIFT:  4        (KFLGCT)
;   ALT   SHFIT:  8  MSB   (KFLGAL)

PRNORM=	0				; Normal keyboard entry
PRSHFT=	1				; Shifted entry
PRALT=	2				; Alternate
PRCTRL=	3				; Control

KYPRECD	LABEL	BYTE			; Shift key precedence table
	DB	PRNORM			; 0000
	DB	PRSHFT			; 0001 SHIFT
	DB	PRSHFT			; 0010       NUM
	DB	PRSHFT			; 0011 SHIFT NUM
	DB	PRCTRL			; 0100           CTRL
	DB	PRCTRL			; 0101 SHIFT     CTRL
	DB	PRCTRL			; 0110       NUM CTRL
	DB	PRCTRL			; 0111 SHIFT NUM CTRL
	DB	PRALT			; 1000                ALT
	DB	PRALT			; 1001 SHIFT          ALT
	DB	PRALT			; 1010       NUM      ALT
	DB	PRALT			; 1011 SHIFT NUM      ALT
	DB	PRALT			; 1100           CTRL ALT
	DB	PRALT			; 1101 SHIFT     CTRL ALT
	DB	PRALT			; 1110       NUM CTRL ALT
	DB	PRALT			; 1111 SHIFT NUM CTRL ALT
	PAGE
; Shift/Ctrl/Alt key selection table

SHIFTKEYS=	 8			; Number of shift key entrys in table

KYC	LABEL	BYTE			; General table entry

KYCSHFA	DB	42			; Alpha shift keys
KYCSHFB	DB	 0			;

KYCNSHA	DB	54			; Numbers shift (Right shift key)
KYCNSHB	DB	 0			; (Default tables treat this as
					;    normal Alpha shift...)

KYCCTLA	DB	29			; Control key
KYCCTLB	DB	 0			; No secondary control key...

KYCALTA	DB	56			; ALT key
KYCALTB	DB	 0			;

KYCCAPA	DB	58			; Caps Lock
KYCCAPB	DB	 0			;

KYCNUMA	DB	69			; Num Lock
KYCNUMB	DB	 0			;

KYCSCLA	DB	70			; Scroll Lock
KYCSCLB	DB	 0			;

KYCINSA	DB	82			; Insert mode
KYCINSB	DB	 0			;

KYCJTAB	LABEL	WORD			; Vector table for shift processes
	DW	OFFSET CODE:CSHIFT	; Alpha shift 
	DW	OFFSET CODE:CNUSHF	; Numeric shift
	DW	OFFSET CODE:CCTRL	; Control shift
	DW	OFFSET CODE:CALT	; Alternate shift
	DW	OFFSET CODE:CCAPS	; Caps lock
	DW	OFFSET CODE:CNUM	; Numeric lock
	DW	OFFSET CODE:CSCRL	; Scroll lock
	DW	OFFSET CODE:CINS	; Insert mode

; KYASHF provides a mechanism of aliasing the ALPHA shift key.  This
;   allows compatibility with existing PC applications if the shift
;   key is aliased to the NUMBERS SHIFT key.  If a new (separate)
;   NUMBERS SHIFT key is defined KYASHF should be set to ZERO to indicate
;   no alias availible

KYASHF	DB	KFLGNU			; Aliases of SHIFT key
	PAGE
; BREAK/HOLD/RESET/PRINT - Special key code templates 

SCT	RECORD	SCAT:8=0,SCKEY:8=0

SPECKEYS=	5			; Count of special key templates

KYS	LABEL	WORD			; General table entry
KYSSUPR	SCT	<KFLGAL,1>		; ALT-ESC superkey
KYSBRK	SCT	<KFLGCT,70>		; CTRL-BREAK
KYSHOLD	SCT	<KFLGCT,69>		; CTRL-NUM LOCK
KYSREST	SCT	<KFLGCT+KFLGAL,83>	; CTRL-ALT-DEL
KYSPRNT	SCT	<KFLGSH,55>		; SHFT-PRTSC

KYSJTAB	LABEL	WORD			; Vector table for special key code
	DW	OFFSET CODE:SUPERK	; Super-keyboard passthrough
	DW	OFFSET CODE:SBRK	; Break
	DW	OFFSET CODE:SHOLD	; Hold <machine lock>
	DW	OFFSET CODE:SREST	; Reset
	DW	OFFSET CODE:SPRNT	; Print screen
	PAGE
; KEYLOCK table defines the shift key action when the NUM LOCK and CAPS LOCK
;   keys are activated.  When a lock is active the appropriate nybble is
;   XOR'ed with the shift key status before the key code is looked up in
;   KEYTAB.  The upper nybble contains the CAPS LOCK information, the lower
;   nybble the NUM LOCK information.  If both CAPS & NUM locks are active 
;   the upper and lower nybbles are OR'ed together before being merged with
;   shift status from KFLG.

KEYLOCK	LABEL	BYTE			; Lock control bytes

KYL	RECORD	CPL:4=0,ALT:4=0		; Numeric & alpha locks
;       LOCK:  NUM,ALPHA
	KYL	<0,0>			;  0   No such key
	KYL	<0,0>			;  1   ESC
	KYL	<0,0>			;  2 1
	KYL	<0,0>			;  2 2
	KYL	<0,0>			;  4 3
	KYL	<0,0>			;  5 4 
	KYL	<0,0>   		;  6 5 
	KYL	<0,0>			;  7 6 
  	KYL	<0,0>			;  8 7 
	KYL	<0,0>			;  9 8 
	KYL	<0,0>			; 10 9 
	KYL	<0,0>			; 11 0 
	KYL	<0,0>			; 12 - 
	KYL	<0,0>			; 13 = 
	KYL	<0,0>			; 14   Backspace
	KYL	<0,0>			; 15   Horizontal tab
	KYL	<0,KFLGSH>		; 16 Q
	KYL	<0,KFLGSH>		; 17 W
	KYL	<0,KFLGSH>		; 18 E
	KYL	<0,KFLGSH>		; 19 R
	KYL	<0,KFLGSH>		; 20 T
	KYL	<0,KFLGSH>		; 21 Y
	KYL	<0,KFLGSH>		; 22 U
	KYL	<0,KFLGSH>		; 23 I
	KYL	<0,KFLGSH>		; 24 O
	KYL	<0,KFLGSH>		; 25 P
	KYL	<0,0>			; 26 [
	KYL	<0,0>			; 27 ]
	KYL	<0,0>			; 28   Carriage return
	KYL	<0,0>			; **   Control key
	KYL	<0,KFLGSH>		; 30 A
	KYL	<0,KFLGSH>		; 31 S
	KYL	<0,KFLGSH>		; 32 D
	KYL	<0,KFLGSH>		; 33 F
	KYL	<0,KFLGSH>		; 34 G
	KYL	<0,KFLGSH>		; 35 H
	KYL	<0,KFLGSH>		; 36 J
	KYL	<0,KFLGSH>		; 37 K
	KYL	<0,KFLGSH>		; 38 L
	KYL	<0,0>			; 39 ;
	KYL	<0,0>			; 40 '
	KYL	<0,0>			; 41 `
	KYL	<0,0>			; **   Left shift
	KYL	<0,0>			; 43 \
	KYL	<0,KFLGSH>		; 44 Z
	KYL	<0,KFLGSH>		; 45 X
	KYL	<0,KFLGSH>		; 46 C
	KYL	<0,KFLGSH>		; 47 V
	KYL	<0,KFLGSH>		; 48 B
	KYL	<0,KFLGSH>		; 49 N
	KYL	<0,KFLGSH>		; 50 M
	KYL	<0,0>			; 51 ,
	KYL	<0,0>			; 52 . 
	KYL	<0,0>			; 53 /
	KYL	<0,0>			; **   Right shift
	KYL	<0,0>			; 55 * (on PrtSc key)
	KYL	<0,0>			; **   ALT
	KYL	<0,0>			; 57   Space
	KYL	<0,0>			; 58   CAPS LOCK
	KYL	<0,0>			; 59   F1
	KYL	<0,0>			; 60   F2
	KYL	<0,0>			; 61   F3
	KYL	<0,0>			; 62   F4
	KYL	<0,0>			; 63   F5
	KYL	<0,0>			; 64   F6
	KYL	<0,0>			; 65   F7
	KYL	<0,0>			; 66   F8
	KYL	<0,0>			; 67   F9
	KYL	<0,0>			; 68   F10
	KYL	<0,0>			; **   NUM LOCK
	KYL	<0,0>			; **   SCROLL LOCK
	KYL	<KFLGSH,0>		; 71 7 (on numeric pad)
	KYL	<KFLGSH,0>		; 72 8
	KYL	<KFLGSH,0>		; 73 9
	KYL	<0,0>			; 74 -
	KYL	<KFLGSH,0>		; 75 4
	KYL	<KFLGSH,0>		; 76 5
	KYL	<KFLGSH,0>		; 77 6
	KYL	<0,0>			; 78 +
	KYL	<KFLGSH,0>		; 79 1
	KYL	<KFLGSH,0>		; 80 2
	KYL	<KFLGSH,0>		; 81 3
	KYL	<KFLGSH,0>		; 82 0
	KYL	<KFLGSH,0>		; 83 .

	DB	44 DUP(0)		;      Fill remainder of table
	PAGE
KEYPASS	DB	"Passing keys through to  STANDARD  keyboard handler. ",0
TRESPAS	DB	"Key pass-through not allowed from resident emulator. ",0
	PAGE
;
; KEYTAB contains one entry per each of 128 possible key scan codes for
;   each of 4 shift states currently allowed.  Each section of KEYTAB must
;   contain exactly 128 words (256 bytes) to preserve alignment throughout
;   the table.  An entry of zero is assumed to be a 'DEAD' key and enters
;   no code into the keyboard input buffer.  Non-zero key codes are entered
;   directly into the key ring with out interpretation.

KEYTAB	LABEL	WORD			; Main keyboard table entry (local)

KEYNORM	LABEL	BYTE			; Normal (unshifted) keyboard entrys

	DW	  0			;  0 Key zero (no such key?)
	DW	 27			;  1 ESC
	DW	"1"			;  2 1
	DW	"2"			;  3 2
	DW	"3"			;  4 3
	DW	"4"			;  5 4
	DW	"5"			;  6 5
	DW	"6"			;  7 6
	DW	"7"			;  8 7
	DW	"8"			;  9 8
	DW	"9"			; 10 9
	DW	"0"			; 11 0
	DW	"-"			; 12 -
	DW	"="			; 13 =
	DW	  8			; 14 Backspace
	DW	  9			; 15 Horizontal tab
	DW	"q"			; 16 q
	DW	"w"			; 17 w
	DW	"e"			; 18 e
	DW	"r"			; 19 r
	DW	"t"			; 20 t
	DW	"y"			; 21 y
	DW	"u"			; 22 u
	DW	"i"			; 23 i
	DW	"o"			; 24 o
	DW	"p"			; 25 p
	DW	"["			; 26 [
	DW	"]"			; 27 ]
	DW	 13			; 28 Carriage return
	DW	  0			; ** Control key
	DW	"a"			; 30 a
	DW	"s"			; 31 s
	DW	"d"			; 32 d
	DW	"f"			; 33 f
	DW	"g"			; 34 g
	DW	"h"			; 35 h
	DW	"j"			; 36 j
	DW	"k"			; 37 k
	DW	"l"			; 38 l
	DW	";"			; 39 ;
	DW	"'"			; 40 ' Single quote
	DW	"`"			; 41 ` Accent
	DW	  0			; ** Left shift
	DW	"\"			; 43 \
	DW	"z"			; 44 z
	DW	"x"			; 45 x
	DW	"c"			; 46 c
	DW	"v"			; 47 v
	DW	"b"			; 48 b
	DW	"n"			; 49 n
	DW	"m"			; 50 m
	DW	","			; 51 , Comma
	DW	"."			; 52 . Period
	DW	"/"			; 53 /
	DW	  0			; ** Right shift
	DW	"*"			; 55 * (on PrtSc key)
	DW	  0			; ** Alt 
	DW	" "			; 57 Space
	DW	  0			; ** Caps lock
	DW	59*256			; 59 F1
	DW	60*256			; 60 F2
	DW	61*256			; 61 F3
	DW	62*256			; 62 F4
	DW	63*256			; 63 F5
	DW	64*256			; 64 F6
	DW	65*256			; 65 F7
	DW	66*256			; 66 F8
	DW	67*256			; 67 F9
	DW	68*256			; 68 F10
	DW	  0			; ** Num lock
	DW	  0			; ** Scroll lock
	DW	71*256			; 71 HOME
	DW	72*256			; 72 UP ARROW
	DW	73*256			; 73 PAGE UP
	DW	"-"			; 74 - (on numeric pad)
	DW	75*256			; 75 LEFT ARROW
	DW	  0			; 76 Dead key!
	DW	77*256			; 77 RIGHT ARROW
	DW	"+"			; 78 + (on numeric pad)
	DW	79*256			; 79 END
	DW	80*256			; 80 DOWN ARROW
	DW	81*256			; 81 PAGE DOWN
	DW	82*256			; 82 INSERT
	DW	83*256			; 83 DELETE

 	DW	44 DUP(0)		;      Fill remainder of table
	PAGE

KEYSHFT	LABEL	BYTE			; SHIFTED keyboard entrys

	DW	  0			;  0 Key zero (no such key?)
	DW	 27			;  1 ESC
	DW	"!"			;  2 !
	DW	"@"			;  3 @
	DW	"#"			;  4 #
	DW	"$"			;  5 $
	DW	"%"			;  6 %
	DW	"^"			;  7 ^
	DW	"&"			;  8 &
	DW	"*"			;  9 *
	DW	"("			; 10 (
	DW	")"			; 11 )
	DW	"_"			; 12 _ Underscore
	DW	"+"			; 13 +
	DW	  8			; 14 Backspace
	DW	15*256			; 15 Back tab
	DW	"Q"			; 16 Q
	DW	"W"			; 17 W
	DW	"E"			; 18 E
	DW	"R"			; 19 R
	DW	"T"			; 20 T
	DW	"Y"			; 21 Y
	DW	"U"			; 22 U
	DW	"I"			; 23 I
	DW	"O"			; 24 O
	DW	"P"			; 25 P
	DW	"{"			; 26 {
	DW	"}"			; 27 }
	DW	 13			; 28 Carriage return
	DW	  0			; ** Control key
	DW	"A"			; 30 A
	DW	"S"			; 31 S
	DW	"D"			; 32 D
	DW	"F"			; 33 F
	DW	"G"			; 34 G
	DW	"H"			; 35 H
	DW	"J"			; 36 J
	DW	"K"			; 37 K
	DW	"L"			; 38 L
	DW	":"			; 39 ;
	DW	'"'			; 40 " Double quote
	DW	"~"			; 41 ~ Tilde
	DW	  0			; ** Left shift
	DW	"|"			; 43 | Split vertical bar
	DW	"Z"			; 44 Z
	DW	"X"			; 45 X
	DW	"C"			; 46 C
	DW	"V"			; 47 V
	DW	"B"			; 48 B
	DW	"N"			; 49 N
	DW	"M"			; 50 M
	DW	"<"			; 51 < Less than
	DW	">"			; 52 > Greater than
	DW	"?"			; 53 ?
	DW	  0			; ** Right shift
	DW	  0			; ** Print screen function
	DW	  0			; ** Alt 
	DW	" "			; 57 Space
	DW	  0			; ** Caps lock
	DW	84*256			; 59 F1
	DW	85*256			; 60 F2
	DW	86*256			; 61 F3
	DW	87*256			; 62 F4
	DW	88*256			; 63 F5
	DW	89*256			; 64 F6
	DW	90*256			; 65 F7
	DW	91*256			; 66 F8
	DW	92*256			; 67 F9
	DW	93*256			; 68 F10
	DW	  0			; ** Num lock
	DW	  0			; ** Scroll lock
	DW	"7"			; 71 7 Numeric pad numbers
	DW	"8"			; 72 8 
	DW	"9"			; 73 9 
	DW	"-"			; 74 - 
	DW	"4"			; 75 4 
	DW	"5"			; 76 5 
	DW	"6"			; 77 6 
	DW	"+"			; 78 + 
	DW	"1"			; 79 1 
	DW	"2"			; 80 2 
	DW	"3"			; 81 3 
	DW	"0"			; 82 0 
	DW	"."			; 83 .

	DW	44 DUP(0)		;      Fill remainder of table
	PAGE

KEYALT	LABEL	BYTE			; Alternate keyboard entrys

	DW	  0			;  0 Key zero (no such key?)
	DW	  0			;  1 
	DW	120*256			;  3 1
	DW	121*256			;  3 2
	DW	122*256			;  4 3
	DW	123*256			;  5 4
	DW	124*256			;  6 5
	DW	125*256			;  7 6
	DW	126*256			;  8 7
	DW	127*256			;  9 8
	DW	128*256			; 10 9
	DW	129*256			; 11 0
	DW	130*256			; 12 -
	DW	131*256			; 13 =
	DW	 14*256			; 14 APL ON/OFF
	DW	 69*256			; 15 ALT TAB
	DW	 16*256			; 16 q
	DW	 17*256			; 17 w
	DW	 18*256			; 18 e
	DW	 19*256			; 19 r
	DW	 20*256			; 20 t
	DW	 21*256			; 21 y
	DW	 22*256			; 22 u
	DW	 23*256			; 23 i
	DW	 24*256			; 24 o
	DW	 25*256			; 25 p
	DW	 26*256			; 26 [
	DW	 27*256			; 27 ]
	DW	   0			; 28 
	DW	   0			; ** Control key
	DW	 30*256			; 30 a
	DW	 31*256			; 31 s
	DW	 32*256			; 32 d
	DW	 33*256			; 33 f
	DW	 34*256			; 34 g
	DW	 35*256			; 35 h
	DW	 36*256			; 36 j
	DW	 37*256			; 37 k
	DW	 38*256			; 38 l
	DW	 39*256			; 39 ;
	DW	 40*256			; 40 '
	DW	 41*256			; 41 `
	DW	   0			; ** Left shift
	DW	   0			; 43 
	DW	 44*256			; 44 z
	DW	 45*256			; 45 x
	DW	 46*256			; 46 c
	DW	 47*256			; 47 v
	DW	 48*256			; 48 b
	DW	 49*256			; 49 n
	DW	 50*256			; 50 m
	DW	 51*256			; 51 ,
	DW	 52*256			; 52 .
	DW	 53*256			; 53 /
	DW	   0			; ** Right shift
	DW	   0			; 55 
	DW	   0			; ** Alt 
	DW	" "			; 57 Space
	DW	   0			; ** Caps lock
	DW	104*256			; 59 F1
	DW	105*256			; 60 F2
	DW	106*256			; 61 F3
	DW	107*256			; 62 F4
	DW	108*256			; 63 F5
	DW	109*256			; 64 F6
	DW	110*256			; 65 F7
	DW	111*256			; 66 F8
	DW	112*256			; 67 F9
	DW	113*256			; 68 F10
	DW	  0			; ** Num lock
	DW	  0			; ** Scroll lock
	DW	  0			; 71   
	DW	  0			; 72
	DW	  0			; 73
	DW	  0			; 74
	DW	  0			; 75
	DW	  0			; 76   
	DW	  0			; 77
	DW	  0			; 78
	DW	  0			; 79   
	DW	  0			; 80
	DW	  0			; 81
	DW	  0			; 82   
	DW	  160*256		; 83   

	DW	44 DUP(0)		;      Fill remainder of table
	PAGE

KEYCTRL	LABEL	BYTE			; CONTROL keyboard entrys

	DW	  0			; No such key	
	DW	 27			; ESC
	DW	140*256			; 1
	DW	141*256			; 2
	DW	142*256			; 3
	DW	143*256			; 4
	DW	144*256			; 5
	DW	145*256			; 6
	DW	146*256			; 7
	DW	147*256			; 8
	DW	148*256			; 9
	DW	149*256			; 0
	DW	150*256			; -
	DW	151*256			; =
	DW	127			; DEL
	DW	0			;
	DW	 17+128			; Q CTRL-alpha like normal w/ 'parity'
	DW	 23+128			; W
	DW	  5+128			; E
	DW	 18+128			; R
	DW	 20+128			; T
	DW	 25+128			; Y
	DW	 21+128			; U
	DW	  9+128			; I
	DW	 15+128			; O
	DW	 10+128			; P
	DW	 27+128			; [
	DW	 29+128			; ]
	DW	 10			; CR
	DW	  0			; ** CTRL
	DW	  1+128			; A
	DW	 19+128			; S
	DW	  4+128			; D
	DW	  6+128			; F
	DW	  7+128			; G
	DW	  8+128			; H
	DW	 10+128			; J
	DW	 11+128			; K
	DW	 12+128			; L
	DW	  0			; ;
	DW	  0 			; '
	DW	  0			; `
	DW	  0			; ** Left shift
	DW	 28+128			; \
	DW	 26+128			; Z
	DW	 24+128			; X
	DW	  3+128			; C
	DW	 22+128			; V
	DW	  2+128			; B
	DW	 14+128			; N
	DW	 13+128			; M
	DW	  0			; ,
	DW	  0			; .
	DW	  0			; /
	DW	  0			; ** Right shift
	DW	114*256			; PrtSc
	DW	  0			; ** Alt
	DW	 " "			; Space
	DW	  0			; ** Caps lock
	DW	 94*256			; F1
	DW	 95*256			; F2
	DW	 96*256			; F3
	DW	 97*256			; F4
	DW	 98*256			; F5
	DW	 99*256			; F6
	DW  	100*256			; F7
	DW	101*256			; F8
	DW	102*256			; F9
	DW	103*256			; F10
	DW	  0			; ** Num lock
	DW	  0			; ** Scroll lock
	DW	119*256			; HOME
	DW	 13*256			; UP ARROW
	DW	132*256			; PgUp
	DW	  0			; -
	DW	115*256			; LEFT ARROW
	DW	  0			; 
	DW	116*256			; RIGHT ARROW
	DW	  0			; +
	DW	117*256			; End
	DW	 12*256			; DOWN ARROW
	DW	118*256			; PgDn
	DW	  0			; 
	DW	  0			;

	DW	44 DUP(0)		;    Fill remainder of table

DATA	ENDS
	PAGE
CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	PUBLIC	KYINSTL,KYRLSE	
	EXTRN	RINGROOM:NEAR,RINGIN:NEAR,RINGOUT:NEAR,RINGMT:NEAR
	EXTRN	MESSAGE:NEAR,UPDRST:NEAR

KYINSTL	PROC	NEAR			; Install keyboard interrupt handler
	PUSH	ES			; Point to interrupt vector area
	PUSH	DS			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX

	CLI				; No interrupts while vectors move!

	MOV	AX,BIOSSEG		; Get keyboard state variables
	MOV	DS,AX			;

	MOV	BL,BYTE PTR DS:[BIOSKFLG]; Get current key states for init
	MOV	BH,BYTE PTR DS:[BIOSSFLG];
	MOV	CL,BYTE PTR DS:[97H]	; Get the IBM KB_FLAG_2 byte	
	
	MOV	AX,DATA			; Point to internal data area
	MOV	DS,AX			;

	MOV	KFLG,BL			; Save the key states
	MOV	SSFLG,BH		;
	MOV	KB_LED_STAT,CL

	XOR	AX,AX			;
	MOV	ES,AX			;

	MOV	AX,WORD PTR ES:[(9*4)+0]; Low half, previous handler
	MOV	BX,WORD PTR ES:[(9*4)+2]; High half
	MOV	WORD PTR OKBVEC[0],AX	; Save it away
	MOV	WORD PTR OKBVEC[2],BX	;

	MOV	WORD PTR ES:[(9*4)+0],OFFSET KBINT ; Place new handler vector
	MOV	WORD PTR ES:[(9*4)+2],SEG    KBINT ;

	MOV	AX,WORD PTR ES:[(22*4)+0]; Low half, I/O call
	MOV	BX,WORD PTR ES:[(22*4)+2]; High half
	MOV	WORD PTR OKBSRV[0],AX	 ; Save it away
	MOV	WORD PTR OKBSRV[2],BX	 ;

	MOV	WORD PTR ES:[(22*4)+0],OFFSET KBSRV ; Keyboard I/O service
	MOV	WORD PTR ES:[(22*4)+2],SEG    KBSRV ;

	STI				; Allow interrupts

	POP	CX
	POP	BX			; Restore user's registers
	POP	AX			;
	POP	DS			;
	POP	ES			;
	RET				; And back to the caller.

KYINSTL	ENDP		
	PAGE
KYRLSE	PROC	NEAR			; Release keyboard interrupt
	PUSH	ES			;
	PUSH	DS			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX

	MOV	AX,DATA			; Setup data segment for sure
	MOV	DS,AX			;

	CLI				; No interrupts while vector changes

	XOR	AX,AX			; Point to vector segment
	MOV	ES,AX			;

	MOV	AX,WORD PTR OKBVEC[0]	; Get previous vector
	MOV	BX,WORD PTR OKBVEC[2]	;
	MOV	WORD PTR ES:[(9*4)+0],AX; Put it back where we found it.
	MOV	WORD PTR ES:[(9*4)+2],BX;

	MOV	AX,WORD PTR OKBSRV[0]	; Previous I/O driver vector
	MOV	BX,WORD PTR OKBSRV[2]	;
	MOV	WORD PTR ES:[(22*4)+0],AX
	MOV	WORD PTR ES:[(22*4)+2],BX

	MOV	BL,KFLG			; Pass on the current keyboard state
	MOV	BH,SSFLG		;
	MOV	CL,KB_LED_STAT

	MOV	AX,BIOSSEG		; Point to BIOS internal data area
	MOV	DS,AX			;

	MOV	BYTE PTR DS:[BIOSKFLG],BL; Update BIOS information
	MOV	BYTE PTR DS:[BIOSSFLG],BH;

	CMP	ATFLAG,0FFH
	JNE	RLS1			; Jump if not PC/AT
	MOV	BYTE PTR DS:[97H],CL

RLS1:	STI				; Re-enable interrupts

	POP	CX
	POP	BX			; Restore user's registers
	POP	AX			;
	POP	DS			;
	POP	ES			;
	RET				;

KYRLSE	ENDP
	PAGE
KEYBEEP	PROC	NEAR			; Keyboard overrun beeper
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX			;

	MOV	BX,128			; Duration of beep (~ .1 second)

	IN	AL,KBCTL		; Keyboard control port
	PUSH	AX			; Status save

BEE0:	AND	AL,0FCH			; Turn off timer & spkr gating
	OUT	KBCTL,AL		;

	MOV	CX,72			; Pitch magic constant
BEE1:	LOOP	BEE1			; Half cycle one

	OR	AL,2			; Turn on speaker
	OUT	KBCTL,AL		;

	MOV	CX,72			; 
BEE2:	LOOP	BEE2			; Half cycle two

	DEC	BX			; One less cycle to do
	JNZ	BEE0			; Do more cycles...

	POP	AX			; Restore keyboard status
	OUT	KBCTL,AL		;

	POP	CX			; Restore user's registers
	POP	BX			;
	POP	AX			;
	RET				; End of BEEEEEEEP!

KEYBEEP	ENDP 
	PAGE
KBSRV	PROC	FAR			; User keyboard service access
	STI				; Allow interrupt service...

	PUSH	DS			; Save a few neccessary registers
	PUSH	DI			;
	PUSH	DX			;
	PUSH	CX			;
	PUSH	BX			;

	MOV	BX,DATA			; Set up DATA segment
	MOV	DS,BX			;

	PUSH	AX			; Do not disturb during superman check

	TEST	SUPKEY,0FFH		; Is this a SUPER time?
	JZ	NOMAN			; No, superman not availible now.

	MOV	SUPKEY,0		; We are doing it. Turn off the req.

	TEST	RESFLG,0FFH		; Is the SUPERKEY! feature disallowed
	JZ	MAN			; Because of residency? Jump if NO.

	MOV	SI,OFFSET TRESPAS	; No passthrough availible
	MOV	DI,LSADDR		; On the status line, if you please.
	CALL	MESSAGE			;
	JMP	SHORT NOMAN		;

MAN:	CALL	KYRLSE			; Allow the normal DOS handler keys

	MOV	SI,OFFSET KEYPASS	; Pass-through key message
	MOV	DI,LSADDR		;
	CALL	MESSAGE			; Say hello!

	MOV	AH,7			; DOS get key w/o echo
	INT	21H			;

	CALL	KYINSTL			; Put the keyboard handler back

NOMAN:	POP	AX			; Restore command

	CMP	AH,2+1			; See if call number too large
	JB	KBS1			; Not too big, continue

KBS0:	POP	BX			; Bogus call
	POP	CX			; Get the heck out of Dodge
	POP	DX			;
	POP	DI			;
	POP	DS			;
	IRET				; Back with no changes...

KBS1:	OR	AH,AH			; Test for ZERO
	JZ	KBREAD			; Read request w/ wait

	DEC	AH			; Test for ONE
	JZ	KBTEST			; Check for character waiting

	DEC	AH			; Test for TWO
	JZ	KBSHFT			; Return current shift status

	JMP	KBS0			; Should never get here...
	PAGE
; Read keystroke from buffer, wait if none availible

KBREAD:	CMP	ATFLAG,0FFH		; Is this an IBM PC/AT
	JNE	KBR0			; Jump if not PC/AT

	CALL	GET_LED_STATE		; Get the info about which bits are on

	MOV	DL,KB_LED_STAT
	XOR	DL,AL
	AND	DL,LED_BITS
	JZ	KBR0
	CALL	UPDATE_LEDS

KBR0:	MOV	DI,OFFSET KEYBUF	; Point to keyring

KBRD0:	CALL	RINGOUT			; Try to get a key
	JNC	KBRD0			; Until one appears...

	MOV	AH,AL			; Save the first byte

KBRD1:	CALL	RINGOUT			; Wait for the second byte to show up
	JNC	KBRD1			;

	XCHG	AH,AL			; Position the bytes as needed.

	JMP	KBS0			; Use the easy return route.

; Return shift status bits from KFLG

KBSHFT:	MOV	AL,KFLG			; Get the shift flag state
	JMP	KBS0			; And exit the easy way

; Test for keys in buffer.

KBTEST:	CLI				; No interrupts during look ahead!

	MOV	DI,OFFSET KEYBUF	; See if characters await!

	PUSH	KEYBUF[0]		; Save input & output pointers
	PUSH	KEYBUF[2]		;

	CALL	RINGOUT			; Get low byte
	JNC	KBT1			; Not enough data in the ring!
	MOV	AH,AL			; 

	CALL	RINGOUT			; Get high byte
	JNC	KBT1			;
	XCHG	AH,AL			; Put them in normal positions

KBT0:	OR	AX,AX			; Set the flags...
	POP	KEYBUF[2]		; Restore ring pointers to usual 
	POP	KEYBUF[0]		;

	STI				; Allow interrupts again

	POP	BX			; Restore registers
	POP	CX			;
	POP	DX			;
	POP	DI			;
	POP	DS			;

	RET	2			; Return w/o restoring flags...

KBT1:	XOR	AX,AX			; Zero with no look ahead!
	JMP	KBT0			; And exit w/ flags intact

KBSRV	ENDP
	PAGE
KBINT	PROC	FAR			; Keyboard interrupt service code
	STI				; Allow other device interrupts
	PUSH	BP			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;
	PUSH	SI			;
	PUSH	DI			;
	PUSH	DS			;
	PUSH	ES			;

	CLD

	MOV	BX,DATA			; Point to local data segment
	MOV	DS,BX			;

	CMP	ATFLAG,0FFH		; Is this an AT PC
	JE	ATKBINT			; Jump If IBM PC AT
	JMP	KBINT1

ATKBINT:
	MOV	AL,DISABLE_KBD
	CALL	SEND_TO_KBD_CONTROL_PORT

	CALL	WAITKBD		; Wait for the keyboard busy status to clear

	IN	AL,KBDATA
	STI

	CMP	AL,RESEND_REQ
	MOV	AH,KB_RESEND
	JZ	ATKBD1

	CMP	AL,ACK_KBD
	MOV	AH,KB_ACK_REC
	JNZ	ATKBD2

ATKBD1:	CLI
	OR	KB_LED_STAT,AH
	JMP	KBIXIT

ATKBD2:	PUSH	AX
	CALL	GET_LED_STATE

	MOV	DL,KB_LED_STAT
	XOR	DL,AL
	AND	DL,LED_BITS
	JZ	SKIP_UPDATE
	CALL	UPDATE_LEDS

SKIP_UPDATE:	
	POP	AX
	MOV	AH,AL

	CMP	AL,0FFH
	JE	AT1
	JMP	KBI0

AT1:	CALL	KEYBEEP
	JMP	KBIXIT

	PAGE
KBINT1:	IN	AL,KBDATA		; Get the character
	PUSH 	AX			; Save the keycode (AL)

	IN	AL,KBCTL		; Reset the keyboard ready
	MOV	AH,AL			; Save current state
	OR	AL,80H			; Keyboard reset bit
	OUT	KBCTL,AL		;
	XCHG	AH,AL			; Restore previous state
	OUT	KBCTL,AL		;

	POP	AX			; Restore keycode to AL
	MOV	AH,AL			; Make a local copy...

	CMP	AL,0FFH			; Has the keyboard been OVERRUN?
	JNE	KBI0			; No, skip the beeper

	CALL	KEYBEEP			; Sound the Alarums!!
	JMP	KBIXIT			; And punt!

KBI0:	MOV	DL,AL			; Save another copy of the key
	AND	AL,07FH			; Remove the key^up bit

	CMP	AH,80H			; Is this a key going up?
	JAE	KBI3B			; Yes, skip special key search

	TEST	SSFLG,SFLGHH		; Are we holding?
	JZ	KBI2			; No, continue normal process

	CMP	AL,BYTE PTR KYSHOLD[0]	; See if this is the stop key again
	JNZ	KBI1			; Yes, punt!
	JMP	KBIXIT			;

KBI1:	AND	SSFLG,NOT SFLGHH	; Turn off the hold bit
	JMP	KBIXIT			; 

KBI2:	MOV	CX,SPECKEYS		; Special control key templates
	MOV	DI,0			;
	
	MOV	AH,KFLG			; Get current shift state
	AND	AH,0FH			; Ignoring shift lock things

	MOV	BL,KYASHF		; Process shift key alias
	TEST	AH,BL			; Is the alternate shift active?
	JZ	KBI3			; No, skip the transfer of the bit

	NOT	BL			; Turn off the aliased bit
	AND	AH,BL			;
	OR	AH,KFLGSH		; Turn on the real shift bit...

KBI3:	CMP	AX,KYS[DI]		; See if the template matches
	JNE	KBI3A			; No, continue search
	JMP	KSPEC			; Yes, special key process required

KBI3A:	ADD	DI,2			; Increment word pointer
	LOOP	KBI3			; Test the next template

KBI3B:	XCHG	AH,DL			; Restore key w/ up/dn bit

	MOV	DI,0 			; Scan control selection table
	MOV	CX,SHIFTKEYS*2		; Seven key types, 2 keys each

KBI3C:	CMP	AL,KYC[DI]		; Is this the special key?
	JNE	KBI3D			;

	CALL	KSHIFT			; Process the shift key
	JMP	KBI3D1			; Then continue onward.

KBI3D:	INC	DI			; Point to next key entry
	LOOP	KBI3C			; Until no more specials to check

KBI3D1:	CMP	AH,80H			; Is the key going up?
	JNAE	KBI3E			; No, continue
	JMP	KBIXIT			; Yes, no further interest...

KBI3E:	XCHG	AH,DL			; Get shift status back
	PUSH	AX			; Save the key code

	MOV	BL,AL			; Get the shift control byte for key
	XOR	BH,BH			;
	MOV	BL,KEYLOCK[BX]		;

	TEST	KFLG,KFLGNL		; Is numeric lock on?
	JNZ	KBI4			; Yes, allow numeric shifts

	AND	BL,00FH			; Remove NUMLOCK toggle bits

KBI4:	TEST	KFLG,KFLGCL		; Is CAPS lock on?
	JNZ	KBI5			; Yes, allow CAPS shifts

	AND	BL,0F0H			; Remove CAPSLOCK toggle bits

KBI5:	MOV	BH,BL			; Save a copy of the bits
	MOV	CL,4			;
	SHR	BH,CL			; Move NUMLOCK bits over the CAPSLOCK
	OR	BL,BH			; Superimpose lock bits
	AND	BL,0FH			; Remove extra bits...

	XOR	BL,AH			; AH contains active shift bits
	AND	BL,0FH			; Remove extra locks etc.
	XOR	BH,BH			; Make full index to KYPRECD

	MOV	BH,KYPRECD[BX]		; Get new shift state from table

	POP	AX			; Get key scan code back...
	SHL	AL,1			; Convert to word offset
	MOV	BL,AL			; As a full pointer to keytable

	MOV	BX,KEYTAB[BX]		; Get keycode word from keytables
	OR	BX,BX			; Is this an empty entry (0)?
	JZ	KBIXIT			; Yes, do not put it in the ring!

	PUSH	BX			; Save the key code
	
	MOV	DI,OFFSET KEYBUF	; Point to the keyboard buffer
	CALL	RINGROOM		; Is there room in the in?
	CMP	AX,2			;
	JAE	KBI10			; Yes, skip the complaint

	CALL	KEYBEEP			; Complain and drop key.
	POP	BX			;
	JMP	KBIXIT			; Then exit for more keys...

KBI10:	POP	AX			; Put the characters away
	CALL	RINGIN			; This 'should not' error out...
	XCHG	AH,AL			; Put second byte in place
	CALL	RINGIN			; Ignore errors.

KBIXIT:	CLI				; Do not allow keyboard ints during
					;   last stage of keyint service...
	MOV	AL,20H			; Non-specific EOI 
	OUT	ICTL,AL			; 

KBQXT:	CMP	ATFLAG,0FFH		; Is this an IBM PC/AT [1.32]
	JNE	KBQXT1			; Jump if not a PC/AT [1.32]

	MOV	AL,ENABLE_KBD
	CALL	SEND_TO_KBD_CONTROL_PORT

KBQXT1:	CLI				; [1.32]
	POP	ES			; Restore main process registers
	POP	DS			;
	POP	DI			;
	POP	SI			;
	POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	AX			;
	POP	BP			;
	IRET				; And leave!
	PAGE
; KSHIFT/KSPEC vector table operations.  Action routines on following pages.
;   KSHIFT routines exit with a NEAR RETURN.  KSPEC routines exit as needed
;   for functionality.  Shift keys can generate application scan codes as
;   well as affecting keyboard state while special keys cannot.
;   An example of a shift class key which generates a scan code is the 
;   INS key which toggles the insert state bit as well as making scan code
;   82*256.

KSHIFT	PROC	NEAR			; Subroutine to modify shift states
	PUSH	AX			; Save key codes

	AND	DI,NOT 1		; Force DI to even address
	MOV	BX,KYCJTAB[DI]		; Get shift key service address
	JMP	BX			; Go to it!

; Simple key up/dn shift operations

CSHIFT:	MOV	AL,KFLGSH		; Select ALPHA shift bit
	JMP	SHORT CXXSH		; General purpose shift handler

CNUSHF:	MOV	AL,KFLGNU		; Select NUMERIC shift bit
	JMP	SHORT CXXSH		;

CCTRL:	MOV	AL,KFLGCT		; Select CONTROL shift bit
	JMP	SHORT CXXSH		;

CALT:	MOV	AL,KFLGAL		; Select ALTERNATE shift bit
	
CXXSH:	TEST	AH,80H			; Is this key going up?
	JNZ	CXXUP			; Yes, turn off the shift bit

	OR	KFLG,AL			; New shift key down...
	JMP	KSHXIT

CXXUP:	NOT	AL			; Old shift key up
	AND	KFLG,AL
	JMP	KSHXIT

; Alternating action keys 

CCAPS:	MOV	AL,KFLGCL		; Select CAPS LOCK bit
	JMP	SHORT CXXLK		; General purpose alternate action

CNUM:	MOV	AL,KFLGNL		; Select NUM LOCK bit
	JMP	SHORT CXXLK		;

CSCRL:	MOV	AL,KFLGSC		; Select SCROLL LOCK bit
	JMP	SHORT CXXLK		;

CINS:	MOV	AL,KFLGIN		; Select INSERT toggle bit

CXXLK:	TEST	AH,80H			; Is this key going up?
	JNZ	CLKUP			; Yes, fix activity flag

	MOV	AH,AL			; Save a copy of the bit
	AND	AL,SSFLG		; Remove other shift toggle bits
	JZ	CXXND			; We have found a new downer...
	JMP	SHORT KSHXIT		;
	
CXXND:	OR	SSFLG,AH		; Set the key down bit
	XOR	KFLG,AH			; Toggle the lock state

	CMP	ERICKEY,1
	JE	K_ERICSSON		; Ericsson PC
	CMP	ALTMOD2,1
	JNE	SHORT KSHXIT

; Olivetti AT&T PC LED fix
	MOV	AL,1
	CMP	AH,40H
	JE	K_LED			; CAPS LOCK TOGGLE
	MOV	AL,2
	CMP	AH,20H			; NUM LOCK TOGGLE
	JE	K_LED
	JMP	SHORT KSHXIT

K_LED:	AND	AH,KFLG
	JE	K_LED1
	XOR	AL,80H
K_LED1:	TEST	BYTE PTR SSFLG,01  ;If dlx kbd #2
	JZ	K_STAND
	TEST	AL,2		;if num lock
	JZ	K_STAND
	XOR	AL,80H		;Deluxe keyboard 2
K_STAND: PUSH	AX
K_LED4:	IN	AL,KBD_STATUS
	TEST	AL,10B
	JNZ	K_LED4
	MOV	AL,13H
	OUT	KBDATA,AL
K_LED6:	IN	AL,KBD_STATUS
	TEST	AL,10B
	JNZ	K_LED6
	POP	AX
	OUT	KBDATA,AL
	JMP	SHORT KSHXIT
		
K_ERICSSON:
	CLI
	PUSH	DS
	MOV	AL,KFLG		;Transfer keyboard shift info
	PUSH	AX
	MOV	AX,BIOSSEG	;Point to BIOS ram
	MOV	DS,AX
	POP	AX
	MOV	BYTE PTR DS:[BIOSKFLG],AL ;update ram
	POP	DS
	STI
	JMP	SHORT KSHXIT

CLKUP:	NOT	AL			; Turn bit into bit mask
	AND	SSFLG,AL		; Turn off key down flag bit
	JMP	SHORT KSHXIT

KSHXIT:	POP	AX			; Restore keyboard scan code
	RET				;

KSHIFT	ENDP				; End of shift type operations
	PAGE
; Special class keys do not generate application scan codes and may
;   change machine state drastically.  Each routine exits as appropriate.

KSPEC:	AND	DI,NOT 1		; This should not be needed...
	MOV	BX,KYSJTAB[DI]		; Special key service address
	JMP	BX			; Go to it!

SUPERK: MOV	SUPKEY,1		; Set the superkey process flag
	JMP	KBIXIT			; And let go of the interrupt.


; Break key process

SBRK:	MOV	KEYBUF[0],0		; Empty the keyboard buffer
	MOV	KEYBUF[2],0		; By setting pointers equal

	PUSH	ES			; Set BIOS BREAK flag
	MOV	AX,BIOSSEG		;
	MOV	ES,AX			;
	MOV	BYTE PTR ES:[BIOSBRK],80H
	POP	ES			;

	INT	1BH			; Execute users interrupt code

	JMP	KBIXIT			; 

; Hold key process

SHOLD:	OR	SSFLG,SFLGHH		; Set the machine holding bit

	MOV	AL,20H			; Allow other interrupts
	OUT	ICTL,AL			; Non-specific EOI

HOLDIT:	TEST	SSFLG,SFLGHH		; Stay here until a non-hold key
	JNZ	HOLDIT			; Tiny little tight loop...

	JMP	KBQXT			; Exit w/o interrupt enable

; Reset key process

SREST:	MOV	AX,BIOSSEG		; Set BIOS RESET FLAG
	MOV	ES,AX			;
	MOV	WORD PTR ES:[BIOSRFG],1234H ; Magic constant

	XOR	AX,AX			; Setup the registers for a reset
	MOV	ES,AX			;
	MOV	SS,AX			;
	MOV	DS,AX			;

	PUSH	AX			; Push a zero flag word
	DEC	AX			; Push a minus one (FFFFH) segment
	PUSH	AX			; for CS
	PUSH	DS			; Push a zero for IP
	IRET				; Return through top of memory

; Print screen request

SPRNT:	MOV	AL,20H			; Allow other interrupts while print
	OUT	ICTL,AL			;

	INT	5H			; Screen print function call
	JMP	KBQXT			; Exit & continue...

KBINT	ENDP

SEND_TO_KBD_CONTROL_PORT	PROC	NEAR

	PUSH	AX
	CLI
	CALL	WAITKBD		; Wait for the keyboard busy status to clear
	POP	AX
	OUT	KBD_STATUS,AL
	STI
	RET

SEND_TO_KBD_CONTROL_PORT	ENDP

WAITKBD	PROC	NEAR

	XOR	CX,CX
WAIT1:	IN	AL,KBD_STATUS
	TEST	AL,KBD_BUF_FULL
	LOOPNZ	WAIT1
	RET

WAITKBD	ENDP

GET_LED_STATE	PROC	NEAR

	PUSH	CX
	MOV	AL,KFLG
	AND	AL,KFLG_LED_BITS 
	MOV	CL,4
	ROL	AL,CL
	AND	AL,LED_BITS
	POP	CX
	RET

GET_LED_STATE	ENDP

UPDATE_LEDS	PROC	NEAR

	CLI
	TEST	AL,UPDATE_IN_PROGRESS
	JNZ	NO_UPDATE
	
	OR	AL,UPDATE_IN_PROGRESS
	MOV	AL,END_OF_INTERRUPT
	OUT	ICTL,AL

UPDL1:	MOV	AL,SET_RESET_CMD
	CALL	SEND_DATA_TO_KBD

	CLI
	CALL	GET_LED_STATE
	AND	KB_LED_STAT,NOT(LED_BITS)
	OR	KB_LED_STAT,AL

	TEST	KB_LED_STAT,KBD_ERROR_FLAG
	JNZ	ERROR_DETECTED

	CALL	SEND_DATA_TO_KBD
	CLI

	TEST	KB_LED_STAT,KBD_ERROR_FLAG
	JZ	NO_ERROR

ERROR_DETECTED:
	
	MOV	AL,KBD_ENABLE_CMD
	CALL	SEND_DATA_TO_KBD

	CLI

NO_ERROR:
	AND	KB_LED_STAT,NOT(UPDATE_IN_PROGRESS+KBD_ERROR_FLAG)

NO_UPDATE:
	STI
	RET

UPDATE_LEDS	ENDP

SEND_DATA_TO_KBD	PROC	NEAR

	PUSH	BX
	PUSH	AX
	PUSH	CX

	MOV	BL,AL		; Save away the byte to transmit
	MOV	BH,RETRY_COUNT	; Counter to keep track of retries
SEND1:	CLI			; Disable interrupts before sending byte out
	AND	KB_LED_STAT,NOT(KB_ACK_REC+KB_RESEND)
	CALL	WAITKBD		; Wait for the keyboard busy status to clear
	MOV	AL,BL		; Restore the byte to send to the keyboard
	OUT	KBDATA,AL
	STI			; Turn on the interrupts again
	
	MOV	CX,1A00H	; This is a timer which will wait 10+ ms
TIMER:	TEST	KB_LED_STAT,KB_ACK_REC+KB_RESEND
	JNZ	EXIT_TIMER_LOOP
	LOOP	TIMER

SEND2:	DEC	BH
	JNZ	SEND1

	OR	KB_LED_STAT,KBD_ERROR_FLAG	; Retries failed ... quit
	JMP	XIT_SEND_DATA

EXIT_TIMER_LOOP:
	TEST	KB_LED_STAT,KB_ACK_REC
	JZ	SEND2				; Was not ACK GO RETRY

XIT_SEND_DATA:
	
	POP	CX
	POP	AX
	POP	BX
	RET

SEND_DATA_TO_KBD	ENDP

UPDATE_LEDS_1	PROC	NEAR

	CLI
	TEST	KB_LED_STAT,UPDATE_IN_PROGRESS
	JZ	UL1

	STI
	RET

UL1:	OR	KB_LED_STAT,UPDATE_IN_PROGRESS
	JMP	UPDL1

UPDATE_LEDS_1	ENDP

CODE	ENDS

	END
