	NAME	INKEY
	INCLUDE	PAGESIZE.INC
	TITLE	INKEY - Get keystroke to AX, BIOSKY BIOS keyboard entry
; 3-20-85  kbd Added INT 16 passthrough option
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	OKBD:DWORD,	COMCLIK:BYTE,	COMCODE:WORD
	EXTRN	SFKPRES:BYTE,	SFKEYS:BYTE,	LINOFF:WORD	
	EXTRN	SFKBUF:BYTE,	A_INT16:BYTE,	A4SCANC:BYTE
DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	CLICK:NEAR,	GCSTAT:NEAR,	GETCOM:NEAR

	PUBLIC	INKEY
INKEY	PROC	NEAR	
	MOV	AH,1		; Test to see if a key is waiting
	INT	16H		; BIOS keyboard call

	JZ	INK0		; No keys today

	MOV	AH,0		; Get the key
	INT	16H		; BIOS keyboard call

	CMP	A_INT16,1	; Is the INT 16 passthrough allowed
	JNE	INKXCL		; Jump if not

	PUSH	AX		; Save the key
	AND	AL,7Fh		; Remove the control offset bias inserted by e78 
	CMP	AL,A4SCANC	; Set flags for the decision
	POP	AX		; Restore the original key
	JNE	SHORT INKXCL
	MOV	A_INT16+1,1	; Signal hot-shift

INKXCL:	CALL	CLICK		; Make a rude noise if IBM says to.

INKXQQ:	STC			; Set success flag
	RET			;

INK0:	CMP	A_INT16,1
	JNE	INKMOD
	MOV	AH,1
	CALL	BIOSKY		;See if any alternate keys
	JZ	INKMOD
	MOV	AH,0
	CALL	BIOSKY		;Get the key
	CMP	AL,A4SCANC
	JNE	SHORT INKXQQ
	MOV	A_INT16+1,1	;Signal hot-shift
	JMP	SHORT INKXQQ

INKMOD:	MOV	AL,SFKPRES	; Is there a Shift Function key activated
	OR	AL,AL
	JNZ	INK02		; Jump if presently involved in sending out key

	CALL	CKSFKPR		; Check if a Shift Function Key was Pressed
	JC	INK0		; Jump for a new function key pressed
	JMP	INK10		; Check the COM1 port if not 
	
INK02:	XOR	AH,AH		; Zero the upper 8 bits
	DEC	AX		; Convert from ONE based to ZERO based
	MOV	CX,AX		; Put the ZERO based key # in CX
	JZ	INK04		; If Key zero don't loop

INK03:	ADD	AX,69		; Point to the correct key's data
	LOOP	INK03

INK04:	MOV	BX,AX		; Put Shift Key buffer Offset into BX

INK06:	MOV	CX,LINOFF	; Put offset into line in CX
	ADD	BX,CX		; Make the two offsets into one
	MOV	AL,SFKBUF[BX]	; Point to character in line
	OR	AL,AL		; Check for end of line
	JZ	INK07		; Jump if end
	INC	LINOFF		; increment offset counter
	CMP	LINOFF,70	; Have we reached MAX character count
	JG	INK07		; Jump if yes
	AND	AL,07FH
	MOV	BL,AL
	XOR	BH,BH
	SHL	BX,1
	MOV	AX,COMCODE[BX]
	OR	AX,AX
	JZ	INK10

	PUSH	CX
	MOV	CX,10000
SDLY:	LOOP	SDLY
	POP	CX

	JMP	INKXCL

INK07:	MOV	LINOFF,0
	XOR	BH,BH
	MOV	BL,SFKPRES
	DEC	BX
	SHL	BX,1
	MOV	BYTE PTR SFKEYS[BX],0
	MOV	BYTE PTR SFKPRES,0

INK10:	CALL	GCSTAT		; See if a communication character awaits..
	JZ	INK0A		; No characters, we strike out.

	CALL	GETCOM		; Get a COM1: character
	AND	AL,07FH		; Remove any paritys

	MOV	BL,AL		; Make as an array index
	XOR	BH,BH		; All 16 bits
	SHL	BX,1		; As a word offset
	MOV	AX,COMCODE[BX]	; Convert to internal scan codes...

	OR	AX,AX		; Is this a dummy?
	JZ	INK0A		; Yes, do not send it on...

	PUSH	CX		; Trial delay
	MOV	CX,10000	; Some fairly long time
DLY:	LOOP	DLY		;
	POP	CX		;

	CMP	COMCLIK,0	; Is the clicker enabled for COM1 strokes?
	JZ	INKXQX		; No if zero

	JMP	INKXCL		; Yes if non-zero
INKXQX:	JMP	INKXQQ

INK0A:	CLC			; Set failure flag
	RET

INKEY	ENDP

CKSFKPR	PROC	NEAR	; Check if a Shift Function Key was pressed

	XOR	BX,BX		; Zero the index pointer
CKSF1:	MOV	AL,SFKEYS[BX]	; Load the key pressed flag byte
	OR	AL,AL
	JNZ	CKSF5		; Jump if key is pressed
	INC	BX
	INC	BX		; Point to the next flag byte
	CMP	BX,20
	JL	CKSF1
	MOV	SFKPRES,0	; No keys pressed
	MOV	LINOFF,0	; No offset either
	CLC			; No carry = no new SFK
	RET

CKSF5:	SAR	BX,1		; Divide by 2
	INC	BX		; Make BX ONE based rather than ZERO based
	MOV	SFKPRES,BL	; Since BX <= 20 BL is everything
	MOV	LINOFF,0	; Start off with a fresh offset
	STC			; Set carry to indicate new SFK pressed
	RET

CKSFKPR	ENDP


	PAGE
	PUBLIC	BIOSKY
BIOSKY	PROC	NEAR
	PUSHF			; Simulate an interrupt 
	CALL	OKBD		; Run through saved vector
	RET			;
BIOSKY	ENDP			;

CODE	ENDS

	END
