	NAME	EXITS
	INCLUDE PAGESIZE.INC
	TITLE	.EXITS - Exit processing
;  4-29-85  Hercules support
; 12-12-84  MicroPhonics support
; 11-30-84  exit indicator added
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	SLVERR:BYTE,	PRVATR:BYTE,	OPSC:DWORD,	FCB0:BYTE
	EXTRN	NOFILE:BYTE,	RESFLG:BYTE,	LSADDR:WORD,	OTICK:DWORD
	EXTRN	COMRUN:BYTE,	RESQIK:BYTE,	ALTEXIT:BYTE
	EXTRN	A_INT16:BYTE
	EXTRN	HEPAGE1:BYTE	;[KA]
DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	INKEY:NEAR,	BIOSKY:NEAR,	BEEP:NEAR,	PUTCH:NEAR
	EXTRN	CACHEOUT:NEAR,	PUTDSK:NEAR,	KYRLSE:NEAR,	COMKILL:NEAR

	PUBLIC	EXKCHK
EXKCHK	PROC	NEAR
	CMP	SLVERR,0	; Is the slave Ok?
	JZ	EXK10		; Yes, skip the message setup

	MOV	BL,SLVERR	; Make a pointer to the message
	AND	BL,127		; Remove non-fatal control bit (128)
	XOR	BH,BH		; Sixteen bits, word offset
	SHL	BX,1		;

	MOV	DI,LSADDR	; Status line (Beginning of...)
	MOV	SI,ERMES[BX]	;   Error message
	CALL	MESSAGE		;     Send the word

	CALL	BEEP		; Wake up the user

	CMP	SLVERR,SE$RR	; This is the only thing RESQIK affects
	JNE	EXK0		; Skip RESQIK check

	CMP	RESQIK,0	; See if this is a QUICK exit
	JNE	EXK1		;

EXK0:	MOV	SI,OFFSET PRESSK
	CALL	MESSAGE		; Press ESC to continue

PKL:	CALL	INKEY		; Wait for the keyboard...
	JNC	PKL		;

	CMP	AL,27		; ASCII ESCAPE
	JNZ	PKL		;

EXK1:	TEST	SLVERR,128	; Is this a nonfatal error?
	JZ	EXK20		; No, exit request path

	MOV	SLVERR,0	; Clear non-fatal error

EXK10:	MOV	AH,2		; Test for both shift keys pressed
	INT	16H		; BIOS keyboard call

	AND	AL,1011B	; [KA] check for Alt+Shift+Shift
	CMP	AL,1011B	; [KA]
	JNZ	EXK12		; [KA]
	MOV	HEPAGE1,1	; [KA] switch to Hercules Page 1
EXK12:				; [KA]

	AND	AL,11B		; Right and left shift key MASK
	CMP	AL,11B		;                          TEST
	JZ	EXK20		; A match, time to go

	CMP	A_INT16,1	; MicroPhonics flag
	JNE	EXK14
	CMP	A_INT16+1,1	; check flag for exit =1
	JNE	EXK14
	MOV	A_INT16+1,00	; clear exit flag
	JMP	SHORT EXK22
EXK14:	CLC			; Not time to exit
	RET			;

EXK20:	CALL	WAITK		; Wait for release

EXK22:	STC			; Exit request
	RET			;

EXKCHK	ENDP

	PUBLIC	WAITK		; Wait for both shift keys to be released
WAITK	PROC	NEAR
WK0:	MOV	AH,2		; Get shift key status
	INT	16H		; Raw keyboard handler

	AND	AL,11B		;
	CMP	AL,11B		; Low order shift bits
	JZ	WK0		; Loop until one or both keys released
	RET			; 
WAITK	ENDP

	PUBLIC	QEXKY
QEXKY	PROC	NEAR		; Return zero if exit key sequence pending, else, nz
	MOV	AH,2		; Get shift key status
	INT	16H
	AND	AL,11B		; Mask to only left and right shift keys
	CMP	AL,11B		; Are both down? Zero if yes.
	RET
QEXKY	ENDP

	PAGE
	PUBLIC	MESSAGE
MESSAGE	PROC	NEAR
	CMP	RESQIK,0	; Is the screen dead?
	JE	SCROK		; No, screen is Ok

	MOV	DL,[SI]		; Get a character to go.
	OR	DL,DL		;
	JZ	MS0A		; Last character has been done

	PUSH	SI		; DOS pchar
	MOV	AH,2		;
	INT	21H		;
	POP	SI		;

	INC	SI		; Point to next character
	JMP	MESSAGE		; And do it again!

SCROK:	SHL	DI,1		; Make screen word offset

MS0:	MOV	CL,[SI]		; Get a byte from the message
	MOV	CH,PRVATR	; Get default screen attribute
	OR	CH,8		; Turn on the bright bit
	INC	SI		; Point to next just in case

	CMP	CL,0		; Is this the end?
	JZ	MS10		; Yes, do not continue

	CALL	PUTCH		; Put the character on the screen

	JMP	SHORT MS0	; Put another character on the screen

MS10:	SHR	DI,1		; Put the destination offset back

MS0A:	RET			; And exit

MESSAGE	ENDP

	PUBLIC	EXIT
EXIT	PROC	NEAR
	CMP	RESQIK,0	; Is this a quick exit?
	JNE	QRS		; No, do normal exit stuff

	MOV	ALTEXIT,1	; indicate that exit in progress
	CALL	CACHEOUT	; Restore previous screen state

QRS:	XOR	AX,AX		; Make a segment for page zero ints
	MOV	ES,AX		;

	CLI			; Turn off interrupts during INT clear
	
	MOV	BX,WORD PTR OPSC[0] ; Get old value of PRINTSC interrupt
	MOV	CX,WORD PTR OPSC[2]
	MOV	ES:WORD PTR (5*4),BX ; Set it back
	MOV	ES:WORD PTR (5*4+2),CX

	MOV	BX,WORD PTR OTICK[0] ; Get old value of CLOCK TICK
	MOV	CX,WORD PTR OTICK[2]
	MOV	ES:WORD PTR (1CH*4),BX
	MOV	ES:WORD PTR (1CH*4+2),CX

	STI			; Allow normal interrupts

	TEST	NOFILE,1	; Is there a file open?
	JNZ	NOF		; No, skip the close

	MOV	AL,1AH		; Put an end-of-file mark on the file
	CALL	PUTDSK		; Put the character on the disk

	MOV	AH,10H		; DOS file close
	MOV	DX,OFFSET FCB0	; Main file control block
	INT	21H		; DOS function call

NOF:	MOV	NOFILE,1	; Turn off the file!

	MOV	RESQIK,0	; Turn off super-resident flag

	CALL	KYRLSE		; Turn off extended keyboard handler

	CMP	COMRUN,0	; Is there a communication drive running?
	JZ	NONCOM		; No, do not turn one off!

	CALL	COMKILL		; Remove COM1: interrupt service routine

NONCOM:	RET

EXIT	ENDP

CODE	ENDS
	PAGE
DATA	SEGMENT PUBLIC BYTE

	PUBLIC	ERMES
ERMES	LABEL	WORD
	DW	OFFSET NOERR
	DW	OFFSET SETO$
	DW	OFFSET SEBF$
	DW	OFFSET SEWE$
	DW	OFFSET SEID$
	DW	OFFSET SERR$
	DW	OFFSET NFND$
	DW	OFFSET NFRS$
	DW	OFFSET NFAR$
	DW	OFFSET SEN2$
	DW	OFFSET SEMEM$

NOERR	DB	0			;   0 - No error
SETO$	DB	"IRMA failed to respond to emulator request. ",0
SEBF$	DB	"Unable to open screen save file. ",0
SEWE$	DB	"Error while attempting to save screen image. ",0
SEID$	DB	"IRMA is busy for too long. ",0
SERR$	DB	"E78 becoming resident. ",0
NFND$	DB	"No SCREEN SAVE file in use. ",0
NFRS$	DB	"SCREEN SAVE not allowed from resident emulator. ",0
NFAR$	DB	"E78 is already resident. ",0
SEN2$	DB	"Cannot make a second emulator resident. ",0
SEMEM$	DB	"Fatal memory allocation error - too many screen MEMORYs. ",0

	PUBLIC	PRESSK
PRESSK	DB	"Press ESC to continue. ",0

DATA	ENDS

	END
