	NAME	MEMORY
	INCLUDE	PAGESIZE.INC
	TITLE	.MEMORY - Screen memory management runtime 
;
;	HISTORY
;	Date	Version    Prog.    Comments
;	2/1/85	 1.40	   csm     Added dynamic mod change ability on recall
;	2/5/85   1.40	   jsc     Final changes for IRMAvision
;	9/3/85	 1.44	   cmb     Memory error messages on AT's fixed
;	9/11/85	 1.44	   CMB	   Memory save disallowed on mod 3 or 4
;				   without an IRMAvision board
;	11/21/85 1.45.0001 CMB	   VMODE is only used for the current video 
;				   state. SMODE is a temporary storage for what
;				   the mode is to become.
;
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	MEMTAB:BYTE,	NBUF:BYTE,	LSADDR:WORD,	MONB26:BYTE
	EXTRN	VMODE:BYTE,	SCRNMOD:BYTE,	HORB26:BYTE,	ATFLAG:BYTE
	EXTRN	MODSIZ:BYTE,	SLVERR:BYTE,	SMODE:BYTE
	PUBLIC  BADID$,UCNTM$

BADID$	DB	"Invalid MEMORY number. Use 1 thru 9. ",0
NOSBF$	DB	"Selected MEMORY does not exist. Use a smaller number. ",0
BUFEM$	DB	"Selected MEMORY is currently empty. ",0
UCNTM$	DB	"The normal screen cannot be STORED into. Use 1 thru 9. ",0

;	BMSGE	EBCDIC -> "Screen Memory 0"

BMSGE	LABEL BYTE

	DB	0B2H,082H,091H,084H,084H,08DH,010H,0ACH,084H,08CH
	DB	08EH,091H,098H,010H,020H

BMSL	= 	$ - OFFSET BMSGE	; Length of BMSGE

DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	READCH:NEAR,	MESSAGE:NEAR,	UPDRST:NEAR
	EXTRN	SVMODE:NEAR,	UPDHBR:NEAR,	UDELAY:NEAR

	PUBLIC	RECALL
RECALL	PROC	NEAR			; Recall buffer AL
	SUB	AL,"0"			; Convert from decimal to binary
	CMP	AL,9+1			; It should be less
	JNC	RECER			; Jump to handle error

	PUSH	AX
	XOR	AH,AH
	MOV	BL,TYPE MEMTE		; Get size of MEMTE structure
	MUL	BL
	MOV	BX,AX			; BX = NBUF * (Type MEMTE)
	POP	AX
	CMP	AL,0			; Zero is the normal screen
	JZ	RECZZ			; Jump to get current screen from IRMA

	TEST	MEMTAB.MFLG[BX],ME$AVL	; Is this a real buffer?
	JZ	RECER1			; No, not declared here

	TEST	MEMTAB.MFLG[BX],ME$FUL	; Is there something to see?
	JZ	RECER2			; No.

RECZZ:	PUSH	AX			; Save the buffer number
	MOV	AL,MEMTAB.MSRMOD[BX]	; Get the correct SCRNMOD
	MOV	SCRNMOD,AL
	MOV	AL,MEMTAB.MSMODE[BX]	; Get the correct video mode
	MOV	SMODE,AL
	CALL	SVMODE			; Set the video mode
	CMP	HORB26,0		; Is this a short screen?
	JNZ	RECZ9			; Yes, don't do horizontal bar
	CMP	MONB26,0		; Is Monochrome bar faker active?
	JNZ	RECZ9			; Yes, don't force one
	
	CALL	UPDHBR			; Else put horizontal bar on screen
RECZ9:	POP	AX			; Restore buffer number
	MOV	NBUF,AL			; Set the buffer number for UPDLIN
	CALL	UPDRST			;
	RET				; And exit

RECER:	MOV	SI,OFFSET BADID$	; Bad buffer ID character
	JMP	RECEX			;

RECER1:	MOV	SI,OFFSET NOSBF$	; No such buffer now
	JMP	RECEX			;

RECER2:	MOV	SI,OFFSET BUFEM$	; Buffer empty
	JMP	RECEX			;

STOE0:	MOV	SI,OFFSET UCNTM$	; You can't overwrite IRMA
	JMP	RECEX			;

RECEX:	MOV	DI,LSADDR		; Point to the status line
	CALL	UPDRST			; 
	CALL	MESSAGE			;

	CALL	UDELAY			; Wait for user message to display
	RET				; Return with no buffer change
RECALL	ENDP

	PAGE
	PUBLIC	STORE
STORE	PROC	NEAR	
	SUB	AL,"0"			; Convert to binary
	CMP	AL,10			; Should be less
	JNC	RECER			; Invalid buffer character
	CMP	AL,0			; This is bogus
	JZ	STOE0			; You can't do that...

	CMP	MODSIZ,0		; Are we in MOD 2 & not IVISION
	JE	ST1
	MOV	SLVERR,NF$NM2		; Not mod 2 error
	RET

ST1:	PUSH	AX
	XOR	AH,AH
	MOV	BL,TYPE MEMTE		; Get size of MEMTE structure
	MUL	BL
	MOV	BX,AX			; BX = NBUF * (Type MEMTE)
	POP	AX			; Restore buffer number
	
	TEST	MEMTAB.MFLG[BX],ME$AVL	; Is this a real buffer?
	JZ	RECER1			; No, buffer not currently allocated

	OR	MEMTAB.MFLG[BX],ME$FUL	; Something is going to be there

	MOV	NBUF,AL			; This will be needed for buf #
	MOV	AL,SCRNMOD
	MOV	MEMTAB.MSRMOD[BX],AL	; Set the SCRNMOD of stored screen

	MOV	AL,VMODE    		; Set the mode of stored screen
	MOV	MEMTAB.MSMODE[BX],AL

	PUSH	ES			; This will be needed to save data
	LES	DI,MEMTAB.MEMADR[BX]	; Get memory offset:segment
	PUSH	DI			; Save buffer address

	XOR	SI,SI			; Start at IRMA's beginning
	XOR	DI,DI			; And at the screen beginning
	MOV	CX,80*25		; Normal screen size
	CMP	SCRNMOD,2		; Is IRMAvision MOD 3,4, or 5 active?
	JLE	STO1			; No, use standard screen size
	MOV	CX,132*29  		; Number of MAX screen positions

STO1:	PUSH	CX			; Save the counter
	CALL	READCH			; Get EAB:DATA from IRMA[SI]
	POP	CX			;

	STOSW				; MOV ES:[DI],AX : ADD DI,2
	INC	SI			; Next source character
	LOOP	STO1			;

	MOV	CX,BMSL			; Length of buffer select message
	POP	DI			; Restore buffer address
	XOR	SI,SI			; Point to beginning of message
	ADD	DI,(80-BMSL)*2		; Offset of buffer address message

STO2:	MOV	AL,BMSGE[SI]		; Get the data byte
	MOV	AH,28H			; EAB, force to CYAN
	STOSW				; Put directly in the buffer
	INC	SI			; Point to next character
	LOOP	STO2			; Until all chars moved

	SUB	DI,2			; Point back to the last location
	MOV	AL,NBUF			; Add the buffer number
	ADD	ES:[DI],AL		; So it will display

	CALL	UDELAY			; Wait for user message to display

	POP	ES			; Restore screen data segment

	MOV	NBUF,0			; Go back to normal display
	CALL	UPDRST			;
	RET				;
STORE	ENDP

CODE	ENDS
	END
