	NAME	EXITS
	TITLE	.EXITS - Exit processing
	INCLUDE PAGESIZE.INC
	INCLUDE	SKFLAG.INC

; 03-12-86  Selectable Hot Key support added
; 10-21-85  Emulator ENABLE/DISABLE support added
;  4-29-85  Hercules support
; 12-12-84  MicroPhonics support
; 11-30-84  exit indicator added
;  5-21-85  Added SKDRIVER stuff

DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	SLVERR:BYTE,	PRVATR:BYTE,	OPSC:DWORD,	FCB0:BYTE
	EXTRN	NOFILE:BYTE,	RESFLG:BYTE,	LSADDR:WORD,	OTICK:DWORD
	EXTRN	COMRUN:BYTE,	RESQIK:BYTE,	ALTEXIT:BYTE,	HEPAGE1:BYTE
	EXTRN	A_INT16:BYTE,	ENADIS:BYTE,	HOTKEY:BYTE,	HERKEY:BYTE
	EXTRN	ALTMOD3:BYTE

	PUBLIC  SEBID$

	IF	SKFLAG
	EXTRN	OKBD:DWORD	; For previous level I/O
	ENDIF

DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	INKEY:NEAR,	BIOSKY:NEAR,	BEEP:NEAR,	PUTCH:NEAR
	EXTRN	CACHEOUT:NEAR,	PUTDSK:NEAR,	KYRLSE:NEAR,	COMKILL:NEAR
	EXTRN	UPDRST:NEAR,	UPDATE:NEAR,	UPDLIN:NEAR,	BANDEL:NEAR

	PUBLIC	EXKCHK
EXKCHK	PROC	NEAR

;	TEST	ENADIS,0FFH	; Is the emulator Disabled
;	JZ	EXKC1		; Jump if not disabled
;	MOV	SLVERR,SE$EDS	; Set Error condition if Disabled
;	MOV	CX,500		; Give the UPDATE routine to paint screen
;UPD:	PUSH	CX		; Save the loop counter
;	CALL	UPDATE		; Update the Emulator Screen
;	POP	CX		; Restore the counter
;	LOOP	UPD		; Loop until the screen is displayed

	
	test	enadis,0ffh
	jz	exkc1
	mov	slverr,SE$EDS

	mov	cx,25
	mov	bl,0
upd:	push	cx
	push	bx
	call	updlin
	pop	bx
	pop	cx
	inc	bl
	loop	upd
	call	bandel		; Delay so the user may see the status line

EXKC1:	CMP	SLVERR,0	; Is the slave Ok?
	JZ	EXK10		; Yes, skip the message setup

	MOV	BL,SLVERR	; Make a pointer to the message
	AND	BL,127		; Remove non-fatal control bit (128)
	XOR	BH,BH		; Sixteen bits, word offset
	SHL	BX,1		;

	MOV	DI,LSADDR	; Status line (Beginning of...)
	MOV	SI,ERMES[BX]	;   Error message
	CALL	MESSAGE		;     Send the word

	CALL	BEEP		; Wake up the user

	CMP	SLVERR,SE$RR	; This is the only thing RESQIK affects
	JNE	EXK0		; Skip RESQIK check

	CMP	RESQIK,0	; See if this is a QUICK exit
	JNE	EXK1		;

EXK0:	MOV	SI,OFFSET PRESSK
	CALL	MESSAGE		; Press ESC to continue

PKL:	CALL	INKEY		; Wait for the keyboard...
	JNC	PKL		;

	CMP	AL,27		; ASCII ESCAPE
	JNZ	PKL		;

	CALL	UPDRST		; Clean up the screen

EXK1:	TEST	SLVERR,128	; Is this a nonfatal error?
	JZ	EXK20		; No, exit request path

	MOV	SLVERR,0	; Clear non-fatal error

EXK10:	MOV	AH,2		; Test for both shift keys pressed

	IF	SKFLAG

	PUSHF			; Simulate INT
	CALL	[OKBD]		; To previous key handler

	ELSE

	INT	16H		; BIOS keyboard call

	ENDIF

	CMP	ALTMOD3,1	; Is there a Hercules Board present
	JNZ	EXK12		; Jump if Not

	AND	AL,0FH		; Remove all the non Shift Keys
	CMP	AL,HERKEY	; [KA]
	JNZ	EXK12		; [KA]
	MOV	HEPAGE1,1	; [KA] switch to Hercules Page 1

EXK12:				; [KA]
	AND	AL,0FH		; Remove all the non shift keys
	CMP	AL,HOTKEY	;
	JZ	EXK20		; A match, time to go

	CMP	A_INT16,1	; MicroPhonics flag
	JNE	EXK14
	CMP	A_INT16+1,1	; check flag for exit =1
	JNE	EXK14
	MOV	A_INT16+1,00	; clear exit flag
	JMP	SHORT EXK22
EXK14:	CLC			; Not time to exit
	RET			;

EXK20:	CALL	WAITK		; Wait for release

EXK22:	STC			; Exit request
	RET			;

EXKCHK	ENDP

	PUBLIC	WAITK		; Wait for both shift keys to be released
WAITK	PROC	NEAR

	IF	SKFLAG

WK0:	CALL	QEXKY		; Reuse this code
	JZ	WK0
	RET

	ELSE

WK0:	MOV	AH,2		; Get shift key status
	INT	16H		; Raw keyboard handler

	AND	AL,0FH
	CMP	AL,HOTKEY	; Low order shift bits
	JZ	WK0		; Loop until one or both keys released
	RET			; 

	ENDIF

WAITK	ENDP

	PUBLIC	QEXKY
QEXKY	PROC	NEAR		; Return zero if exit key sequence pending, else, nz
	MOV	AH,2		; Get shift key status

	IF	SKFLAG

	PUSHF			; Simulate INT
	CALL	[OKBD]		;   to old keyboard handler

	ELSE

	INT	16H

	ENDIF

	AND	AL,0FH		; Mask off all but shift keys
	CMP	AL,HOTKEY	; Are both down? Zero if yes.
	RET
QEXKY	ENDP

	PAGE
	PUBLIC	MESSAGE
MESSAGE	PROC	NEAR
	CMP	RESQIK,0	; Is the screen dead?
	JE	SCROK		; No, screen is Ok

	MOV	DL,[SI]		; Get a character to go.
	OR	DL,DL		;
	JZ	MS0A		; Last character has been done

	PUSH	SI		; DOS pchar
	MOV	AH,2		;
	INT	21H		;
	POP	SI		;

	INC	SI		; Point to next character
	JMP	MESSAGE		; And do it again!

SCROK:	SHL	DI,1		; Make screen word offset

MS0:	MOV	CL,[SI]		; Get a byte from the message
	MOV	CH,PRVATR	; Get default screen attribute
	OR	CH,8		; Turn on the bright bit
	INC	SI		; Point to next just in case

	CMP	CL,0		; Is this the end?
	JZ	MS10		; Yes, do not continue

	CALL	PUTCH		; Put the character on the screen

	JMP	SHORT MS0	; Put another character on the screen

MS10:	SHR	DI,1		; Put the destination offset back

MS0A:	RET			; And exit

MESSAGE	ENDP

	PUBLIC	EXIT
EXIT	PROC	NEAR
	CMP	RESQIK,0	; Is this a quick exit?
	JNE	QRS		; No, do normal exit stuff

	MOV	ALTEXIT,1	; indicate that exit in progress
	CALL	CACHEOUT	; Restore previous screen state

QRS:	XOR	AX,AX		; Make a segment for page zero ints
	MOV	ES,AX		;

	CLI			; Turn off interrupts during INT clear
	
	MOV	BX,WORD PTR OPSC[0] ; Get old value of PRINTSC interrupt
	MOV	CX,WORD PTR OPSC[2]
	MOV	ES:WORD PTR (5*4),BX ; Set it back
	MOV	ES:WORD PTR (5*4+2),CX

	MOV	BX,WORD PTR OTICK[0] ; Get old value of CLOCK TICK
	MOV	CX,WORD PTR OTICK[2]
	MOV	ES:WORD PTR (1CH*4),BX
	MOV	ES:WORD PTR (1CH*4+2),CX

	STI			; Allow normal interrupts

	TEST	NOFILE,1	; Is there a file open?
	JNZ	NOF		; No, skip the close

	TEST	SLVERR,SE$WE	; Was there an error writing to disks
	JNZ	NOF		; Yes, Skip the file close operation

	MOV	AL,1AH		; Put an end-of-file mark on the file
	CALL	PUTDSK		; Put the character on the disk

	MOV	AH,10H		; DOS file close
	MOV	DX,OFFSET FCB0	; Main file control block
	INT	21H		; DOS function call

NOF:	MOV	NOFILE,1	; Turn off the file!

	MOV	RESQIK,0	; Turn off super-resident flag

	CALL	KYRLSE		; Turn off extended keyboard handler

	CMP	COMRUN,0	; Is there a communication drive running?
	JZ	NONCOM		; No, do not turn one off!

	CALL	COMKILL		; Remove COM1: interrupt service routine

NONCOM:	RET

EXIT	ENDP

CODE	ENDS
	PAGE
DATA	SEGMENT PUBLIC BYTE

	PUBLIC	ERMES
ERMES	LABEL	WORD
	DW	OFFSET NOERR
	DW	OFFSET SETO$
	DW	OFFSET SEBF$
	DW	OFFSET SEWE$
	DW	OFFSET SEID$
	DW	OFFSET SERR$
	DW	OFFSET NFND$
	DW	OFFSET NFRS$
	DW	OFFSET NFAR$
	DW	OFFSET SEN2$
	DW	OFFSET SEMEM$
	DW	OFFSET SEBID$	; Invalid memory number Use 1 through 9
	DW	OFFSET NFNM2$	; Not MOD 2 error
	DW	OFFSET SEEDS$	; Emulator Currently Disabled
	DW	OFFSET SEBNS$	; Busy Flag Not Set Error !!!
	DW	OFFSET SKERR0$	; [sk] No SKDRIVER
	DW	OFFSET SKERR1$	; [sk] Bad SKDRIVER revision
	DW	OFFSET SKERRP$	; [sk] Can't fetch profile

NOERR	DB	0			;   0 - No error
SETO$	DB	"IRMA failed to respond to emulator request. ",0
SEBF$	DB	"Unable to open screen save file. ",0
SEWE$	DB	"Fatal IRMA disk write error. ",0
SEID$	DB	"IRMA is busy for too long. ",0
SERR$	DB	"E78 becoming resident. ",0
NFND$	DB	"No SCREEN SAVE file in use. ",0
NFRS$	DB	"SCREEN SAVE not allowed from resident emulator. ",0
NFAR$	DB	"E78 is already resident. ",0
SEN2$	DB	"Cannot make a second emulator resident. ",0
SEMEM$	DB	"Fatal memory allocation error - too many screen MEMORYs. ",0
SEBID$	DB	"Invalid MEMORY number. Use 1 thru 9. ",0
NFNM2$	DB	"Screen Store only allowed for Model 2. ",0
SEEDS$	DB	"Emulator Currently Disabled.    ",0
SEBNS$	DB	"Busy Flag NOT Set Error !!!   ",0
SKERR0$	DB	"SKDRIVER.SYS not found.  Check your CONFIG.SYS file. ",0 		; [sk]
SKERR1$	DB	"SKDRIVER.SYS is resident but not correct revision! ",0                 ; [sk]
SKERRP$	DB	"Cannot load keyboard profile from SK78.SK in this directory! ",0       ; [sk]

	PUBLIC	PRESSK
PRESSK	DB	"Press ESC to continue. ",0

DATA	ENDS

	END
