	NAME	CURSOR
	INCLUDE	PAGESIZE.INC
	TITLE	.CURSOR - Cursor postion and type routines CPOS, CTYPE
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	CURSOR:WORD,	CRTBASE:WORD,	AUXST:BYTE,	CTTCUR:WORD
	EXTRN	LSADDR:WORD,	TOPLIN:WORD,	PCURSR:WORD,	TOPSET:BYTE
	EXTRN	MODSIZ:WORD,	STLINE:WORD,	BUFEND:WORD,	SCRNMOD:BYTE
	EXTRN	SIGMA:BYTE,	CURCOL:BYTE,	CURLIN:BYTE

DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	UPDRST:NEAR

	PUBLIC	CPOS
CPOS	PROC	NEAR
	MOV	AX,CURSOR	; Get current cursor position

	CMP	AX,SSTART	; Is the position too small?
	JGE	CP1		; No, check for too large

CP0:	MOV	AX,LSADDR[0]	; Lower LEFT hand corner hideout
	JMP	SHORT CP2	; INVISIBLE (almost)

CP1:	CMP	AX,STLINE	; Status line and beyond are out of bounds
	JGE	CP0		; It was too big...

	SUB	AX,SSTART	; Convert logical address to physical offset

CP2:	cmp	sigma,01
	jne	useio
	jmp	useint

useio:	PUSH	AX		; Save a copy of the address

	MOV	DX,CRTBASE	; Point to the crt controller
	MOV	AL,14		; Select cursor high order address register
	OUT	DX,AL		;

	INC	DX		; Point to controller data register
	POP	AX		; Restore the cursor address
	PUSH	AX		; Save it again on stack
	
	CMP	SCRNMOD,5  	; is it mod 5?
	JZ	M5CURSOR 	; yes, it's mod 5 handle cursor differently
	JMP	NORMAL		; NO, it's not mod 5, do it normally

M5CURSOR:  TEST AX,1		; See it cursor is odd or even
	JZ	EVEN
	JMP	ODD

EVEN:	ROR 	AX,1 		; Divide cursor position in ax by 2
	XCHG	AH,AL		; Get the high address byte
	OUT 	DX,AL           ; Send it to the 6845 data register 14

	DEC	DX 		; Point DX to the 6845 index register
	MOV	AL,15
	OUT	DX,AL 		; Set 6845 index register to 15

	INC	DX   		; Point DX to the 6845 data register
	XCHG	AH,AL		; Get the low address byte
	OUT 	DX,AL       	; Send low value out to 6845

	ADD	DX,10		; Point to mode register 2 (3BF)
	MOV	AL,64H		; 132Col, 6845lock, non-blink cursor
	OUT	DX,AL		; Set mode register 2 for 132 col even cursor

	JMP	OUT

ODD:	SUB	AX,1
	ROR	AX,1		; Divide cursor position in ax by 2

	XCHG	AH,AL		; Get the high address byte
	OUT 	DX,AL

	DEC	DX 		; Point DX to the 6845 index register
	MOV	AL,15
	OUT	DX,AL 		; Set 6845 index register to 15

	INC	DX   		; Point DX to the 6845 data register
	XCHG	AH,AL		; Get the low address byte
	OUT 	DX,AL       	; Send low value out to 6845

	ADD	DX,10		; Point to mode register 2 (3BF)
	MOV	AL,0E4H		; 132Col, 6845lock, ODD CURSOR, non-blink cursor
	OUT	DX,AL		; Set mode register 2 with above information

	JMP	OUT

NORMAL:	XCHG	AH,AL		; Get the high address byte
	OUT	DX,AL		;

	DEC	DX		; Command/address register
	MOV	AL,15		; Low address register
	OUT	DX,AL		;

	INC	DX		; Low address byte
	XCHG	AH,AL		; Get into output position
	OUT	DX,AL		;

OUT: 	POP	AX
	RET

useint:
	mov	dl,curcol
	mov	dh,curlin
	dec	dh
	mov	ah,2
	mov	bh,0
	int	10h
	ret

CPOS	ENDP
	PAGE
	PUBLIC	CTYPE
CTYPE	PROC	NEAR

	cmp	sigma,01
	jne	tuseio
	jmp	tuseint

tuseio:	MOV	DX,CRTBASE	; Where to poke the cursor parameters
	MOV	AL,10		; Select cursor start register
	OUT	DX,AL		;

	INC	DX		; Point to 6845 data register

	MOV	AL,AUXST	; Get where cursor data comes from (stork)
	AND	AL,1110B	; Only the cursor bits
	XOR	AH,AH		; As 16 bits in AX

	MOV	BX,AX		; Into an index register it goes
	MOV	BX,CTTCUR[BX]	; BX now contains current cursor parameters

	MOV	AL,BH		; Get current cursor type and start 
	OUT	DX,AL		;

	DEC	DX		; Point back to the selector register
	MOV	AL,11		;
	OUT	DX,AL		;

	INC	DX		;

	MOV	AL,BL		; Get current cursor end 
	OUT	DX,AL		;

	RET

tuseint:
	MOV	AL,AUXST	; Get where cursor data comes from (stork)
	AND	AL,1110B	; Only the cursor bits
	XOR	AH,AH		; As 16 bits in AX

	MOV	BX,AX		; Into an index register it goes
	MOV	BX,CTTCUR[BX]	; BX now contains current cursor parameters

	MOV	CH,BH		; Get current cursor type and start 
	MOV	CL,BL		; Get current cursor end 
	MOV	AH,1
	INT	10H

	RET

CTYPE	ENDP
	PAGE
	PUBLIC	SCRNFX
SCRNFX	PROC	NEAR		; Fix appropriate screen location

	CMP	SCRNMOD,0	; Is this IRMAvision?
	JNZ	SCRXIT		; If yes, then return

	CMP	TOPSET,0	; Is nothing happening?
	JZ	SCRXIT		; BORING.

	DEC	TOPSET		; Count down one main line pass until align.
	JNZ	SCRXIT		; No yet.

	TEST	AUXST,M$CINH	; Is the cursor off?
	JNZ	SCRXIT		; Yes, do not mess w/ screen location

	CMP	PCURSR,80	; Are we on the status line?
	JNAE	SCR0		; Yes, do this again on the next pass

	MOV	AX,PCURSR	; Make a screen physical cursor
	SUB	AX,80		; Upper left corner is zero.
	SUB	AX,TOPLIN	;
	JB	SCR1		; Cursor is above active area
	
	CMP	AX,24*80	; Beginning of extended screen
	JAE	SCR2		; It is in range, ignore

SCRXIT:	RET			; Exit with screen aligned

SCR0:	MOV	TOPSET,1	; Arrange for a new meeting
	RET			;

SCR1:	MOV	TOPLIN,0	;
	JMP	SHORT SCR3	;

SCR2:	MOV	AX,MODSIZ	; Offset of this model screen
	MOV	TOPLIN,AX	; Move the screen to show the bottom
	
SCR3:	CALL	UPDRST		; Force screen synch alignment
	RET			;

SCRNFX	ENDP

CODE	ENDS				; END OF CODE

	END
